/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.search;

import com.sas.metadata.logical.visuals.search.DefaultAdvancedFilterDialog;
import com.sas.metadata.logical.visuals.search.ExtendedAttributesFilterComponent;
import com.sas.metadata.logical.visuals.search.FilterComponentInterface;
import com.sas.metadata.logical.visuals.search.KeywordsFilterComponent;
import com.sas.metadata.logical.visuals.search.NotesFilterComponent;
import com.sas.metadata.logical.visuals.search.ResponsibilitiesFilterComponent;
import com.sas.services.information.search.ExtendedAttributesFilter;
import com.sas.services.information.search.KeywordFilter;
import com.sas.services.information.search.NotesFilter;
import com.sas.services.information.search.ResponsibilitiesFilter;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.search.Search;
import com.sas.services.information.search.SearchFilter;
import com.sas.services.information.search.SearchFolder;
import com.sas.services.information.search.SortOrder;
import com.sas.workspace.MessageUtil;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class SearchAdvancedFilterDialog
extends DefaultAdvancedFilterDialog {
    private static final long serialVersionUID = -6843465304464272419L;
    private ResultDetails.ResultLimit _resultLimit;
    private SortOrder[] _order;
    private ResultDetails.ResultLimit _selectedLimit = null;
    private SortOrder[] _selectedOrder = null;
    private KeywordFilter _startingKeywordFilter = null;
    private ResponsibilitiesFilter _startingResponsibleFilter = null;
    private NotesFilter _startingNotesFilter = null;
    private ExtendedAttributesFilter _startingExtAttrFilter = null;
    private Search _search;
    private SearchFolder _searchFolder;
    private boolean isEditable = true;

    public SearchAdvancedFilterDialog(String title, SearchFolder searchFolder, Dialog dlgOwner) {
        super(title, dlgOwner);
        this._searchFolder = searchFolder;
        this.buildAdvancedDialog();
    }

    protected void buildAdvancedDialog() {
        try {
            this._search = this._searchFolder.getSearch();
            this._order = this._search.getResultDetails().getSortOrder();
            this._resultLimit = this._search.getResultDetails().getResultLimit();
            this.getFilterinfo();
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        this.addFilterPanel((FilterComponentInterface)new KeywordsFilterComponent(), (SearchFilter)this._startingKeywordFilter);
        this.addFilterPanel((FilterComponentInterface)new NotesFilterComponent(), (SearchFilter)this._startingNotesFilter);
        this.addFilterPanel((FilterComponentInterface)new ExtendedAttributesFilterComponent(), (SearchFilter)this._startingExtAttrFilter);
        this.addFilterPanel((FilterComponentInterface)new ResponsibilitiesFilterComponent(), (SearchFilter)this._startingResponsibleFilter);
    }

    protected void getFilterinfo() throws RemoteException {
        List filtersList = this._search.getFilters();
        SearchFilter[] searchFilters = null;
        if (filtersList == null) {
            return;
        }
        for (SearchFilter sc : filtersList.toArray(new SearchFilter[filtersList.size()])) {
            ExtendedAttributesFilter extendedAttrFilter;
            if (sc instanceof ResponsibilitiesFilter) {
                ResponsibilitiesFilter rfilter;
                this._startingResponsibleFilter = rfilter = (ResponsibilitiesFilter)sc;
                continue;
            }
            if (sc instanceof KeywordFilter) {
                KeywordFilter keywordFilter;
                this._startingKeywordFilter = keywordFilter = (KeywordFilter)sc;
                continue;
            }
            if (sc instanceof NotesFilter) {
                NotesFilter notesFilter;
                this._startingNotesFilter = notesFilter = (NotesFilter)sc;
                continue;
            }
            if (!(sc instanceof ExtendedAttributesFilter)) continue;
            this._startingExtAttrFilter = extendedAttrFilter = (ExtendedAttributesFilter)sc;
        }
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        super.doDataExchange(bSaveToModel);
        if (!bSaveToModel) {
            this.setEditable(this.isEditable);
        }
        return true;
    }

    public boolean validateData() {
        boolean validated = super.validateData();
        if (this.isDisplayingResultsConfiguration()) {
            this._selectedOrder = this._resultsPanel.getSortOrder();
            this._selectedLimit = this._resultsPanel.getResultLimit();
        }
        return validated;
    }

    protected boolean onCancel() {
        super.onCancel();
        if (this.isDisplayingResultsConfiguration()) {
            this._resultsPanel.setPreviousValues(this._selectedLimit, this._selectedOrder);
        }
        return true;
    }

    protected ActionListener getResetAction() {
        return new ResetAction();
    }

    protected void resetAllValues() {
        try {
            Map filterPanels = this._basePanel.getFilterPanelMap();
            for (FilterComponentInterface panel : filterPanels.keySet()) {
                if (panel instanceof KeywordsFilterComponent) {
                    panel.setPreviousValues((SearchFilter)this._startingKeywordFilter);
                    continue;
                }
                if (panel instanceof ResponsibilitiesFilterComponent) {
                    panel.setPreviousValues((SearchFilter)this._startingResponsibleFilter);
                    continue;
                }
                if (panel instanceof NotesFilterComponent) {
                    panel.setPreviousValues((SearchFilter)this._startingNotesFilter);
                    continue;
                }
                if (!(panel instanceof ExtendedAttributesFilterComponent)) continue;
                panel.setPreviousValues((SearchFilter)this._startingExtAttrFilter);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        if (this.isDisplayingResultsConfiguration()) {
            this._resultsPanel.resetValues();
        }
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        try {
            Map filterPanels = this._basePanel.getFilterPanelMap();
            for (FilterComponentInterface panel : filterPanels.keySet()) {
                if (panel instanceof KeywordsFilterComponent) {
                    panel.setEditable(bEditable);
                    continue;
                }
                if (panel instanceof ResponsibilitiesFilterComponent) {
                    panel.setEditable(bEditable);
                    continue;
                }
                if (panel instanceof NotesFilterComponent) {
                    panel.setEditable(bEditable);
                    continue;
                }
                if (!(panel instanceof ExtendedAttributesFilterComponent)) continue;
                panel.setEditable(bEditable);
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        if (this.isDisplayingResultsConfiguration()) {
            this._resultsPanel.setEditable(bEditable);
        }
    }

    public void setSearchEditable(boolean bEditable) {
        this.isEditable = bEditable;
    }

    private class ResetAction
    implements ActionListener {
        private ResetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchAdvancedFilterDialog.this.resetAllValues();
        }
    }
}

