/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.search;

import com.sas.metadata.logical.search.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class ResultsPanel
extends WAStandardDialog {
    private static final long serialVersionUID = 9200000001L;
    private String _title;
    private List<PublicObjectInterface> _searchResults;
    private WATextArea _textArea;
    private JScrollPane _scrollPane;
    private JButton _okButton;

    public ResultsPanel(String title, List<PublicObjectInterface> searchResults, Dialog dlgOwner) {
        super(dlgOwner, true);
        this._title = title;
        this._searchResults = searchResults;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.setTitle(this._title);
        this.setResizable(true);
        this._okButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._okButton, (String)RB.getStringResource("ResultsPanel.OKButton.txt"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsPanel.this.dispose();
            }
        });
        this._textArea = new WATextArea();
        this._textArea.setEditable(false);
        this._textArea.setAutoSelect(false);
        this._textArea.setMargin(new Insets(5, 5, 5, 5));
        this._textArea.setBehavior(0);
        Font fnt = this._textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        this._textArea.setFont(fnt);
        this._scrollPane = new JScrollPane((Component)this._textArea);
        this._scrollPane.setPreferredSize(new Dimension(500, 350));
    }

    protected void layoutWidgets() {
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        panel.add((Component)this._scrollPane, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        panel.add((Component)this._okButton, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        this.setMainPanel(panel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            try {
                this._textArea.setText(this.getSearchResults());
                this._textArea.setCaretPosition(0);
            }
            catch (ServiceException e) {
                this._textArea.setText(Message.format((ResourceBundle)RB.getResources(), (String)"SearchCriteriaTab.SearchResultsDialog.DisplayError.txt", (Object)e.getMessage()));
            }
            catch (RemoteException e) {
                this._textArea.setText(Message.format((ResourceBundle)RB.getResources(), (String)"SearchCriteriaTab.SearchResultsDialog.DisplayError.txt", (Object)e.getMessage()));
            }
            this._okButton.requestFocus();
        }
        return true;
    }

    public String getSearchResults() throws ServiceException, RemoteException {
        String searchResultsSummary = null;
        try {
            for (PublicObjectInterface sobj : this._searchResults) {
                String ObjectId = sobj.getIdentifier();
                String ObjectName = sobj.getName();
                String ObjectType = sobj.getTypeDescriptor().getTypeName();
                DetailsProcessorInterface sobjDetails = (DetailsProcessorInterface)sobj.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                searchResultsSummary = searchResultsSummary == null ? "Type: " + ObjectType + "\n" : searchResultsSummary + "Type: " + ObjectType + "\n";
                searchResultsSummary = searchResultsSummary + "Name: " + ObjectName + "\n";
                searchResultsSummary = searchResultsSummary + "Id: " + ObjectId + "\n";
                searchResultsSummary = searchResultsSummary + "Desc: " + sobjDetails.getDescription() + "\n";
                searchResultsSummary = searchResultsSummary + "\n";
            }
        }
        catch (Exception e) {
            String errmsg = Message.format((String)RB.getStringResource("ResultsPanel.exception.message.fmt"), (Object)e.getMessage());
            System.err.println(errmsg);
        }
        if (searchResultsSummary == null) {
            searchResultsSummary = " ";
        }
        return searchResultsSummary;
    }
}

