/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.note;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.note.Note;
import com.sas.metadata.logical.note.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Document;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NoteImportListener
extends AbstractImportListener {
    public NoteImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        if (operation.getPackageFileVersion() < 9200) {
            String reposId = operation.getRepositoryID();
            String strTemplate = "<Templates><TextStore><Objects/><Trees/></TextStore></Templates>";
            String metadataType = "TextStore";
            MdObjectStore store = operation.getStore();
            for (ImportItemInterface noteItem : objects) {
                block19: {
                    String name;
                    String type;
                    this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.PreviousStatusIndicator.fmt"), (Object)noteItem.getName()));
                    operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.PreviousUpgradeInfo.fmt"), (Object)noteItem.getName()));
                    try {
                        CMetadata srvMeta;
                        MdFactory m_Factory = store.getFactory();
                        String id = noteItem.getTargetID();
                        if (id == null || id.length() == 0) {
                            id = noteItem.getID();
                        }
                        TextStore tsNote = null;
                        Document doc = null;
                        CMetadata clientObj = store.getObject(id, true);
                        if (clientObj != null) {
                            store.deleteDetailMetadataObject(id);
                        }
                        if ((srvMeta = this.getNoteMetadataObject(operation.getStore(), metadataType, id, strTemplate)) instanceof Document) {
                            doc = (Document)srvMeta;
                            this.updateAttributes(doc, operation);
                        } else if (srvMeta instanceof TextStore) {
                            int localrc;
                            tsNote = (TextStore)srvMeta;
                            if ((doc = this.getDocumentBasedOnObjectPath(noteItem, tsNote, doc)) == null) {
                                doc = this.getDocumentBasedOnPath(operation, store, noteItem, m_Factory, doc);
                            }
                            if (doc == null) {
                                doc = (Document)m_Factory.createComplexMetadataObject(store, noteItem.getName(), "Document", reposId.substring(9, 17));
                            }
                            if ((localrc = this.setupNewNoteDocument(operation, tsNote, doc)) != 0) {
                                rc |= localrc;
                                if (doc == null) continue;
                                doc.delete();
                                continue;
                            }
                        }
                        if (doc != null && doc.objectModified()) {
                            doc.updateMetadataAll();
                        }
                        if (doc == null || noteItem.getTargetID().equals(doc.getId())) break block19;
                        noteItem.setTargetID(doc.getId());
                    }
                    catch (RemoteException re) {
                        type = noteItem.getTypeInterface().getDisplayType();
                        name = noteItem.getName();
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.errorConvertingMetadata.txt"), (Object)type, (Object)name), (Throwable)re);
                        rc |= 8;
                        continue;
                    }
                    catch (MdException e) {
                        type = noteItem.getTypeInterface().getDisplayType();
                        name = noteItem.getName();
                        operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.errorConvertingMetadata.txt"), (Object)type, (Object)name), (Throwable)e);
                        rc |= 8;
                        continue;
                    }
                }
                if (!operation.getLogger().isInfoEnabled()) continue;
                operation.getLogger().info((Object)RB.getStringResource("NoteImportListener.PreviousVersionImportInfo.txt"));
            }
            return rc;
        }
        for (ImportItemInterface noteItem : objects) {
            String name;
            String type;
            this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)noteItem.getTypeInterface(), (String)noteItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.MetadataInfo.fmt"), (Object)noteItem.getName()));
            boolean bMetadataChanged = false;
            try {
                Document docNote;
                String id = noteItem.getTargetID();
                if (id == null || id.length() == 0) {
                    id = noteItem.getID();
                }
                if (!(bMetadataChanged = this.updateAttributes(docNote = this.getNoteMetadataObject(operation.getStore(), noteItem, id), operation))) continue;
                bMetadataChanged = false;
                docNote.updateMetadataAll();
            }
            catch (MdException e) {
                type = noteItem.getTypeInterface().getDisplayType();
                name = noteItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (RemoteException e) {
                type = noteItem.getTypeInterface().getDisplayType();
                name = noteItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("NoteImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
        }
        return rc;
    }

    private Document getDocumentBasedOnPath(ImportOperationInterface operation, MdObjectStore store, ImportItemInterface noteItem, MdFactory m_Factory, Document doc) throws RemoteException, MdException {
        String[] path = noteItem.getTargetPath();
        String[] objectPath = new String[path.length + 1];
        System.arraycopy(path, 0, objectPath, 0, path.length);
        objectPath[path.length] = noteItem.getName();
        if (objectPath != null && objectPath.length > 0) {
            String reposID = operation.getRepositoryID();
            String rootFolderID = this.getRootFolderID(operation, objectPath[0]);
            String xmlSelect = BIPTreeUtil.buildXMLSelectForObject((String[])objectPath, (String)noteItem.getTypeInterface().getPublicType(), (String)rootFolderID);
            MdFactory factory = operation.getMetadataFactory();
            Map objectMap = BIPTreeUtil.searchForObject((MdFactory)factory, (String)xmlSelect, (String)reposID, (String)noteItem.getTypeInterface().getMetadataType(), (boolean)operation.isProjectRepository());
            if (objectMap != null) {
                String targetID = (String)objectMap.get("Id");
                doc = (Document)m_Factory.createComplexMetadataObject(store, noteItem.getName(), "Document", targetID);
            }
        }
        return doc;
    }

    public boolean updateAttributes(Document docNote, ImportOperationInterface operation) throws RemoteException, MdException {
        boolean usageVersionChanged;
        boolean bMetadataChanged = false;
        PromotionUtil.updateProductInfo((Root)docNote, (ImportOperationInterface)operation);
        bMetadataChanged = true;
        boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)docNote, (String)"Note");
        if (publicTypeChanged) {
            bMetadataChanged = true;
        }
        if (usageVersionChanged = UtilMetadata.setUsageVersion((Root)docNote, (UsageVersion)Note.CURRENT_VERSION)) {
            bMetadataChanged = true;
        }
        if (bMetadataChanged) {
            bMetadataChanged = false;
            docNote.updateMetadataAll();
        }
        return bMetadataChanged;
    }

    private CMetadata getNoteMetadataObject(MdObjectStore store, String type, String fqid, String template) throws MdException, RemoteException {
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        return object;
    }

    private Document getNoteMetadataObject(MdObjectStore store, ImportItemInterface importItem, String fqid) throws MdException, RemoteException {
        String type = importItem.getTypeInterface().getMetadataType();
        String template = "<Templates><Document><Objects/><Trees/></Document></Templates>";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        if (object instanceof Document) {
            return (Document)object;
        }
        throw new MdException("Invalid type returned from metadata for Note: " + object.getCMetadataType());
    }

    private int setupNewNoteDocument(ImportOperationInterface operation, TextStore ts, Document doc) throws RemoteException, MdException {
        int returnCode = 0;
        AssociationList objList = ts.getObjects();
        doc.setDesc(ts.getDesc());
        doc.setPublicType("Note");
        doc.setUsageVersion("1000000.0");
        doc.setTextRole("Note");
        doc.setURI("");
        AssociationList docObjects = doc.getObjects();
        for (int j = 0; j < objList.size(); ++j) {
            docObjects.add(objList.get(j));
        }
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        AssociationList docExtensions = doc.getExtensions();
        for (Extension noteExtension : ts.getExtensions()) {
            String uniqueExtIdentifier = this.generateUniqueIdentiferForExtension(noteExtension);
            boolean found = false;
            Iterator iterator2 = docExtensions.iterator();
            while (iterator2.hasNext() && !found) {
                Extension docExtension = (Extension)iterator2.next();
                String docUniqueExtension = this.generateUniqueIdentiferForExtension(docExtension);
                SASStringComparator collator = SASCollatorFactory.createCollator();
                if (collator.compare(docUniqueExtension, uniqueExtIdentifier) != 0) continue;
                found = true;
            }
            if (found) continue;
            extensions.add(noteExtension);
        }
        for (int i = 0; i < extensions.toArray().length; ++i) {
            Extension exten = (Extension)extensions.get(i);
            String reposId = operation.getRepositoryID();
            Extension newExt = (Extension)doc.getObjectStore().getFactory().createComplexMetadataObject((MdObjectStore)exten.getObjectStore(), exten.getName(), "Extension", reposId.substring(9, 17));
            docExtensions.add(newExt);
            newExt.setDesc(exten.getDesc());
            newExt.setExtensionType(exten.getExtensionType());
            newExt.setValue(exten.getValue());
            exten.delete();
        }
        ts.getObjects().removeAllElements();
        doc.getNotes().removeAllElements();
        doc.getNotes().add((Object)ts);
        AssociationList folderList = ts.getTrees();
        if (folderList.size() > 0) {
            Tree folder = (Tree)folderList.get(0);
            doc.getTrees().add((Object)folder);
            ts.getTrees().removeAllElements();
        }
        ts.setPublicType("");
        return returnCode;
    }

    private String generateUniqueIdentiferForExtension(Extension extension) throws RemoteException {
        String seperator = "::";
        StringBuffer out = new StringBuffer();
        String name = extension.getName();
        if (name != null) {
            out.append(name);
        }
        out.append(seperator);
        String extensionValue = extension.getValue();
        if (extensionValue != null) {
            out.append(extensionValue);
        }
        return out.toString();
    }

    private String getRootFolderID(ImportOperationInterface operation, String folderName) throws RemoteException, MdException {
        Map _rootFoldersMap = BIPTreeUtil.getMapOfRootFolders((MdFactory)operation.getMetadataFactory());
        if (_rootFoldersMap == null) {
            return null;
        }
        for (Map.Entry entry : _rootFoldersMap.entrySet()) {
            String name = (String)entry.getValue();
            if (!name.equals(folderName)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private Document getDocumentBasedOnObjectPath(ImportItemInterface noteItem, TextStore tsNote, Document doc) throws RemoteException, MdException {
        AssociationList folderList = tsNote.getTrees();
        if (folderList.size() > 0) {
            Tree folder = (Tree)folderList.get(0);
            AssociationList siblings = folder.getMembers();
            Iterator iterator2 = siblings.iterator();
            while (iterator2.hasNext() && doc == null) {
                Document potentialTarget;
                Root object = (Root)iterator2.next();
                if (!(object instanceof Document) || (potentialTarget = (Document)object).getPublicType() == null || !potentialTarget.getPublicType().equals(noteItem.getTypeInterface().getPublicType()) || !noteItem.getName().equals(potentialTarget.getName())) continue;
                doc = potentialTarget;
            }
        }
        return doc;
    }
}

