/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.messagequeue;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.messagequeue.RB;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import java.rmi.RemoteException;
import java.util.List;

public class MessageQueueNameValidator
implements ImportNameValidatorInterface {
    private static final String SERVERCOMPONENT_CONTENT_TEMPLATE = "<Templates><ServerComponent><InitProcesses/></ServerComponent></Templates>";

    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        boolean isUnique = true;
        String name = importItem.getName();
        if (importItem.getImportState() == 1) {
            List cps = importItem.getConnectionPoints();
            ServerComponent qMan = null;
            block2: for (int i = 0; i < cps.size() && isUnique; ++i) {
                ConnectionPointInterface cp = (ConnectionPointInterface)cps.get(i);
                try {
                    ImportItemInterface qManItem;
                    String targetID;
                    if (!"ServerComponent".equals(cp.getMetadataType())) continue;
                    if (cp.isActive() && (targetID = cp.getTargetID()) != null) {
                        qMan = (ServerComponent)importOperation.getStore().getObject(targetID);
                        if (qMan == null) {
                            qMan = this.queryQueueManager(importOperation, targetID);
                        }
                    } else if (!cp.isActive() && null != (qManItem = importOperation.getImportItem(cp.getSourceID()))) {
                        if (qManItem.getImportState() == 1) {
                            return true;
                        }
                        if (qManItem.getImportState() == 2) {
                            targetID = qManItem.getTargetID();
                            qMan = this.queryQueueManager(importOperation, targetID);
                        }
                    }
                    if (null == qMan) {
                        throw new MdException("Unable to find Message Queue Manager: " + cp.getName());
                    }
                    AssociationList queues = qMan.getInitProcesses();
                    for (int j = 0; j < queues.size(); ++j) {
                        Transformation queue = (Transformation)queues.get(j);
                        if (!queue.getName().equals(name)) continue;
                        isUnique = false;
                        continue block2;
                    }
                    continue;
                }
                catch (RemoteException re) {
                    String message = UtilMisc.getMessage((String)RB.getStringResource("MQM.NameValidator.RemoteException.fmt.txt"), (Object)re.getMessage());
                    importOperation.getLogger().error((Object)message);
                }
            }
        }
        return isUnique;
    }

    ServerComponent queryQueueManager(ImportOperationInterface importOperation, String targetID) throws RemoteException, MdException {
        int options = 16668;
        return (ServerComponent)importOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)importOperation.getStore(), "ServerComponent", targetID, null, null, SERVERCOMPONENT_CONTENT_TEMPLATE, options);
    }
}

