/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.messagequeue;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.metadata.MetadataInterface;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMessageQueueManagerExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    public AbstractMessageQueueManagerExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObject> objects = null;
        if (0 == relationshipType) {
            try {
                MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)this._exportOperation, (SimpleLogicalObjectInterface)this);
                ServerComponent qman = (ServerComponent)mi.getRepositoryEntity();
                objects = new ArrayList<SimpleLogicalObject>();
                AssociationList queues = qman.getInitProcesses();
                for (int i = 0; i < queues.size(); ++i) {
                    if (!(queues.get(i) instanceof Transformation) || !((Transformation)queues.get(i)).getTransformRole().equals(this.getAssociatedTransformRole())) continue;
                    Transformation queue = (Transformation)queues.get(i);
                    TypeInterface ti = Factory.getInstance().getTypeInterface(queue.getPublicType());
                    objects.add(new SimpleLogicalObject(queue.getName(), queue.getFQID(), ti));
                }
            }
            catch (Exception e) {
                throw new LogicalTypeException(e);
            }
        }
        if (relationshipType == 1) {
            try {
                MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)this._exportOperation, (SimpleLogicalObjectInterface)this);
                ServerComponent qman = (ServerComponent)mi.getRepositoryEntity();
                objects = new ArrayList();
                AssociationList queues = qman.getInitProcesses();
                for (int i = 0; i < queues.size(); ++i) {
                    if (!(queues.get(i) instanceof Transformation) || !((Transformation)queues.get(i)).getTransformRole().equals(this.getAssociatedTransformRole())) continue;
                    Transformation queue = (Transformation)queues.get(i);
                    AssociationList servers = queue.getTransformationTargets();
                    for (int j = 0; j < queues.size(); ++j) {
                        if (!(servers.get(j) instanceof ServerComponent)) continue;
                        ServerComponent server = (ServerComponent)servers.get(j);
                        TypeInterface ti = Factory.getInstance().getTypeInterface(server.getPublicType());
                        objects.add(new SimpleLogicalObject(server.getName(), server.getFQID(), ti));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objects;
    }

    protected abstract String getAssociatedTransformRole();
}

