/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesFactory;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class NewFavoritesGroupDialog
extends WAPropertyDialog {
    private WAGeneralPanel _generalPanel;
    private FavoritesContainer _parent;
    private FavoritesGroup _favoritesGroup;

    public NewFavoritesGroupDialog(Frame frm, FavoritesContainer parent) {
        super(frm, true);
        this._parent = parent;
        this.setTitle(RB.getStringResource("NewFavoritesGroupDialog.Title.txt"));
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("new_favorites_group");
        this._generalPanel = new WAGeneralPanel(null, null, false, false, false, false);
        this._generalPanel.setPreferredSize(new Dimension(400, 200));
        this._generalPanel.enableNameValidation(true);
        this._generalPanel.setHelpProduct("shared");
        this._generalPanel.setHelpTopic("new_favorites_group");
        this.setMainPanel((WAPanel)this._generalPanel);
        this.setResizable(true);
    }

    public FavoritesGroup getNewFavoritesGroup() {
        return this._favoritesGroup;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this._generalPanel.moveDataToView();
                return true;
            }
            return this.createFavoritesGroup();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return false;
    }

    public boolean validateData() {
        boolean state = this._generalPanel.validateData();
        if (!state) {
            return state;
        }
        if (this._parent == null) {
            MessageUtil.displayMessage((String)RB.getStringResource("NewFavoritesGroupDialog.NoFolder.txt"), (int)0);
            return false;
        }
        try {
            String name = this._generalPanel.getNameComponent().getText().trim();
            boolean isDuplicate = this._parent.hasDuplicateFavoritesGroup(name);
            if (isDuplicate) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesGroupDialog.Title.DuplicateName.fmt.txt", (Object)name);
                MessageUtil.displayMessage((String)msg, (int)0);
                return false;
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        return true;
    }

    public boolean hasDataChanged() {
        return false;
    }

    private boolean createFavoritesGroup() throws RemoteException, ServiceException {
        String name = this._generalPanel.getNameComponent().getText().trim();
        FavoritesFactory factory = FavoritesFactory.getInstance((SessionContextInterface)Workspace.getWorkspace().getSessionContext());
        FavoritesGroup group = factory.createFavoritesGroup(name, this._parent);
        if (group != null) {
            group.setDescription(this._generalPanel.getDescriptionComponent().getText().trim());
            group.update();
            this._favoritesGroup = group;
            return true;
        }
        return false;
    }
}

