/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.favorites.FavoritesContainerLogicalObjectInterface;
import com.sas.metadata.logical.favorites.NewFavoritesGroupDialog;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.logical.visuals.Images;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class NewFavoritesGroupAction
extends AbstractAction {
    private Frame _frame;
    private FavoritesContainerLogicalObjectInterface _parent;

    private NewFavoritesGroupAction(Frame frame) {
        this._frame = frame;
        Util.setLabelAndMnemonicOnAction((Action)this, (String)RB.getStringResource("NewFavoritesGroupAction.Label.txt"));
        this.putValue("SmallIcon", Images.getNewObjectIcon((String)"FavoritesFolder"));
        this.putValue("ShortDescription", RB.getStringResource("NewFavoritesGroupAction.ToolTip.txt"));
    }

    public NewFavoritesGroupAction(Frame frame, FavoritesContainerLogicalObjectInterface logicalObject) {
        this(frame);
        this._parent = logicalObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._parent == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            childServer = server.newChild(true);
            String key = this._parent.getID() + "/" + this._parent.getTypeInterface().getMetadataType();
            MetadataInterface mi = childServer.fetch(key, true);
            if (!(mi instanceof FavoritesContainer)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesGroupAction.NoFolder.fmt.txt", (Object)this._parent.getName());
                throw new ServiceException(msg);
            }
            NewFavoritesGroupDialog dialog = new NewFavoritesGroupDialog(this._frame, (FavoritesContainer)mi);
            dialog.show();
        }
        catch (ServiceException ex) {
            UtilGui.displayExceptionError((Exception)((Object)ex));
        }
        catch (RemoteException re) {
            UtilGui.displayRemoteException((RemoteException)re);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.destroy();
                }
                catch (Exception ex) {}
            }
        }
    }
}

