/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.favorites.FavoritesFactory;
import com.sas.services.information.metadata.favorites.FavoritesFolder;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.WAGeneralPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ResourceBundle;

public class NewFavoritesFolderDialog
extends WAPropertyDialog {
    private WAGeneralPanel _generalPanel;
    private FolderInterface _parentFolder;
    private FavoritesFolder _favoritesFolder;

    public NewFavoritesFolderDialog(Frame frm, FolderInterface parentFolder) {
        super(frm, true);
        this._parentFolder = parentFolder;
        this.setTitle(RB.getStringResource("NewFavoritesFolderDialog.Title.txt"));
        this.initialize();
    }

    protected void initialize() {
        super.initialize();
        this.setHelpProduct("shared");
        this.setHelpTopic("new_favorites_folder");
        this._generalPanel = new WAGeneralPanel(null, null, false, false, false, false);
        this._generalPanel.setPreferredSize(new Dimension(400, 200));
        this._generalPanel.enableNameValidation(true);
        this._generalPanel.setHelpProduct("shared");
        this._generalPanel.setHelpTopic("new_favorites_folder");
        this.setMainPanel((WAPanel)this._generalPanel);
        this.setResizable(true);
    }

    public FavoritesFolder getNewFavoritesFolder() {
        return this._favoritesFolder;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        try {
            if (!bSaveToModel) {
                this._generalPanel.moveDataToView();
                return true;
            }
            return this.createFavoritesFolder();
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        return false;
    }

    public boolean validateData() {
        boolean state = this._generalPanel.validateData();
        if (!state) {
            return state;
        }
        if (this._parentFolder == null) {
            MessageUtil.displayMessage((String)RB.getStringResource("NewFavoritesFolderDialog.NoFolder.txt"), (int)0);
            return false;
        }
        try {
            String name = this._generalPanel.getNameComponent().getText().trim();
            boolean isDuplicate = this._parentFolder.hasDuplicate(name, "FavoritesFolder");
            if (isDuplicate) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesFolderDialog.Title.DuplicateName.fmt.txt", (Object)name);
                MessageUtil.displayMessage((String)msg, (int)0);
                return false;
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)se);
            return false;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return false;
        }
        return true;
    }

    public boolean hasDataChanged() {
        return false;
    }

    private boolean createFavoritesFolder() throws RemoteException, ServiceException {
        String name = this._generalPanel.getNameComponent().getText().trim();
        FavoritesFactory factory = FavoritesFactory.getInstance((SessionContextInterface)Workspace.getWorkspace().getSessionContext());
        FavoritesFolder folder = factory.createFavoritesFolder(name, this._parentFolder);
        if (folder != null) {
            folder.setDescription(this._generalPanel.getDescriptionComponent().getText().trim());
            folder.update();
            this._favoritesFolder = folder;
            return true;
        }
        return false;
    }
}

