/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.ActionType;
import com.sas.metadata.logical.BaseObjectFactory;
import com.sas.metadata.logical.ContainerContextInterface;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.common.GoToFolderLocationAction;
import com.sas.metadata.logical.favorites.AddFavoriteAction;
import com.sas.metadata.logical.favorites.FavoritesContainerLogicalObjectInterface;
import com.sas.metadata.logical.favorites.FavoritesGroupGeneralTab;
import com.sas.metadata.logical.favorites.FavoritesGroupLogicalObject;
import com.sas.metadata.logical.favorites.NewFavoritesGroupAction;
import com.sas.metadata.logical.favorites.RemoveAction;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.NonFolderMemberGeneralPropertyTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.FavoritesContainer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class FavoritesGroupObjectFactory
extends BaseObjectFactory
implements ContainerContextInterface {
    public FavoritesGroupObjectFactory(TypeInterface type) {
        super(type);
    }

    public FavoritesGroupObjectFactory(TypeInterface type, Factory factory) {
        super(type, factory);
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        return new FavoritesGroupLogicalObject((FavoritesContainer)root, this._type, this._factory);
    }

    protected NonFolderMemberGeneralPropertyTab getNonFolderMemberGeneralPropertyTab(Root root, Config config) throws MdException, RemoteException, ServiceException {
        config.setVisible(ConfigGeneralPanel.CONTEXT, false);
        return new FavoritesGroupGeneralTab(root, 1, this._type, config);
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) throws RemoteException {
        if (logicalObject instanceof FavoritesContainerLogicalObjectInterface) {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>(2);
            try {
                boolean isWriteAllowed = ((FavoritesContainerLogicalObjectInterface)logicalObject).isCreateChildAllowed();
                NewFavoritesGroupAction groupAction = new NewFavoritesGroupAction(this.getFactory().getFrame(), (FavoritesContainerLogicalObjectInterface)logicalObject);
                groupAction.setEnabled(isWriteAllowed);
                actions.add(groupAction);
                AddFavoriteAction addAction = new AddFavoriteAction((FavoritesContainerLogicalObjectInterface)logicalObject);
                addAction.setEnabled(isWriteAllowed);
                actions.add(addAction);
                return actions.toArray(new Action[actions.size()]);
            }
            catch (Exception e) {
                UtilGui.displayExceptionError((Exception)e);
            }
        }
        return EMPTY_ACTION_ARRAY;
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) throws RemoteException {
        if (logicalObjects != null && logicalObjects.length == 1 && roots != null && roots.length == 1) {
            return this.getActions(logicalObjects[0], roots[0], config);
        }
        return EMPTY_ACTION_ARRAY;
    }

    public Action[] getActionsForMembers(LogicalObjectInterface container, List<LogicalObjectInterface> selectedMembers, List<PublicObjectInterface> allMembers) throws RemoteException {
        if (container instanceof FavoritesContainerLogicalObjectInterface) {
            ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>(3);
            if (selectedMembers != null && selectedMembers.size() == 1) {
                LogicalObjectInterface obj = selectedMembers.get(0);
                try {
                    if (this._factory.isTypeContainedByFolder(obj.getTypeInterface().getPublicType())) {
                        GoToFolderLocationAction act = new GoToFolderLocationAction(obj);
                        actions.add(act);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean containsGroup = false;
            if (selectedMembers != null) {
                for (LogicalObjectInterface obj : selectedMembers) {
                    if (!(obj instanceof FavoritesGroupLogicalObject)) continue;
                    containsGroup = true;
                    break;
                }
            }
            if (!containsGroup) {
                actions.add(new RemoveAction((FavoritesContainerLogicalObjectInterface)container, selectedMembers));
            }
            return actions.toArray(new Action[actions.size()]);
        }
        return EMPTY_ACTION_ARRAY;
    }

    public boolean isActionSupportedForMembers(ActionType action, LogicalObjectInterface container, List<LogicalObjectInterface> selectedMembers) throws ServiceException, RemoteException {
        switch (action) {
            case DELETE: 
            case RENAME: {
                boolean favoritesExist = false;
                if (selectedMembers != null && !selectedMembers.isEmpty()) {
                    for (LogicalObjectInterface member : selectedMembers) {
                        if (member instanceof FavoritesGroupLogicalObject) continue;
                        favoritesExist = true;
                        break;
                    }
                }
                return !favoritesExist;
            }
        }
        return true;
    }
}

