/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.favorites.FavoritesFolderImportItem;
import com.sas.metadata.logical.favorites.FavoritesImportOptionsPanel;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesFolder;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.JPanel;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class FavoritesFolderImportListener
extends AbstractImportListener
implements ImportListener,
PromotionOptionsInterface {
    private int _rc = 0;
    private FavoritesImportOptionsPanel _optionsPanel;

    public FavoritesFolderImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new FavoritesFolderImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        this._rc = 0;
        if (objects != null && !objects.isEmpty()) {
            for (ImportItemInterface importItem : objects) {
                if (importItem.getImportState() != 2 || !(importItem instanceof FavoritesFolderImportItem) || ((FavoritesFolderImportItem)importItem).isReplacingFavorites()) continue;
                this.mergeFavorites(operation, importItem);
            }
        }
        return this._rc;
    }

    private void mergeFavorites(ImportOperationInterface operation, ImportItemInterface importItem) {
        String targetID = importItem.getTargetID();
        if (targetID != null && targetID.length() > 0) {
            try {
                FavoritesFolder folder = (FavoritesFolder)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetID, (String)"FavoritesContainer");
                if (folder == null) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.FolderNotFound.fmt.txt", (Object)importItem.getName());
                    operation.getLogger().error((Object)msg);
                    this._rc |= 8;
                    return;
                }
                this.mergeFavoritesContainer((FavoritesContainer)folder, importItem.getNestedItems());
            }
            catch (ServiceException e) {
                operation.getLogger().error((Object)e.getLocalizedMessage());
                this._rc |= 8;
            }
            catch (RemoteException e) {
                operation.getLogger().error((Object)e.getLocalizedMessage());
                this._rc |= 8;
            }
        }
    }

    private void mergeFavoritesContainer(FavoritesContainer targetContainer, List childGroups) throws ServiceException, RemoteException {
        if (childGroups == null || childGroups.isEmpty()) {
            return;
        }
        for (NestedImportItemInterface item : childGroups) {
            FavoritesGroup targetGroup = null;
            if (targetContainer == null) {
                item.setImportState(1);
            } else {
                targetGroup = this.getTargetGroupByName(targetContainer, item.getName());
                if (targetGroup != null) {
                    item.setImportState(2);
                    item.setTargetID(targetGroup.getIdentifier());
                } else if (targetContainer.hasDuplicateFavoritesGroup(item.getName())) {
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.GroupExists.fmt.txt", (Object)item.getName(), (Object)targetContainer.getName());
                    item.getImportOperation().getLogger().warn((Object)msg);
                    this._rc |= 4;
                    this.disableFavoritesGroup(item);
                } else {
                    item.setImportState(1);
                }
            }
            if (!item.containsNestedItems()) continue;
            this.mergeFavoritesContainer((FavoritesContainer)targetGroup, item.getNestedItems());
        }
    }

    private void disableFavoritesGroup(NestedImportItemInterface item) {
        item.setImportState(0);
        if (item.containsNestedItems()) {
            for (NestedImportItemInterface childItem : item.getNestedItems()) {
                this.disableFavoritesGroup(childItem);
            }
        }
    }

    private FavoritesGroup getTargetGroupByName(FavoritesContainer targetContainer, String groupName) throws ServiceException, RemoteException {
        if (targetContainer != null) {
            List groups = targetContainer.getFavoritesGroups();
            for (FavoritesGroup group : groups) {
                if (!groupName.equalsIgnoreCase(group.getName())) continue;
                return group;
            }
        }
        return null;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        this._rc = 0;
        if (objects != null && !objects.isEmpty()) {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            for (ImportItemInterface importItem : objects) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.AddingFavorites.fmt.txt", (Object)importItem.toString());
                this.fireDisplayMessage(msg);
                operation.getLogger().info((Object)msg);
                if (!(importItem instanceof FavoritesFolderImportItem)) continue;
                this.importFavorites(operation, inputFactory, (FavoritesFolderImportItem)importItem);
            }
        }
        return this._rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFavorites(ImportOperationInterface operation, XMLInputFactory inputFactory, FavoritesFolderImportItem importItem) {
        boolean isRefreshNeeded = false;
        if (importItem.getImportState() == 2) {
            isRefreshNeeded = true;
        }
        XMLStreamReader streamReader = null;
        try {
            Map contentMap = operation.getContentHandler().getTextContent(importItem.getID());
            Reader rdr = (Reader)contentMap.get(importItem.getID());
            if (rdr == null) {
                return;
            }
            MetadataInterface mi = PromotionUtil.getSmartObject((ServerInterface)operation.getServer(), (String)importItem.getTargetID(), (String)"FavoritesContainer");
            if (mi instanceof FavoritesFolder) {
                FavoritesFolder folder = (FavoritesFolder)mi;
                if (isRefreshNeeded) {
                    folder.refresh();
                }
                Stack<Object> containerStack = new Stack<Object>();
                containerStack.add(folder);
                if (importItem.isReplacingFavorites()) {
                    folder.removeAllFavorites();
                }
                streamReader = inputFactory.createXMLStreamReader(rdr);
                block31: while (streamReader.hasNext()) {
                    int event = streamReader.next();
                    switch (event) {
                        case 7: {
                            break;
                        }
                        case 1: {
                            FavoritesContainer container = (FavoritesContainer)containerStack.get(containerStack.size() - 1);
                            String name = streamReader.getLocalName();
                            if ("Favorite".equalsIgnoreCase(name)) {
                                this.addFavorite(operation, container, streamReader.getAttributeValue(null, "Path"));
                                break;
                            }
                            if (!"Group".equalsIgnoreCase(name)) break;
                            String groupName = streamReader.getAttributeValue(null, "Name");
                            FavoritesGroup group = this.getTargetGroupByName(container, groupName);
                            containerStack.add(group);
                            if (group == null) {
                                operation.getLogger().debug((Object)("The favorites group \"" + groupName + "\" could not be found.  The favorites will not be added to it."));
                                break;
                            }
                            if (importItem.isReplacingFavorites()) {
                                group.removeAllFavorites();
                                break;
                            }
                            if (!isRefreshNeeded) continue block31;
                            group.refresh();
                            break;
                        }
                        case 2: {
                            if (!"Group".equalsIgnoreCase(streamReader.getLocalName())) break;
                            containerStack.pop();
                            break;
                        }
                    }
                }
                folder.update();
            }
        }
        catch (ServiceException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.MetadataError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error retreiving metadata", (Throwable)e);
            }
        }
        catch (XMLStreamException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.ParsingError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error parsing xml", (Throwable)e);
            }
        }
        catch (IOException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.LoadContentsError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error reading content", (Throwable)e);
            }
        }
        catch (Exception e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.ContentError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Exception occurred", (Throwable)e);
            }
        }
        finally {
            try {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
            catch (Exception e) {
                operation.getLogger().debug((Object)"Unable to close input/output streams.");
            }
        }
    }

    private void addFavorite(ImportOperationInterface operation, FavoritesContainer container, String path) throws ServiceException, RemoteException {
        PathUrl url;
        if (path == null || container == null) {
            return;
        }
        ServerInterface server = operation.getServer();
        MetadataInterface mi = server.getObjectByPath(url = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path));
        if (mi == null) {
            operation.getLogger().warn((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesImportListener.ObjectNotFound.fmt.txt", (Object)url.getAbsolutePath()));
            this._rc |= 4;
            return;
        }
        if (!container.containsFavorite(mi)) {
            container.addFavorite(mi);
        }
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface operation) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface operation) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new FavoritesImportOptionsPanel();
        }
        this._optionsPanel.populateImportOptions(items);
        return this._optionsPanel;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }
}

