/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.metadata.favorites.FavoritesFolder;
import com.sas.services.information.metadata.favorites.FavoritesGroup;
import com.sas.text.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class FavoritesFolderExportListener
extends AbstractExportListener
implements ExportListener {
    private int _rc = 0;

    public FavoritesFolderExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException {
        this._rc = 0;
        if (objects != null && !objects.isEmpty()) {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            for (ExportItemInterface exportItem : objects) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.RetrievingFavorites.fmt.txt", (Object)exportItem.toString());
                this.fireDisplayMessage(msg);
                operation.getLogger().info((Object)msg);
                this.exportFavorites(operation, outputFactory, exportItem.getID());
            }
        }
        return this._rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportFavorites(ExportOperationInterface operation, XMLOutputFactory outputFactory, String id) {
        XMLStreamWriter streamWriter = null;
        try {
            MetadataInterface mi = PromotionUtil.getSmartObject((ServerInterface)operation.getServer(), (String)id, (String)"FavoritesContainer");
            if (mi instanceof FavoritesFolder) {
                FavoritesFolder folder = (FavoritesFolder)mi;
                if (folder.isEmpty()) {
                    return;
                }
                StringWriter sw = new StringWriter();
                streamWriter = outputFactory.createXMLStreamWriter(sw);
                streamWriter.writeStartDocument("UTF-8", "1.0");
                streamWriter.writeStartElement("Favorites");
                streamWriter.writeAttribute("Path", folder.getPathUrl().getAbsolutePath());
                this.addFavorites(operation, (FavoritesContainer)folder, streamWriter);
                streamWriter.writeEndElement();
                streamWriter.writeEndDocument();
                StringReader sr = new StringReader(sw.toString());
                operation.getContentHandler().addTextContent(id, null, (Reader)sr);
            }
        }
        catch (ServiceException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.MetadataError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error retreiving metadata", (Throwable)e);
            }
        }
        catch (XMLStreamException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.WritingError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error creating xml", (Throwable)e);
            }
        }
        catch (IOException e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.SaveContentsError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Error adding content", (Throwable)e);
            }
        }
        catch (Exception e) {
            this._rc |= 8;
            operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.ContentError.fmt.txt", (Object)e.getLocalizedMessage()));
            if (operation.getLogger().isDebugEnabled()) {
                operation.getLogger().debug((Object)"Exception occurred", (Throwable)e);
            }
        }
        finally {
            try {
                if (streamWriter != null) {
                    streamWriter.close();
                }
            }
            catch (Exception e) {
                operation.getLogger().debug((Object)"Unable to close input/output streams.");
            }
        }
    }

    private void addFavorites(ExportOperationInterface operation, FavoritesContainer container, XMLStreamWriter streamWriter) throws ServiceException, RemoteException, XMLStreamException {
        List groups = container.getFavoritesGroups();
        for (FavoritesGroup group : groups) {
            streamWriter.writeStartElement("Group");
            streamWriter.writeAttribute("Name", group.getName());
            this.addFavorites(operation, (FavoritesContainer)group, streamWriter);
            streamWriter.writeEndElement();
        }
        List favorites = container.getFavorites();
        for (MetadataInterface favorite : favorites) {
            PathUrl path = favorite.getPathUrl();
            if (path == null) {
                this._rc |= 4;
                operation.getLogger().error((Object)Message.format((ResourceBundle)RB.getResources(), (String)"FavoritesExportListener.ObjectNotFound.fmt.txt", (Object)favorite.getTypeDescriptor().getTypeName(), (Object)favorite.getName()));
                continue;
            }
            streamWriter.writeStartElement("Favorite");
            streamWriter.writeAttribute("Path", path.getAbsolutePath());
            streamWriter.writeEndElement();
        }
    }
}

