/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.favorites;

import com.sas.metadata.logical.ActionContextInterface;
import com.sas.metadata.logical.ContainerChangeEvent;
import com.sas.metadata.logical.favorites.FavoritesContainerLogicalObjectInterface;
import com.sas.metadata.logical.favorites.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.favorites.FavoritesContainer;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;

class AddFavoriteAction
extends AbstractAction
implements ActionContextInterface {
    private FavoritesContainerLogicalObjectInterface _container;
    private final String ACTION_CONTEXT = "FAVORITES_CONTEXT";

    public AddFavoriteAction(FavoritesContainerLogicalObjectInterface container) {
        this._container = container;
        Util.setLabelAndMnemonicOnAction((Action)this, (String)RB.getStringResource("AddFavoriteAction.AddItem.txt"));
        this.putValue("ShortDescription", RB.getStringResource("AddFavoriteAction.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._container == null) {
            return;
        }
        ChildServerInterface childServer = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            childServer = server.newChild(true);
            String key = this._container.getID() + "/" + this._container.getTypeInterface().getMetadataType();
            MetadataInterface mi = childServer.fetch(key, true);
            if (!(mi instanceof FavoritesContainer)) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"NewFavoritesFolderAction.NoFolder.fmt.txt", (Object)this._container.getName());
                throw new ServiceException(msg);
            }
            MetadataInterface favorite = this.selectObject((ServerInterface)childServer);
            if (favorite != null && !((FavoritesContainer)mi).containsFavorite(favorite)) {
                ((FavoritesContainer)mi).addFavorite(favorite);
                mi.update();
                ContainerChangeEvent event = new ContainerChangeEvent(this, ContainerChangeEvent.EventType.MEMBER_ADDED, (PublicObjectContainerInterface)((FavoritesContainer)mi), (PublicObjectInterface)favorite);
                this.firePropertyChange("CONTAINER_CHANGE_EVENT", null, event);
            }
        }
        catch (Exception ex) {
            UtilGui.displayExceptionError((Exception)ex);
        }
        finally {
            if (childServer != null) {
                try {
                    childServer.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataInterface selectObject(ServerInterface server) {
        LinkedHashMap<String, Object> mapFileTypes = new LinkedHashMap<String, Object>(1);
        mapFileTypes.put(RB.getStringResource("AddFavoriteAction.FileSelector.AllTypes.txt"), InformationServicesSelectorPanel.ALL_TYPES);
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(null, server, mapFileTypes);
        panel.setShowDirectoriesOnly(false);
        panel.setSelectionMode(InformationServicesSelectorPanel.FILES_AND_DIRECTORIES);
        panel.setMultiSelectionEnabled(false);
        panel.setRootFolderSelectable(false);
        RemoteFileSelectorDialog dialog = null;
        dialog = new RemoteFileSelectorDialog((Frame)Workspace.getWorkspace(), RB.getStringResource("AddFavoriteAction.FileSelector.Title.txt"), true, 2, (BaseRemoteFileSelectorPanel)panel);
        dialog.setAllowNonExistentSelections(false);
        dialog.setVisible(true);
        try {
            List lReturnedItems;
            if (!panel.isCancelled() && (lReturnedItems = panel.getReturnedInformation(true)) != null && !lReturnedItems.isEmpty()) {
                String path = lReturnedItems.get(0).toString();
                PathUrl pathUrl = new PathUrl(path);
                MetadataInterface metadataInterface = server.getObjectByPath(pathUrl);
                return metadataInterface;
            }
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AddFavoriteAction.Error.fmt.txt", (Object)this._container.getName());
            MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("Common.ErrorDialog.Title.txt"), (int)0);
        }
        finally {
            dialog.dispose();
        }
        return null;
    }

    public String getActionContext() {
        return "FAVORITES_CONTEXT";
    }
}

