/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.common;

import com.sas.metadata.logical.common.RB;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATable;
import com.sas.workspace.WATableModel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.Workspace;
import com.sas.workspace.connection.ConnectionManager;
import com.sas.workspace.visuals.TableCellEditorManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ConfigurationPropertiesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    SoftwareComponent m_metadata = null;
    protected cPropTableModel m_optionsModel;
    protected JLabel m_configPropLabel;
    protected WATextArea m_noConfigPropsText;
    protected JScrollPane m_noConfigPropsPanel;
    protected WATable m_configPropsTable;
    protected JScrollPane m_configPropsPanel;
    protected cPropTableModel m_modeledOptionsModel;
    protected JLabel m_modeledOptionLabel;
    protected WATable m_modeledOptionsTable;
    protected JScrollPane m_modeledAttrPanel;
    protected ConnectionManager m_cm;
    protected Map m_publicProps;
    protected Map m_privateProps;
    protected Map m_modeledProps;
    protected HashMap m_newPublicProps;
    protected HashMap m_newPrivateProps;
    protected TableModelListener m_tableModelListener;
    public static int STORED = 0;
    public static int MODELED = 1;
    protected boolean m_modeledAttrs = true;

    public ConfigurationPropertiesTab(CMetadata metaObject) {
        this.m_metadata = (SoftwareComponent)metaObject;
        this.m_cm = Workspace.getWorkspace().getConnectionManager();
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        int i;
        this.m_optionsModel = new cPropTableModel(STORED);
        this.m_configPropsTable = new WATable((WATableModel)this.m_optionsModel, false);
        this.m_configPropLabel = new JLabel(RB.getStringResource("ConfigPropTab.OptionInfo.txt"));
        this.m_configPropsPanel = new JScrollPane((Component)this.m_configPropsTable, 20, 30);
        this.m_configPropsTable.setToolTipColumn(3);
        this.m_modeledOptionsModel = new cPropTableModel(MODELED);
        if (this.m_modeledOptionsModel.getRowCount() == 0) {
            this.m_modeledAttrs = false;
        } else {
            this.m_modeledOptionsTable = new WATable((WATableModel)this.m_modeledOptionsModel, false);
            this.m_modeledOptionLabel = new JLabel(RB.getStringResource("ConfigPropTab.ModeledOptionInfo.txt"));
            this.m_modeledAttrPanel = new JScrollPane((Component)this.m_modeledOptionsTable, 20, 30);
            this.m_modeledOptionsTable.setToolTipColumn(3);
        }
        this.m_noConfigPropsText = new WATextArea(RB.getStringResource("ConfigPropTab.NoOptions.txt"));
        this.m_noConfigPropsText.setBehavior(1);
        this.m_noConfigPropsPanel = new JScrollPane((Component)this.m_noConfigPropsText);
        if (this.m_optionsModel.getRowCount() == 0) {
            this.displayLabel(this.m_configPropsPanel, this.m_noConfigPropsPanel);
        }
        this.m_configPropsTable.sort(0, true);
        TableColumn column = null;
        for (i = 0; i < 2; ++i) {
            column = this.m_configPropsTable.getColumnModel().getColumn(i);
            if (i == 2) {
                column.setPreferredWidth(40);
                continue;
            }
            column.setPreferredWidth(500);
        }
        if (this.m_modeledAttrs) {
            column = null;
            for (i = 0; i < 2; ++i) {
                column = this.m_modeledOptionsTable.getColumnModel().getColumn(i);
                if (i == 2) {
                    column.setPreferredWidth(40);
                    continue;
                }
                column.setPreferredWidth(500);
            }
            this.m_modeledOptionsTable.sort(0, true);
        }
        super.setEditable(true);
        this.setHelpTopic("app_config_tab");
        this.setHelpProduct("shared");
        super.setName(RB.getStringResource("ConfigPropTab.Name.txt"));
        this.m_tableModelListener = new cPropTableListener(this);
        this.m_optionsModel.addTableModelListener(this.m_tableModelListener);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        if (this.m_modeledAttrs) {
            this.m_configPropsPanel.setPreferredSize(new Dimension(200, 280));
            this.m_modeledAttrPanel.setPreferredSize(new Dimension(200, 280));
            this.m_noConfigPropsPanel.setPreferredSize(new Dimension(200, 280));
            this.add(this.m_modeledOptionLabel, new GridBagConstraints(0, 0, -1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_modeledAttrPanel, new GridBagConstraints(0, 1, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_configPropLabel, new GridBagConstraints(0, 2, -1, 1, 1.0, 0.0, 18, 1, new Insets(20, 0, 0, 0), 0, 0));
            this.add(this.m_configPropsPanel, new GridBagConstraints(0, 3, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_noConfigPropsPanel, new GridBagConstraints(0, 3, -1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add(this.m_configPropLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_configPropsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.m_noConfigPropsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public boolean validateData() {
        if (this.m_bDataChanged) {
            this.updateDialogProperties();
            try {
                ConfigurablePropertiesUtil.setObjectProperties((SoftwareComponent)this.m_metadata, (Map)this.m_newPublicProps, (Map)this.m_newPrivateProps);
            }
            catch (RemoteException remoteException) {
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Writing");
            }
        }
        return true;
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_optionsModel.setupModel();
        this.m_configPropsTable.sort(0, true);
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        TableCellEditorManager locem = new TableCellEditorManager((JTable)this.m_configPropsTable);
        ArrayList cellChoices = null;
        Vector comboItems = null;
        for (int i = 0; i < this.m_configPropsTable.getRowCount(); ++i) {
            cellChoices = this.m_optionsModel.getCellChoices(i);
            comboItems = new Vector();
            for (int j = 0; j < cellChoices.size(); ++j) {
                comboItems.add(cellChoices.get(j));
            }
            if (comboItems.size() <= 1) continue;
            locem.setEditorAt(i, (TableCellEditor)new DefaultCellEditor(new JComboBox(comboItems)));
        }
        this.m_configPropsTable.getColumn((Object)this.m_configPropsTable.getColumnName(2)).setCellEditor((TableCellEditor)locem);
    }

    public void stateChanged(ChangeEvent e) {
        this.setDataChanged(true);
    }

    public void modelChanged(TableModelEvent e) {
        this.setDataChanged(true);
    }

    public void undoChange() {
        try {
            this.moveDataToView();
            this.setDataChanged(false);
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
    }

    public void setListeningForChanges(boolean bListeningForChanges) {
        this.m_bListeningForChanges = bListeningForChanges;
        if (!bListeningForChanges) {
            this.m_optionsModel.removeTableModelListener(this.m_tableModelListener);
        } else {
            this.m_optionsModel.addTableModelListener(this.m_tableModelListener);
        }
    }

    public void updateDialogProperties() {
        if (this.m_newPublicProps != null && this.m_newPublicProps.size() > 0) {
            this.m_newPublicProps.clear();
        }
        if (this.m_newPrivateProps != null && this.m_newPrivateProps.size() > 0) {
            this.m_newPrivateProps.clear();
        }
        if (this.m_newPublicProps == null) {
            this.m_newPublicProps = new HashMap();
        }
        if (this.m_newPrivateProps == null) {
            this.m_newPrivateProps = new HashMap();
        }
        for (int i = 0; i < this.m_optionsModel.getRowCount(); ++i) {
            Object obj = this.m_optionsModel.getValueAt(i, 2);
            String scope = "Public";
            if (obj instanceof cOptionInfo) {
                scope = ((cOptionInfo)obj).getActualValue();
            }
            if (scope.equals("Public")) {
                this.m_newPublicProps.put((String)this.m_optionsModel.getValueAt(i, 0), (String)this.m_optionsModel.getValueAt(i, 1));
                continue;
            }
            this.m_newPrivateProps.put((String)this.m_optionsModel.getValueAt(i, 0), (String)this.m_optionsModel.getValueAt(i, 1));
        }
    }

    protected void displayLabel(JScrollPane panel, JScrollPane label) {
        panel.setVisible(false);
        label.setVisible(true);
        this.validate();
        this.repaint();
    }

    protected void displayPane(JScrollPane panel, JScrollPane label) {
        panel.setVisible(true);
        label.setVisible(false);
        this.validate();
        this.repaint();
    }

    protected class cPropTableModel
    extends WATableModel {
        private static final long serialVersionUID = 1L;
        protected ArrayList m_cellChoices = new ArrayList();
        protected boolean[] m_columnIsEditable = new boolean[]{false, true, true, false};
        protected boolean[] m_columnIsChoice = new boolean[]{false, false, true, false};
        protected int m_type = STORED;

        public cPropTableModel(int type) {
            this.columnNames.add(RB.getStringResource("ConfigPropModel.Name.txt"));
            this.columnNames.add(RB.getStringResource("ConfigPropModel.Value.txt"));
            this.columnNames.add(RB.getStringResource("ConfigPropModel.Scope.txt"));
            this.m_type = type;
            if (this.m_type == MODELED) {
                this.m_columnIsEditable[1] = false;
                this.m_columnIsEditable[2] = false;
                this.m_columnIsChoice[2] = false;
            }
            this.setupModel();
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public String getColumnName(int col) {
            return (String)this.columnNames.get(col);
        }

        public String getRowName(int row) {
            return String.valueOf(row + 1);
        }

        public boolean isCellEditable(int row, int col) {
            return this.m_columnIsEditable[col];
        }

        public Object getRowValue(int row) {
            return String.valueOf(row + 1);
        }

        public void setupModel() {
            try {
                ConfigurationPropertiesTab.this.m_publicProps = new HashMap();
                ConfigurationPropertiesTab.this.m_privateProps = new HashMap();
                ConfigurationPropertiesTab.this.m_modeledProps = new HashMap();
                ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)ConfigurationPropertiesTab.this.m_metadata, (Map)ConfigurationPropertiesTab.this.m_publicProps, (Map)ConfigurationPropertiesTab.this.m_privateProps);
                if (this.m_type == STORED) {
                    if (ConfigurationPropertiesTab.this.m_publicProps != null && ConfigurationPropertiesTab.this.m_publicProps.size() > 0) {
                        cOptionInfo scope;
                        String propValue;
                        int count = 0;
                        int rows = this.getRowCount();
                        for (int i = rows - 1; i >= 0; --i) {
                            this.deleteRow(i);
                        }
                        this.fireTableRowsDeleted(0, rows);
                        Set ks = ConfigurationPropertiesTab.this.m_publicProps.keySet();
                        for (String propName : ks) {
                            if (ConfigurationPropertiesTab.this.m_modeledProps.get(propName) != null) continue;
                            propValue = (String)ConfigurationPropertiesTab.this.m_publicProps.get(propName);
                            scope = new cOptionInfo(RB.getStringResource("ConfigPropTab.Public.txt"), "Public");
                            this.insertRow(propName, propValue, scope, propValue);
                            ++count;
                        }
                        if (ConfigurationPropertiesTab.this.m_privateProps != null && ConfigurationPropertiesTab.this.m_privateProps.size() > 0) {
                            ks = ConfigurationPropertiesTab.this.m_privateProps.keySet();
                            for (String propName : ks) {
                                if (ConfigurationPropertiesTab.this.m_modeledProps.get(propName) != null) continue;
                                propValue = (String)ConfigurationPropertiesTab.this.m_privateProps.get(propName);
                                scope = new cOptionInfo(RB.getStringResource("ConfigPropTab.Private.txt"), "Private");
                                this.insertRow(propName, propValue, scope, propValue);
                                ++count;
                            }
                        }
                        this.fireTableRowsInserted(0, count);
                    }
                } else {
                    int count = 0;
                    int rows = this.getRowCount();
                    for (int i = rows - 1; i >= 0; --i) {
                        this.deleteRow(i);
                    }
                    this.fireTableRowsDeleted(0, rows);
                    if (ConfigurationPropertiesTab.this.m_modeledProps != null && ConfigurationPropertiesTab.this.m_modeledProps.size() > 0) {
                        Set ks = ConfigurationPropertiesTab.this.m_modeledProps.keySet();
                        for (String propName : ks) {
                            String propValue = (String)ConfigurationPropertiesTab.this.m_privateProps.get(propName);
                            cOptionInfo scope = new cOptionInfo(RB.getStringResource("ConfigPropTab.Modeled.txt"), "Modeled");
                            this.insertRow(propName, propValue, scope, propValue);
                            ++count;
                        }
                    }
                    this.fireTableRowsInserted(0, count);
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
            catch (MdException e) {
                MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
            }
        }

        public boolean insertRow(String name, String value, cOptionInfo scope, String toolTip) {
            ++this.instanceCount;
            ArrayList<Object> m = new ArrayList<Object>();
            m.add(name);
            m.add(value);
            m.add(scope);
            m.add(toolTip);
            this.m_cellChoices.add(this.getPossibleValues());
            this.data.add(m);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return true;
        }

        public void removeData() {
            this.data.clear();
            this.m_cellChoices.clear();
        }

        public ArrayList getCellChoices(int row) {
            return (ArrayList)this.m_cellChoices.get(row);
        }

        private ArrayList getPossibleValues() {
            ArrayList<cOptionInfo> values = new ArrayList<cOptionInfo>();
            cOptionInfo publicChoice = new cOptionInfo(RB.getStringResource("ConfigPropTab.Public.txt"), "Public");
            cOptionInfo privateChoice = new cOptionInfo(RB.getStringResource("ConfigPropTab.Private.txt"), "Private");
            values.add(publicChoice);
            values.add(privateChoice);
            return values;
        }
    }

    private class cPropTableListener
    implements TableModelListener {
        ConfigurationPropertiesTab propTab = null;
        boolean dialogShown = false;

        public cPropTableListener(ConfigurationPropertiesTab t) {
            this.propTab = t;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (!this.dialogShown) {
                int dialogAction = MessageUtil.displayMessage((String)RB.getStringResource("ConfigPropTab.Warning.Dialog.txt"), (int)2, (int)2);
                this.dialogShown = true;
                if (dialogAction == 0) {
                    this.propTab.modelChanged(e);
                }
                if (dialogAction == 2) {
                    this.propTab.undoChange();
                    this.dialogShown = false;
                }
            } else {
                this.propTab.modelChanged(e);
            }
        }
    }

    private class cOptionInfo {
        String displayValue = new String("");
        String actualValue = new String("");

        public cOptionInfo(String displayValue, String actualValue) {
            this.displayValue = displayValue;
            this.actualValue = actualValue;
        }

        public String getActualValue() {
            return this.actualValue;
        }

        public void setActualValue(String actualValue) {
            this.actualValue = actualValue;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        public String toString() {
            return this.displayValue;
        }
    }
}

