/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.metadata.logical.channel.ResourceFilter;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.DavPropertyItem;
import com.sas.services.webdav.DavPropertyResult;
import com.sas.services.webdav.PropertyMap;
import com.sas.services.webdav.PropertyName;
import com.sas.services.webdav.Utils;
import com.sas.services.webdav.WebDavProperty;
import com.sas.services.webdav.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;

public class ResourceFinder {
    static List<String> propNamesList = null;
    static boolean allProperties;
    static PropertyName[] propNames;

    public static void getResources(DAVResource r, ResourceFilter filter, List<Map<String, Map<String, String>>> returnList, boolean stopWhenFound) throws DAVException, RemoteException {
        if (propNamesList == null) {
            propNamesList = filter.getPropertyList();
            if (propNamesList == null) {
                return;
            }
            if (propNamesList.isEmpty()) {
                allProperties = true;
            } else {
                allProperties = false;
                if (!propNamesList.contains("{DAV:}resourcetype")) {
                    propNamesList.add("{DAV:}resourcetype");
                }
                propNames = new PropertyName[propNamesList.size()];
                for (int i = 0; i < propNames.length; ++i) {
                    ResourceFinder.propNames[i] = new PropertyName(propNamesList.get(i));
                }
            }
        }
        String currUrl = r.getURL().toString();
        boolean depth = true;
        DavPropertyResult davPropertyResult = allProperties ? r.getDavProperties(1) : r.getDavProperties(propNames, 1);
        HashMap rMap = new HashMap();
        List davPropertyItems = davPropertyResult.getDavProperties();
        ResourceFinder.transformProperties(davPropertyItems, rMap, currUrl);
        for (Map.Entry me : rMap.entrySet()) {
            String newurl = (String)me.getKey();
            if (Utils.isSameUrl((String)newurl, (String)currUrl)) continue;
            Map pMap = (Map)me.getValue();
            if (filter.accept(pMap)) {
                String key = ResourceFinder.extractPath((String)me.getKey());
                HashMap<String, Map> results = new HashMap<String, Map>(1);
                results.put(key, pMap);
                returnList.add(results);
                if (stopWhenFound || !"COLLECTION".equals(pMap.get("{DAV:}resourcetype"))) continue;
                r.setPath(ResourceFinder.extractPath(newurl));
                ResourceFinder.getResources(r, filter, returnList, stopWhenFound);
                continue;
            }
            if (!"COLLECTION".equals(pMap.get("{DAV:}resourcetype"))) continue;
            r.setPath(ResourceFinder.extractPath(newurl));
            ResourceFinder.getResources(r, filter, returnList, stopWhenFound);
        }
    }

    public static String extractPath(String url) {
        int p2;
        int p1 = url.indexOf("://");
        String path = p1 != -1 ? ((p2 = url.indexOf("/", p1 + 3)) != -1 ? url.substring(p2) : "/") : url;
        return path;
    }

    private static String transformProperties(List<DavPropertyItem> davPropertyItems, Map rMap, String entityUrl) throws DAVException {
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            DavProperty davProperty;
            DavPropertyName davPropertyName;
            Namespace namespace;
            Map pmap;
            String url = davPropertyItem.getDavResourceHref();
            if (url.indexOf("://") == -1) {
                try {
                    URL u = new URL(entityUrl);
                    String tempurl = u.getProtocol() + "://" + u.getHost();
                    if (u.getPort() != -1) {
                        tempurl = tempurl + (58 + u.getPort());
                    }
                    url = tempurl + url;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            if (url.endsWith("//")) {
                url = url.substring(0, url.length() - 1);
            }
            if (Utils.isSameUrl((String)entityUrl, (String)url)) {
                entityUrl = url;
            }
            if (null == (pmap = (Map)rMap.get(url))) {
                pmap = new PropertyMap();
                rMap.put(url, pmap);
            }
            String propertyNamespace = null == (namespace = (davPropertyName = (davProperty = davPropertyItem.getDavProperty()).getName()).getNamespace()).getURI() ? "" : namespace.getURI();
            String propertyNm = String.format("{%s}%s", propertyNamespace, davPropertyName.getName());
            String davPropertyValue = null;
            try {
                davPropertyValue = XMLUtil.getPropertyAsString((DavPropertyItem)davPropertyItem);
            }
            catch (ParserConfigurationException e) {
                throw new DAVException(e.getMessage(), (Exception)e, 500);
            }
            pmap.put(propertyNm, davPropertyValue);
        }
        return entityUrl;
    }

    public static List getChildrenList(DAVResource r, String path) throws DAVException, RemoteException, MalformedURLException {
        ArrayList<Object> members = new ArrayList<Object>();
        r.setPath(path);
        String currUrl = r.getURL().toString();
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        davPropertyNameSet.add(DavPropertyName.RESOURCETYPE);
        DavPropertyResult davPropertyResult = r.getDavProperties(davPropertyNameSet, 1);
        List davPropertyItems = davPropertyResult.getDavProperties();
        for (DavPropertyItem davPropertyItem : davPropertyItems) {
            String davResourcePath;
            List mems;
            String newurl = davPropertyItem.getDavResourceHref();
            if (Utils.isSameUrl((String)newurl, (String)currUrl) || members.contains(newurl)) continue;
            members.add(newurl);
            DavProperty davProperty = davPropertyItem.getDavProperty();
            if (!WebDavProperty.isResourceTypeCollection((DavProperty)davProperty) || (mems = ResourceFinder.getChildrenList(r, davResourcePath = new URL(newurl).getPath())).isEmpty()) continue;
            members.add(mems);
        }
        return members;
    }
}

