/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.MoveDisallowedCause;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.DirectoryInterface;
import com.sas.services.publish.metadata.PackageInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class ChannelLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final Logger log = Logger.getLogger(ChannelLogicalObject.class.getName());

    public ChannelLogicalObject(ITChannel mdoITChannel, TypeInterface type, Factory factory) throws RemoteException {
        super((Root)mdoITChannel, type, factory);
    }

    public boolean delete(OperationUserInteractionInterface oui) {
        String progressText = UtilMisc.getMessage((String)RB.getStringResource("CLO.UpdProgDelete.fmt.txt"), (Object)this.getName());
        oui.updateProgress(progressText);
        try {
            ChannelInterface channel;
            block19: {
                block20: {
                    channel = (ChannelInterface)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)this);
                    if (channel == null) {
                        return false;
                    }
                    if (!oui.isUserInteractionSupported()) break block19;
                    if (channel.getDeliveryTransport() != 2) break block20;
                    ContentDestination archivepath = channel.getArchivePath();
                    MdFactory factory = this._factory.getMdFactory();
                    if (archivepath == null || factory == null) break block19;
                    DirectoryInterface dir = archivepath.getDirectory();
                    MdObjectStore store = factory.createObjectStore();
                    StringBuffer buf = new StringBuffer();
                    buf.append("A0000001.");
                    buf.append(channel.getReposId().substring(0, 8));
                    String repos = buf.toString();
                    int flags = 8588;
                    String selectXML = "<XMLSelect Search=\"*[PathChannels/*ITChannel]\" /><Templates><Directory Name=\"\"> </Directory></Templates>";
                    List dirs = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, repos, "Directory", flags, selectXML);
                    for (Object o : dirs) {
                        String title;
                        String message;
                        int returnValue;
                        Directory afi;
                        if (!(o instanceof Directory) || (afi = (Directory)o).getName().compareTo(dir.getName()) != 0 || afi.getDirectoryName().compareTo(dir.getFilePath()) != 0 || afi.getId().compareTo(dir.getIdentifier()) == 0) continue;
                        String channelName = "";
                        try {
                            ITChannel c = (ITChannel)afi.getPathChannels(true).get(0);
                            Tree t = (Tree)c.getTrees(true).get(0);
                            ArrayList<String> folders = new ArrayList<String>();
                            folders.add(0, t.getName());
                            for (Tree node = t.getParentTree(); node != null; node = node.getParentTree()) {
                                folders.add(0, node.getName());
                            }
                            StringBuffer path = new StringBuffer();
                            int numPaths = folders.size();
                            for (int x = 0; x < numPaths; ++x) {
                                path.append("/");
                                path.append((String)folders.get(x));
                            }
                            path.append("/");
                            channelName = path.toString();
                            String prefix = "/System/Publishing/Channels/";
                            channelName = channelName.startsWith(prefix) ? channelName.substring(prefix.length()) + c.getName() : channelName + c.getName();
                        }
                        catch (Exception ex) {
                            channelName = channel.getName();
                        }
                        if ((returnValue = MessageUtil.displayMessage((String)(message = Message.format((ResourceBundle)RB.getResources(), (String)"CLO.deletePkgs.archivefile.multiuse.fmt.txt", (Object)afi.getName(), (Object)channelName)), (String)(title = RB.getStringResource("CLO.shortDescription.txt")), (int)2, (int)2)) != 2 && returnValue != -1) continue;
                        if (store != null) {
                            store.dispose();
                        }
                        return false;
                    }
                    if (store == null) break block19;
                    store.dispose();
                    break block19;
                }
                if (channel.getDeliveryTransport() == 3) {
                    int choice = 3;
                    String messageText = null;
                    int numPkgs = channel.packageList().size();
                    if (numPkgs > 0) {
                        if (numPkgs == 1) {
                            messageText = UtilMisc.getMessage((String)RB.getStringResource("CLO.confirm.package.fmt.txt"), (Object)this.getName());
                        } else if (numPkgs > 1) {
                            messageText = UtilMisc.getMessage((String)RB.getStringResource("CLO.confirm.packages.fmt.txt"), (Object)numPkgs, (Object)this.getName());
                        }
                        String title = UtilMisc.getMessage((String)RB.getStringResource("CLO.shortDescription.txt"), null);
                        choice = oui.displayMessage(title, messageText, 3, OperationUserInteractionInterface.YES_NO_CANCEL_CHOICE_SET);
                        if (choice == 0) {
                            PackageInterface pkg2 = null;
                            String url = null;
                            for (PackageInterface pkg2 : channel.packageList()) {
                                try {
                                    url = pkg2.getEntityURL();
                                    pkg2.delete();
                                    pkg2 = null;
                                }
                                catch (Throwable t) {
                                    if (log == null) continue;
                                    log.log(Level.INFO, Message.format((ResourceBundle)RB.getResources(), (String)"CLO.pkgDelError.fmt.txt", (Object)url, (Object)t));
                                }
                            }
                        }
                    }
                }
            }
            channel.delete();
            return true;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            if (oui.continueOperationWithPrompting()) {
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("CLO.DeleteFailedMsg.fmt.txt"), (Object)this.getName(), (Object)UtilMisc.getExceptionMessageText((Exception)e));
                int choice = oui.displayMessage(RB.getStringResource("CLO.DeleteFailedTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
            }
            return false;
        }
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    public MoveDisallowedCause checkMoveAllowed() throws LogicalTypeException, RemoteException {
        return MoveDisallowedCause.NO_SUPPORT_FROM_TYPE;
    }

    public MoveDisallowedCause checkMoveAllowed(FolderInterface targetFolder) throws LogicalTypeException, RemoteException {
        return MoveDisallowedCause.NO_SUPPORT_FROM_TYPE;
    }
}

