/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IFileref;
import com.sas.iom.SAS.StreamOpenMode;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.channel.ChannelContentHelper;
import com.sas.metadata.logical.channel.ChannelImportItem;
import com.sas.metadata.logical.channel.ChannelPromotionOptionsPanel;
import com.sas.metadata.logical.channel.ChannelUtil;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.logical.channel.WebDAVRestore;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.BasePathConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.ResponsiblePartyHandler;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.ITChannel;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ResponsibleParty;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.ChannelInterface;
import com.sas.services.information.metadata.ContentDestination;
import com.sas.services.information.metadata.FtpServerInterface;
import com.sas.services.information.metadata.HttpServerInterface;
import com.sas.services.information.metadata.ServerInterface;
import com.sas.services.publish.metadata.PackageUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.util.URIUtil;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.visuals.LogonView;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.omg.CORBA.StringHolder;

public class ChannelImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    private static final int FTP_TYPE = 1;
    private static final int FILESYSTEM_TYPE = 2;
    private Map _davCreds = new HashMap();
    protected static final Class[] CONNECTION_TYPES = new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, BasePathConnectionType.class};
    protected static final Class[] SUBSTITUTION_TYPES = new Class[]{DirectoryPathSubstitutionType.class};
    private ChannelContentHelper _contentHelper;
    private Log _importLogger = null;
    private ChannelPromotionOptionsPanel _optionsPanel;
    private static final String template = "<Template><ITChannel DefaultTransport=\"\"><ArchivePaths><Directory IsRelative=\"\" DirectoryName=\"\"><Parent><Directory/></Parent><Properties><Property PropertyName=\"\" DefaultValue=\"\"/></Properties></Directory></ArchivePaths><Archives><ArchiveFile FileName=\"\"><ResponsibleParties><ResponsibleParty/></ResponsibleParties></ArchiveFile></Archives><ContentDestination><Directory IsRelative=\"\" DirectoryName=\"\"><Parent><Directory/></Parent><Properties><Property PropertyName=\"\" DefaultValue=\"\"/></Properties></Directory></ContentDestination><ChannelSubscriptions><ITContentSubscriber></ITContentSubscriber><ITEventSubscriber></ITEventSubscriber></ChannelSubscriptions></ITChannel></Template>";
    private static final String ARCHIVEPATH_UPDATE_TEMPLATE = "<Template><ITChannel><ArchivePaths><Directory></Directory></ArchivePaths></ITChannel></Template>";

    public ChannelImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new ChannelImportItem(name, id, type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        int retVal = 0;
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("CIL.ProjectRepos.txt"));
        }
        this.verifyImportFolder(importItems);
        this._importLogger = operation.getLogger();
        return retVal;
    }

    private void verifyImportFolder(List importItems) throws MetadataPromotionException {
        Iterator itor = importItems.iterator();
        ChannelImportItem cit = null;
        while (itor.hasNext()) {
            cit = (ChannelImportItem)((Object)itor.next());
            String[] path = cit.getTargetPath();
            if (path.length < 3) {
                throw new MetadataPromotionException(RB.getStringResource("CIL.InvalidFolder.ex.txt"));
            }
            if (!path[0].equals("System")) {
                throw new MetadataPromotionException(RB.getStringResource("CIL.InvalidFolder.ex.txt"));
            }
            if (!path[1].equals("Publishing")) {
                throw new MetadataPromotionException(RB.getStringResource("CIL.InvalidFolder.ex.txt"));
            }
            if (path[2].equals("Channels")) continue;
            throw new MetadataPromotionException(RB.getStringResource("CIL.InvalidFolder.ex.txt"));
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        this._importLogger = operation.getLogger();
        try {
            iRC = this.attachResponsibleParties(operation, objects);
        }
        catch (Exception e) {
            String errorMsg = RB.getStringResource("CIL.RespParties.GeneralError.txt");
            this._importLogger.error((Object)errorMsg, (Throwable)e);
            iRC = 8;
        }
        return iRC;
    }

    private int attachResponsibleParties(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int iRC = 0;
        this._importLogger = operation.getLogger();
        Map map = operation.getAssociationsForObjects(objects, template);
        int i = 0;
        Iterator it = map.entrySet().iterator();
        ResponsiblePartyHandler rph = new ResponsiblePartyHandler(operation);
        while (it.hasNext()) {
            String errorMsg;
            ITChannel channel = null;
            ArchiveFile theArchive = null;
            String channelName = null;
            try {
                theArchive = null;
                Map.Entry me = it.next();
                ImportItemInterface importItem = (ImportItemInterface)objects.get(i++);
                String targetMetadataId = importItem.getTargetID();
                Map channelMap = (Map)me.getValue();
                channelName = (String)channelMap.get("Name");
                List archiveFiles = (List)channelMap.get("Archives");
                if (archiveFiles.size() == 0) continue;
                MdFactory factory = operation.getStore().getFactory();
                channel = (ITChannel)factory.getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "ITChannel", targetMetadataId, null, null, "", 0);
                for (int j = 0; j < archiveFiles.size(); ++j) {
                    String errorMsg2;
                    Map archiveFile = (Map)archiveFiles.get(j);
                    String archiveName = (String)archiveFile.get("FileName");
                    AssociationList alist = channel.getArchives();
                    Iterator aitor = alist.iterator();
                    theArchive = null;
                    while (aitor.hasNext() && !(theArchive = (ArchiveFile)aitor.next()).getFileName().equals(archiveName)) {
                        theArchive = null;
                    }
                    if (theArchive == null) continue;
                    List rParties = (List)archiveFile.get("ResponsibleParties");
                    if (rParties == null || rParties.size() == 0) {
                        String errorMsg3 = UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.NoArchiveError.fmt.txt"), (Object)theArchive.getFileName(), (Object)channelName);
                        this._importLogger.error((Object)errorMsg3);
                        iRC = 4;
                        continue;
                    }
                    Map rParty = (Map)rParties.get(0);
                    String rpId = (String)rParty.get("Id");
                    Iterator cit = importItem.getConnectionPoints().iterator();
                    ConnectionPointInterface rpCP = null;
                    while (!(!cit.hasNext() || (rpCP = (ConnectionPointInterface)cit.next()).getMetadataType().equals("ResponsibleParty") && rpCP.getSourceID().equals(rpId))) {
                        rpCP = null;
                    }
                    if (rpCP == null) {
                        errorMsg2 = UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.NoArchiveError.fmt.txt"), (Object)theArchive.getFileName(), (Object)channelName);
                        this._importLogger.error((Object)errorMsg2);
                        iRC = 4;
                        continue;
                    }
                    if (!rpCP.getMetadataType().equals("ResponsibleParty")) {
                        errorMsg2 = UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.NoArchiveError.fmt.txt"), (Object)theArchive.getFileName(), (Object)channelName);
                        this._importLogger.error((Object)errorMsg2);
                        iRC = 4;
                        continue;
                    }
                    ResponsibleParty responsibleParty = rph.getResponsibleParty(rpCP);
                    if (responsibleParty == null) {
                        String errorMsg4 = UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.RPError.fmt.txt"), (Object)theArchive.getFileName(), (Object)channelName);
                        this._importLogger.error((Object)errorMsg4);
                        iRC = 4;
                        continue;
                    }
                    AssociationList assoc = theArchive.getResponsibleParties();
                    if (assoc.size() > 0) {
                        assoc.clear();
                    }
                    assoc.add(responsibleParty);
                    responsibleParty.updateMetadataAll();
                }
            }
            catch (MdException e) {
                errorMsg = null;
                errorMsg = channelName != null ? UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.AttachError.fmt.txt"), channelName) : RB.getStringResource("CIL.RespParties.GeneralError.txt");
                this._importLogger.error((Object)errorMsg, (Throwable)e);
                iRC = 8;
            }
            catch (RemoteException e) {
                errorMsg = null;
                if (channelName != null) {
                    UtilMisc.getMessage((String)RB.getStringResource("CIL.RespParties.AttachError.fmt.txt"), channelName);
                } else {
                    errorMsg = RB.getStringResource("CIL.RespParties.GeneralError.txt");
                }
                this._importLogger.error((Object)errorMsg, (Throwable)e);
                iRC = 8;
            }
        }
        return iRC;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        int retVal = 0;
        HashMap pubMap = new HashMap();
        this._importLogger = operation.getLogger();
        this._contentHelper = new ChannelContentHelper();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        this._davCreds.clear();
        if (operation.getPromotionType() == 2) {
            return 0;
        }
        try {
            for (ImportItemInterface item : objects) {
                int val;
                if (!this.includeContentForItem(item, operation)) continue;
                String targetMetadataId = item.getTargetID();
                Map contentMap = contentHandler.getBinaryContent(item.getID());
                if (contentMap.size() == 0) continue;
                ChannelInterface channel = (ChannelInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetMetadataId, (String)item.getTypeInterface().getMetadataType());
                int deliveryTransport = channel.getDeliveryTransport();
                if (deliveryTransport == 0 || deliveryTransport == 1) {
                    int n = 0;
                    return n;
                }
                if (deliveryTransport == 2) {
                    val = this.importArchiveContent(channel, contentMap, operation, pubMap);
                    if (retVal != 0) continue;
                    retVal = val;
                    continue;
                }
                if (deliveryTransport != 3) continue;
                val = this.importDAVContent(channel, contentMap, operation);
                if (retVal != 0) continue;
                retVal = val;
            }
            if (pubMap.size() > 0) {
                int val = this.importAppServerContent(pubMap, operation);
                if (retVal == 0) {
                    retVal = val;
                }
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            this._contentHelper.deleteTemporaryFiles();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importAppServerContent(Map pubMap, ImportOperationInterface operation) throws RemoteException {
        int retVal = 0;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        Iterator itor = pubMap.entrySet().iterator();
        String failureMsg = null;
        while (itor.hasNext()) {
            Map.Entry me = itor.next();
            ServerContext serverContext = (ServerContext)me.getKey();
            WsAppServer wsAppServer = null;
            try {
                wsAppServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)serverContext);
            }
            catch (Exception e1) {
                retVal = 8;
                failureMsg = UtilMisc.getMessage((String)RB.getStringResource("CIL.ImpExpNoConn.fmt.txt"), (Object)serverContext.getName(), (Object)e1.getMessage());
                this._importLogger.error((Object)failureMsg);
                StringBuffer buf = new StringBuffer();
                List infoList = (List)pubMap.get(serverContext);
                for (int i = 0; i < infoList.size(); ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    ImportInfo iinfo = (ImportInfo)infoList.get(i);
                    buf.append(iinfo._channel.getName());
                }
                failureMsg = UtilMisc.getMessage((String)RB.getStringResource("CIL.ImpExpNoConnChList.fmt.txt"), (Object)buf.toString());
                this._importLogger.error((Object)failureMsg);
                if (wsAppServer == null) continue;
                wsAppServer.dispose();
                wsAppServer = null;
                continue;
            }
            try {
                List list = (List)me.getValue();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    int val = 0;
                    ImportInfo info = (ImportInfo)it.next();
                    val = info._type == 1 ? this.importArchiveContentToFtpServer(wsAppServer, info, operation) : this.importArchiveContentToFileSystem(wsAppServer, info, contentHandler);
                    if (retVal != 0) continue;
                    retVal = val;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (wsAppServer == null) continue;
                wsAppServer.dispose();
                wsAppServer = null;
            }
        }
        return retVal;
    }

    private int importArchiveContent(ChannelInterface channel, Map contentMap, ImportOperationInterface operation, Map pubMap) throws RemoteException, ServiceException, MdException {
        int retVal = 0;
        String targetMetadataId = null;
        String channelName = null;
        ContentDestination apath = null;
        ServerInterface server = null;
        ITChannel itChannel = null;
        ServerContext theServerContext = null;
        try {
            targetMetadataId = channel.getReposId();
            channelName = channel.getName();
            apath = channel.getArchivePath();
            server = apath.getServer();
            int iOptions = 268;
            itChannel = (ITChannel)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "ITChannel", targetMetadataId, null, null, ARCHIVEPATH_UPDATE_TEMPLATE, iOptions);
            theServerContext = this.findTheLogicalServer((Directory)itChannel.getArchivePaths().get(0));
        }
        catch (ServiceException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            throw e;
        }
        catch (MdException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            throw e;
        }
        catch (RemoteException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            throw e;
        }
        if (server == null) {
            if (theServerContext == null) {
                int val = this.importArchiveContentToFileSystem(apath, contentMap, channelName);
                if (retVal == 0) {
                    retVal = val;
                }
            } else {
                ArrayList<ImportInfo> infoList = (ArrayList<ImportInfo>)pubMap.get(theServerContext);
                if (infoList == null) {
                    infoList = new ArrayList<ImportInfo>();
                    pubMap.put(theServerContext, infoList);
                }
                infoList.add(new ImportInfo(channel, contentMap, 2));
            }
        } else {
            URL u = null;
            try {
                u = PackageUtil.getServerURL((ContentDestination)apath);
            }
            catch (ServiceException e) {
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                throw e;
            }
            if (u.getProtocol().equalsIgnoreCase("http")) {
                int val = this.importArchiveContentToHttpServer(channel, contentMap, operation);
                if (retVal == 0) {
                    retVal = val;
                }
            } else {
                if (theServerContext == null) {
                    this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportFTPContentNoSC.fmt.txt"), (Object)channelName));
                    retVal = 8;
                    return retVal;
                }
                ArrayList<ImportInfo> infoList = (ArrayList<ImportInfo>)pubMap.get(theServerContext);
                if (infoList == null) {
                    infoList = new ArrayList<ImportInfo>();
                    pubMap.put(theServerContext, infoList);
                }
                infoList.add(new ImportInfo(channel, contentMap, 1));
            }
        }
        if (pubMap.size() == 0) {
            return retVal;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int importDAVContent(ChannelInterface channel, Map contentMap, ImportOperationInterface operation) throws RemoteException, IOException, ServiceException {
        Iterator contentItor;
        int retVal = 0;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        String user = null;
        String password = null;
        ContentDestination cd = channel.getContentDestination();
        URL u = PackageUtil.getServerURL((ContentDestination)cd);
        UserContextInterface userContext = operation.getUserContext();
        String authType = ((HttpServerInterface)cd.getServer()).getAuthenticationType();
        if (authType != null) {
            UserIdentityInterface identity;
            if (authType.equalsIgnoreCase("metadata")) {
                if (userContext != null) {
                    identity = userContext.getAuthServer().generatePassword(null);
                    if (identity != null) {
                        user = (String)identity.getPrincipal();
                        password = (String)identity.getCredential();
                    } else {
                        this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.MetaAuthNoIdent.fmt.txt"), (Object)cd.getServer().getName()));
                    }
                } else {
                    this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.MetaAuthNoUser.fmt.txt"), (Object)cd.getServer().getName()));
                }
            } else if (!authType.equalsIgnoreCase("none")) {
                try {
                    identity = ChannelUtil.getCreds(userContext, cd.getServer());
                    if (identity != null) {
                        user = (String)identity.getPrincipal();
                        password = (String)identity.getCredential();
                    } else {
                        String[] creds = null;
                        List sl = cd.getServer().getDomains();
                        String domain = null;
                        if (sl.size() > 0) {
                            domain = (String)sl.get(0);
                            creds = (String[])this._davCreds.get(domain);
                        }
                        if (creds == null) {
                            if (operation.isBatchProcess()) {
                                this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)cd.getServer().getName()));
                            } else {
                                String loginTitle = UtilMisc.getMessage((String)RB.getStringResource("CIL.PromptForServer.fmt.txt"), (Object)cd.getServer().getName());
                                WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), loginTitle, true);
                                LogonView panel = new LogonView();
                                dialog.setMainPanel((WAPanel)panel);
                                dialog.show();
                                if (dialog.getReturnValue() == 1) {
                                    user = panel.getUserName();
                                    password = panel.getPassword();
                                    creds = new String[]{user, password};
                                    this._davCreds.put(domain, creds);
                                } else {
                                    this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)cd.getServer().getName()));
                                }
                            }
                        } else {
                            user = creds[0];
                            password = creds[1];
                        }
                    }
                }
                catch (Exception e) {
                    this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)cd.getServer().getName()));
                }
            }
        }
        if ((contentItor = contentMap.entrySet().iterator()).hasNext()) {
            Map.Entry element = contentItor.next();
            String key = (String)element.getKey();
            InputStream inStream = (InputStream)element.getValue();
            File file = contentHandler.createFile(inStream, key);
            try {
                WebDAVRestore.restoreFromZip(file, u.toExternalForm(), user, password, this._importLogger);
            }
            catch (IOException e) {
                retVal = 8;
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channel.getName(), (Object)e.getMessage()));
            }
            finally {
                file.delete();
            }
        }
        return retVal;
    }

    private int importArchiveContentToHttpServer(ChannelInterface channel, Map contentMap, ImportOperationInterface operation) {
        int retVal = 0;
        String permPartOfUrl = null;
        ConnectionInfo c = null;
        ContentDestination contentDest = null;
        String channelName = null;
        URL url = null;
        try {
            contentDest = channel.getArchivePath();
            channelName = channel.getName();
            url = PackageUtil.getServerURL((ContentDestination)contentDest);
        }
        catch (ServiceException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 8;
        }
        catch (RemoteException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 8;
        }
        try {
            UserContextInterface uc = operation.getUserContext();
            HttpServerInterface hs = (HttpServerInterface)contentDest.getServer();
            String proxy = hs.getProxyUrl();
            URL proxyUrl = null;
            if (proxy != null && proxy.length() > 0) {
                proxyUrl = new URL(proxy);
            }
            String user = null;
            String pw = null;
            try {
                UserIdentityInterface identity = ChannelUtil.getCreds(uc, (ServerInterface)hs);
                if (identity != null) {
                    user = (String)identity.getPrincipal();
                    pw = (String)identity.getCredential();
                } else {
                    String[] creds = null;
                    List sl = contentDest.getServer().getDomains();
                    String domain = null;
                    if (sl.size() > 0) {
                        domain = (String)sl.get(0);
                        creds = (String[])this._davCreds.get(domain);
                    }
                    if (creds == null) {
                        if (operation.isBatchProcess()) {
                            this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)contentDest.getServer().getName()));
                        } else {
                            String loginTitle = UtilMisc.getMessage((String)RB.getStringResource("CIL.PromptForServer.fmt.txt"), (Object)contentDest.getServer().getName());
                            WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), loginTitle, true);
                            LogonView panel = new LogonView();
                            dialog.setMainPanel((WAPanel)panel);
                            dialog.show();
                            if (dialog.getReturnValue() == 1) {
                                user = panel.getUserName();
                                pw = panel.getPassword();
                                creds = new String[]{user, pw};
                                this._davCreds.put(domain, creds);
                            } else {
                                this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)contentDest.getServer().getName()));
                            }
                        }
                    } else {
                        user = creds[0];
                        pw = creds[1];
                    }
                }
            }
            catch (Exception e) {
                this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)hs.getName()));
            }
            permPartOfUrl = url.toExternalForm();
            c = new ConnectionInfo(permPartOfUrl);
            if (proxyUrl != null) {
                c.setProxyURL(proxyUrl);
            }
            if (user != null) {
                c.setUser(user);
            }
            if (pw != null) {
                c.setPW(pw);
            }
            for (Map.Entry element : contentMap.entrySet()) {
                String key = (String)element.getKey();
                InputStream stream = (InputStream)element.getValue();
                String finalUrl = URIUtil.addSegment((String)permPartOfUrl, (String)(key + ".spk"));
                c.setUrl(finalUrl);
                try {
                    this._contentHelper.retrieveAndUpdateContentFromPackage(c, stream);
                }
                catch (Exception e) {
                    this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportNamedContentErr.fmt.txt"), (Object)key, (Object)channel.getName(), (Object)e.getMessage()));
                    retVal = 8;
                }
            }
        }
        catch (IOException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            retVal = 8;
        }
        catch (ServiceException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            retVal = 8;
        }
        return retVal;
    }

    private int importArchiveContentToFtpServer(WsAppServer wsAppServer, ImportInfo info, ImportOperationInterface operation) {
        String ftpPw;
        String ftpUser;
        URL u;
        String channelName;
        int retVal;
        block14: {
            retVal = 0;
            ContentDestination contentDest = null;
            channelName = null;
            u = null;
            try {
                contentDest = info._channel.getArchivePath();
                channelName = info._channel.getName();
                u = PackageUtil.getServerURL((ContentDestination)contentDest);
            }
            catch (ServiceException e) {
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                return 8;
            }
            catch (RemoteException e) {
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                return 8;
            }
            UserContextInterface uc = null;
            ftpUser = null;
            ftpPw = null;
            try {
                uc = operation.getUserContext();
                FtpServerInterface ftpServer = (FtpServerInterface)contentDest.getServer();
                try {
                    UserIdentityInterface identity = ChannelUtil.getCreds(uc, (ServerInterface)ftpServer);
                    if (identity != null) {
                        ftpUser = (String)identity.getPrincipal();
                        ftpPw = (String)identity.getCredential();
                        break block14;
                    }
                    if (operation.isBatchProcess()) {
                        this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)ftpServer.getName()));
                        break block14;
                    }
                    String loginTitle = UtilMisc.getMessage((String)RB.getStringResource("CIL.PromptForServer.fmt.txt"), (Object)ftpServer.getName());
                    WAStandardDialog dialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), loginTitle, true);
                    LogonView panel = new LogonView();
                    dialog.setMainPanel((WAPanel)panel);
                    dialog.show();
                    if (dialog.getReturnValue() == 1) {
                        ftpUser = panel.getUserName();
                        ftpPw = panel.getPassword();
                        break block14;
                    }
                    this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)ftpServer.getName()));
                }
                catch (Exception e) {
                    this._importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("Common.UnableToGetCreds.fmt.txt"), (Object)ftpServer.getName()));
                }
            }
            catch (Exception e) {
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
                return 8;
            }
        }
        IFileService fileService = wsAppServer.getWorkspace().FileService();
        StringHolder stringHolder = new StringHolder();
        String requestedName = "";
        String accessMethod = "FTP";
        String externalFile = null;
        String hostOptions = "";
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        Iterator contentItor = info._contentMap.entrySet().iterator();
        while (contentItor.hasNext()) {
            IBinaryStream bs = null;
            IFileref fileref = null;
            Map.Entry element = contentItor.next();
            String key = (String)element.getKey();
            InputStream stream = (InputStream)element.getValue();
            externalFile = u.getPath().length() == 0 ? key + ".spk" : URIUtil.addSegment((String)u.getPath(), (String)(key + ".spk"));
            try {
                StringBuffer buf = new StringBuffer();
                buf.append("host='");
                buf.append(u.getHost());
                buf.append("' ");
                buf.append("port=");
                buf.append(u.getPort());
                buf.append(" ");
                if (ftpUser != null) {
                    buf.append("user='");
                    buf.append(ftpUser);
                    buf.append("' pass='");
                    buf.append(ftpPw);
                    buf.append("'");
                }
                hostOptions = buf.toString();
                fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                StreamOpenMode mode = StreamOpenMode.StreamOpenModeForWriting;
                bs = fileref.OpenBinaryStream(mode);
                contentHandler.writeToBinaryStream(stream, bs);
                fileService.DeassignFileref(stringHolder.value);
                fileref = null;
            }
            catch (Exception e) {
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportNamedContentErr.fmt.txt"), (Object)key, (Object)channelName, (Object)e.getMessage()));
                retVal = 8;
            }
        }
        return retVal;
    }

    private int importArchiveContentToFileSystem(ContentDestination contentDest, Map contentMap, String channelName) {
        int retVal = 0;
        String outputPath = contentDest.getPath();
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath.concat(File.separator);
        }
        for (Map.Entry element : contentMap.entrySet()) {
            String key = (String)element.getKey();
            InputStream inStream = (InputStream)element.getValue();
            String fullPath = outputPath + key + ".spk";
            try {
                this._contentHelper.writeToOutputStream(inStream, new FileOutputStream(fullPath));
            }
            catch (IOException e) {
                retVal = 8;
                this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportNamedContentErr.fmt.txt"), (Object)key, (Object)channelName, (Object)e.getMessage()));
            }
        }
        return retVal;
    }

    private int importArchiveContentToFileSystem(WsAppServer wsAppServer, ImportInfo info, ContentHandlerInterface contentHandler) {
        int retVal = 0;
        ContentDestination contentDest = null;
        String channelName = null;
        try {
            channelName = info._channel.getName();
            contentDest = info._channel.getArchivePath();
        }
        catch (ServiceException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 8;
        }
        catch (RemoteException e) {
            this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportContentErr.fmt.txt"), (Object)channelName, (Object)e.getMessage()));
            return 8;
        }
        String outputPath = contentDest.getPath();
        if (wsAppServer != null) {
            IFileService fileService = wsAppServer.getWorkspace().FileService();
            StringHolder stringHolder = new StringHolder();
            String requestedName = "";
            String accessMethod = "";
            String externalFile = null;
            String hostOptions = "";
            Iterator contentItor = info._contentMap.entrySet().iterator();
            while (contentItor.hasNext()) {
                IBinaryStream bs = null;
                IFileref fileref = null;
                Map.Entry element = contentItor.next();
                String key = (String)element.getKey();
                InputStream stream = (InputStream)element.getValue();
                try {
                    externalFile = outputPath != null ? fileService.FullName(key + ".spk", outputPath) : key + ".spk";
                    fileref = fileService.AssignFileref(requestedName, accessMethod, externalFile, hostOptions, stringHolder);
                    StreamOpenMode mode = StreamOpenMode.StreamOpenModeForWriting;
                    bs = fileref.OpenBinaryStream(mode);
                    contentHandler.writeToBinaryStream(stream, bs);
                    fileService.DeassignFileref(stringHolder.value);
                    fileref = null;
                }
                catch (Exception e) {
                    this._importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("CIL.ImportNamedContentErr.fmt.txt"), (Object)key, (Object)channelName, (Object)e.getMessage()));
                    retVal = 8;
                }
            }
        }
        return retVal;
    }

    private ServerContext findTheLogicalServer(Directory dir) throws MdException, RemoteException {
        ServerContext theServerContext = null;
        for (Object o : dir.getDeployedComponents()) {
            if (!(o instanceof LogicalServer)) continue;
            theServerContext = (ServerContext)((LogicalServer)o).getUsedByComponents().get(0);
            break;
        }
        return theServerContext;
    }

    private boolean includeContentForItem(ImportItemInterface importItem, ImportOperationInterface operation) {
        boolean includeContent = true;
        String exclude = operation.getPropertiesFile().getProperty(importItem.getID() + "_ExcludeContent");
        if (exclude != null && exclude.equalsIgnoreCase("true")) {
            includeContent = false;
        } else if (!((ChannelImportItem)importItem).getIncludeContent()) {
            includeContent = false;
        }
        return includeContent;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface exportHandler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface operation) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new ChannelPromotionOptionsPanel(operation.getPromotionType());
        }
        this._optionsPanel.populateImportOptions(items, operation.getPropertiesFile());
        return this._optionsPanel;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }

    class ImportInfo {
        ChannelInterface _channel = null;
        Map _contentMap = null;
        int _type = 0;

        ImportInfo(ChannelInterface channel, Map contentMap, int type) {
            this._channel = channel;
            this._contentMap = contentMap;
            this._type = type;
        }
    }
}

