/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.channel;

import com.sas.iom.SAS.IBinaryStream;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.channel.RB;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.services.webdav.ConnectionInfo;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.ResourceFactory;
import com.sas.services.webdav.ResourceInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class ChannelContentHelper
extends ContentHelper {
    private static final Logger log = Logger.getLogger(ChannelContentHelper.class.getName());

    void retrieveAndUpdateContentFromPackage(ConnectionInfo c, InputStream inStream) throws IOException {
        ResourceInterface res = null;
        try {
            res = ResourceFactory.bindResource((ConnectionInfo)c);
            res.setContents(inStream);
        }
        catch (DAVException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, RB.getStringResource("CCH.streamErr.txt"), e);
                }
                inStream = null;
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (DAVException e) {
                    log.log(Level.SEVERE, "Failed on repository write/close", e);
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        }
    }

    void retrieveAndUpdateContentFromPackage(ConnectionInfo c, File tempFile) throws IOException {
        log.fine(UtilMisc.getMessage((String)RB.getStringResource("CCH.retrv.fmt.txt"), (Object)tempFile.getName()));
        this._tempFiles.add(tempFile);
        ResourceInterface res = null;
        FileInputStream fis = null;
        try {
            res = ResourceFactory.bindResource((ConnectionInfo)c);
            fis = new FileInputStream(tempFile);
            res.setContents((InputStream)fis);
        }
        catch (DAVException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, RB.getStringResource("CCH.streamErr.txt"), e);
                }
                fis = null;
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (DAVException e) {
                    log.log(Level.SEVERE, "Failed on repository write/close", e);
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        }
    }

    void retrieveContentFromPackage(IBinaryStream bs, File tempFile) throws FileNotFoundException, IOException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("CCH.retrv.fmt.txt"), (Object)tempFile.getName()));
        }
        this._tempFiles.add(tempFile);
        FileInputStream fis = new FileInputStream(tempFile);
        try {
            int len;
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) > 0) {
                if (len < 4096) {
                    byte[] bb = new byte[len];
                    System.arraycopy(buffer, 0, bb, 0, len);
                    bs.Write(bb);
                    continue;
                }
                bs.Write(buffer);
            }
        }
        catch (GenericError e) {
            throw new IOException(e.getLocalizedMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, RB.getStringResource("CCH.streamErr.txt"), e);
                }
            }
            if (bs != null) {
                try {
                    bs.Close();
                }
                catch (GenericError e) {
                    log.log(Level.SEVERE, "Error encountered  closing stream for IOM", e);
                }
            }
        }
    }
}

