/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.application;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.application.ApplicationExportItem;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ApplicationUtility {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getRelatedObjects(ApplicationExportItem exportItem, int relationshipType, MdFactory factory) throws LogicalTypeException {
        int iOptions = 272;
        try {
            MdObjectStore mdStore = factory.createObjectStore(null, "ApplicationUtility.getRelatedObjects");
            try {
                SoftwareComponent sc = (SoftwareComponent)factory.getOMIUtil().getMetadataAllDepths((MdStore)mdStore, exportItem.getTypeInterface().getMetadataType(), exportItem.getID(), null, null, null, iOptions);
                if (sc == null) {
                    throw new LogicalTypeException("Couldn't find corresponding metadata object for document \"" + exportItem.getName() + "\".");
                }
                List list = ApplicationUtility.getRelatedObjects(sc, relationshipType);
                return list;
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }

    public static List getRelatedObjects(SoftwareComponent comp, int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> relatedObjects;
        block9: {
            relatedObjects = new ArrayList<SimpleLogicalObjectInterface>();
            try {
                if (relationshipType == 0) {
                    try {
                        AssociationList depList = comp.getDependentComponents();
                        for (Root metadataObject : depList) {
                            SimpleLogicalObjectInterface logicalObj = PrivateObjectImportUtility.getLogicalFromJOMAObject(metadataObject);
                            if (logicalObj == null) continue;
                            relatedObjects.add(logicalObj);
                        }
                        break block9;
                    }
                    catch (MdException mde) {
                        throw new LogicalTypeException((Exception)((Object)mde));
                    }
                }
                if (relationshipType != 1) break block9;
                try {
                    AssociationList depList = comp.getDependsOnComponents();
                    for (Root metadataObject : depList) {
                        SimpleLogicalObjectInterface logicalObj = PrivateObjectImportUtility.getLogicalFromJOMAObject(metadataObject);
                        if (logicalObj == null) continue;
                        relatedObjects.add(logicalObj);
                    }
                }
                catch (MdException mde) {
                    throw new LogicalTypeException((Exception)((Object)mde));
                }
            }
            catch (RemoteException e) {
                throw new LogicalTypeException((Exception)e);
            }
        }
        return relatedObjects;
    }
}

