/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.application;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.application.ApplicationObject;
import com.sas.metadata.logical.application.RB;
import com.sas.metadata.logical.common.ConfigurationPropertiesTab;
import com.sas.metadata.logical.common.SoftwareDependencyTab;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class ApplicationObjectFactory
implements ObjectFactoryInterface {
    private Action[] NO_ACTIONS = new Action[0];
    private TypeInterface m_type;
    private Factory m_factory;

    public ApplicationObjectFactory(TypeInterface type, Factory factory) {
        this.m_type = type;
        this.m_factory = factory;
    }

    public Factory getFactory() {
        return this.m_factory;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        return new ApplicationObject((SoftwareComponent)root, this.m_type, this.m_factory);
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) throws RemoteException {
        return this.NO_ACTIONS;
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) throws RemoteException {
        return this.NO_ACTIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("<Templates><");
            sb.append(this.m_type.getMetadataType());
            sb.append(" ");
            sb.append(this.m_factory.getTemplateFormOfRequiredAndNeededAttributes(this.m_type));
            sb.append("/></Templates>");
            int fFlags = 260;
            List lApplications = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", fFlags, sb.toString());
            ArrayList<LogicalObjectInterface> lObjects = new ArrayList<LogicalObjectInterface>(lApplications.size());
            for (int iApplication = 0; iApplication < lApplications.size(); ++iApplication) {
                lObjects.add(this.createItemFromMetadataObject((Root)((SoftwareComponent)lApplications.get(iApplication))));
            }
            ArrayList<LogicalObjectInterface> arrayList = lObjects;
            return arrayList;
        }
        finally {
            store.dispose();
        }
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root root, Config config) throws MdException, RemoteException {
        ArrayList<Object> lTabs = null;
        BIPTreeElementGeneralPropertyTab generalTab = this.getGeneralPropertyTab(root, config);
        WAExtAttrPropertyTab extTab = new WAExtAttrPropertyTab((CMetadata)root);
        extTab.setName(RB.getStringResource("ApplicationObjectFactory.Extension.txt"));
        extTab.setHelpTopic("app_exten_tab");
        extTab.setHelpProduct("shared");
        try {
            if (Workspace.getWorkspace().getConnectionManager().isAdministrator()) {
                lTabs = new ArrayList<Object>(4);
                ConfigurationPropertiesTab tabConfig = new ConfigurationPropertiesTab((CMetadata)root);
                lTabs.add(generalTab);
                lTabs.add((Object)tabConfig);
                SoftwareDependencyTab depTab = new SoftwareDependencyTab(this.m_type, (CMetadata)root);
                lTabs.add((Object)depTab);
                lTabs.add(extTab);
            } else {
                lTabs = new ArrayList(2);
                lTabs.add(generalTab);
                lTabs.add(extTab);
            }
        }
        catch (ServiceException e) {
            Workspace.handleServiceException((ServiceException)e);
        }
        return lTabs;
    }

    protected BIPTreeElementGeneralPropertyTab getGeneralPropertyTab(Root root, Config config) throws MdException, RemoteException {
        if (!this.isObjectOfInterest(root)) {
            throw new IllegalArgumentException("Unable to display properties.  Reason: Not a public object type or invalid public object type.");
        }
        if (config == null) {
            config = new Config();
        }
        Tree tree = (Tree)root.getTrees().get(0);
        BIPTreeElementGeneralPropertyTab generalTab = new BIPTreeElementGeneralPropertyTab(root, tree, 1, this.m_type, config);
        return generalTab;
    }

    protected boolean isObjectOfInterest(Root root) throws RemoteException {
        if (!(root instanceof PrimaryType)) {
            return false;
        }
        PrimaryType pt = (PrimaryType)root;
        return pt.getPublicType().equalsIgnoreCase(this.m_type.getPublicType());
    }
}

