/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.application;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.application.ApplicationObject;
import com.sas.metadata.logical.application.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.List;

public class ApplicationImportListener
extends AbstractImportListener {
    public ApplicationImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        ConnectionManagerInterface manager = operation.getConnectionManager();
        for (ImportItemInterface importItem : objects) {
            List connectionPoints = importItem.getConnectionPoints();
            for (ConnectionPointInterface pt : connectionPoints) {
                if (pt.getTargetID() != null || !pt.isActive() || !"Tree".equalsIgnoreCase(pt.getMetadataType()) || "Folder".equalsIgnoreCase(pt.getPublicType())) continue;
                manager.autoMapConnectionPoint(operation, pt, 2);
            }
        }
        return 0;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        int rc = 0;
        for (ImportItemInterface scItem : objects) {
            String type;
            this.fireDisplayMessage(StatusMessageUtil.createUpdatingMessage((TypeInterface)scItem.getTypeInterface(), (String)scItem.getName()));
            operation.getLogger().info((Object)UtilMisc.getMessage((String)RB.getStringResource("ApplicationImportListener.MetadataInfo.fmt"), (Object)scItem.getName()));
            boolean bMetadataChanged = false;
            try {
                boolean usageVersionChanged;
                String id = scItem.getTargetID();
                if (id == null || id.length() == 0) {
                    id = scItem.getID();
                }
                SoftwareComponent scObject = this.getApplicationMetadataObject(operation.getStore(), scItem, id);
                PromotionUtil.updateProductInfo((Root)scObject, (ImportOperationInterface)operation);
                bMetadataChanged = true;
                boolean publicTypeChanged = UtilMetadata.setPublicType((PrimaryType)scObject, (String)"Application");
                if (publicTypeChanged) {
                    bMetadataChanged = true;
                }
                if (usageVersionChanged = UtilMetadata.setUsageVersion((Root)scObject, (UsageVersion)ApplicationObject.CURRENT_VERSION)) {
                    bMetadataChanged = true;
                }
                if (!bMetadataChanged) continue;
                bMetadataChanged = false;
                scObject.updateMetadataAll();
            }
            catch (MdException e) {
                type = scItem.getTypeInterface().getDisplayType();
                String name = scItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ApplicationImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
            catch (RemoteException e) {
                type = scItem.getTypeInterface().getDisplayType();
                String name = scItem.getName();
                operation.getLogger().error((Object)UtilMisc.getMessage((String)RB.getStringResource("ApplicationImportListener.errorValidatingMetadata.fmt"), (Object)type, (Object)name), (Throwable)e);
                rc |= 8;
            }
        }
        return rc;
    }

    private SoftwareComponent getApplicationMetadataObject(MdObjectStore store, ImportItemInterface importItem, String fqid) throws MdException, RemoteException {
        String type = importItem.getTypeInterface().getMetadataType();
        String template = "<Templates><SoftwareComponent><Trees/></SoftwareComponent></Templates>";
        int options = 268;
        CMetadata object = store.getFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, type, fqid, null, null, template, options);
        if (object instanceof SoftwareComponent) {
            return (SoftwareComponent)object;
        }
        throw new MdException(UtilMisc.getMessage((String)RB.getStringResource("ApplicationImportListener.invalid.fmt"), (Object)object.getCMetadataType()));
    }
}

