/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.XML2NLD;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLModel
extends NLDModel {
    private XML2NLD x2n = null;
    public URL doc = null;
    public URL code = null;
    private Document document = null;

    @Override
    public boolean loadModel(NLDViewer v) {
        this.viewer = v;
        return this.xml();
    }

    @Override
    public boolean loadModel() {
        return this.xml();
    }

    private boolean xml() {
        DocumentBuilder parser = null;
        this.code = this.viewer.getCodeBase();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String messagePattern = this.GRS(this.appRB, "StatusText.pce.fmt.txt", "Parser Configuration Exception={0}");
            String formattedMessg = MessageFormat.format(messagePattern, pce);
            System.out.println(formattedMessg);
            return false;
        }
        this.document = null;
        Exception e = null;
        try {
            if (this.xmlFile != null) {
                URL url = new URL(this.code, this.xmlFile);
                if (url == null) {
                    this.code = this.viewer.getDocumentBase();
                    url = new URL(this.code, this.xmlFile);
                }
                if (url != null) {
                    this.document = this.getDocument(parser, url);
                }
            } else if (this.xmlParam != null) {
                StringReader sr = new StringReader(this.xmlParam);
                InputSource src = new InputSource(sr);
                if (src == null) {
                    this.dispError(this.GRS(this.appRB, "StatusText.errorAccess", "Error accessing XML source."));
                    return false;
                }
                this.document = parser.parse(src);
            } else {
                InputSource src = null;
                String data = this.viewer.getAltHtml();
                if (data != null && data.length() > 0) {
                    src = new InputSource(new StringReader(data));
                }
                if (src == null) {
                    this.dispError(this.GRS(this.appRB, "StatusText.errorAccess", "Error accessing XML source."));
                    return false;
                }
                this.document = parser.parse(src);
            }
        }
        catch (SAXParseException exception) {
            e = exception;
            e.printStackTrace();
            this.document = null;
        }
        catch (Exception exception) {
            e = exception;
            if (this.doc == null && this.xmlFile != null) {
                try {
                    this.doc = this.viewer.getDocumentBase();
                    URL url = new URL(this.doc, this.xmlFile);
                    if (url != null) {
                        this.document = this.getDocument(parser, url);
                    }
                }
                catch (Exception ex) {
                    e = ex;
                    e.printStackTrace();
                    this.document = null;
                }
            }
            e.printStackTrace();
            this.document = null;
        }
        if (this.document == null) {
            String msg = this.GRS(this.appRB, "StatusText.internalException", "Internal Exception:") + e;
            if (e instanceof FileNotFoundException) {
                msg = this.GRS(this.appRB, "StatusText.xmlfile", "XML file '") + this.xmlFile + this.GRS(this.appRB, "StatusText.notfound", "' not found.");
            }
            this.dispError(msg);
            return false;
        }
        if (this.x2n == null) {
            this.x2n = new XML2NLD();
        }
        this.x2n.setNLDModel(this);
        this.x2n.setDoc(this.document);
        this.x2n.setNLDViewer(this.viewer);
        this.x2n.load();
        this.numLinks = this.links.size();
        this.numNodes = this.nodes.size();
        return true;
    }

    private boolean xml(String file) {
        if (file == null) {
            return false;
        }
        DocumentBuilder parser = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            String messagePattern = this.GRS(this.appRB, "StatusText.pce.fmt.txt", "Parser Configuration Exception={0}");
            String formattedMessg = MessageFormat.format(messagePattern, pce);
            System.out.println(formattedMessg);
            return false;
        }
        Document document = null;
        Exception e = null;
        try {
            InputSource src = null;
            URL url = new URL(this.code, this.xmlFile);
            if (url == null) {
                this.code = this.viewer.getDocumentBase();
                url = new URL(this.code, this.xmlFile);
            }
            if (url != null) {
                document = this.getDocument(parser, url);
            }
            if ((src = new InputSource(url.toString())) == null) {
                this.dispError(this.GRS(this.appRB, "StatusText.errorAccess", "Error accessing XML source."));
                return false;
            }
            document = parser.parse(src);
        }
        catch (SAXParseException exception) {
            e = exception;
            e.printStackTrace();
            document = null;
        }
        catch (Exception exception) {
            e = exception;
            if (this.doc == null) {
                try {
                    this.doc = this.viewer.getDocumentBase();
                    URL url = new URL(this.doc, this.xmlFile);
                    if (url != null) {
                        document = this.getDocument(parser, url);
                    }
                }
                catch (Exception ex) {
                    e = ex;
                    e.printStackTrace();
                    document = null;
                }
            }
            e.printStackTrace();
            document = null;
        }
        if (document == null) {
            String msg = this.GRS(this.appRB, "StatusText.internalException", "Internal Exception:") + e;
            if (e instanceof FileNotFoundException) {
                msg = this.GRS(this.appRB, "StatusText.xmlfile", "XML file '") + this.xmlFile + this.GRS(this.appRB, "StatusText.notfound", "' not found.");
            }
            this.dispError(msg);
            return false;
        }
        if (this.x2n == null) {
            this.x2n = new XML2NLD();
        }
        this.x2n.setNLDModel(this);
        this.x2n.setDoc(document);
        this.x2n.setNLDViewer(this.viewer);
        this.x2n.load();
        this.numLinks = this.links.size();
        this.numNodes = this.nodes.size();
        return true;
    }

    @Override
    public boolean loadNodePositions() {
        this.x2n.readNodePositions();
        return true;
    }

    private Document getDocument(DocumentBuilder parser, URL url) throws IOException, SAXException {
        InputSource src = null;
        src = new InputSource(url.toString());
        if (src == null) {
            this.dispError(this.GRS(this.appRB, "StatusText.errorAccess", "Error accessing XML source."));
            return null;
        }
        Document document = parser.parse(src);
        return document;
    }

    @Override
    public boolean loadChildren(int index) {
        NLDNode node = (NLDNode)this.nodes.elementAt(index);
        this.dupCheck = true;
        int saveNode = this.numNodes;
        if (node.action != null) {
            this.xmlFile = node.action + "?EXPANDID=" + node.id;
        } else if (this.userAction) {
            this.xmlFile = this.action + "?EXPANDID=" + node.id;
        } else {
            return false;
        }
        this.xml();
        return this.numNodes > saveNode;
    }

    public boolean updateTree(String file) {
        if (file.startsWith("<?xml")) {
            this.xmlFile = null;
            this.xmlParam = file;
        } else {
            this.xmlFile = file;
        }
        int saveNode = this.numNodes;
        this.xml();
        return this.numNodes > saveNode;
    }

    @Override
    public boolean updateDragAndDrop(NLDNode draggedNode, NLDNode dropAt) {
        boolean save = this.dupCheck;
        this.dupCheck = true;
        int saveNode = this.numNodes;
        if (!this.userAction) {
            return false;
        }
        this.xmlFile = this.action + "?DRAGGEDID=" + draggedNode.id + "&DROPATID=" + dropAt.id;
        this.xml();
        this.dupCheck = save;
        return true;
    }

    @Override
    public boolean loadLayer(NLDNode parent, int index) {
        String xmlFile = (String)parent.getVarXMLs().elementAt(index);
        this.updateTree(xmlFile);
        this.numNodes = this.nodes.size();
        this.numLinks = this.links.size();
        return true;
    }

    public Document getDocument() {
        return this.document;
    }
}

