/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Color;
import java.awt.Image;
import java.util.Vector;

public class VectorNodeModel
extends Vector {
    public static final String[] keys = new String[]{"ID", "Parent", "Label", "Info", "Color", "Size", "Shape", "Value", "X", "Y", "Action", "Url", "Image", "Icon", "ColorIndex", "HasChildren"};
    public static final int ID = 0;
    public static final int Parent = 1;
    public static final int Label = 2;
    public static final int Info = 3;
    public static final int Color = 4;
    public static final int Size = 5;
    public static final int Shape = 6;
    public static final int Value = 7;
    public static final int X = 8;
    public static final int Y = 9;
    public static final int Action = 10;
    public static final int Url = 11;
    public static final int Image = 12;
    public static final int Icon = 13;
    public static final int ColorIndex = 14;
    public static final int HasChildren = 15;
    public static final int ColorVal = 16;
    public static final int MAP_COLOR = 0;
    public static final int MAP_SIZE = 1;
    public static final int MAP_LOCATION = 2;
    public static final int NUM_MAPS = 3;
    boolean[] maps = new boolean[3];
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    protected int nodeLabelMode = 1;
    protected Vector nodesToUpdate = new Vector();
    protected Vector nodesToRemove = new Vector();

    public void dispose() {
        this.clear();
    }

    public int numNodes() {
        return this.size();
    }

    public int getIndexOf(Object id) {
        if (id instanceof Number) {
            return ((Number)id).intValue();
        }
        return super.indexOf(id);
    }

    public Color getColor(int id) {
        NLDNode node = (NLDNode)this.elementAt(id);
        if (null != node) {
            return node.getColor();
        }
        return null;
    }

    public double getNumValue(int property, int id) {
        NLDNode node = (NLDNode)this.elementAt(id);
        double rc = -1.0;
        switch (property) {
            case 16: {
                rc = node.colval;
                break;
            }
            case 5: {
                rc = node.size;
                break;
            }
            case 6: {
                rc = node.type;
                break;
            }
            case 8: {
                rc = node.orgXpos;
                break;
            }
            case 9: {
                rc = node.orgYpos;
                break;
            }
            case 7: {
                rc = node.value;
                break;
            }
        }
        return rc;
    }

    public Vector getNewNodes() {
        return this.nodesToUpdate;
    }

    public Vector getRemovedNodes() {
        return this.nodesToRemove;
    }

    public void dynamicRemove(int idx) {
        this.remove(idx);
        int nNodes = this.size();
        for (int i = idx; i < nNodes; ++i) {
            NLDNode node = (NLDNode)this.elementAt(i);
            node.setIndex(i);
        }
    }

    public void setValue(int property, int id, double val) {
        NLDNode node = (NLDNode)this.elementAt(id);
        switch (property) {
            case 16: {
                node.colval = val;
                break;
            }
            case 5: {
                node.size = val;
                break;
            }
            case 8: {
                node.orgXpos = node.xpos = val;
                break;
            }
            case 9: {
                node.orgYpos = node.ypos = val;
                break;
            }
            case 7: {
                node.value = val;
                break;
            }
            case 6: {
                node.type = val < 0.0 ? 0 : (int)val % 4;
            }
        }
    }

    public String getStringValue(int property, int id) {
        NLDNode node = (NLDNode)this.elementAt(id);
        String rc = null;
        switch (property) {
            case 0: {
                rc = node.id;
                break;
            }
            case 1: {
                rc = node.parent;
                break;
            }
            case 2: {
                rc = node.label;
                break;
            }
            case 3: {
                rc = node.info;
                break;
            }
            case 10: {
                rc = node.action;
                break;
            }
            case 11: {
                rc = node.urlStr;
                break;
            }
            case 12: {
                rc = node.imgstr;
                break;
            }
            case 13: {
                rc = node.iconstr;
                break;
            }
        }
        return rc;
    }

    public void setValue(int property, int id, String val) {
        NLDNode node = (NLDNode)this.elementAt(id);
        switch (property) {
            case 0: {
                node.id = val;
                break;
            }
            case 1: {
                node.parent = val;
                break;
            }
            case 2: {
                node.label = val;
                break;
            }
            case 3: {
                node.info = val;
                break;
            }
            case 10: {
                node.action = val;
                break;
            }
            case 11: {
                node.urlStr = val;
                break;
            }
            case 12: {
                node.imgstr = val;
                break;
            }
            case 13: {
                node.iconstr = val;
                break;
            }
        }
    }

    public Color getColorValue(int property, int id) {
        NLDNode node = (NLDNode)this.elementAt(id);
        Color rc = node.color;
        return rc;
    }

    public void setValue(int property, int id, Color val) {
        NLDNode node = (NLDNode)this.elementAt(id);
        node.color = val;
    }

    public Object getValue(int property, int id) {
        Object rc = null;
        NLDNode node = (NLDNode)this.elementAt(id);
        switch (property) {
            case 16: {
                rc = new Double(node.colval);
                break;
            }
            case 5: {
                rc = new Double(node.size);
                break;
            }
            case 6: {
                rc = new Double(node.type);
                break;
            }
            case 8: {
                rc = new Double(node.orgXpos);
                break;
            }
            case 9: {
                rc = new Double(node.orgYpos);
                break;
            }
            case 7: {
                rc = new Double(node.value);
                break;
            }
            case 0: {
                rc = node.id;
                break;
            }
            case 1: {
                rc = node.parent;
                break;
            }
            case 2: {
                rc = node.label;
                break;
            }
            case 3: {
                rc = node.info;
                break;
            }
            case 10: {
                rc = node.action;
                break;
            }
            case 11: {
                rc = node.urlStr;
                break;
            }
            case 12: {
                rc = node.imgstr;
                break;
            }
            case 13: {
                rc = node.iconstr;
                break;
            }
            case 4: {
                rc = node.color;
            }
        }
        return rc;
    }

    public void setValue(int property, int id, Object val) {
        if (val instanceof Number) {
            Number num = (Number)val;
            this.setValue(property, id, num.doubleValue());
        } else if (val instanceof Color) {
            this.setValue(property, id, (Color)val);
        } else if (val instanceof String) {
            this.setValue(property, id, (String)val);
        }
    }

    public NLDNode getNode(int ID) {
        NLDNode node = (NLDNode)this.elementAt(ID);
        return node;
    }

    public NLDNode getNode(int ID, NLDNode n) {
        try {
            return (NLDNode)this.elementAt(ID);
        }
        catch (Exception e) {
            return n;
        }
    }

    public NLDNode getNode(Object ID) {
        NLDNode n = null;
        if (ID instanceof String) {
            String id = (String)ID;
            for (int i = 0; i < this.size(); ++i) {
                n = (NLDNode)this.elementAt(i);
                if (!n.id.equals(id) && !id.equals(n.label)) {
                    continue;
                }
                break;
            }
        } else if (ID instanceof Number) {
            n = this.getNode(((Number)ID).intValue());
        }
        return n;
    }

    public Vector getSelected() {
        Vector<Integer> retVec = new Vector<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            if (!n.selected) continue;
            retVec.addElement(new Integer(n.getIndex()));
        }
        return retVec;
    }

    public void setSelected(int[] indices, boolean flag, int cntr, boolean handleEvents) {
        for (int i = 0; i < cntr; ++i) {
            NLDNode n = (NLDNode)this.elementAt(indices[i]);
            if (!handleEvents) continue;
            n.selected = flag;
        }
    }

    public void setSelected(int i, boolean flag) {
        this.setSelected(i, flag, true);
    }

    public void setSelected(int i, boolean flag, boolean handleEvents) {
        NLDNode n = (NLDNode)this.elementAt(i);
        if (handleEvents) {
            n.selected = flag;
        }
    }

    public boolean isSelected(int i) {
        NLDNode n = (NLDNode)this.elementAt(i);
        return n.selected;
    }

    public void setCollapsed(int i, boolean flag) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.hideSubtree = flag;
    }

    public boolean isCollapsed(int i) {
        NLDNode n = (NLDNode)this.elementAt(i);
        return n.hideSubtree;
    }

    public void setVisible(int i, boolean flag) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.hide = !flag;
    }

    public boolean isVisible(int i) {
        NLDNode n = (NLDNode)this.elementAt(i);
        return !n.hide;
    }

    public void setCurX(int i, double x) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.xpos = x;
    }

    public void setType(int i, int type) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.type = type;
    }

    public void setInitX(int i, double x) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.orgXpos = x;
        n.xpos = x;
    }

    public void setCurY(int i, double y) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.ypos = y;
    }

    public void setInitY(int i, double y) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.orgYpos = y;
        n.ypos = y;
    }

    public void setCurLoc(int i, double x, double y) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.xpos = x;
        n.ypos = y;
    }

    public void setColor(int i, Color c) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.color = c;
    }

    public void setSize(int i, double s) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.size = s;
    }

    public void setValue(int i, double s) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.value = s;
    }

    public void setHandleSize(int i, double s) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.handleSize = s;
    }

    public void setHandleX(int i, double s) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.handleX = s;
    }

    public void setHandleY(int i, double s) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.handleY = s;
    }

    public void setLabel(int i, String label) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setLabel(label);
    }

    public void setID(int i, String id) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.id = id;
    }

    public void setParent(int i, String id) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.parent = id;
    }

    public void setInfo(int i, String info) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setInfo(info);
    }

    public void setAction(int i, String val) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.action = val;
    }

    public void setUrl(int i, String val) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.urlStr = val;
    }

    public void setImage(int i, String im) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setImage(im);
    }

    public void setIcon(int i, String im) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setIcon(im);
    }

    public void setImage(int i, Image im) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setImage(im);
    }

    public void setIcon(int i, Image im) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setIcon(im);
    }

    public void setShape(int i, String shape) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.type = NLDViewer.shapeToType(shape);
    }

    public void setDoAlignment(int i, double val) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.moveToCenter = (int)val;
    }

    public void setSelectAll(boolean flag) {
        for (int i = 0; i < this.size(); ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            n.selected = flag;
        }
    }

    public boolean isSelectAll() {
        for (int i = 0; i < this.size(); ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            if (n.selected) continue;
            return false;
        }
        return true;
    }

    public void setShowAll() {
        for (int i = 0; i < this.size(); ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            n.hide = false;
            n.hideSubtree = false;
        }
    }

    public void resetAll() {
        for (int i = 0; i < this.size(); ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            n.reset();
        }
    }

    public boolean isMapped(int property) {
        return this.maps[property];
    }

    public void setToMap(int property, boolean flag) {
        this.maps[property] = flag;
    }

    public void addObservation(NLDNode n) {
        if (this.minValue > n.value) {
            this.minValue = n.value;
        }
        if (this.maxValue < n.value) {
            this.maxValue = n.value;
        }
        this.addElement(n);
    }

    public void unselectAll(boolean handleEvents) {
        int numNodes = this.size();
        for (int i = 0; i < numNodes; ++i) {
            NLDNode n = (NLDNode)this.elementAt(i);
            if (!handleEvents) continue;
            n.selected = false;
        }
    }

    public void sendRepaint() {
    }

    public int getNumberObservations() {
        return this.size();
    }

    public double getMinimumValue() {
        return this.minValue;
    }

    public double getMaximumValue() {
        return this.maxValue;
    }

    public void setLabelMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.nodeLabelMode = mode;
            }
        }
    }

    public void setOrgLoc(int i, double x, double y) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.xpos = n.orgXpos = x;
        n.ypos = n.orgYpos = y;
    }

    public double[] getSize(int i, ChannelLite ch, int handleType, int iconType) {
        NLDNode n = (NLDNode)this.elementAt(i);
        return n.getSize(ch, handleType, iconType);
    }

    public void setSize(int i, double width, double height) {
        NLDNode n = (NLDNode)this.elementAt(i);
        n.setSize(width, height);
    }

    public double[] getLocation(int i, ChannelLite channel, int handleType, int iconType) {
        NLDNode n = (NLDNode)this.elementAt(i);
        return n.getLocation(channel, handleType, iconType);
    }

    public boolean readNodePositions() {
        System.out.println("Not implemented. Should Not come here. VectorNodeModel:readNodePositions()");
        return false;
    }
}

