/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDLink;
import java.awt.Color;
import java.util.Vector;

public class VectorLinkModel
extends Vector {
    public static String[] keys = new String[]{"ID", "From", "To", "Label", "Info", "Width", "Value", "Color", "Style", "Group"};
    public static final int ID = 0;
    public static final int From = 1;
    public static final int To = 2;
    public static final int Label = 3;
    public static final int Info = 4;
    public static final int Width = 5;
    public static final int Value = 6;
    public static final int Color = 7;
    public static final int Style = 8;
    public static final int Group = 9;
    public static final int ColorVal = 10;
    private double minValue = Double.MAX_VALUE;
    private double maxValue = Double.MIN_VALUE;
    protected int nodeLabelMode = 1;
    protected Vector linksToUpdate = new Vector();
    protected Vector linksToRemove = new Vector();

    public double getNumValue(int property, int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        double rc = -1.0;
        switch (property) {
            case 10: {
                rc = link.colval;
                break;
            }
            case 5: {
                rc = link.width;
                break;
            }
            case 8: {
                rc = link.stipple;
                break;
            }
            case 6: {
                rc = link.value;
                break;
            }
        }
        return rc;
    }

    public Vector getNewLinks() {
        return this.linksToUpdate;
    }

    public Vector getRemovedLinks() {
        return this.linksToRemove;
    }

    public void dispose() {
        this.clear();
        if (this.linksToRemove != null) {
            this.linksToRemove.clear();
        }
        this.linksToRemove = null;
        if (this.linksToUpdate != null) {
            this.linksToUpdate.clear();
        }
        this.linksToUpdate = null;
    }

    public void dynamicRemove(int idx) {
        this.remove(idx);
        int nLinks = this.size();
        for (int i = idx; i < nLinks; ++i) {
            NLDLink link = (NLDLink)this.elementAt(i);
            link.setIndex(i);
        }
    }

    public void setValue(int property, int id, double val) {
        NLDLink link = (NLDLink)this.elementAt(id);
        switch (property) {
            case 10: {
                link.colval = val;
                break;
            }
            case 5: {
                link.width = val;
                break;
            }
            case 8: {
                link.stipple = (int)val;
                break;
            }
            case 6: {
                link.value = val;
                break;
            }
        }
    }

    public String getStringValue(int property, int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        String rc = null;
        switch (property) {
            case 3: {
                rc = link.label;
                break;
            }
            case 4: {
                rc = link.info;
                break;
            }
        }
        return rc;
    }

    public void setValue(int property, Object id, String val) {
        if (id instanceof Number) {
            int index = ((Number)id).intValue();
            this.setValue(property, index, val);
        }
    }

    public void setValue(int property, int id, String value) {
        NLDLink link = (NLDLink)this.elementAt(id);
        switch (property) {
            case 3: {
                link.label = value;
                break;
            }
            case 4: {
                link.info = value;
                break;
            }
        }
    }

    public boolean isSelected(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        return link.selected;
    }

    public boolean isVisible(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        return !link.hide;
    }

    public boolean isCulled(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        return link.cull;
    }

    public Vector getSelected() {
        Vector<Integer> retVec = new Vector<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            NLDLink l = (NLDLink)this.elementAt(i);
            if (!l.selected) continue;
            retVec.addElement(new Integer(l.getIndex()));
        }
        return retVec;
    }

    public void setSelected(int[] indices, boolean flag, int cntr, boolean handleEvents) {
        for (int i = 0; i < cntr; ++i) {
            NLDLink l = (NLDLink)this.elementAt(indices[i]);
            if (!handleEvents) continue;
            l.selected = flag;
        }
    }

    public void setSelected(int i, boolean flag, boolean handleEvents) {
        NLDLink l = (NLDLink)this.elementAt(i);
        if (handleEvents) {
            l.selected = flag;
        }
    }

    public void setSelected(int id, boolean flag) {
        NLDLink link = (NLDLink)this.elementAt(id);
        link.selected = flag;
    }

    public void unselectAll(boolean handleEvents) {
        int numLinks = this.size();
        for (int i = 0; i < numLinks; ++i) {
            NLDLink l = (NLDLink)this.elementAt(i);
            if (!handleEvents) continue;
            l.selected = false;
        }
    }

    public void setVisible(int id, boolean flag) {
        NLDLink link = (NLDLink)this.elementAt(id);
        link.hide = !flag;
    }

    public void setCulled(int id, boolean flag) {
        NLDLink link = (NLDLink)this.elementAt(id);
        link.cull = flag;
    }

    public int getWidth(int index) {
        NLDLink link = (NLDLink)this.elementAt(index);
        return (int)link.width;
    }

    public void setWidth(int index, double x) {
        NLDLink link = (NLDLink)this.elementAt(index);
        link.width = x;
    }

    public void setStipple(int index, int stipple) {
        NLDLink link = (NLDLink)this.elementAt(index);
        link.stipple = stipple;
    }

    public void setLabel(int i, String label) {
        NLDLink link = (NLDLink)this.elementAt(i);
        link.setLabel(label);
    }

    public void setFrom(int i, int from) {
        NLDLink link = (NLDLink)this.elementAt(i);
        link.from = from;
    }

    public void setTo(int i, int to) {
        NLDLink link = (NLDLink)this.elementAt(i);
        link.to = to;
    }

    public void setInfo(int i, String info) {
        NLDLink link = (NLDLink)this.elementAt(i);
        link.setInfo(info);
    }

    public void setValue(int i, double s) {
        NLDLink link = (NLDLink)this.elementAt(i);
        link.value = s;
    }

    public void isCulled(int id, boolean flag) {
        NLDLink link = (NLDLink)this.elementAt(id);
        link.cull = flag;
    }

    public Color getColorValue(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        Color rc = link.color;
        return rc;
    }

    public Color getColorValue(int property, int id) {
        return this.getColorValue(id);
    }

    public void setColor(int id, Color val) {
        NLDLink link = (NLDLink)this.elementAt(id);
        link.color = val;
    }

    public void setValue(int property, Object id, double val) {
        if (id instanceof Number) {
            int index = ((Number)id).intValue();
            this.setValue(property, index, val);
        }
    }

    public void setValue(int property, Object id, Object val) {
        if (id instanceof Number) {
            int index = ((Number)id).intValue();
            this.setValue(property, index, val);
        }
    }

    public Object getValue(int property, int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        Object rc = null;
        switch (property) {
            case 10: {
                rc = new Double(link.colval);
                break;
            }
            case 5: {
                rc = new Double(link.width);
                break;
            }
            case 8: {
                rc = new Double(link.stipple);
                break;
            }
            case 6: {
                rc = new Double(link.value);
                break;
            }
            case 3: {
                rc = link.label;
                break;
            }
            case 4: {
                rc = link.info;
                break;
            }
            case 7: {
                rc = link.color;
            }
        }
        return rc;
    }

    public void setValue(int property, int id, Object val) {
        if (val instanceof Number) {
            Number num = (Number)val;
            this.setValue(property, id, num.doubleValue());
        } else if (val instanceof Color) {
            this.setColor(id, (Color)val);
        } else if (val instanceof String) {
            this.setValue(property, id, (String)val);
        }
    }

    public void setSelectAll(boolean flag) {
        for (int i = 0; i < this.size(); ++i) {
            NLDLink link = (NLDLink)this.elementAt(i);
            link.selected = flag;
        }
    }

    public void setShowAll() {
        for (int i = 0; i < this.size(); ++i) {
            NLDLink link = (NLDLink)this.elementAt(i);
            link.hide = false;
        }
    }

    public Object[] getNodes(int id) {
        Object[] rc = new Object[2];
        NLDLink link = (NLDLink)this.elementAt(id);
        rc[0] = new Integer(link.from);
        rc[1] = new Integer(link.to);
        return rc;
    }

    public Object getFromNode(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        return new Integer(link.from);
    }

    public Object getToNode(int id) {
        NLDLink link = (NLDLink)this.elementAt(id);
        return new Integer(link.to);
    }

    public void addObservation(NLDLink a) {
        if (this.minValue > a.value) {
            this.minValue = a.value;
        }
        if (this.maxValue < a.value) {
            this.maxValue = a.value;
        }
        this.addElement(a);
    }

    public int getIndexOf(Object id) {
        if (id instanceof Number) {
            return ((Number)id).intValue();
        }
        return super.indexOf(id);
    }

    public double getMinimumValue() {
        return this.minValue;
    }

    public double getMaximumValue() {
        return this.maxValue;
    }

    public void computeMinMax(double value) {
        if (this.minValue > value) {
            this.minValue = value;
        }
        if (this.maxValue < value) {
            this.maxValue = value;
        }
    }

    public int getNumberObservations() {
        return this.size();
    }

    public void setLabelMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.nodeLabelMode = mode;
            }
        }
    }
}

