/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

public class Ring {
    private double m_amin;
    private double m_amax;
    private double m_rmin;
    private double m_rmax;
    private double m_key;

    public Ring() {
        this.m_amin = 0.0;
        this.m_amax = Math.PI * 2;
        this.m_rmin = 0.0;
        this.m_rmax = Double.MAX_VALUE;
    }

    public Ring(double amin, double amax, double rmin, double rmax) {
        this.m_amin = amin;
        this.m_amax = amax;
        this.m_rmin = rmin;
        this.m_rmax = rmax;
    }

    public void setAMin(double a) {
        this.m_amin = a;
    }

    public double getAMin() {
        return this.m_amin;
    }

    public void setAMax(double a) {
        this.m_amax = a;
    }

    public double getAMax() {
        return this.m_amax;
    }

    public void setRMin(double r) {
        this.m_rmin = r;
    }

    public double getRMin() {
        return this.m_rmin;
    }

    public void setRMax(double r) {
        this.m_rmax = r;
    }

    public double getRMax() {
        return this.m_rmax;
    }

    public boolean isInside(double a1, double a2, double r1, double r2) {
        return a1 < this.m_amin || a2 > this.m_amax || r1 < this.m_rmin || r2 > this.m_rmax;
    }

    public double calcMaxInteriorCircle() {
        double sinHalfDA;
        double r1;
        double r = (this.m_rmax - this.m_rmin) / 2.0;
        double dA = this.m_amax - this.m_amin;
        if (dA < Math.PI && r > (r1 = (sinHalfDA = Math.sin(dA / 2.0)) * this.m_rmin / (1.0 - sinHalfDA))) {
            r = r1;
        }
        this.m_key = r;
        return r;
    }
}

