/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.AboutFrame;
import com.sas.graphics.util.BMPWriter;
import com.sas.graphics.util.SASIcon;
import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.nld.NLD;
import com.sas.graphics.util.nld.NLDFilterDlg;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDMouseFrame;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDScrollPaneInterface;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import netscape.javascript.JSObject;

public abstract class NLDViewer
extends JComponent
implements ActionListener,
ItemListener,
ImageObserver,
MouseListener,
MouseMotionListener,
Runnable,
NLDScrollPaneInterface {
    public static final int MODE_NONE = 0;
    public static final int MODE_BRUSH = 1;
    public static final int MODE_VIEWPORT = 2;
    public static final int MODE_ZOOM = 3;
    public static final int MODE_PAN = 4;
    public static final int MODE_RESET = 5;
    public static final int MODE_SELECT = 6;
    public static final int MODE_MOVE = 7;
    public static final int NUM_ACTION_MODES = 8;
    public static final RenderingHints ANTIALIAS_ON = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    public static final RenderingHints ANTIALIAS_OFF = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    protected static final int ANTIALIAS_THRESHOLD = 100;
    private static final double TOOLTIP_WIDTH_RATIO = 0.8;
    protected static int DEFAULT_SHAPE_TYPE = 0;
    protected static String DEFAULT_SHAPE_STRING = "Square";
    protected JSObject js = null;
    protected ResourceBundle appRB = null;
    protected boolean DEBUG = false;
    protected double centerx = 0.0;
    protected double centery = 0.0;
    protected double pixsize;
    protected double zoomval = 1.0;
    protected double defaultzoom = 1.0;
    protected String[] str;
    protected ChannelLite channel;
    protected Dimension dimension;
    protected long displist = 0L;
    protected long tiplist = 1L;
    protected long selectionList = 2L;
    protected long nodelist = 3L;
    protected long linklist = 4L;
    protected boolean brush = false;
    protected boolean viewport = false;
    protected boolean zoom = false;
    protected boolean pan = false;
    protected boolean select = false;
    protected boolean chgview = false;
    protected boolean extsel = false;
    protected boolean movenode = false;
    protected boolean nodeMoved = false;
    protected boolean drag = false;
    protected boolean popup = false;
    protected int actionMode = 0;
    protected boolean actionModeValid = false;
    protected boolean handleEvents = true;
    protected boolean brushActive = false;
    protected boolean brushPress = false;
    protected boolean brushDrag = false;
    protected boolean brushResize = false;
    protected boolean viewportActive = false;
    protected boolean building = false;
    private NLDFilterDlg dlg = null;
    protected boolean myMouseAction = false;
    protected int prevx = 0;
    protected int prevy = 0;
    protected int shiftX = 0;
    protected int shiftY = 0;
    protected int diffx = 0;
    protected int diffy = 0;
    protected int pressX = 0;
    protected int pressY = 0;
    protected int brushPressX = 0;
    protected int brushPressY = 0;
    protected int startStretchX = 0;
    protected int startStretchY = 0;
    protected int stretchX = 0;
    protected int stretchY = 0;
    protected int stretchPrevX = 0;
    protected int stretchPrevY = 0;
    protected Rectangle l;
    protected Rectangle r;
    protected Rectangle t;
    protected Rectangle b;
    protected Rectangle tr;
    protected Rectangle br;
    protected Rectangle bl;
    protected Rectangle tl;
    protected int handleSize = 6;
    protected int handleID = -1;
    protected Cursor normalCursor = Cursor.getPredefinedCursor(0);
    protected Cursor moveOpenCursor = null;
    protected Cursor moveCloseCursor = null;
    protected Cursor zoomCursor = null;
    protected Cursor viewportCursor = null;
    protected NLDNode pressNLDNode = null;
    protected NLDNode lastPressNLDNode = null;
    protected boolean ready = false;
    protected Color background = Color.black;
    protected Color textColor = Color.black;
    protected Color selectColor = Color.red;
    protected Color nodeColor = Color.white;
    protected Color nodeBorderColor = Color.black;
    protected Color linkColor = Color.lightGray;
    protected Color errorNodeColor = Color.red;
    protected Color errorLinkColor = Color.black;
    protected Color[] rampColors = new Color[3];
    protected AppletStub applet = null;
    protected NLDModel model = null;
    protected int numNodes = 0;
    protected int numLinks = 0;
    protected int linkWidth = 1;
    protected boolean fan = false;
    protected double cutoff = 0.5;
    protected double spreadCutoff = 1.0;
    protected boolean lens = true;
    protected double lensFactor = 1.0;
    protected double spreadFactor = 1.25;
    protected boolean JXDspread = true;
    protected double savedLensFactor = 1.0;
    protected double savedSpreadFactor = 1.25;
    protected boolean isWorldCoord = true;
    protected double xlens = 0.0;
    protected double ylens = 0.0;
    protected boolean tracking = true;
    protected boolean showLabels = true;
    protected boolean userLayout = false;
    protected boolean infoFlag = true;
    protected int imageDraw;
    protected int imagePositionX;
    protected int imagePositionY;
    protected int imageWidth;
    protected int imageHeight;
    protected String imageUrl;
    protected Image backImage;
    protected String urlTarget;
    protected String helpUrlString;
    protected String rbstr;
    protected URL code;
    protected URL document;
    protected int urlDispLim = 64;
    private boolean doubleBuffer = true;
    private boolean cleanTip = false;
    protected boolean readyCalled = false;
    protected boolean deselAll = true;
    protected boolean useRBsizing = true;
    protected int textBorderType = 0;
    protected int borderType = 1;
    protected boolean fixedShapeNoneSelected = false;
    private Font font;
    protected int handleType = 1;
    protected Color handleColor = Color.darkGray;
    protected int iconType = 0;
    protected String nodeSep = ";";
    protected boolean colmap = true;
    protected boolean colmapLinks = false;
    protected boolean colmapNodes = false;
    protected boolean widthMapLinks = true;
    protected boolean shapeMapNodes = true;
    protected boolean sizeMapNodes = true;
    protected double defaultNodeSize = 0.025;
    protected int defaultUserNodeSize = 10;
    protected double defaultNodeSizeIncrease = 0.05;
    protected int defaultUserNodeSizeIncrease = 1;
    protected double defaultLinkWidth = 1.0;
    protected double defaultLinkWidthIncrease = 3.0;
    protected double nodeSize = -1.0;
    protected Color[] linkColors;
    protected Color[] nodeColors;
    protected double[] nodeSizes;
    protected double[] linkWidths;
    protected int[] nodeShapes;
    protected String selectIdFunc;
    protected String selectLabelFunc;
    protected String selectURLFunc;
    protected AboutFrame aboutFrame = null;
    protected NLDMouseFrame mouseFrame = null;
    protected SASIcon sasIcon = null;
    protected int BMPImageWidth = 0;
    protected int BMPImageHeight = 0;
    protected String BMPImageFileName = null;
    protected boolean backborder = false;
    public Object clrRamp = null;
    private Method clrMethod = null;
    private boolean centerSelected = false;
    private NLDNode probeNode = null;
    private NLDLink probeLink = null;
    private int probePtX;
    private int probePtY;
    private boolean cascadeLinkFilters = false;
    private Vector probeInfo = null;
    private boolean tooltipPaint = false;
    private boolean inApplet = true;
    protected boolean emptyPlot = true;
    protected boolean rebuilt = false;
    protected boolean selectedBuilt = false;
    protected boolean pickLinks = true;
    protected boolean buildAsNonSelected = false;
    protected boolean drawBrush = true;
    protected boolean pauseLayout = false;
    private boolean doAnimation = false;
    private boolean animating = false;
    private int layoutStrategy = 3;
    private TooltipHandler tooltipHandler = null;
    protected Timer tooltipTimer = null;
    protected Point tipLocation = null;
    protected Vector tipText = null;
    protected boolean rebuildRequired = false;
    private String stationaryEng = "stationary";
    private String stationaryNLS = null;
    String center1Eng = "Center";
    String tile1Eng = "Tile";
    String scale1Eng = "Scale";
    String position1Eng = "Position";
    String center2Eng = "C";
    String tile2Eng = "T";
    String scale2Eng = "S";
    String position2Eng = "P";
    String scale1NLS = null;
    String scale2NLS = null;
    String tile1NLS = null;
    String tile2NLS = null;
    String center1NLS = null;
    String center2NLS = null;
    String position1NLS = null;
    String position2NLS = null;
    String empty = null;
    String fill = null;
    String line = null;
    String outline = null;
    protected static String diamondEng = "Diamond";
    protected static String circleEng = "Circle";
    protected static String triangleEng = "Triangle";
    protected static String squareEng = "Square";
    protected static String noneEng = "None";
    protected static String diamondNLS;
    protected static String circleNLS;
    protected static String triangleNLS;
    protected static String squareNLS;
    protected static String noneNLS;
    boolean[] prevSelected = null;
    protected boolean ignoreBuild = false;
    protected int[] lastSelectedNodes = null;
    protected int lastNumSelectedNodes = 0;
    protected int[] lastSelectedLinks = null;
    protected int lastNumSelectedLinks = 0;
    protected boolean handleSelected;
    protected int compWidth = 0;
    protected int compHeight = 0;
    private double minDim = 0.0;
    protected boolean verticalLens = false;
    protected double[] lensLocs;
    protected double[] lensRange;
    protected double[] lensValues;
    protected double[] lensScreenLocs;
    protected double[] lensScreenRange;
    protected double[] textCutoffs;
    private double arrowsize = 0.05;
    protected int texthalign = 1;
    protected int textvalign = 1;
    Hashtable images = new Hashtable();
    Hashtable icons = new Hashtable();
    static int imid;
    MediaTracker mt = null;
    double iconWidth = 0.0;
    double iconHeight = 0.0;
    private boolean handCursor = false;
    private Object lock = new Object();
    boolean first = true;
    Point imageLocation;
    protected Rectangle imageRect = null;
    private Vector[] outLinks = null;
    private double prevCenterX = 0.0;
    private double prevCenterY = 0.0;
    protected boolean interrupted = false;
    Thread clickThread;
    protected boolean resetNeeded = false;
    int[] oldIndices = null;
    int[] oldIndicesLinks = null;
    int oldCnt = 0;
    int oldCntLinks = 0;
    protected int dragMinX;
    protected int dragMinY;
    protected int dragMaxX;
    protected int dragMaxY;
    static int checkStateCntr;
    protected Object id = null;

    protected void DEBUG(String msg) {
    }

    protected NLDViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pauseLayout = false;
        this.rampColors[0] = Color.red;
        this.rampColors[1] = Color.green;
        this.rampColors[2] = Color.blue;
        this.layoutStrategy = 3;
        this.tooltipHandler = new TooltipHandler();
        this.tooltipTimer = new Timer(500, this.tooltipHandler);
        this.tooltipTimer.start();
    }

    public void dispose() {
        this.js = null;
        this.channel = null;
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.tooltipTimer.stop();
        this.tooltipTimer = null;
        this.tooltipHandler = null;
        this.model = null;
        this.tipText = null;
    }

    public boolean isEmptyPlot() {
        return this.emptyPlot;
    }

    protected void setModel(NLDModel m) {
        this.model = m;
    }

    public void setBMPImageWidth(int width) {
        this.BMPImageWidth = width;
    }

    public void setBMPImageHeight(int height) {
        this.BMPImageHeight = height;
    }

    public void setBMPImageFileName(String file) {
        this.BMPImageFileName = new String(file);
    }

    public abstract void load();

    public void saveToBitmap() {
        while (!this.ready) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ee) {
                System.out.println("Image not saved");
                return;
            }
        }
        Image img = this.channel.getBackbuffer();
        Image img2 = null;
        if (this.BMPImageWidth != img.getWidth(this) || this.BMPImageHeight != img.getHeight(this)) {
            img = img2 = img.getScaledInstance(this.BMPImageWidth, this.BMPImageHeight, 1);
        }
        BMPWriter writer = new BMPWriter();
        writer.saveBitmap(this.BMPImageFileName, img, this.BMPImageWidth, this.BMPImageHeight);
    }

    public void waitTilReady() {
        while (!this.ready) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ee) {
                System.out.println("Image not saved");
                return;
            }
        }
    }

    public void copyModel(NLDViewer viewer) {
        this.model = viewer.model;
    }

    public void copy(NLDViewer viewer) {
        this.centerx = viewer.centerx;
        this.centery = viewer.centery;
        this.pixsize = viewer.pixsize;
        this.zoomval = viewer.zoomval;
        this.defaultzoom = viewer.defaultzoom;
        this.background = viewer.background;
        this.textColor = viewer.textColor;
        this.selectColor = viewer.selectColor;
        this.nodeColor = viewer.nodeColor;
        this.nodeSize = viewer.nodeSize;
        this.linkColor = viewer.linkColor;
        this.model = viewer.model;
        this.fan = viewer.fan;
        this.cutoff = viewer.cutoff;
        this.spreadCutoff = viewer.spreadCutoff;
        this.lens = viewer.lens;
        this.lensFactor = viewer.lensFactor;
        this.spreadFactor = viewer.spreadFactor;
        this.savedSpreadFactor = viewer.savedSpreadFactor;
        this.JXDspread = viewer.JXDspread;
        this.savedLensFactor = viewer.savedLensFactor;
        this.xlens = viewer.xlens;
        this.ylens = viewer.ylens;
        this.isWorldCoord = viewer.isWorldCoord;
        this.handleColor = viewer.handleColor;
        this.handleType = viewer.handleType;
        this.iconType = viewer.iconType;
        this.tracking = viewer.tracking;
        this.showLabels = viewer.showLabels;
        this.userLayout = viewer.userLayout;
        this.infoFlag = viewer.infoFlag;
        this.doubleBuffer = viewer.doubleBuffer;
        this.outLinks = viewer.outLinks;
        this.imageDraw = viewer.imageDraw;
        this.imagePositionX = viewer.imagePositionX;
        this.imagePositionY = viewer.imagePositionY;
        this.imageRect = viewer.imageRect;
        this.imageLocation = viewer.imageLocation;
        this.imageWidth = viewer.imageWidth;
        this.imageHeight = viewer.imageHeight;
        this.imageUrl = viewer.imageUrl;
        this.backImage = viewer.backImage;
        this.urlTarget = viewer.urlTarget;
        this.code = viewer.code;
        this.document = viewer.document;
        this.rbstr = viewer.rbstr;
        this.appRB = viewer.appRB;
        this.useRBsizing = viewer.useRBsizing;
        this.helpUrlString = viewer.helpUrlString;
        this.borderType = viewer.borderType;
        this.textBorderType = viewer.textBorderType;
        this.clrRamp = viewer.clrRamp;
        this.setFont(new Font(viewer.font.getName(), viewer.font.getStyle(), viewer.font.getSize()));
    }

    public void setDebug(boolean flag) {
        this.DEBUG = flag;
    }

    protected void createChannel() {
        this.dimension = new Dimension();
        if (this.font == null) {
            this.font = this.getValidFont();
        } else {
            this.setFont(this.font);
        }
        if (this.channel == null) {
            this.channel = new ChannelLite((Component)this);
            this.channel.setTextBorderFlag(true);
            this.channel.setTextBorderType(this.textBorderType);
            this.channel.setBorderType(this.borderType);
            this.channel.setTextBorderColor(Color.black);
            this.channel.glEdgeColor(Color.black);
            this.setBackground(this.background);
            this.channel.glPolygonMode(4);
            this.channel.glPushName((Object)"");
            this.channel.glSelect2DFont(this.font);
            this.channel.setTextHandleColor(this.handleColor);
            this.channel.glEnable(1);
        }
        if (this.rebuildRequired) {
            this.build();
            this.rebuildRequired = false;
        }
        this.channel.addNotify();
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
    }

    protected void setRBString(String s) {
        this.rbstr = s;
        try {
            this.appRB = ResourceBundle.getBundle(this.rbstr);
        }
        catch (MissingResourceException e) {
            this.appRB = null;
        }
        catch (ClassCastException e) {
            this.appRB = null;
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.appRB = rb;
    }

    public void resetView(boolean build) {
        this.zoomval = this.defaultzoom;
        this.lensFactor = this.savedLensFactor;
        this.spreadFactor = this.savedSpreadFactor;
        this.setCenter();
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.proj();
        if (build) {
            this.build();
            this.buildSelected();
        }
        this.repaint();
    }

    protected void setCenter() {
        this.centerx = 0.0;
        this.centery = 0.0;
    }

    public void resetView() {
        this.resetView(true);
    }

    public boolean setActionMode(int mode) {
        if (this.actionMode == 1 && this.actionMode != mode && mode != 5) {
            this.repaint();
        }
        if (mode == 5) {
            this.resetView();
        } else {
            this.actionMode = mode;
        }
        if (mode == 7) {
            this.movenode = true;
        }
        this.setCursor(this.actionMode);
        return true;
    }

    protected void setCursor(int mode) {
        if (this.isAnimating() || this.model.isLayoutThreadAlive()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            return;
        }
        switch (mode) {
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 4: {
                if (this.moveOpenCursor != null) {
                    this.setCursor(this.moveOpenCursor);
                    break;
                }
                System.out.println("Custom Move open cursor not found. Using predefined cursor.");
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
            case 2: {
                if (this.viewportCursor != null) {
                    this.setCursor(this.viewportCursor);
                    break;
                }
                System.out.println("Custom viewport cursor not found. Using predefined cursor.");
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 3: {
                if (this.zoomCursor != null) {
                    this.setCursor(this.zoomCursor);
                    break;
                }
                System.out.println("Custom zoom cursor not found. Using predefined cursor.");
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public int getActionMode() {
        return this.actionMode;
    }

    public void setActionModeValid(boolean flag) {
        this.actionModeValid = flag;
    }

    public boolean isActionModeValid() {
        return this.actionModeValid;
    }

    public void setTooltips(boolean flag) {
        this.infoFlag = flag;
    }

    public void setChartTipsOn(boolean flag) {
        this.infoFlag = flag;
    }

    public boolean areChartTipsOn() {
        return this.infoFlag;
    }

    public String getStyle() {
        return null;
    }

    public boolean setStyle(Object newStyle) {
        return false;
    }

    @Override
    public void setBackground(Color c) {
        if (c == null) {
            return;
        }
        this.background = c;
        super.setBackground(c);
        if (this.channel != null) {
            this.channel.setBackgroundColor(this.background);
            if (this.backImage == null) {
                this.channel.removeBackgroundImage();
            } else {
                this.imageUpdate(this.backImage, 32, 0, 0, this.imageWidth, this.imageHeight);
                this.channel.setBackgroundImage(this.backImage, this.imageDraw);
                this.channel.setBackgroundImagePosition(this.imagePositionX, this.imagePositionY);
            }
        }
    }

    public void setUserLayout(boolean flag) {
        this.userLayout = flag;
    }

    public boolean isUserLayout() {
        return this.userLayout;
    }

    public void setLabels(boolean val) {
        this.showLabels = val;
    }

    public void setLabels(boolean val, boolean updateNodes) {
        if (this.showLabels == val) {
            return;
        }
        this.setLabels(val);
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            n.showLabel = this.showLabels;
        }
    }

    public void setLabels(int mode) {
        switch (mode) {
            case 1: {
                this.setLabels(true);
                break;
            }
            case 2: {
                this.setLabels(false);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setLabels(false);
                this.model.setLabelMode(mode);
            }
        }
    }

    public boolean areLabelsShown() {
        return this.showLabels;
    }

    public void setTooltipsMode(String mode) {
        if (this.stationaryNLS == null) {
            this.stationaryNLS = this.GRS("AppletInfo.Tips.Stationary.txt", this.stationaryEng);
        }
        this.tracking = !mode.toLowerCase().equals(this.stationaryEng) && !mode.toLowerCase().equals(this.stationaryNLS);
    }

    public void setHandleType(int type) {
        this.handleType = type;
    }

    public void setHelpLocation(String param) {
        this.helpUrlString = param;
    }

    public void setURLTarget(String param) {
        Date d;
        this.urlTarget = param != null ? param : ((d = new Date()) != null ? "_" + Integer.toHexString((int)d.getTime()) : "_blank");
    }

    public Color getNodeErrorColor() {
        return this.errorNodeColor;
    }

    public void setNodeErrorColor(Object c) {
        if (c instanceof String) {
            this.errorNodeColor = NLD.decodeColor((String)c);
        } else if (c instanceof Color) {
            this.errorNodeColor = (Color)c;
        }
        if (this.errorNodeColor == null) {
            System.out.println("Color " + c + " was not found. Using default error color.");
            this.errorNodeColor = Color.RED;
        }
    }

    public Color getLinkErrorColor() {
        return this.errorLinkColor;
    }

    public void setLinkErrorColor(Object c) {
        if (c instanceof String) {
            this.errorLinkColor = NLD.decodeColor((String)c);
        } else if (c instanceof Color) {
            this.errorLinkColor = (Color)c;
        }
        if (this.errorLinkColor == null) {
            System.out.println("Color " + c + " was not found. Using default error color.");
            this.errorLinkColor = Color.RED;
        }
    }

    public void setTextColor(Object c) {
        if (c instanceof String) {
            this.textColor = NLD.decodeColor((String)c);
        } else if (c instanceof Color) {
            this.textColor = (Color)c;
        }
        if (this.textColor == null) {
            System.out.println("Color " + c + " was not found. Using default text color.");
            this.textColor = Color.black;
        }
        for (int i = 0; i < this.numNodes; ++i) {
            ((NLDNode)this.model.nodes.elementAt(i)).setTextColor(this.textColor);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setSelectColor(Object col) {
        int i;
        if (col instanceof String) {
            this.selectColor = NLD.decodeColor((String)col);
        } else if (col instanceof Color) {
            this.selectColor = (Color)col;
        }
        if (this.selectColor == null) {
            System.out.println("Color " + col + " was not found. Using default select color.");
            this.selectColor = Color.red;
        }
        for (i = 0; i < this.numNodes; ++i) {
            ((NLDNode)this.model.nodes.elementAt(i)).setSelectColor(this.selectColor);
        }
        for (i = 0; i < this.numLinks; ++i) {
            ((NLDLink)this.model.links.elementAt(i)).setSelectColor(this.selectColor);
        }
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public void setBackColor(Object col) {
        if (col instanceof String) {
            this.background = NLD.decodeColor((String)col);
        } else if (col instanceof Color) {
            this.background = (Color)col;
        }
        this.setBackground(this.background);
        if (this.channel != null) {
            this.channel.setBackgroundColor(this.background);
        }
    }

    public Color getBackColor() {
        return this.background;
    }

    public void setBackBorder(boolean flag) {
        this.backborder = flag;
    }

    public void setBackImage(Object im) {
        if (im == null) {
            this.backImage = null;
        } else if (im instanceof Image) {
            this.backImage = (Image)im;
        } else if (im instanceof String) {
            String param = (String)im;
            this.backImage = param.startsWith("http:") || param.startsWith("HTTP:") || param.startsWith("file:") || param.startsWith("FILE:") ? this.GetImageFromURL(param, null) : this.GetImageFromURL(param, this.document);
        }
    }

    public void setImageURL(String param) {
        this.imageUrl = param;
    }

    public void setDrawImage(String param) {
        this.scale1NLS = this.GRS("AppletInfo.Scale1.txt", this.scale1Eng);
        this.scale2NLS = this.GRS("AppletInfo.Scale2.txt", this.scale2Eng);
        this.tile1NLS = this.GRS("AppletInfo.tile1.txt", this.tile1Eng);
        this.tile2NLS = this.GRS("AppletInfo.tile2.txt", this.tile2Eng);
        this.center1NLS = this.GRS("AppletInfo.center1.txt", this.center1Eng);
        this.center2NLS = this.GRS("AppletInfo.center2.txt", this.center2Eng);
        this.position1NLS = this.GRS("AppletInfo.position1.txt", this.position1Eng);
        this.position2NLS = this.GRS("AppletInfo.position2.txt", this.position2Eng);
        this.imageDraw = param.equalsIgnoreCase(this.center1Eng) || param.equalsIgnoreCase(this.center2Eng) || param.equalsIgnoreCase(this.center1NLS) || param.equalsIgnoreCase(this.center2NLS) ? 2 : (param.equalsIgnoreCase(this.position1Eng) || param.equalsIgnoreCase(this.position2Eng) || param.equalsIgnoreCase(this.position1NLS) || param.equalsIgnoreCase(this.position2NLS) ? 3 : (param.equalsIgnoreCase(this.tile1Eng) || param.equalsIgnoreCase(this.tile2Eng) || param.equalsIgnoreCase(this.tile1NLS) || param.equalsIgnoreCase(this.tile2NLS) ? 1 : 0));
    }

    public String getDrawImage() {
        String strg = null;
        switch (this.imageDraw) {
            case 2: {
                strg = this.center1Eng;
                break;
            }
            case 3: {
                strg = this.position1Eng;
                break;
            }
            case 1: {
                strg = this.tile1Eng;
                break;
            }
            default: {
                strg = this.scale1Eng;
            }
        }
        return strg;
    }

    public void setImagePosition(Point loc) {
        this.imagePositionX = loc.x;
        this.imagePositionY = loc.y;
    }

    @Override
    public int getHeight() {
        return this.compHeight;
    }

    @Override
    public int getWidth() {
        return this.compWidth;
    }

    public void setNodeSize(double param) {
        this.nodeSize = param;
    }

    public void setNodeSize(double nodeSze, boolean paintNodes) {
        if (nodeSze <= 0.0) {
            return;
        }
        this.setNodeSize(nodeSze);
        double nsize = -1.0;
        nsize = this.isUserLayout() ? (double)this.defaultUserNodeSize * (1.0 + this.nodeSize / 100.0) : this.defaultNodeSize * (1.0 + this.nodeSize / 100.0);
        if (paintNodes) {
            VectorNodeModel nodes = this.model.nodes;
            int numNodes = nodes.size();
            for (int i = 0; i < numNodes; ++i) {
                NLDNode n = (NLDNode)nodes.elementAt(i);
                n.setSize(nsize);
                n.setHeight(nsize);
            }
        }
    }

    public void setNodeColor(Object param) {
        if (param instanceof String) {
            this.nodeColor = NLD.decodeColor((String)param);
        } else if (param instanceof Color) {
            this.nodeColor = (Color)param;
        }
    }

    public void setNodeColor(Color nodeClr, boolean paintNodes) {
        if (nodeClr == null) {
            return;
        }
        this.setNodeColor(nodeClr);
        if (paintNodes) {
            VectorNodeModel nodes = this.model.nodes;
            int numNodes = nodes.size();
            for (int i = 0; i < numNodes; ++i) {
                NLDNode n = (NLDNode)nodes.elementAt(i);
                n.setColor(this.nodeColor);
            }
        }
    }

    public Color getNodeColor() {
        return this.nodeColor;
    }

    public double getNodeSize() {
        return this.nodeSize;
    }

    public Color getNodeBorderColor() {
        return this.nodeBorderColor;
    }

    public void setLinkColor(Object param) {
        if (param instanceof String) {
            this.linkColor = NLD.decodeColor((String)param);
        } else if (param instanceof Color) {
            this.linkColor = (Color)param;
        }
        if (this.linkColor == null) {
            System.out.println("Color " + param + " was not found. Using default link color.");
            this.linkColor = Color.lightGray;
        }
    }

    public void setLinkColor(Object param, boolean paintLinks) {
        if (param == null) {
            return;
        }
        this.setLinkColor(param);
        if (paintLinks) {
            VectorLinkModel links = this.model.links;
            int numLinks = links.size();
            for (int i = 0; i < numLinks; ++i) {
                NLDLink l = (NLDLink)links.elementAt(i);
                l.setColor(this.linkColor);
            }
        }
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public int getLinkWidth() {
        return this.linkWidth;
    }

    public String getTextBorderType() {
        String rc = null;
        switch (this.borderType) {
            default: {
                rc = this.empty;
                break;
            }
            case 2: {
                rc = this.fill;
                break;
            }
            case 1: {
                rc = this.line;
                break;
            }
            case 3: {
                rc = this.outline;
            }
        }
        return rc;
    }

    public String getNodeBorderType() {
        String rc = null;
        switch (this.borderType) {
            default: {
                rc = "none";
                break;
            }
            case 1: {
                rc = "line";
                break;
            }
            case 2: {
                rc = "raised";
                break;
            }
            case 3: {
                rc = "wide";
            }
        }
        return rc;
    }

    public void setNodeBorderType(String param) {
        this.borderType = (param = param.toLowerCase()).startsWith("none") ? 0 : (param.startsWith("line") ? 1 : (param.startsWith("raised") ? 2 : (param.startsWith("wide") ? 3 : 0)));
        if (this.channel != null) {
            this.channel.setBorderType(this.borderType);
        }
    }

    public void setNodeBorderType(int type) {
        this.borderType = type;
        if (this.channel != null) {
            this.channel.setBorderType(this.borderType);
        }
    }

    public void setCascadeLinkFilters(boolean on) {
        this.cascadeLinkFilters = on;
    }

    public boolean getCascadeLinkFilters() {
        return this.cascadeLinkFilters;
    }

    public void setTextBorderType(String param) {
        this.empty = this.GRS("AppletInfo.Scale1.txt", "empty");
        this.fill = this.GRS("AppletInfo.Scale1.txt", "fill");
        this.line = this.GRS("AppletInfo.Scale1.txt", "line");
        this.outline = this.GRS("AppletInfo.Scale1.txt", "outline");
        this.textBorderType = (param = param.toLowerCase()).startsWith(this.empty) ? 0 : (param.startsWith(this.fill) ? 2 : (param.startsWith(this.line) ? 1 : (param.startsWith(this.outline) ? 3 : 3)));
        if (this.channel != null) {
            this.channel.setTextBorderType(this.textBorderType);
        }
    }

    public void setTextBorderType(int type) {
        this.textBorderType = type;
        if (this.channel != null) {
            this.channel.setTextBorderType(this.textBorderType);
        }
    }

    public void setFontName(String param) {
        if (this.font == null) {
            this.font = this.getValidFont();
        }
        this.font = new Font(param, this.font.getStyle(), this.font.getSize());
        this.setFont(this.font);
    }

    public void setFontSize(int val) {
        if (val <= 0) {
            return;
        }
        if (this.font == null) {
            this.font = this.getValidFont();
        }
        this.font = new Font(this.font.getFamily(), this.font.getStyle(), val);
        this.setFont(this.font);
    }

    public void setFontStyle(int val) {
        if (val < 0) {
            return;
        }
        if (this.font == null) {
            this.font = this.getValidFont();
        }
        this.font = new Font(this.font.getFamily(), val, this.font.getSize());
        this.setFont(this.font);
    }

    public void setColorRamp(Object ramp) {
        this.clrRamp = ramp;
    }

    private Font getValidFont() {
        Font fn = this.getFont();
        if (fn == null) {
            fn = new Font("SansSerif", 0, 10);
        }
        return fn;
    }

    public void setSelectIdFunction(String param) {
        this.selectIdFunc = param;
    }

    public void setSelectLabelFunction(String param) {
        this.selectLabelFunc = param;
    }

    public void setSelectURLFunction(String param) {
        this.selectURLFunc = param;
    }

    public Object getSelectedNodesIds() {
        VectorNodeModel nodes = this.model.nodes;
        Vector<String> selected = new Vector<String>();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)nodes.elementAt(i);
            if (!n.selected || n.hide) continue;
            selected.addElement(n.id);
        }
        return this.createSelectList(selected, this.selectIdFunc);
    }

    public Object getSelectedNodesLabels() {
        VectorNodeModel nodes = this.model.nodes;
        Vector<String> selected = new Vector<String>();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)nodes.elementAt(i);
            if (!n.selected || n.hide || n.label == null) continue;
            selected.addElement(n.label);
        }
        return this.createSelectList(selected, this.selectLabelFunc);
    }

    public Object getSelectedNodesURLs() {
        VectorNodeModel nodes = this.model.nodes;
        Vector<String> selected = new Vector<String>();
        for (int i = 0; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)nodes.elementAt(i);
            if (!n.selected || n.hide || n.urlStr == null) continue;
            selected.addElement(n.urlStr);
        }
        return this.createSelectList(selected, this.selectURLFunc);
    }

    private Object createSelectList(Vector selected, String selectFunc) {
        int size = selected.size();
        if (size == 0) {
            return null;
        }
        Object obj = null;
        if (selectFunc != null) {
            Object[] selArray = new String[size];
            for (int i = 0; i < size; ++i) {
                selArray[i] = (String)selected.elementAt(i);
            }
            if (this.js == null) {
                try {
                    String name = this.applet.getParameter("NAME");
                    Applet ap = null;
                    if (name != null) {
                        ap = this.applet.getAppletContext().getApplet(name);
                    } else {
                        Enumeration<Applet> e = this.applet.getAppletContext().getApplets();
                        if (e.hasMoreElements()) {
                            ap = e.nextElement();
                        }
                    }
                    if (ap != null) {
                        this.js = JSObject.getWindow((Applet)ap);
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    this.js = null;
                }
            }
            if (this.js == null) {
                return null;
            }
            try {
                obj = this.js.call(selectFunc, selArray);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (obj instanceof String && ((String)obj).equals("undefined")) {
                return null;
            }
        } else {
            String sel = selected.elementAt(0).toString();
            String nodeSep = this.getNodeSeparator();
            for (int i = 1; i < size; ++i) {
                sel = sel + nodeSep + " " + selected.elementAt(i).toString().toString();
            }
            obj = sel;
        }
        return obj;
    }

    public String getNodeSeparator() {
        return this.nodeSep;
    }

    public void setNodeSeparator(String param) {
        this.nodeSep = param;
    }

    public void setColorMapping(boolean flag) {
        this.colmapNodes = this.colmap = flag;
        this.colmapLinks = this.colmap;
    }

    public void setColorMappingLinks(boolean flag) {
        this.colmapLinks = flag;
        this.colmap = this.colmapLinks || this.colmapNodes;
    }

    public void setWidthMappingLinks(boolean flag) {
        this.widthMapLinks = flag;
    }

    public boolean isWidthMappingLinks() {
        return this.widthMapLinks;
    }

    public void setShapeMappingNodes(boolean flag) {
        this.shapeMapNodes = flag;
    }

    public boolean isShapeMappingNodes() {
        return this.shapeMapNodes;
    }

    public void setSizeMappingNodes(boolean flag) {
        this.sizeMapNodes = flag;
    }

    public boolean isSizeMappingNodes() {
        return this.sizeMapNodes;
    }

    public boolean isColorMappingLinks() {
        return this.colmapLinks;
    }

    public void setColorMappingNodes(boolean flag) {
        this.colmapNodes = flag;
        this.colmap = this.colmapLinks || this.colmapNodes;
    }

    public boolean isColorMappingNodes() {
        return this.colmapNodes;
    }

    public void setRBSizing(boolean flag) {
        this.useRBsizing = flag;
    }

    public void setDuplicateCheck(boolean flag) {
        this.model.setDuplicateCheck(flag);
    }

    public void setAppletStub(AppletStub appletStub) {
        this.applet = appletStub;
        this.code = this.applet.getCodeBase();
        this.document = this.applet.getDocumentBase();
    }

    public boolean isLensActive() {
        return this.lens;
    }

    public void setLens(boolean flag) {
        this.lens = flag;
        if (this.channel != null) {
            if (flag) {
                this.channel.glEnable(2);
                this.channel.setLensFactor(this.lensFactor);
                if (this.JXDspread && this.spreadFactor > 0.0) {
                    this.channel.glEnable(3);
                    this.channel.setThetaLensFactor(this.spreadFactor);
                } else {
                    this.channel.glDisable(3);
                }
                this.channel.setTextCutoff(this.cutoff, this.spreadCutoff);
                if (this.isWorldCoord) {
                    this.channel.setLensWorldLocation(this.xlens, this.ylens);
                } else {
                    this.channel.setLensScreenLocation(this.xlens, this.ylens);
                }
                this.resetBorderProperties();
            } else {
                this.channel.glDisable(2);
                this.channel.glDisable(3);
            }
        }
    }

    public void setLensLocation(double x, double y) {
        this.xlens = x;
        this.ylens = y;
        this.isWorldCoord = x <= 1.0 && y <= 1.0;
        this.setLens(this.lens);
    }

    public void setFan(boolean flag) {
        this.fan = flag;
    }

    public void setSpreadFactor(double fac) {
        this.spreadFactor = this.savedSpreadFactor = fac;
        if (this.JXDspread && this.spreadFactor > 0.0 && this.channel != null) {
            this.channel.glEnable(3);
            this.channel.setThetaLensFactor(this.spreadFactor);
        }
    }

    public double getSpreadFactor() {
        return this.spreadFactor;
    }

    public void setRadialCutoffFactor(double fac) {
        this.cutoff = fac;
        if (this.channel != null) {
            this.channel.setTextCutoff(this.cutoff, this.spreadCutoff);
        }
    }

    public void setCutoffFactor(double fac) {
        this.setRadialCutoffFactor(fac);
    }

    public double getCutoffFactor() {
        return this.cutoff;
    }

    public void setSpreadCutoffFactor(double fac) {
        this.spreadCutoff = fac;
        if (this.channel != null) {
            this.channel.setTextCutoff(this.cutoff, this.spreadCutoff);
        }
    }

    public void setLensFactor(double fac) {
        this.lensFactor = this.savedLensFactor = fac;
        this.setLens(this.lens);
    }

    public double getLensFactor() {
        return this.lensFactor;
    }

    public void setHandleColor(Object c) {
        if (c instanceof String) {
            this.handleColor = NLD.decodeColor((String)c);
        } else if (c instanceof Color) {
            this.handleColor = (Color)c;
        }
    }

    public void showDirectionArrow(boolean flag) {
        this.model.setDirected(flag);
    }

    public void setLinkWidth(Object w) {
        if (w instanceof Number) {
            this.linkWidth = ((Number)w).intValue();
        } else if (w instanceof String) {
            this.linkWidth = Integer.parseInt((String)w);
        }
    }

    public void setLinkWidth(Object w, boolean changeWidths) {
        if (w == null) {
            return;
        }
        this.setLinkWidth(w);
        if (changeWidths) {
            double lWidth = this.linkWidth;
            VectorLinkModel links = this.model.links;
            int numLinks = links.size();
            for (int i = 0; i < numLinks; ++i) {
                NLDLink link = (NLDLink)links.elementAt(i);
                link.setWidth(lWidth);
            }
        }
    }

    protected void setLinkFromNode(NLDLink a, int node) {
        a.from = node;
    }

    protected void setLinkToNode(NLDLink a, int node) {
        a.to = node;
    }

    void setShapeStrings() {
        diamondNLS = this.GRS("AppletInfo.Diamond.txt", diamondEng);
        circleNLS = this.GRS("AppletInfo.Circle.txt", circleEng);
        triangleNLS = this.GRS("AppletInfo.Triangle.txt", triangleEng);
        squareNLS = this.GRS("AppletInfo.Square.txt", squareEng);
        noneNLS = this.GRS("AppletInfo.None.txt", noneEng);
    }

    public static int shapeToType(String shape) {
        if (shape == null) {
            return DEFAULT_SHAPE_TYPE;
        }
        if (shape.equalsIgnoreCase(diamondEng) || shape.equalsIgnoreCase(diamondNLS)) {
            return 3;
        }
        if (shape.equalsIgnoreCase(circleEng) || shape.equalsIgnoreCase(circleNLS)) {
            return 1;
        }
        if (shape.equalsIgnoreCase(noneEng) || shape.equalsIgnoreCase(noneNLS)) {
            return 4;
        }
        if (shape.equalsIgnoreCase(triangleEng) || shape.equalsIgnoreCase(triangleNLS)) {
            return 2;
        }
        if (shape.equalsIgnoreCase(squareEng) || shape.equalsIgnoreCase(squareNLS)) {
            return 0;
        }
        return DEFAULT_SHAPE_TYPE;
    }

    public static String shapeTypeToString(int shapeType) {
        String shapestr = null;
        switch (shapeType) {
            case 4: {
                shapestr = "None";
                break;
            }
            case 0: {
                shapestr = "Square";
                break;
            }
            case 1: {
                shapestr = "Circle";
                break;
            }
            default: {
                shapestr = DEFAULT_SHAPE_STRING;
                break;
            }
            case 2: {
                shapestr = "Triangle";
                break;
            }
            case 3: {
                shapestr = "Diamond";
                break;
            }
            case 5: {
                shapestr = "Image";
            }
        }
        return shapestr;
    }

    public void setNodeShape(String shape) {
        if (diamondNLS == null) {
            this.setShapeStrings();
        }
        if (shape.equalsIgnoreCase(diamondEng) || shape.equalsIgnoreCase(diamondNLS)) {
            this.model.setNodeShape(diamondEng);
        } else if (shape.equalsIgnoreCase(circleEng) || shape.equalsIgnoreCase(circleNLS)) {
            this.model.setNodeShape(circleEng);
        } else if (shape.equalsIgnoreCase(noneEng) || shape.equalsIgnoreCase(noneNLS)) {
            this.model.setNodeShape(noneEng);
            this.textBorderType = 3;
            this.setTextValign(1);
            this.setHalign(1);
            this.channel.setTextBorderType(this.textBorderType);
        } else if (shape.equalsIgnoreCase(triangleEng) || shape.equalsIgnoreCase(triangleNLS)) {
            this.model.setNodeShape(triangleEng);
        } else {
            this.model.setNodeShape(squareEng);
        }
    }

    public String getNodeShape() {
        return this.model.getNodeShape();
    }

    public NLDModel getModel() {
        return this.model;
    }

    @Override
    public void print(Graphics g) {
        this.build();
        this.paint(g);
    }

    public synchronized void buildSelected() {
        if (!(this.lastSelectedNodes != null && this.lastNumSelectedNodes > 0 || this.lastSelectedLinks != null && this.lastNumSelectedLinks > 0)) {
            return;
        }
        this.buildSelected(this.lastSelectedNodes, this.lastNumSelectedNodes, this.lastSelectedLinks, this.lastNumSelectedLinks);
    }

    public synchronized void buildSelected(int[] selectedNodes, int numSelectedNodes, int[] selectedLinks, int numSelectedLinks) {
        NLDLink a;
        if (this.ignoreBuild) {
            return;
        }
        if (this.model == null) {
            return;
        }
        if (!this.doubleBuffer) {
            this.build();
            return;
        }
        this.building = true;
        if (this.channel == null) {
            this.rebuildRequired = true;
            return;
        }
        this.channel.glNewList(this.selectionList);
        this.channel.glLoadName((Object)"");
        int visibleLinks = 0;
        if (this.model.isHideLinks()) {
            int arcMask = this.model.getLinksMask();
            for (int i = 0; i < this.model.links.size(); ++i) {
                a = (NLDLink)this.model.links.elementAt(i);
                if (a.from < 0 || a.to < 0) continue;
                NLDNode f = (NLDNode)this.model.nodes.elementAt(a.from);
                NLDNode t = (NLDNode)this.model.nodes.elementAt(a.to);
                if (f.hide || t.hide) continue;
                a.hide = true;
                if ((arcMask & 1) != 0 && !f.selected && t.selected) {
                    a.hide = false;
                }
                if ((arcMask & 2) != 0 && f.selected && !t.selected) {
                    a.hide = false;
                }
                if ((arcMask & 4) != 0 && f.selected && t.selected) {
                    a.hide = false;
                }
                if (a.hide) continue;
                ++visibleLinks;
                a.build(this.channel, this.model.nodes, this.getWidth(), this.getHeight(), this.zoomval, this.arrowsize);
                if (!a.showLabel) continue;
                a.buildLabel(this.channel);
            }
        } else {
            int nLinks = this.model.links.size();
            for (int i = 0; i < numSelectedLinks && selectedLinks != null; ++i) {
                if (selectedLinks[i] < 0 || selectedLinks[i] >= nLinks) continue;
                a = (NLDLink)this.model.links.elementAt(selectedLinks[i]);
                if (a.from == -1) {
                    a.from = a.getFromIndex();
                }
                if (a.to == -1) {
                    a.to = a.getToIndex();
                }
                if (a.hide || a.from == -1 || a.from >= this.numNodes || a.to == -1 || a.to >= this.numNodes || !this.model.nodes.isVisible(a.from) || !this.model.nodes.isVisible(a.to)) continue;
                ++visibleLinks;
                a.build(this.channel, this.model.nodes, this.getWidth(), this.getHeight(), this.zoomval, this.arrowsize);
                if (!a.showLabel) continue;
                a.buildLabel(this.channel);
            }
        }
        if (numSelectedNodes > 0) {
            this.setDeselectAll(false);
        }
        int nNodes = this.model.nodes.size();
        for (int i = 0; i < numSelectedNodes && selectedNodes != null; ++i) {
            if (selectedNodes[i] < 0 || selectedNodes[i] >= nNodes) continue;
            NLDNode n = (NLDNode)this.model.nodes.elementAt(selectedNodes[i]);
            if (!n.selected || !n.isVisible()) continue;
            n.build(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, this.getWidth(), this.getHeight(), this.zoomval);
            if (!n.showLabel) continue;
            n.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, this.getWidth(), this.getHeight(), this.zoomval);
        }
        this.channel.glLoadName((Object)"");
        this.channel.glEndList();
        this.lastSelectedNodes = selectedNodes;
        this.lastNumSelectedNodes = numSelectedNodes;
        this.lastSelectedLinks = selectedLinks;
        this.lastNumSelectedLinks = numSelectedLinks;
        this.selectedBuilt = true;
        this.building = false;
    }

    public void setSelectedList(int[] selectedNodes, int numSelectedNodes, int[] selectedLinks, int numSelectedLinks) {
        this.lastSelectedNodes = selectedNodes;
        this.lastNumSelectedNodes = numSelectedNodes;
        this.lastSelectedLinks = selectedLinks;
        this.lastNumSelectedLinks = numSelectedLinks;
    }

    public synchronized void build() {
        if (this.ignoreBuild) {
            return;
        }
        if (this.model == null) {
            return;
        }
        this.DEBUG("DWG.build");
        if (this.channel == null) {
            return;
        }
        if (this.emptyPlot) {
            return;
        }
        this.building = true;
        this.channel.glNewList(this.linklist);
        this.channel.glLoadName((Object)"");
        this.buildLinks();
        this.channel.glLoadName((Object)"");
        this.channel.glEndList();
        this.channel.glNewList(this.nodelist);
        this.channel.glLoadName((Object)"");
        this.buildNodes();
        this.channel.glLoadName((Object)"");
        this.channel.glEndList();
        this.channel.glNewList(this.displist);
        this.channel.glCallList(this.linklist);
        this.channel.glCallList(this.nodelist);
        this.channel.glEndList();
        this.rebuilt = true;
        this.rebuildRequired = false;
        this.building = false;
    }

    protected synchronized void buildLinks() {
        if (this.numLinks > 0 && !this.model.isHideLinks()) {
            int visibleLinks = 0;
            for (int i = 0; i < this.numLinks; ++i) {
                NLDLink a = (NLDLink)this.model.links.elementAt(i);
                if (!this.buildLink(a)) continue;
                ++visibleLinks;
            }
            if (this.getGraphics() instanceof Graphics2D) {
                if (visibleLinks < 100) {
                    this.channel.glEnable(9);
                    ((Graphics2D)this.getGraphics()).addRenderingHints(ANTIALIAS_ON);
                } else {
                    this.channel.glDisable(9);
                    ((Graphics2D)this.getGraphics()).addRenderingHints(ANTIALIAS_OFF);
                }
            }
        }
    }

    protected synchronized boolean buildLink(NLDLink a) {
        boolean rc = false;
        if (a.from == -1) {
            a.from = a.getFromIndex();
        }
        if (a.to == -1) {
            a.to = a.getToIndex();
        }
        if (a.hide || a.from == -1 || a.from >= this.numNodes || a.to == -1 || a.to >= this.numNodes) {
            return rc;
        }
        boolean sel = a.selected;
        if (this.buildAsNonSelected) {
            a.selected = false;
        }
        if (this.model.nodes.isVisible(a.from) && this.model.nodes.isVisible(a.to)) {
            a.build(this.channel, this.model.nodes, this.getWidth(), this.getHeight(), this.zoomval, this.arrowsize);
            if (a.showLabel) {
                a.buildLabel(this.channel);
            }
            rc = true;
        }
        a.selected = sel;
        return rc;
    }

    protected synchronized void buildNodes() {
        double w = this.getWidth();
        double h = this.getHeight();
        double maxNodeSize = 0.0;
        if (this.numNodes > 0) {
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                boolean sel = n.selected;
                if (this.buildAsNonSelected) {
                    n.selected = false;
                }
                if (n.hide) continue;
                n.build(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, w, h, this.zoomval);
                if (n.showLabel) {
                    n.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, w, h, this.zoomval);
                }
                maxNodeSize = Math.max((double)this.getWidth(this.channel.getBackbufferGC(), this.channel.glGetFont(), n.getLabel()), maxNodeSize);
                n.selected = sel;
            }
            if (this.getCutoffFactor() == 1.0) {
                this.channel.setMaxNodeTextSize(Math.ceil(maxNodeSize));
            }
        }
    }

    private int getWidth(Graphics gc, Font font, String string) {
        int w = 0;
        if (gc == null) {
            return w;
        }
        gc.setFont(font);
        FontMetrics fm = gc.getFontMetrics();
        if (fm == null) {
            return w;
        }
        Vector list = this.makeMultiLine(string);
        if (list == null) {
            return 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            w = Math.max(w, fm.stringWidth((String)list.elementAt(i)));
        }
        return w;
    }

    public Color colmap(double val) {
        double blue;
        double green;
        double red;
        if (this.clrRamp != null) {
            try {
                if (this.clrMethod == null) {
                    Class<?> aramp = this.clrRamp.getClass();
                    Class[] types = new Class[3];
                    int[] rgb = new int[]{0, 0, 0};
                    types[0] = Double.TYPE;
                    types[1] = Boolean.TYPE;
                    types[2] = rgb.getClass();
                    this.clrMethod = aramp.getMethod("queryDouble", types);
                }
                Object[] args = new Object[]{new Double(val), new Boolean(false), null};
                Color clr = (Color)this.clrMethod.invoke(this.clrRamp, args);
                if (clr != null) {
                    return clr;
                }
            }
            catch (Exception e) {
                this.clrRamp = null;
            }
        }
        int r1 = this.rampColors[0].getRed();
        int g1 = this.rampColors[0].getGreen();
        int b1 = this.rampColors[0].getBlue();
        int r2 = this.rampColors[1].getRed();
        int g2 = this.rampColors[1].getGreen();
        int b2 = this.rampColors[1].getBlue();
        int r3 = this.rampColors[2].getRed();
        int g3 = this.rampColors[2].getGreen();
        int b3 = this.rampColors[2].getBlue();
        if (val >= 0.5) {
            red = (double)r1 + (double)(r2 - r1) * (1.0 - val) * 2.0;
            green = (double)g1 + (double)(g2 - g1) * (1.0 - val) * 2.0;
            blue = (double)b1 + (double)(b2 - b1) * (1.0 - val) * 2.0;
        } else {
            red = (double)r2 + (double)(r3 - r2) * (0.5 - val) * 2.0;
            green = (double)g2 + (double)(g3 - g2) * (0.5 - val) * 2.0;
            blue = (double)b2 + (double)(b3 - b2) * (0.5 - val) * 2.0;
        }
        int ir = (int)red;
        int ig = (int)green;
        int ib = (int)blue;
        return new Color(ir, ig, ib);
    }

    public void setDefaultZoom(double val) {
        this.zoomval = this.defaultzoom = val;
        if (this.channel != null) {
            this.proj();
        }
    }

    protected void displayNodeLoc(NLDNode node) {
        node.displayPos(this.channel);
    }

    protected void setDeselectAll(boolean flag) {
        this.deselAll = flag;
    }

    protected boolean isDeselectAll() {
        return this.deselAll;
    }

    protected boolean SetImage(Image img, int style, int x, int y, Rectangle rect) {
        if (img != null) {
            this.backImage = img;
            this.imagePositionX = x;
            this.imagePositionY = y;
            this.imageRect = rect;
        } else {
            this.backImage = null;
            this.imagePositionX = 0;
            this.imagePositionY = 0;
            this.imageRect = null;
        }
        this.imageDraw = style;
        if (this.channel != null) {
            if (img == null) {
                this.channel.removeBackgroundImage();
            } else {
                this.channel.setBackgroundImage(img, style);
                this.channel.setBackgroundImagePosition(x, y);
            }
            if (!this.building && this.model != null) {
                this.repaint();
            }
        }
        return true;
    }

    protected boolean isNodeMoved() {
        return this.nodeMoved;
    }

    protected void setNodeMoved(boolean flag) {
        this.nodeMoved = flag;
    }

    protected void selectAll() {
        this.model.selectAll();
        this.deselAll = false;
        if (this.isInApplet()) {
            int[] selectedNodes = new int[this.model.nodes.size()];
            for (int i = 0; i < selectedNodes.length; ++i) {
                selectedNodes[i] = i;
            }
            this.buildSelected(selectedNodes, selectedNodes.length, null, 0);
        }
        this.build();
        this.repaint();
    }

    protected boolean isSelectAll() {
        return this.model.nodes.isSelectAll();
    }

    protected void filter() {
        Container c = this;
        while (!(c instanceof Frame)) {
            c = c.getParent();
        }
        Frame pframe = (Frame)c;
        if (this.dlg == null) {
            this.dlg = new NLDFilterDlg(pframe, this, false, this.centerSelected);
            this.dlg.model = this.model;
            this.dlg.setResizable(true);
        }
        this.dlg.show();
    }

    public Object pick(int x, int y) {
        return this.pick(x, y, this.displist);
    }

    public Object pick(int x, int y, long list) {
        Object o = null;
        this.handleSelected = false;
        this.channel.glRenderMode(1);
        this.channel.gluPickMatrix(x, y, 3, 3);
        Stack hit = new Stack();
        this.channel.glSelectBuffer(hit);
        this.channel.glCallList(list);
        this.channel.glRenderMode(0);
        if (!hit.empty()) {
            String name = (String)hit.pop();
            if (name.equals("")) {
                return null;
            }
            int index = new Integer(name.substring(1));
            if (index >= 0) {
                if (name.charAt(0) == 'N') {
                    if (index >= 0 && index < this.model.nodes.size()) {
                        o = this.model.nodes.elementAt(index);
                    }
                } else if (name.charAt(0) == 'A') {
                    if (index >= 0 && index < this.model.links.size()) {
                        o = this.model.links.elementAt(index);
                    }
                } else if (name.charAt(0) == 'H') {
                    if (index >= 0 && index < this.model.nodes.size()) {
                        o = this.model.nodes.elementAt(index);
                    }
                    this.handleSelected = true;
                }
            }
        }
        return o;
    }

    public Vector pickAllNodes(int x, int y) {
        Object o = null;
        this.handleSelected = false;
        this.channel.setPickAllHits(true);
        this.channel.glRenderMode(1);
        this.channel.gluPickMatrix(x, y, 3, 3);
        Stack hit = new Stack();
        this.channel.glSelectBuffer(hit);
        this.channel.glCallList(this.nodelist);
        this.channel.glRenderMode(0);
        this.channel.setPickAllHits(false);
        Vector<Object> pickedNodes = new Vector<Object>();
        while (!hit.empty()) {
            String name = (String)hit.pop();
            if (name.equals("")) continue;
            int index = new Integer(name.substring(1));
            if (name.charAt(0) != 'N') continue;
            o = this.model.nodes.elementAt(index);
            pickedNodes.addElement(o);
        }
        return pickedNodes;
    }

    public Object pickID(int x, int y) {
        Object obj = this.pick(x, y);
        if (obj instanceof NLDNode) {
            return ((NLDNode)obj).id;
        }
        return null;
    }

    @Override
    public synchronized void repaint() {
        if (this.inApplet) {
            Graphics g = this.getGraphics();
            if (g == null) {
                return;
            }
            this.DEBUG("DWG.repaint g=" + g);
            this.paint(g);
            g.dispose();
        } else {
            super.repaint();
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this.emptyPlot) {
            int x = this.compWidth / 2 - 20;
            int y = this.compHeight / 2 - 5;
            g.drawString(this.GRS("StatusText.NoChartData.txt", "No Chart Data"), x, y);
            return;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.DEBUG("DWG.paint g=" + g);
        if (this.channel == null || this.building) {
            return;
        }
        this.resize();
        if (!this.readyCalled) {
            this.checkImageSettings(this.backImage, this.imageDraw, this.imagePositionX, this.imagePositionY);
            if (this.imageWidth != 0 && this.imageHeight != 0) {
                this.readyCalled = true;
            }
        }
        this.checkImages();
        if (this.rebuildRequired) {
            this.build();
        }
        if (this.rebuilt) {
            this.channel.clearBGC();
            this.channel.glCallList(this.displist);
            this.rebuilt = false;
        }
        if (this.backborder) {
            this.channel.getBackbufferGC().setColor(g.getColor());
            this.channel.getBackbufferGC().draw3DRect(0, 0, this.compWidth - 1, this.compHeight - 1, true);
        }
        if ((this.probeNode != null || this.probeLink != null) && this.tooltipPaint) {
            Graphics gc;
            if (this.doubleBuffer) {
                if (this.selectedBuilt) {
                    this.channel.setBackbuffer(1);
                    this.channel.copyBuffer(0);
                    this.channel.glCallList(this.selectionList);
                }
                this.channel.setBackbuffer(2);
                if (this.selectedBuilt) {
                    this.channel.copyBuffer(1);
                } else {
                    this.channel.copyBuffer(0);
                }
                gc = this.channel.getBackbufferGC();
            } else {
                if (this.selectedBuilt) {
                    this.channel.setBackbuffer(1);
                    this.channel.copyBuffer(0);
                    this.channel.glCallList(this.selectionList);
                    this.channel.glRefresh(g);
                    this.channel.setBackbuffer(0);
                } else {
                    this.channel.glRefresh(g);
                }
                gc = g;
            }
            if (this.brushActive) {
                this.drawBrush(gc, this.prevx, this.prevy, this.diffx, this.diffy);
            }
            this.drawTooltip(gc);
            if (this.backborder) {
                gc.setColor(g.getColor());
                gc.draw3DRect(0, 0, this.compWidth - 1, this.compHeight - 1, true);
            }
            if (this.doubleBuffer) {
                this.channel.glRefresh(g);
                this.channel.setBackbuffer(0);
            }
            this.probeNode = null;
            this.probeLink = null;
            this.tooltipPaint = false;
        } else {
            if (this.selectedBuilt) {
                this.channel.setBackbuffer(1);
                this.channel.copyBuffer(0);
                this.channel.glCallList(this.selectionList);
                this.channel.glRefresh(g);
                this.channel.setBackbuffer(0);
            } else {
                this.channel.glRefresh(g);
            }
            if (this.brushActive && this.drawBrush || this.viewportActive) {
                this.drawBrush(g, this.prevx, this.prevy, this.diffx, this.diffy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawTooltip(Graphics g) {
        int ytip;
        int xtip;
        int yo;
        int xo;
        ChannelLite channelLite;
        Font tipFont = null;
        if (this.probeNode != null) {
            channelLite = this.channel;
            synchronized (channelLite) {
                this.channel.glNewList(this.tiplist);
                this.probeNode.build(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, this.getWidth(), this.getHeight(), this.zoomval);
                if (this.showLabels) {
                    this.probeNode.buildLabel(this.channel, this.handleType, this.iconType, this.texthalign, this.textvalign, this.getWidth(), this.getHeight(), this.zoomval);
                }
                this.channel.glEndList();
            }
            this.channel.glCallList(this.tiplist);
            tipFont = this.probeNode.font;
        } else if (this.probeLink != null) {
            channelLite = this.channel;
            synchronized (channelLite) {
                this.channel.glNewList(this.tiplist);
                this.channel.glEndList();
            }
            this.channel.glCallList(this.tiplist);
            tipFont = this.probeLink.font;
        }
        Font saveFont = null;
        if (tipFont != null) {
            saveFont = g.getFont();
            g.setFont(tipFont);
        } else {
            saveFont = g.getFont();
            g.setFont(this.font);
        }
        if (this.probeInfo == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int theight = fm.getHeight();
        int size = theight * this.probeInfo.size();
        int wid = 0;
        for (int j = 0; j < this.probeInfo.size(); ++j) {
            wid = Math.max(wid, fm.stringWidth((String)this.probeInfo.elementAt(j)));
        }
        wid = Math.min(wid, (int)((double)this.compWidth * 0.8));
        if (this.tracking || this.probeNode == null) {
            xo = this.probePtX;
            yo = this.probePtY;
            xtip = this.probePtX - wid / 2 - 3;
            ytip = this.probePtY - size - theight - 6;
        } else {
            double[] world = new double[]{this.probeNode.xpos, this.probeNode.ypos, 1.0};
            double[] win = new double[3];
            this.channel.gluProject(world, win);
            xo = (int)win[0];
            yo = (int)win[1];
            xtip = xo - wid / 2 - 3;
            ytip = yo - size - theight - 6;
        }
        if (xtip + wid + 4 > this.dimension.width) {
            xtip = Math.max(0, this.dimension.width - wid - 6);
        } else if (xtip < 0) {
            xtip = 0;
        }
        if (ytip > 0) {
            g.setColor(Color.black);
            g.drawLine(xo, yo, xo, yo - theight);
            g.setColor(Color.white);
            g.drawLine(xo + 1, yo, xo + 1, yo - theight);
        } else {
            ytip = Math.min(yo + theight, this.dimension.height - theight - 6);
            g.setColor(Color.black);
            g.drawLine(xo, yo, xo, ytip);
            g.setColor(Color.white);
            g.drawLine(xo + 1, yo, xo + 1, ytip);
        }
        g.setColor(new Color(250, 245, 225));
        g.fillRect(xtip, ytip, wid + 6, size + 6);
        g.setColor(Color.white);
        g.drawRect(xtip + 1, ytip + 1, wid + 5, size + 5);
        g.setColor(Color.black);
        g.drawRect(xtip, ytip, wid + 5, size + 5);
        for (int j = 0; j < this.probeInfo.size(); ++j) {
            String strInfo = (String)this.probeInfo.elementAt(j);
            int strWidth = fm.stringWidth(strInfo);
            if (strWidth > wid && strWidth != 0) {
                int nChar = strInfo.length() * wid / strWidth;
                if (nChar > 4) {
                    String strToDraw = strInfo.substring(0, nChar - 1 - 3);
                    strInfo = strToDraw.concat("...");
                } else if (nChar != 0) {
                    strInfo = new String(".");
                }
            }
            g.drawString(strInfo, xtip + 3, ytip + fm.getAscent() + 2);
            ytip += theight;
        }
        if (tipFont != null) {
            g.setFont(saveFont);
        }
    }

    protected void projectAndBuild(boolean build) {
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.proj();
        if (build) {
            this.build();
            this.buildSelected();
        }
        this.repaint();
    }

    protected void rebuild(boolean build) {
        this.zoomval = this.userLayout ? 1.0 : this.defaultzoom;
        this.projectAndBuild(build);
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        int prefwidth;
        super.setBounds(x, y, w, h);
        if (this.compWidth != w || this.compHeight != h) {
            this.rebuildRequired = true;
        }
        this.compWidth = w;
        this.compHeight = h;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.channel == null) {
            this.createChannel();
        }
        if (w != (prefwidth = this.getPreferredWidth())) {
            this.centerx = Math.max(w / 2, Math.min(w / 2 + x, prefwidth - w / 2));
        }
        this.resize();
        this.buildSelected();
    }

    public int getComponentWidth() {
        return this.compWidth;
    }

    public int getComponentHeight() {
        return this.compHeight;
    }

    public void setComponentSize(int w, int ht) {
        this.compWidth = w;
        this.compHeight = ht;
        this.resize();
    }

    public void setVerticalLens(double[] locs, double[] range, double[] values, double[] cutoffs) {
        this.verticalLens = true;
        this.lensLocs = locs;
        this.lensRange = range;
        this.lensValues = values;
        this.textCutoffs = cutoffs;
        this.setVerticalLens();
    }

    public void setVerticalLens() {
        int len = this.lensLocs.length;
        this.lensScreenLocs = new double[len];
        this.lensScreenRange = new double[len];
        double[] w = new double[]{0.0, 0.0};
        double[] s = new double[]{0.0, 0.0};
        this.channel.glDisable(2);
        for (int i = 0; i < len; ++i) {
            w[0] = this.lensLocs[i];
            w[1] = this.lensRange[i];
            this.channel.gluProject(w, s);
            this.lensScreenLocs[i] = s[0];
            this.lensScreenRange[i] = s[1];
        }
        this.channel.glEnable(2);
        this.channel.setVerticalLensLocations(this.lensScreenLocs, this.lensScreenRange, this.lensValues, this.textCutoffs);
    }

    protected synchronized void resize() {
        this.DEBUG("DWG.resize : first=" + this.first);
        if (this.channel == null || this.model == null) {
            return;
        }
        int prefwidth = this.getPreferredWidth();
        int prefheight = this.getPreferredHeight();
        if (prefwidth == this.dimension.width && prefheight == this.dimension.height) {
            return;
        }
        this.dimension = new Dimension(this.compWidth, this.compHeight);
        if (this.backborder) {
            this.channel.glViewport(2, 2, prefwidth - 4, prefheight - 4);
        } else {
            this.channel.glViewport(0, 0, prefwidth, prefheight);
        }
        if (this.doubleBuffer) {
            this.channel.setBackbuffer(1);
            this.channel.clearBGC();
            this.channel.setBackbuffer(0);
        }
        this.reProjection();
    }

    protected void reProjection() {
        this.proj();
    }

    public void setFont(String name, int style, int size) {
        if (name == null) {
            name = this.font.getName();
        }
        if (style == -1) {
            style = this.font.getStyle();
        }
        if (size < 1) {
            size = this.font.getSize();
        }
        this.font = new Font(name, style, size);
        this.setFont(this.font);
        super.setFont(this.font);
    }

    public void unprojectNodes() {
        int height;
        double minDimCurr;
        NLDNode n;
        VectorNodeModel nodes = this.model.nodes;
        int size = nodes.size();
        double[] w = new double[2];
        double[] s = new double[2];
        for (int i = 0; i < size; ++i) {
            n = (NLDNode)nodes.elementAt(i);
            s[0] = n.orgXpos;
            s[1] = n.orgYpos;
            this.channel.gluUnProject(s, w);
            nodes.setCurLoc(i, w[0] * this.zoomval, w[1] * this.zoomval);
        }
        int width = this.getPreferredWidth();
        double d = minDimCurr = width < (height = this.getPreferredHeight()) ? (double)width : (double)height;
        if ((double)width != 0.0 && (double)height != 0.0 && this.minDim == 0.0) {
            this.minDim = width < height ? (double)width : (double)height;
        }
        if (minDimCurr == 0.0 || this.minDim == 0.0) {
            return;
        }
        double r = minDimCurr / this.minDim;
        double maxXPos = Double.NEGATIVE_INFINITY;
        double maxYPos = Double.NEGATIVE_INFINITY;
        double minXPos = Double.POSITIVE_INFINITY;
        double minYPos = Double.POSITIVE_INFINITY;
        for (int i = 0; i < size; ++i) {
            n = (NLDNode)nodes.elementAt(i);
            n.xpos *= r;
            n.ypos *= r;
            maxXPos = maxXPos < n.xpos ? n.xpos : maxXPos;
            maxYPos = maxYPos < n.ypos ? n.ypos : maxYPos;
            minXPos = minXPos > n.xpos ? n.xpos : minXPos;
            minYPos = minYPos > n.ypos ? n.ypos : minYPos;
        }
        double cX = (maxXPos + minXPos) / 2.0;
        double cY = (maxYPos + minYPos) / 2.0;
        for (int i = 0; i < size; ++i) {
            n = (NLDNode)nodes.elementAt(i);
            n.xpos -= cX;
            n.ypos -= cY;
        }
    }

    @Override
    public Point getOrigin() {
        return new Point((int)(this.centerx - (double)(this.compWidth / 2)), (int)(this.centery + (double)(this.compHeight / 2)));
    }

    @Override
    public void setOrigin(Point org, boolean scaleX, boolean scaleY) {
        this.centerx = org.x + this.compWidth / 2;
        this.centery = org.y - this.compHeight / 2;
        if (this.channel != null) {
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        }
        this.rebuildRequired = true;
        if (this.ready) {
            this.repaint();
        }
    }

    protected Rectangle currExtent() {
        return new Rectangle((int)(this.centerx - (double)(this.compWidth / 2)), (int)(this.centery - (double)(this.compHeight / 2)), this.compWidth, this.compHeight);
    }

    protected double getTextHeight(String str, Font font) {
        return this.channel.glGetTextHeight(str, font);
    }

    protected double getTextHeight(Font font) {
        return this.channel.glGetTextHeight(font);
    }

    protected double getTextSize(Font font) {
        return this.channel.glGetTextSize(font);
    }

    protected double getTextWidth(String str, Font font) {
        return this.channel.glGetTextWidth(str, font);
    }

    protected double[] getHandlePosition(NLDNode n) {
        return n.getHandlePosition(this.channel, this.iconType);
    }

    protected double[] getNodeSize(NLDNode n) {
        return n.getSize(this.channel, this.handleType, this.iconType);
    }

    protected double[] getNodeLocation(NLDNode n) {
        return n.getLocation(this.channel, this.handleType, this.iconType);
    }

    public void setSelected(Object id, boolean state) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n != null) {
            this.model.nodes.setSelected(n.index, state);
        }
    }

    protected void setSelected(NLDNode n, boolean state) {
        this.model.nodes.setSelected(n.index, state);
    }

    protected boolean isSelected(NLDNode n) {
        return n.selected;
    }

    public boolean isSelected(Object id) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        if (n != null) {
            return n.selected;
        }
        return false;
    }

    protected NLDNode getNode(Object id) {
        NLDNode n = null;
        n = id instanceof NLDNode ? (NLDNode)id : this.model.nodes.getNode(id);
        return n;
    }

    protected Color getNodeBorderColor(NLDNode node) {
        return node.borderColor;
    }

    protected void setNodeBorderColor(NLDNode node, Color c) {
        node.borderColor = c;
    }

    protected String[] getCustomActionString(NLDNode n) {
        String url = null;
        String[] str = null;
        String[] externalAction = new String[1];
        ArrayList<String> newURL = new ArrayList<String>();
        if (n.urlStr != null && !n.urlStr.equals("")) {
            if (n.action != null) {
                url = n.action;
                str = url.split(";");
            } else if (this.model.userAction && n.urlStr.split(";").length <= 1) {
                externalAction[0] = url = this.model.action;
                str = externalAction;
            } else {
                url = n.urlStr;
                str = url.split(";");
                for (int count = 0; count < str.length; ++count) {
                    if (str[count].length() > this.urlDispLim) {
                        newURL.add(this.GRS("Viewer.OpenURL.txt", "Open URL (") + str[count].substring(0, this.urlDispLim - 1) + this.GRS("Viewer.dots.txt", "...") + this.GRS("Viewer.close.txt", ")"));
                        continue;
                    }
                    newURL.add(this.GRS("Viewer.OpenURL.txt", "Open URL (") + str[count] + this.GRS("Viewer.close.txt", ")"));
                }
                if (newURL.size() > 0) {
                    str = newURL.toArray(new String[newURL.size()]);
                }
            }
        }
        return str;
    }

    protected String getUrlString(NLDNode n) {
        String url = null;
        if (n.urlStr != null && !n.urlStr.equals("")) {
            url = n.action != null ? n.action : (this.model.userAction ? this.model.action : (n.urlStr.length() > this.urlDispLim ? this.GRS("Viewer.OpenURL.txt", "Open URL (") + n.urlStr.substring(0, this.urlDispLim - 1) + this.GRS("Viewer.dots.txt", "...") + this.GRS("Viewer.close.txt", ")") : this.GRS("Viewer.OpenURL.txt", "Open URL (") + n.urlStr + this.GRS("Viewer.close.txt", ")")));
        }
        return url;
    }

    protected int getType(NLDNode n) {
        return n.type;
    }

    protected String getAction(NLDNode n) {
        if (n.action != null) {
            return n.action;
        }
        return this.model.action;
    }

    protected void setPixelSize(double val) {
        NLDNode.sizefac = val;
    }

    protected void setDefaultArrowSize(double val) {
        this.arrowsize = val;
    }

    protected void setTextValign(int align) {
        this.textvalign = align;
    }

    protected void setTextHalign(int align) {
        this.texthalign = align;
    }

    protected void setHalign(int align) {
        if (this.model.nodes != null) {
            for (int i = 0; i < this.model.nodes.size(); ++i) {
                NLDNode n = (NLDNode)this.model.nodes.get(i);
                n.setHalign(align);
            }
        }
    }

    protected void showAllLinks() {
        VectorLinkModel links = this.model.links;
        VectorNodeModel nodes = this.model.nodes;
        for (int i = 0; i < this.numLinks; ++i) {
            NLDLink a = (NLDLink)links.elementAt(i);
            if (a.from == -1) {
                a.from = a.getFromIndex();
            }
            if (a.to == -1) {
                a.to = a.getToIndex();
            }
            if (a.to == -1 || a.from == -1) continue;
            int from = a.from;
            int to = a.to;
            boolean visible = nodes.isVisible(to) && nodes.isVisible(from);
            links.setVisible(i, visible);
        }
    }

    protected void openURL(Object context) {
        if (context == null || !(context instanceof NLDNode)) {
            return;
        }
        NLDNode n = (NLDNode)context;
        if (n.urlStr == null) {
            return;
        }
        if (n.urlStr.startsWith("javascript:")) {
            try {
                if (this.js == null) {
                    String name = this.applet.getParameter("NAME");
                    Applet ap = null;
                    if (name != null) {
                        ap = this.applet.getAppletContext().getApplet(name);
                    } else {
                        Enumeration<Applet> e = this.applet.getAppletContext().getApplets();
                        if (e.hasMoreElements()) {
                            ap = e.nextElement();
                        }
                    }
                    if (ap != null) {
                        this.js = JSObject.getWindow((Applet)ap);
                    }
                }
                if (this.js != null) {
                    String method = n.urlStr.substring(11, n.urlStr.length());
                    this.js.eval(method);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.js = null;
            }
        } else if (n.urlStr != null && !n.urlStr.equals("")) {
            try {
                URL url = null;
                url = new URL(this.document, n.urlStr);
                if (this.applet != null) {
                    this.applet.getAppletContext().showDocument(url, this.urlTarget);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    protected void openActionURL(Object context, String str) {
        String methodURL = null;
        if (context == null || !(context instanceof NLDNode)) {
            return;
        }
        NLDNode n = (NLDNode)context;
        if (n.urlStr == null) {
            return;
        }
        String[] urlstr = n.urlStr.split(";");
        methodURL = urlstr[Integer.parseInt(str)];
        if (methodURL.startsWith("javascript:")) {
            try {
                if (this.js == null) {
                    String name = this.applet.getParameter("NAME");
                    Applet ap = null;
                    if (name != null) {
                        ap = this.applet.getAppletContext().getApplet(name);
                    } else {
                        Enumeration<Applet> e = this.applet.getAppletContext().getApplets();
                        if (e.hasMoreElements()) {
                            ap = e.nextElement();
                        }
                    }
                    if (ap != null) {
                        this.js = JSObject.getWindow((Applet)ap);
                    }
                }
                if (this.js != null) {
                    String method = methodURL.substring(11, n.urlStr.length());
                    this.js.eval(method);
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                this.js = null;
            }
        } else if (n.urlStr != null && !n.urlStr.equals("")) {
            try {
                URL url = null;
                url = new URL(this.document, methodURL);
                if (this.applet != null) {
                    this.applet.getAppletContext().showDocument(url, this.urlTarget);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    protected void loadNodeImages(URL docBase) {
        this.loadNodeImages(0, docBase);
    }

    protected void loadNodeImages(int start, URL docBase) {
        if (this.font == null) {
            return;
        }
        if (this.mt == null) {
            this.mt = new MediaTracker(this);
        }
        Image im = null;
        Image sim = null;
        for (int i = start; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            Vector list = (Vector)this.icons.get(new Integer(i));
            if (list == null) {
                sim = n.iconstr != null ? (n.iconstr.startsWith("http:") || n.iconstr.startsWith("HTTP:") || n.iconstr.startsWith("file:") || n.iconstr.startsWith("FILE:") ? this.GetImageFromURL(n.iconstr, null) : this.GetImageFromURL(n.iconstr, docBase)) : n.getIcon();
                if (sim != null) {
                    this.addIconToList(i, sim);
                    n.setIcon(sim);
                }
            } else {
                n.icon = (Image)list.elementAt(0);
            }
            im = null;
            list = (Vector)this.images.get(new Integer(i));
            if (list != null) continue;
            im = n.imgstr != null ? (n.imgstr.startsWith("http:") || n.imgstr.startsWith("HTTP:") || n.imgstr.startsWith("file:") || n.imgstr.startsWith("FILE:") ? this.GetImageFromURL(n.imgstr, null) : this.GetImageFromURL(n.imgstr, docBase)) : n.getImage();
            if (im == null) continue;
            list = new Vector();
            list.addElement(im);
            this.images.put(new Integer(i), list);
            list.addElement(new Integer(++imid));
            this.mt.addImage(im, imid);
            n.setImage(im);
            n.type = 5;
            im = null;
        }
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sim != null) {
            this.iconWidth = this.channel.glGetImageWidth(sim);
            this.iconHeight = this.channel.glGetImageHeight(sim);
        }
    }

    protected void addIconToList(int i, Image icon) {
        if (icon != null && i >= 0) {
            Vector<Object> list = new Vector<Object>();
            list.addElement(icon);
            this.icons.put(new Integer(i), list);
            this.mt.addImage(icon, i);
            list.addElement(new Integer(i));
        }
    }

    protected void setNodeImageSizes() {
        this.setNodeImageSizes(0);
    }

    protected void setNodeImageSizes(int start) {
        Image im = null;
        for (int i = start; i < this.numNodes; ++i) {
            int iheight;
            int iwidth;
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.getImage() == null) continue;
            im = null;
            double[] nsize = n.getSize(this.channel, this.handleType, this.iconType);
            Vector list = (Vector)this.images.get(new Integer(i));
            n.type = 5;
            if (list == null) continue;
            nsize[0] = nsize[0] / this.zoomval;
            nsize[1] = nsize[1] / this.zoomval;
            boolean found = false;
            int size = list.size();
            for (int j = size - 2; j >= 0; j -= 2) {
                im = (Image)list.elementAt(j);
                iwidth = im.getWidth(this);
                if (iwidth == -1) {
                    imid = (Integer)list.elementAt(j + 1);
                    try {
                        this.mt.waitForID(imid);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    iwidth = im.getWidth(null);
                }
                iheight = im.getHeight(this);
                if (iwidth != (int)nsize[0] || iheight != (int)nsize[1]) continue;
                found = true;
                n.imID = j;
                n.imList = list;
                break;
            }
            if (found) continue;
            iwidth = im.getWidth(this);
            iheight = im.getHeight(this);
            Image sim = im.getScaledInstance((int)nsize[0], (int)nsize[1], 1);
            this.mt.addImage(sim, ++imid);
            list.insertElementAt(sim, size);
            list.insertElementAt(new Integer(imid), size + 1);
            n.imID = size;
            n.imList = list;
        }
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setNodeIconImageSizes() {
        this.setNodeIconImageSizes(0);
    }

    protected void setNodeIconImageSizes(int start) {
        Image im = null;
        int numNodes = this.model.nodes.size();
        int fsize = (int)((double)(this.font.getSize() + 4) / this.zoomval);
        for (int i = start; i < numNodes; ++i) {
            int cursize;
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.getIcon() == null) continue;
            Vector list = (Vector)this.icons.get(new Integer(i));
            int iwidth = 0;
            int n2 = cursize = n.font == null ? fsize + 4 : (int)((double)(n.font.getSize() + 4) / this.zoomval);
            if (list != null) {
                Image sim;
                int size = list.size();
                boolean found = false;
                if (n.getType() == 8) {
                    found = true;
                }
                for (int j = size - 2; j >= 0; j -= 2) {
                    im = (Image)list.elementAt(j);
                    iwidth = im.getWidth(null);
                    if (iwidth == -1) {
                        int id1 = (Integer)list.elementAt(j + 1);
                        try {
                            this.mt.waitForID(id1);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        iwidth = im.getWidth(null);
                    }
                    if (iwidth != cursize) continue;
                    sim = im;
                    found = true;
                    n.icon = sim;
                    break;
                }
                if (found) continue;
                iwidth = im.getWidth(this);
                int iheight = im.getHeight(this);
                sim = im.getScaledInstance(cursize, cursize * iheight / iwidth, 1);
                this.mt.addImage(sim, ++imid);
                list.insertElementAt(sim, size);
                list.insertElementAt(new Integer(imid), size + 1);
                n.icon = sim;
                continue;
            }
            n.iconstr = null;
            n.icon = null;
            n.iconList = null;
        }
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void setNodeImages() {
        this.setNodeImages(0);
    }

    protected void setNodeImages(int start) {
        MediaTracker mt = new MediaTracker(this);
        Image sim = null;
        Image im = null;
        int iwidth = 0;
        int iheight = 0;
        for (int i = start; i < this.numNodes; ++i) {
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.getImage() == null) continue;
            double[] nsize = n.getSize(this.channel, this.handleType, this.iconType);
            nsize[0] = nsize[0] / this.zoomval;
            nsize[1] = nsize[1] / this.zoomval;
            Vector list = (Vector)this.images.get(new Integer(i));
            if (list == null) continue;
            boolean found = false;
            for (int j = list.size() - 2; j >= 0; j -= 2) {
                im = (Image)list.elementAt(j);
                if (im == null) continue;
                iwidth = im.getWidth(null);
                if (iwidth == -1) {
                    try {
                        mt.waitForID((Integer)list.elementAt(j + 1));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    iwidth = im.getWidth(null);
                }
                iheight = im.getHeight(null);
                if (iwidth != (int)nsize[0] || iheight != (int)nsize[1]) continue;
                found = true;
                if (j == n.imID) break;
                list.setElementAt(sim, n.imID);
                list.setElementAt(list.elementAt(j + 1), n.imID + 1);
                break;
            }
            if (!found) {
                iwidth = im.getWidth(null);
                iheight = im.getHeight(null);
                sim = im.getScaledInstance((int)nsize[0], (int)nsize[1], 1);
                mt.addImage(sim, ++imid);
                list.setElementAt(sim, n.imID);
                list.setElementAt(new Integer(imid), n.imID + 1);
            }
            n.setImage(sim);
        }
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void mouseMoved(MouseEvent e) {
        String name;
        if (!this.ready || !this.infoFlag) {
            return;
        }
        if (this.emptyPlot) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.handleID = -1;
        if (this.brushActive && this.actionMode == 1) {
            this.handleID = this.onHandle(x, y);
            if (this.handleID > 0) {
                this.setCursor(Cursor.getPredefinedCursor(this.handleID));
            } else if (this.isInside(x, y)) {
                if (this.moveOpenCursor != null) {
                    this.setCursor(this.moveOpenCursor);
                } else {
                    System.out.println("Custom cursor not found. Using predefined cursor.");
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        } else {
            this.setCursor(this.actionMode);
        }
        this.channel.setPickFullLine(true);
        Stack hit = this.PickObjects(x - 1, y - 1, 3, 3, false);
        this.channel.setPickFullLine(false);
        String string = name = hit.empty() ? null : (String)hit.pop();
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = x;
        this.tipLocation.y = y;
        if (name != null && !name.equals("")) {
            this.tipText = null;
            this.tooltipTimer.restart();
        } else if (name == null || name.equals("")) {
            if (this.model.isHideLinks()) {
                this.channel.setPickFullLine(true);
                hit = this.PickObjects(x - 1, y - 1, 3, 3, false, this.selectionList);
                this.channel.setPickFullLine(false);
                String string2 = name = hit.empty() ? null : (String)hit.pop();
                if (name != null && !name.equals("")) {
                    this.tipText = null;
                    this.tooltipTimer.restart();
                }
            }
        } else if (this.imageUrl != null && this.imageRect != null) {
            if (this.imageRect.contains(x, y)) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.handCursor = true;
            } else if (this.handCursor) {
                this.setCursor(Cursor.getDefaultCursor());
                this.handCursor = false;
            }
        }
        if (this.cleanTip) {
            this.tooltipPaint = false;
            this.repaint();
            this.cleanTip = false;
            if (this.applet != null) {
                this.applet.getAppletContext().showStatus("");
            }
        }
    }

    protected synchronized Vector getTipText(int x, int y) {
        int index;
        this.channel.setPickFullLine(true);
        Stack hit = this.PickObjects(x - 1, y - 1, 3, 3, false);
        this.channel.setPickFullLine(false);
        Vector info = null;
        String name = hit.empty() ? null : (String)hit.pop();
        NLDNode n = null;
        if (name == null || name.equals("")) {
            if (this.model.isHideLinks()) {
                this.channel.setPickFullLine(true);
                hit = this.PickObjects(x - 1, y - 1, 3, 3, false, this.selectionList);
                this.channel.setPickFullLine(false);
                String string = name = hit.empty() ? null : (String)hit.pop();
                if (name == null || name.equals("")) {
                    return null;
                }
            } else {
                return null;
            }
        }
        this.probePtX = x;
        this.probePtY = y;
        if (name.charAt(0) == 'N') {
            int index2 = new Integer(name.substring(1));
            if (index2 >= 0 && index2 < this.model.nodes.size()) {
                int len;
                this.probeNode = n = (NLDNode)this.model.nodes.elementAt(index2);
                if (n.minfo != null) {
                    info = n.minfo;
                } else if (n.info != null) {
                    info = new Vector();
                    info.addElement(n.info);
                } else if (n.mlabel != null) {
                    info = n.mlabel;
                } else if (n.label != null && (len = n.label.trim().length()) > 0) {
                    info = this.makeMultiLine(n.label);
                }
                if (this.applet != null) {
                    this.applet.getAppletContext().showStatus(n.label);
                }
            }
        } else if (name.charAt(0) == 'A' && (index = new Integer(name.substring(1)).intValue()) >= 0 && index < this.model.links.size()) {
            int len;
            NLDLink a;
            this.probeLink = a = (NLDLink)this.model.links.elementAt(index);
            if (a.minfo != null) {
                info = a.minfo;
            } else if (a.info != null) {
                info = new Vector();
                info.addElement(a.info);
            } else if (a.mlabel != null) {
                info = a.mlabel;
            } else if (a.label != null && (len = a.label.trim().length()) > 0) {
                info = this.makeMultiLine(a.label);
            }
        }
        if (info != null) {
            this.probeInfo = info;
        }
        this.tooltipPaint = true;
        this.cleanTip = true;
        return info;
    }

    public boolean isNTipPresent() {
        for (int i = 0; i < this.model.nodes.size(); ++i) {
            String str;
            NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
            if (n.minfo != null) {
                for (int j = 0; j < n.minfo.size(); ++j) {
                    String str2 = new String((String)n.minfo.elementAt(j)).trim();
                    if (str2.length() <= 0) continue;
                    return true;
                }
                continue;
            }
            if (n.info == null || (str = new String(n.info).trim()).length() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        if (!this.ready) {
            return;
        }
        if (this.emptyPlot) {
            return;
        }
        this.tooltipTimer.restart();
        this.tipText = null;
        if (this.tipLocation == null) {
            this.tipLocation = new Point();
        }
        this.tipLocation.x = e.getX();
        this.tipLocation.y = e.getY();
        int x = e.getX();
        int y = e.getY();
        int xd = this.prevx - x;
        int yd = this.prevy - y;
        this.drag = true;
        if (this.movenode) {
            double[] win1 = new double[3];
            double[] obj1 = new double[3];
            double[] win2 = new double[3];
            double[] obj2 = new double[3];
            double[] delta = new double[2];
            win1[0] = x;
            win1[1] = y;
            win2[0] = this.prevx;
            win2[1] = this.prevy;
            this.channel.gluUnProject(win1, obj1);
            this.channel.gluUnProject(win2, obj2);
            delta[0] = obj1[0] - obj2[0];
            delta[1] = obj1[1] - obj2[1];
            for (int i = 0; i < this.numNodes; ++i) {
                NLDNode n = (NLDNode)this.model.nodes.elementAt(i);
                if (!n.selected) continue;
                n.xpos += delta[0];
                n.ypos += delta[1];
            }
            this.build();
            this.repaint();
            this.prevx = x;
            this.prevy = y;
        } else if (this.zoom) {
            if (this.lens) {
                double minfac = 0.1;
                double percent = 1.0 * (double)yd / (double)this.compHeight;
                double thresh = 0.01;
                if (Math.abs(percent) < thresh) {
                    return;
                }
                if (this.lensFactor < 1.0) {
                    double sqrtlen = Math.sqrt(this.lensFactor);
                    this.lensFactor += sqrtlen * percent;
                } else {
                    this.lensFactor *= 1.0 + percent;
                }
                if (this.lensFactor <= minfac) {
                    this.lensFactor = minfac;
                }
                this.channel.setLensFactor(this.lensFactor);
            } else {
                if (Math.abs(yd) < 5) {
                    return;
                }
                this.zoomval *= 1.0 - 1.5 * (double)yd / (double)this.compHeight;
                this.setNodeImages();
                this.checkImages();
                this.proj();
                this.build();
            }
            this.prevx = x;
            this.prevy = y;
            this.repaint();
            if (this.applet != null) {
                this.applet.getAppletContext().showStatus("");
            }
        } else if (this.pan) {
            if (Math.abs(xd) < 5 && Math.abs(yd) < 5) {
                return;
            }
            double wxd = 0.0;
            double wyd = 0.0;
            if (this.lens) {
                double[] ps = new double[]{this.prevx, this.prevy, 0.0};
                double[] pw = new double[3];
                if (this.verticalLens) {
                    int index = 0;
                    while ((double)this.prevy > this.lensScreenRange[index]) {
                        ++index;
                    }
                    int n = index;
                    this.lensScreenLocs[n] = this.lensScreenLocs[n] + (double)(x - this.prevx);
                    this.channel.glDisable(2);
                    double[] s = new double[]{this.lensScreenLocs[index], this.lensScreenRange[index]};
                    double[] w = new double[]{0.0, 0.0};
                    this.channel.gluUnProject(s, w);
                    this.lensLocs[index] = w[0];
                    this.channel.glEnable(2);
                    this.channel.setVerticalLensLocations(this.lensScreenLocs, this.lensScreenRange, this.lensValues, this.textCutoffs);
                    wyd = 0.0;
                    wxd = 0.0;
                    y = this.prevy;
                } else {
                    this.channel.gluUnProject(ps, pw);
                    double[] cs = new double[]{x, y, 0.0};
                    double[] cw = new double[3];
                    this.channel.gluUnProject(cs, cw);
                    wxd = pw[0] - cw[0];
                    wyd = pw[1] - cw[1];
                    wyd = -wyd;
                }
            } else {
                wxd = this.pixsize * (double)xd;
                wyd = this.pixsize * (double)yd;
            }
            this.centerx += wxd;
            this.centery -= wyd;
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            this.prevx = x;
            this.prevy = y;
            this.repaint();
        } else if (this.select || this.extsel) {
            this.repaint();
        }
    }

    public synchronized String getTooltipText(MouseEvent e) {
        String name;
        if (!this.ready) {
            return null;
        }
        int x = e.getX();
        int y = e.getY();
        this.channel.setPickFullLine(true);
        Stack hit = this.PickObjects(x - 1, y - 1, 3, 3, false);
        this.channel.setPickFullLine(false);
        String string = name = hit.empty() ? null : (String)hit.pop();
        if (name != null && !name.equals("")) {
            int index;
            NLDNode n = null;
            if (name.charAt(0) == 'N') {
                int index2 = new Integer(name.substring(1));
                if (index2 >= 0 && index2 < this.model.nodes.size()) {
                    n = (NLDNode)this.model.nodes.elementAt(index2);
                    name = n.minfo != null ? (String)n.minfo.elementAt(0) : (n.info != null ? n.info : (n.mlabel != null ? (String)n.mlabel.elementAt(0) : n.label));
                }
            } else if (name.charAt(0) == 'A' && (index = new Integer(name.substring(1)).intValue()) >= 0 && index < this.model.links.size()) {
                NLDLink a = (NLDLink)this.model.links.elementAt(index);
                if (a.info != null) {
                    name = a.info;
                }
            }
        }
        return name;
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        if (this.tooltipTimer != null) {
            this.tooltipTimer.removeActionListener(this.tooltipHandler);
            this.tooltipTimer.addActionListener(this.tooltipHandler);
            this.tooltipTimer.restart();
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        this.tooltipTimer.restart();
        this.tipLocation = me.getPoint();
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.tipText = null;
        this.tooltipTimer.removeActionListener(this.tooltipHandler);
        this.tooltipTimer.stop();
        this.repaint();
    }

    public double[] project(double x, double y, double[] out) {
        if (this.channel == null) {
            return null;
        }
        if (out == null) {
            out = new double[2];
        } else if (out.length > 2) {
            out[2] = 0.0;
        }
        double[] world = new double[]{x, y};
        this.channel.gluProject(world, out);
        return out;
    }

    public double[] unProject(double pixelX, double pixelY, double[] out) {
        if (out == null) {
            out = new double[2];
        } else if (out.length > 2) {
            out[2] = 0.0;
        }
        if (this.channel == null) {
            return null;
        }
        double[] win = new double[]{pixelX, pixelY};
        this.channel.gluUnProject(win, out);
        return out;
    }

    @Override
    public void run() {
        String thread = Thread.currentThread().getName();
        if (thread.equals("clickThread")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ee) {
                return;
            }
            this.prevCenterX = this.centerx;
            this.prevCenterY = this.centery;
            this.resetNeeded = true;
            if (this.pressNLDNode != null) {
                this.centerNode(this.pressNLDNode, true);
            }
        } else if (thread.equals("resetThread")) {
            if (this.clickThread != null) {
                try {
                    this.clickThread.join(1000L);
                }
                catch (InterruptedException ee) {
                    return;
                }
            }
            this.centerx = this.prevCenterX;
            this.centery = this.prevCenterY;
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            this.rebuild(true);
            this.repaint();
        }
    }

    public void stop() {
        if (this.mouseFrame != null) {
            this.mouseFrame.setVisible(false);
            this.mouseFrame.dispose();
        }
        if (this.aboutFrame != null) {
            this.aboutFrame.setVisible(false);
            this.aboutFrame.dispose();
        }
        if (this.dlg != null) {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        }
        this.clickThread = null;
    }

    protected void checkImages() {
        if (this.mt != null) {
            try {
                this.mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getPreferredWidth() {
        return this.compWidth;
    }

    @Override
    public int getPreferredHeight() {
        return this.compHeight;
    }

    protected void proj() {
        float yrng;
        float xrng;
        int prefwidth = this.getPreferredWidth();
        int prefheight = this.getPreferredHeight();
        float fw = prefwidth;
        float fh = prefheight;
        float xo = 0.0f;
        float yo = 0.0f;
        if (this.userLayout) {
            float minDim;
            xrng = minDim = fw < fh ? fw : fh;
            yrng = minDim;
            yo = 0.0f;
            xo = 0.0f;
        } else if (this.model.chartType == 2) {
            xrng = fw;
            yrng = fh;
            xo = this.lens ? 0.0f : (float)(-this.compWidth / 2);
            yo = this.lens ? -fh : -fh + (float)(this.compHeight / 2);
        } else if (this.model.chartType == 3 || this.model.chartType == 4) {
            xrng = 1.0f;
            yrng = fh;
            xo = 0.0f;
            yo = -fh;
        } else {
            xrng = 2.0f;
            yrng = 2.0f;
        }
        fw = xrng;
        fh = yrng;
        fw = (float)((double)fw * this.zoomval);
        fh = (float)((double)fh * this.zoomval);
        this.pixsize = fw / (float)prefwidth;
        if (this.model.chartType == 2 || this.model.chartType == 3 || this.model.chartType == 4) {
            this.channel.glOrtho((double)xo, (double)(xo + fw), (double)yo, (double)(yo + fh), -10.0, 10.0);
        } else {
            this.channel.glOrtho((double)(-fw / 2.0f), (double)(fw / 2.0f), (double)(-fh / 2.0f), (double)(fh / 2.0f), -10.0, 10.0);
        }
        if (this.verticalLens) {
            this.setVerticalLens();
        }
    }

    protected void prepareImage() {
        this.imageUpdate(this.backImage, 32, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected boolean checkImageSettings(Image img, int drawMode, int x, int y) {
        int ix = x;
        int iy = y;
        if (img == null) {
            return false;
        }
        int width = this.compWidth;
        int height = this.compHeight;
        switch (drawMode) {
            case 2: {
                if (this.imageWidth < width && this.imageHeight < height) {
                    ix = (width - this.imageWidth) / 2;
                    iy = (height - this.imageHeight) / 2;
                    break;
                }
                iy = 0;
                ix = 0;
                drawMode = 0;
                this.imageWidth = width;
                this.imageHeight = height;
                break;
            }
            case 3: {
                for (ix = x; ix < 0; ix += width) {
                }
                for (iy = y; iy < 0; iy += height) {
                }
                if (width <= 0 || height <= 0) break;
                this.imageWidth = Math.min(this.imageWidth, width - ix);
                this.imageHeight = Math.min(this.imageHeight, height - iy);
                break;
            }
            default: {
                iy = 0;
                ix = 0;
                this.imageWidth = width;
                this.imageHeight = height;
            }
        }
        this.imageLocation = new Point(ix, iy);
        this.imageRect = new Rectangle(ix, iy, this.imageWidth, this.imageHeight);
        return true;
    }

    protected void resetFlags() {
        this.zoom = false;
        this.pan = false;
        this.movenode = false;
        this.select = false;
        this.extsel = false;
        this.drag = false;
        this.chgview = false;
        this.viewport = false;
        this.brush = false;
        this.brushDrag = false;
        this.brushResize = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean centerNode(NLDNode n, boolean interrupt) {
        this.ready = false;
        int STEPS = 10;
        this.prevCenterX = this.centerx;
        this.prevCenterY = this.centery;
        double fac = 1.0 / (double)STEPS;
        double xinc = fac * (n.xpos - this.centerx);
        double yinc = fac * (n.ypos - this.centery);
        for (int i = 0; i < STEPS; ++i) {
            if (this.applet != null) {
                this.applet.getAppletContext().showStatus(this.GRS("Viewer.step.txt", "step ") + (i + 1) + this.GRS("Viewer.slash.txt", "/") + STEPS + this.GRS("Viewer.animated.txt", " of animated re-center"));
            }
            this.centerx += xinc;
            this.centery += yinc;
            this.validateCenter();
            this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
            if (this.interrupted) break;
            this.rebuild(true);
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ready = true;
            this.interrupted = false;
        }
        return true;
    }

    protected boolean centerNode(NLDNode n) {
        this.ready = false;
        this.centerx = n.xpos;
        this.centery = n.ypos;
        this.validateCenter();
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.repaint();
        this.ready = true;
        return true;
    }

    protected void validateCenter() {
    }

    protected boolean moveNode(NLDNode n, double x, double y) {
        this.ready = false;
        this.centerx = x + n.xpos;
        this.centery = y + n.ypos;
        this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
        this.repaint();
        this.ready = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean moveNode(NLDNode n, boolean interrupt, double x, double y) {
        this.ready = false;
        int STEPS = 10;
        this.prevCenterX = this.centerx;
        this.prevCenterY = this.centery;
        double fac = 1.0 / (double)STEPS;
        double xinc = fac * (n.xpos + x - this.centerx);
        double yinc = fac * (n.ypos + y - this.centery);
        if (xinc != 0.0 || yinc != 0.0) {
            for (int i = 0; i < STEPS; ++i) {
                if (this.applet != null) {
                    this.applet.getAppletContext().showStatus(this.GRS("Viewer.step.txt", "step ") + (i + 1) + this.GRS("Viewer.slash.txt", "/") + STEPS + this.GRS("Viewer.animated.txt", " of animated re-center"));
                }
                this.centerx += xinc;
                this.centery += yinc;
                this.channel.gluLookAt(this.centerx, this.centery, 0.0, 0.5, 0.0, 0.0, 0.0);
                if (this.interrupted) break;
                this.repaint();
            }
        }
        if (this.applet != null) {
            this.applet.getAppletContext().showStatus("");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ready = true;
            this.interrupted = false;
        }
        return true;
    }

    protected boolean ShowURL(String linkText, String targetIn) {
        if (this.applet == null) {
            return false;
        }
        String target = this.urlTarget;
        if (targetIn != null) {
            target = targetIn;
        }
        try {
            URL url = new URL(this.document, linkText);
            AppletContext appContext = this.applet.getAppletContext();
            if (appContext != null) {
                appContext.showDocument(url, target);
            }
        }
        catch (MalformedURLException e) {
            String err = new String("ERROR: Could not find URL = '" + linkText + "'");
            this.applet.getAppletContext().showStatus(err);
            return false;
        }
        return true;
    }

    public String GRS(String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (this.appRB != null) {
                s = this.appRB.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    protected Dimension getRBSize(String name, int width, int height) {
        String s = this.GRS(name, null);
        Dimension dim = new Dimension(width, height);
        if (s == null || dim == null || !this.useRBsizing) {
            return dim;
        }
        try {
            int i = s.indexOf(",");
            dim.width = Integer.valueOf(s.substring(0, i));
            if (dim.width == -1) {
                dim.width = width;
            }
            s = s.substring(i + 1);
            dim.height = Integer.valueOf(s);
            if (dim.height == -1) {
                dim.height = height;
            }
        }
        catch (NumberFormatException e) {
            dim.width = width;
            dim.height = height;
        }
        return dim;
    }

    @Override
    public void setFont(Font aFont) {
        this.font = aFont;
        super.setFont(this.font);
        if (this.channel != null) {
            this.channel.glSelect2DFont(this.font);
        }
    }

    protected Image GetImageFromURL(String fileName, URL url) {
        Image img = null;
        URL imgurl = null;
        if (fileName == null) {
            return null;
        }
        try {
            if (url == null ? (imgurl = this.document != null ? new URL(this.document, fileName) : new URL(fileName)) == null : (imgurl = new URL(url, fileName)) == null) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            Toolkit tk = this.getToolkit();
            img = tk.getImage(imgurl);
            if (img == null) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        this.imageWidth = img.getWidth(this);
        this.imageHeight = img.getHeight(this);
        this.prepareImage(img, this);
        return img;
    }

    protected void startClickThread() {
        this.clickThread = new Thread((Runnable)this, "clickThread");
        this.clickThread.start();
    }

    protected void showBackgroundURL(int x, int y) {
        if (this.imageUrl != null && this.imageRect != null && this.imageRect.contains(x, y)) {
            this.ShowURL(this.imageUrl, this.urlTarget);
        }
    }

    protected void resetBorderProperties() {
        this.channel.setBorderCutoff(1.0);
        this.channel.setBorderType(this.borderType);
        this.channel.setTextBorderFlag(true);
        this.channel.setTextBorderType(this.textBorderType);
        this.channel.setTextBorderColor(Color.black);
    }

    protected String getAltHtml() {
        String data = null;
        if (this.applet == null) {
            return data;
        }
        Applet ap = null;
        try {
            String name = this.applet.getParameter("NAME");
            if (name != null) {
                ap = this.applet.getAppletContext().getApplet(name);
            } else {
                Enumeration<Applet> e = this.applet.getAppletContext().getApplets();
                if (e.hasMoreElements()) {
                    ap = e.nextElement();
                }
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return data;
        }
        String arg = ap.getParameter("ID");
        String error = null;
        if (arg != null && arg.length() > 0) {
            JSObject appl = null;
            try {
                appl = (JSObject)((JSObject)JSObject.getWindow((Applet)ap).getMember("document")).getMember(arg);
            }
            catch (Exception err) {
                error = this.GRS("StatusText.errorApplet.txt.notrans", "Error finding <APPLET> with ID=") + arg;
                this.applet.getAppletContext().showStatus(error);
                System.out.println(error);
                err.printStackTrace();
                return data;
            }
            if (appl == null) {
                error = this.GRS("StatusText.errorApplet.txt.notrans", "Error finding <APPLET> with ID=") + arg;
                this.applet.getAppletContext().showStatus(error);
                System.out.println(error);
                return data;
            }
            try {
                data = (String)appl.getMember("altHtml");
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return data;
            }
        }
        error = this.GRS("StatusText.errorinlineXML.txt", "For inline XML, you must specify an applet ID.");
        System.out.println(error);
        return data;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x20) == 0) {
            return true;
        }
        if ((infoflags & 0x80) != 0 || (infoflags & 0x40) != 0) {
            this.backImage = null;
        }
        if ((infoflags & 0x20) == 0) {
            return true;
        }
        this.imageHeight = height;
        this.imageWidth = width;
        if (img == this.backImage && !this.readyCalled && this.imageHeight >= 0 && this.imageWidth >= 0) {
            this.ImageReady(img, this.imageDraw, this.imagePositionX, this.imagePositionY, this.imageWidth, this.imageHeight);
            if (this.imageWidth != 0 && this.imageHeight != 0) {
                this.readyCalled = true;
            }
        }
        return false;
    }

    public void UpdateImage(Image img, int drawMode, int x, int y, int width, int height) {
        if (this.checkImageSettings(img, drawMode, x, y)) {
            this.SetImage(img, drawMode, this.imageLocation.x, this.imageLocation.y, this.imageRect);
        }
    }

    protected void ImageReady(Image img, int drawMode, int x, int y, int width, int height) {
        this.UpdateImage(img, drawMode, x, y, width, height);
    }

    public double[] project(double x, double y, double z, double[] out) {
        if (out == null) {
            out = new double[2];
        } else if (out.length > 2) {
            out[2] = 0.0;
        }
        return this.project(x, y, out);
    }

    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        if (out == null) {
            out = new double[2];
        } else if (out.length > 2) {
            out[2] = 0.0;
        }
        return this.unProject(pixelX, pixelY, out);
    }

    protected JMenuItem AddToMenu(JPopupMenu m, String item, String cmd, ActionListener al) {
        JMenuItem mi = null;
        mi = new JMenuItem(item);
        if (mi != null) {
            mi.setActionCommand(cmd);
            mi.addActionListener(al);
            m.add(mi);
        }
        return mi;
    }

    protected JMenuItem AddToMenu(JPopupMenu m, String item, String cmd, ActionListener al, boolean enabled) {
        JMenuItem mi = this.AddToMenu(m, item, cmd, al);
        if (mi != null) {
            mi.setEnabled(enabled);
        }
        return mi;
    }

    protected JCheckBoxMenuItem AddOnOffToMenu(JComponent m, String item, String cmd, boolean isOn, ItemListener il) {
        JCheckBoxMenuItem mi = null;
        mi = new JCheckBoxMenuItem(item);
        if (mi != null) {
            mi.setActionCommand(cmd);
            mi.setState(isOn);
            mi.addItemListener(il);
            m.add(mi);
        }
        return mi;
    }

    protected JCheckBoxMenuItem AddOnOffToMenu(JComponent m, String item, String cmd, boolean isOn, ItemListener il, boolean enabled) {
        JCheckBoxMenuItem mi = this.AddOnOffToMenu(m, item, cmd, isOn, il);
        if (mi != null) {
            mi.setEnabled(enabled);
        }
        return mi;
    }

    protected JRadioButtonMenuItem AddRadioToMenu(JComponent m, ButtonGroup g, String item, String cmd, ItemListener il, boolean enabled) {
        JRadioButtonMenuItem mi = null;
        mi = new JRadioButtonMenuItem(item);
        if (mi != null) {
            mi.setActionCommand(cmd);
            mi.addItemListener(il);
            m.add(mi);
            mi.setEnabled(enabled);
            g.add(mi);
        }
        return mi;
    }

    URL getDocumentBase() {
        return this.document;
    }

    URL getCodeBase() {
        return this.code;
    }

    public void setCenterSelected(boolean flag) {
        this.centerSelected = flag;
    }

    public void setHandleEvents(boolean flag) {
        this.handleEvents = flag;
    }

    public boolean isInside(int x, int y) {
        int endx = this.prevx + this.diffx;
        int endy = this.prevy + this.diffy;
        return x > Math.min(endx, this.prevx) && x < Math.max(endx, this.prevx) && y > Math.min(endy, this.prevy) && y < Math.max(endy, this.prevy);
    }

    protected void doBrushing(int x, int y, int xd, int yd) {
        if (!this.brushActive) {
            int xp = this.dragMinX = Math.min(x, this.pressX);
            int yp = this.dragMinY = Math.min(y, this.pressY);
            this.dragMaxX = Math.max(x, this.pressX);
            this.dragMaxY = Math.max(y, this.pressY);
            int w = Math.abs(x - this.pressX);
            int h = Math.abs(y - this.pressY);
            this.brushActive = true;
            this.prevx = xp;
            this.prevy = yp;
            this.diffx = w;
            this.diffy = h;
        } else if (this.brushResize) {
            if (this.handleID == -1) {
                return;
            }
            int dx = x - this.startStretchX;
            int dy = y - this.startStretchY;
            Graphics gc = this.getGraphics();
            gc.setColor(Color.white);
            gc.setXORMode(Color.black);
            switch (this.handleID) {
                case 7: {
                    gc.drawRect(this.prevx, this.prevy - this.stretchY, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = dx;
                    this.stretchY = 0 - dy;
                    gc.drawRect(this.prevx, this.prevy - this.stretchY, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx;
                    this.stretchPrevY = this.prevy - this.stretchY;
                    break;
                }
                case 6: {
                    gc.drawRect(this.prevx - this.stretchX, this.prevy - this.stretchY, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = 0 - dx;
                    this.stretchY = 0 - dy;
                    gc.drawRect(this.prevx - this.stretchX, this.prevy - this.stretchY, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx - this.stretchX;
                    this.stretchPrevY = this.prevy - this.stretchY;
                    break;
                }
                case 4: {
                    gc.drawRect(this.prevx - this.stretchX, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = 0 - dx;
                    this.stretchY = dy;
                    gc.drawRect(this.prevx - this.stretchX, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx - this.stretchX;
                    this.stretchPrevY = this.prevy;
                    break;
                }
                case 5: {
                    gc.drawRect(this.prevx, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = dx;
                    this.stretchY = dy;
                    gc.drawRect(this.prevx, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx;
                    this.stretchPrevY = this.prevy;
                    break;
                }
                case 8: {
                    gc.drawRect(this.prevx, this.prevy - this.stretchY, this.diffx, this.diffy + this.stretchY);
                    this.stretchX = 0;
                    this.stretchY = 0 - dy;
                    gc.drawRect(this.prevx, this.prevy - this.stretchY, this.diffx, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx;
                    this.stretchPrevY = this.prevy - this.stretchY;
                    break;
                }
                case 9: {
                    gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy + this.stretchY);
                    this.stretchX = 0;
                    this.stretchY = dy;
                    gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx;
                    this.stretchPrevY = this.prevy;
                    break;
                }
                case 11: {
                    gc.drawRect(this.prevx, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = dx;
                    this.stretchY = 0;
                    gc.drawRect(this.prevx, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx;
                    this.stretchPrevY = this.prevy;
                    break;
                }
                case 10: {
                    gc.drawRect(this.prevx - this.stretchX, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchX = 0 - dx;
                    this.stretchY = 0;
                    gc.drawRect(this.prevx - this.stretchX, this.prevy, this.diffx + this.stretchX, this.diffy + this.stretchY);
                    this.stretchPrevX = this.prevx - this.stretchX;
                    this.stretchPrevY = this.prevy;
                }
            }
            gc.dispose();
        } else if (this.brushPress) {
            int dx = x - this.brushPressX;
            int dy = y - this.brushPressY;
            this.brushPressX = x;
            this.brushPressY = y;
            this.prevx += dx;
            this.prevy += dy;
            Stack hit = this.PickObjects(this.prevx, this.prevy, this.diffx, this.diffy, true, this.nodelist);
            boolean updateN = false;
            int[] indices = new int[hit.size()];
            int cntr = 0;
            while (!hit.empty()) {
                String name = (String)hit.pop();
                if (name.equals("")) continue;
                int index = new Integer(name.substring(1));
                if (name.charAt(0) != 'N') continue;
                boolean repeat = false;
                for (int i = 0; i < cntr; ++i) {
                    if (indices[i] != index) continue;
                    repeat = true;
                    break;
                }
                if (repeat) continue;
                indices[cntr++] = index;
            }
            if (this.pickLinks) {
                hit = this.PickObjects(this.prevx, this.prevy, this.diffx, this.diffy, true, this.linklist);
            } else {
                hit.removeAllElements();
            }
            boolean updateL = false;
            int[] indices2 = new int[hit.size()];
            int cntr2 = 0;
            while (!hit.empty()) {
                String name = (String)hit.pop();
                if (name.equals("")) continue;
                int index = new Integer(name.substring(1));
                if (name.charAt(0) != 'A') continue;
                boolean repeat = false;
                for (int i = 0; i < cntr2; ++i) {
                    if (indices2[i] != index) continue;
                    repeat = true;
                    break;
                }
                if (repeat) continue;
                indices2[cntr2++] = index;
            }
            if (this.oldIndices == null) {
                this.oldIndices = new int[this.model.nodes.getNumberObservations()];
                this.oldCnt = 0;
            }
            if (this.oldIndicesLinks == null) {
                this.oldIndicesLinks = new int[this.model.links.getNumberObservations()];
                this.oldCntLinks = 0;
            }
            if (cntr > 0) {
                if (this.oldIndices != null) {
                    if (this.oldCnt != cntr) {
                        updateN = true;
                    } else {
                        for (int i = cntr - 1; i >= 0; --i) {
                            if (this.oldIndices[i] == indices[i]) continue;
                            updateN = true;
                            break;
                        }
                    }
                } else {
                    updateN = true;
                }
            } else if (this.oldCnt > 0) {
                updateN = true;
            }
            if (cntr2 > 0) {
                if (this.oldIndicesLinks != null) {
                    if (this.oldCntLinks != cntr2) {
                        updateL = true;
                    } else {
                        for (int i = cntr2 - 1; i >= 0; --i) {
                            if (this.oldIndicesLinks[i] == indices2[i]) continue;
                            updateL = true;
                            break;
                        }
                    }
                } else {
                    updateL = true;
                }
            } else if (this.oldCntLinks > 0) {
                updateL = true;
            }
            if (updateN || updateL) {
                this.myMouseAction = true;
                if (updateN) {
                    this.oldCnt = 0;
                    for (int i = 0; i < cntr; ++i) {
                        this.oldIndices[this.oldCnt++] = indices[i];
                    }
                    if (cntr > 0) {
                        this.ignoreBuild = true;
                    }
                    this.model.nodes.unselectAll(this.handleEvents);
                    if (!updateL) {
                        this.ignoreBuild = false;
                    }
                    this.model.nodes.setSelected(indices, true, cntr, this.handleEvents);
                }
                if (updateL) {
                    this.oldCntLinks = 0;
                    if (this.oldIndicesLinks.length < cntr2) {
                        this.oldIndicesLinks = new int[cntr2];
                        this.oldCntLinks = 0;
                    }
                    for (int i = 0; i < cntr2; ++i) {
                        this.oldIndicesLinks[this.oldCntLinks++] = indices2[i];
                    }
                    if (cntr2 > 0) {
                        this.ignoreBuild = true;
                    }
                    this.model.links.unselectAll(this.handleEvents);
                    this.ignoreBuild = false;
                    this.model.links.setSelected(indices2, true, cntr2, this.handleEvents);
                }
                this.myMouseAction = false;
                if (this.handleEvents) {
                    this.buildSelected(indices, cntr, indices2, cntr2);
                    this.repaint();
                }
                this.model.updateLinks();
            }
            this.repaint();
            this.brushDrag = true;
        } else {
            this.dragMinX = Math.min(x, this.pressX);
            this.dragMinY = Math.min(y, this.pressY);
            this.dragMaxX = Math.max(x, this.pressX);
            this.dragMaxY = Math.max(y, this.pressY);
            this.prevx = this.dragMinX;
            this.prevy = this.dragMinY;
            this.diffx = this.dragMaxX - this.dragMinX;
            this.diffy = this.dragMaxY - this.dragMinY;
            this.repaint();
            this.updateHandles();
        }
    }

    public void checkState() {
        if (!this.myMouseAction) {
            this.resetBrushInformation();
        }
    }

    protected void drawBrush(Graphics gc, int x, int y, int w, int h) {
        gc.setColor(Color.black);
        gc.drawRect(x, y, w, h);
    }

    protected void resetBrushInformation() {
        this.diffy = 0;
        this.diffx = 0;
        this.stretchY = 0;
        this.stretchX = 0;
        this.startStretchY = 0;
        this.startStretchX = 0;
        this.brushActive = false;
        this.brushPress = false;
        this.brushDrag = false;
        this.brushResize = false;
        this.brush = false;
        this.updateHandles();
    }

    public int onHandle(int x, int y) {
        if (this.tl != null) {
            if (this.tl.contains(x, y)) {
                return 6;
            }
            if (this.tr.contains(x, y)) {
                return 7;
            }
            if (this.br.contains(x, y)) {
                return 5;
            }
            if (this.bl.contains(x, y)) {
                return 4;
            }
            if (this.l.contains(x, y)) {
                return 10;
            }
            if (this.r.contains(x, y)) {
                return 11;
            }
            if (this.t.contains(x, y)) {
                return 8;
            }
            if (this.b.contains(x, y)) {
                return 9;
            }
            return -1;
        }
        return -1;
    }

    protected void createHandles() {
        this.tl = new Rectangle(this.prevx - this.handleSize / 2, this.prevy - this.handleSize / 2, this.handleSize, this.handleSize);
        this.tr = new Rectangle(this.prevx + this.diffx - this.handleSize / 2, this.prevy - this.handleSize / 2, this.handleSize, this.handleSize);
        this.br = new Rectangle(this.prevx + this.diffx - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2, this.handleSize, this.handleSize);
        this.bl = new Rectangle(this.prevx - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2, this.handleSize, this.handleSize);
        this.l = new Rectangle(this.prevx - this.handleSize / 2, this.prevy + this.diffy / 2 - this.handleSize / 2, this.handleSize, this.handleSize);
        this.r = new Rectangle(this.prevx + this.diffx - this.handleSize / 2, this.prevy + this.diffy / 2 - this.handleSize / 2, this.handleSize, this.handleSize);
        this.t = new Rectangle(this.prevx + this.diffx / 2 - this.handleSize / 2, this.prevy - this.handleSize / 2, this.handleSize, this.handleSize);
        this.b = new Rectangle(this.prevx + this.diffx / 2 - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2, this.handleSize, this.handleSize);
    }

    protected void resetHideSubtree() {
        for (int i = 0; i < this.numNodes; ++i) {
            ((NLDNode)this.model.nodes.elementAt(i)).resetHideSubtree();
        }
    }

    protected void updateHandles() {
        if (this.tl == null) {
            this.createHandles();
        } else {
            this.tl.setLocation(this.prevx - this.handleSize / 2, this.prevy - this.handleSize / 2);
            this.tr.setLocation(this.prevx + this.diffx - this.handleSize / 2, this.prevy - this.handleSize / 2);
            this.br.setLocation(this.prevx + this.diffx - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2);
            this.bl.setLocation(this.prevx - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2);
            this.l.setLocation(this.prevx - this.handleSize / 2, this.prevy + this.diffy / 2 - this.handleSize / 2);
            this.r.setLocation(this.prevx + this.diffx - this.handleSize / 2, this.prevy + this.diffy / 2 - this.handleSize / 2);
            this.t.setLocation(this.prevx + this.diffx / 2 - this.handleSize / 2, this.prevy - this.handleSize / 2);
            this.b.setLocation(this.prevx + this.diffx / 2 - this.handleSize / 2, this.prevy + this.diffy - this.handleSize / 2);
        }
    }

    public Cursor getMoveOpenCursor() {
        return this.moveOpenCursor;
    }

    public Cursor getMoveClosedCursor() {
        return this.moveCloseCursor;
    }

    public void setMoveOpenCursor(Cursor moveOpen) {
        this.moveOpenCursor = moveOpen;
    }

    public void setMoveClosedCursor(Cursor moveClosed) {
        this.moveCloseCursor = moveClosed;
    }

    public Cursor getZoomCursor() {
        return this.zoomCursor;
    }

    public Cursor getViewPortCursor() {
        return this.viewportCursor;
    }

    public void setZoomCursor(Cursor cursor) {
        this.zoomCursor = cursor;
    }

    public void setViewPortCursor(Cursor cursor) {
        this.viewportCursor = cursor;
    }

    public ChannelLite getChannel() {
        return this.channel;
    }

    public void setNodeSize(NLDNode n, double size) {
        n.size = size;
        n.height = -1.0;
    }

    public void setRampColor(int index, Color c) {
        if (index < 0 || index > 2) {
            return;
        }
        this.rampColors[index] = c;
    }

    public synchronized Stack PickObjects(int x, int y, int dx, int dy, boolean pickAllHits) {
        return this.PickObjects(x, y, dx, dy, pickAllHits, this.displist);
    }

    public synchronized Stack PickObjects(int x, int y, int dx, int dy, boolean pickAllHits, long list) {
        this.channel.glRenderMode(1);
        this.channel.setPickAllHits(pickAllHits);
        this.channel.gluPickMatrix(x, y, dx, dy);
        Stack hit = new Stack();
        this.channel.glSelectBuffer(hit);
        this.channel.glCallList(list, true);
        this.channel.glRenderMode(0);
        this.channel.setPickAllHits(false);
        return hit;
    }

    public void setInApplet(boolean flag) {
        this.inApplet = flag;
    }

    public boolean isInApplet() {
        return this.inApplet;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return null;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 0;
    }

    protected Vector makeMultiLine(String text) {
        if (text == null || text.length() <= 0) {
            return null;
        }
        int nlIndex = 0;
        Vector<String> multiLine = new Vector<String>();
        int i = 0;
        while (nlIndex >= 0) {
            nlIndex = text.indexOf(10, i);
            String line = text.substring(i, nlIndex >= 0 ? nlIndex : text.length());
            multiLine.addElement(line);
            i = 1 + nlIndex;
        }
        return multiLine;
    }

    public void setPickLinks(boolean flag) {
        this.pickLinks = flag;
    }

    public boolean getPickLinks() {
        return this.pickLinks;
    }

    public boolean isNodeDescendentOfRoot(int index) {
        return this.model.nodes.isVisible(index);
    }

    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public void setRebuildRequired(boolean rebuildRequired) {
        this.rebuildRequired = rebuildRequired;
    }

    public boolean isBrushDrawn() {
        return this.drawBrush;
    }

    public void setDrawBrush(boolean drawBrush) {
        this.drawBrush = drawBrush;
    }

    public void setPauseLayout(boolean flag) {
        this.pauseLayout = flag;
    }

    public boolean isLayoutInterrupted() {
        return this.pauseLayout;
    }

    public void setAnimating(boolean flag) {
        this.animating = flag;
    }

    public boolean isAnimating() {
        return this.animating;
    }

    public void setAnimationFlag(boolean flag) {
        this.doAnimation = flag;
    }

    public boolean getAnimationFlag() {
        return this.doAnimation;
    }

    public void setLayoutStrategy(int flag) {
        this.layoutStrategy = flag;
    }

    public int getLayoutStrategy() {
        return this.layoutStrategy;
    }

    public void setFixedShapeNoneSelected(boolean flag) {
        this.fixedShapeNoneSelected = flag;
    }

    public boolean getFixedShapeNoneSelected() {
        return this.fixedShapeNoneSelected;
    }

    protected boolean calculateCentroid() {
        double y;
        double x;
        NLDNode n;
        int nodeCount = this.model.nodes.size();
        double oldxmin = Double.POSITIVE_INFINITY;
        double oldxmax = Double.NEGATIVE_INFINITY;
        double oldymin = Double.POSITIVE_INFINITY;
        double oldymax = Double.NEGATIVE_INFINITY;
        int nNodes = 0;
        for (int i = 0; i < nodeCount; ++i) {
            n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++nNodes;
            x = n.orgXpos;
            y = n.orgYpos;
            if (i == 0) {
                oldxmin = oldxmax = x;
                oldymin = oldymax = y;
                continue;
            }
            oldxmin = Math.min(x, oldxmin);
            oldxmax = Math.max(x, oldxmax);
            oldymin = Math.min(y, oldymin);
            oldymax = Math.max(y, oldymax);
        }
        double oldxm = (oldxmin + oldxmax) / 2.0;
        double oldym = (oldymin + oldymax) / 2.0;
        double oldxd = oldxmax - oldxmin;
        double oldyd = oldymax - oldymin;
        double fac = 0.6 + 0.1 * Math.min(2.0, Math.sqrt(nNodes));
        if (nNodes == 1) {
            fac = 0.01;
        }
        double newxmin = -fac;
        double newxmax = fac;
        double newymin = -fac;
        double newymax = fac;
        double newxm = (newxmin + newxmax) / 2.0;
        double newym = (newymin + newymax) / 2.0;
        double newxd = newxmax - newxmin;
        double newyd = newymax - newymin;
        double xshift = newxm - oldxm;
        double yshift = newym - oldym;
        double xexp = newxd / (oldxd + 1.0);
        double yexp = newyd / (oldyd + 1.0);
        double expand = Math.min(xexp, yexp);
        for (int i = 0; i < nodeCount; ++i) {
            n = (NLDNode)this.model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            x = n.orgXpos + xshift;
            y = n.orgYpos + yshift;
            x = newxm + (x - newxm) * expand;
            y = newym + (y - newym) * expand;
            n.xpos = x;
            n.ypos = y;
        }
        return true;
    }

    protected void drawSelectionRect(int x, int y) {
        Graphics gc = this.getGraphics();
        gc.setColor(Color.white);
        gc.setXORMode(Color.black);
        gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy);
        this.dragMinX = Math.min(x, this.pressX);
        this.dragMinY = Math.min(y, this.pressY);
        this.dragMaxX = Math.max(x, this.pressX);
        this.dragMaxY = Math.max(y, this.pressY);
        this.prevx = this.dragMinX;
        this.prevy = this.dragMinY;
        this.diffx = this.dragMaxX - this.dragMinX;
        this.diffy = this.dragMaxY - this.dragMinY;
        gc.drawRect(this.prevx, this.prevy, this.diffx, this.diffy);
        gc.dispose();
    }

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        if (this.id == null) {
            this.id = "NLD";
        }
        return "NLD";
    }

    static {
        imid = 0;
        checkStateCntr = 0;
    }

    private class TooltipHandler
    implements ActionListener {
        private TooltipHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NLDViewer.this.tipLocation == null) {
                return;
            }
            Vector prevTipText = NLDViewer.this.tipText;
            NLDViewer.this.tipText = NLDViewer.this.getTipText(NLDViewer.this.tipLocation.x, NLDViewer.this.tipLocation.y);
            NLDViewer.this.tooltipTimer.stop();
            if (prevTipText != NLDViewer.this.tipText) {
                NLDViewer.this.repaint();
            }
        }
    }
}

