/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDScrollPaneInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;

public class NLDScrollPane
extends JComponent
implements AdjustmentListener,
PropertyChangeListener {
    private NLDScrollPaneInterface viewer = null;
    private JScrollBar vbar = null;
    private JScrollBar hbar = null;
    private JViewport rowHeader = null;
    private boolean negativeYScrolling = true;
    boolean ignore = false;

    public NLDScrollPane(NLDScrollPaneInterface viewer) {
        this.viewer = viewer;
        this.setLayout(new BorderLayout());
        this.initViewer(viewer);
        this.manageViewport();
    }

    public void initViewer(NLDScrollPaneInterface viewer) {
        if (viewer != null && viewer instanceof Component) {
            viewer.setOrigin(new Point(0, 0), false, false);
            ((Component)((Object)viewer)).addPropertyChangeListener(this);
            this.add((Component)((Object)viewer));
        }
    }

    public void removeViewer(NLDScrollPaneInterface viewer) {
        if (viewer != null && viewer instanceof Component) {
            viewer.removePropertyChangeListener(this);
            this.remove((Component)((Object)viewer));
        }
    }

    public void manageViewport() {
        Point origin;
        if (this.viewer == null) {
            return;
        }
        if (this.ignore) {
            return;
        }
        int ew = this.viewer.getPreferredWidth();
        int eh = this.viewer.getPreferredHeight();
        Rectangle cd = this.viewer.getBounds();
        if (ew == 0 || eh == 0) {
            return;
        }
        this.ignore = true;
        if (eh > 0) {
            if (eh > cd.height) {
                if (this.vbar == null) {
                    this.vbar = new JScrollBar(1);
                    this.add((Component)this.vbar, "East");
                    this.validate();
                    cd = this.viewer.getBounds();
                }
                this.vbar.removeAdjustmentListener(this);
                origin = this.viewer.getOrigin();
                int y = 0;
                if (origin != null) {
                    y = origin.y;
                }
                this.vbar.setMinimum(0);
                this.vbar.setMaximum(eh);
                this.vbar.setValue(Math.abs(y));
                this.vbar.setVisibleAmount(cd.height);
                this.vbar.setUnitIncrement(this.viewer.getScrollableUnitIncrement(cd, 1, 1));
                this.vbar.setBlockIncrement(this.viewer.getScrollableBlockIncrement(cd, 1, 1));
                this.vbar.addAdjustmentListener(this);
            } else if (this.vbar != null && eh <= cd.height) {
                this.vbar.removeAdjustmentListener(this);
                this.viewer.removePropertyChangeListener(this);
                this.remove(this.vbar);
                this.validate();
                cd = this.viewer.getBounds();
                this.viewer.addPropertyChangeListener(this);
                this.vbar = null;
            } else if (this.vbar != null && eh != this.vbar.getMaximum()) {
                this.vbar.removeAdjustmentListener(this);
                this.vbar.setMaximum(eh);
                this.vbar.addAdjustmentListener(this);
            }
        }
        if (ew > 0) {
            if (ew > cd.width) {
                if (this.hbar == null) {
                    this.hbar = new JScrollBar(0);
                    this.add((Component)this.hbar, "South");
                    this.validate();
                    cd = this.viewer.getBounds();
                }
                this.hbar.removeAdjustmentListener(this);
                origin = this.viewer.getOrigin();
                int x = 0;
                if (origin != null) {
                    x = origin.x;
                }
                this.hbar.setMinimum(0);
                this.hbar.setMaximum(ew);
                this.hbar.setValue(Math.abs(x));
                this.hbar.setVisibleAmount(cd.width);
                this.hbar.setUnitIncrement(this.viewer.getScrollableUnitIncrement(cd, 0, 1));
                this.hbar.setBlockIncrement(this.viewer.getScrollableBlockIncrement(cd, 0, 1));
                this.hbar.addAdjustmentListener(this);
            } else if (this.hbar != null && ew <= cd.width) {
                this.hbar.removeAdjustmentListener(this);
                this.viewer.removePropertyChangeListener(this);
                this.remove(this.hbar);
                this.validate();
                cd = this.viewer.getBounds();
                this.viewer.addPropertyChangeListener(this);
                this.hbar = null;
            } else if (this.hbar != null && ew != this.hbar.getMaximum()) {
                this.hbar.removeAdjustmentListener(this);
                this.hbar.setMaximum(ew);
                this.hbar.addAdjustmentListener(this);
            }
        }
        if (this.rowHeader != null) {
            ((JComponent)this.rowHeader.getView()).setPreferredSize(new Dimension(this.rowHeader.getPreferredSize().width, eh));
        }
        this.ignore = false;
    }

    public void setRowHeader(JComponent rowH) {
        if (rowH == null) {
            return;
        }
        if (this.rowHeader != null) {
            this.remove(this.rowHeader);
        } else {
            this.rowHeader = new JViewport();
        }
        this.rowHeader.setView(rowH);
        this.rowHeader.setViewPosition(new Point(0, 0));
        this.add((Component)this.rowHeader, "West");
        this.manageViewport();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent event) {
        Point p = new Point();
        Point origin = null;
        origin = this.viewer.getOrigin();
        if (origin == null) {
            return;
        }
        Object object = event.getSource();
        if (object == this.vbar) {
            p.x = origin.x;
            int sign = -1;
            if (!this.negativeYScrolling) {
                sign = 1;
            }
            p.y = sign * this.vbar.getValue();
            if (this.rowHeader != null) {
                Point p2 = this.rowHeader.getViewPosition();
                p2.y = this.vbar.getValue();
                this.rowHeader.setViewPosition(p2);
            }
        } else if (object == this.hbar) {
            p.x = this.hbar.getValue();
            p.y = origin.y;
        }
        this.viewer.setOrigin(p, object == this.hbar, object == this.vbar);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("resize")) {
            this.manageViewport();
        } else if (name.equals("adjustXValue")) {
            if (this.hbar != null) {
                int value = (Integer)evt.getNewValue();
                this.hbar.removeAdjustmentListener(this);
                this.hbar.setValue(value);
                this.hbar.addAdjustmentListener(this);
            }
        } else if (name.equals("adjustYValue") && this.vbar != null) {
            int value = (Integer)evt.getNewValue();
            this.vbar.removeAdjustmentListener(this);
            this.vbar.setValue(value);
            this.vbar.addAdjustmentListener(this);
        }
    }

    public boolean isNegativeYScrolling() {
        return this.negativeYScrolling;
    }

    public void setNegativeYScrolling(boolean negativeYScrolling) {
        this.negativeYScrolling = negativeYScrolling;
    }
}

