/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

public class NLDRect {
    int left = 0;
    int top = 0;
    int right = 0;
    int bottom = 0;

    public NLDRect() {
        this.bottom = 0;
        this.right = 0;
        this.top = 0;
        this.left = 0;
    }

    public NLDRect(NLDRect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public NLDRect(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public NLDRect(double startX, double startY, double width, double height) {
        this.left = (int)startX;
        this.top = (int)startY;
        this.right = (int)(startX + width);
        this.bottom = (int)(startY + height);
    }

    public void inflateRect(int x, int y) {
        this.left -= x;
        this.right += x;
        this.top -= y;
        this.bottom += y;
    }

    public void unionRect(NLDRect box) {
        if (box.left < this.left) {
            this.left = box.left;
        }
        if (box.right > this.right) {
            this.right = box.right;
        }
        if (box.top < this.top) {
            this.top = box.top;
        }
        if (box.bottom > this.bottom) {
            this.bottom = box.bottom;
        }
    }

    public int width() {
        return this.right - this.left;
    }

    public int height() {
        return this.bottom - this.top;
    }
}

