/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.j2d.CompositeTextRectangle;
import com.sas.graphics.util.j2d.CompoundedText;
import com.sas.graphics.util.nld.NLDObject;
import com.sas.graphics.util.nld.NLDViewer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.util.StringTokenizer;
import java.util.Vector;

public class NLDNode
extends NLDObject
implements Comparable {
    static String newLine = "\n";
    static boolean horzMajor = true;
    Color borderColor = Color.black;
    int halign = 1;
    int valign = 1;
    static double sizefac = 1.0;
    static int selectBorderWidth = 3;
    String id;
    String parent;
    boolean hasChildren = false;
    String action;
    double size = -1.0;
    double height;
    public double userHeight = -1.0;
    int type;
    Color localTextColor = null;
    public Vector splitVars = null;
    public Vector varXMLs = null;
    double xpos;
    double ypos;
    double orgXpos;
    double orgYpos;
    int level = 1;
    Image image = null;
    String imgstr = null;
    Vector imList = null;
    int imID;
    Image icon = null;
    String iconstr = null;
    Vector iconList = null;
    int iconID;
    private double iconWidth = 0.0;
    private double iconHeight = 0.0;
    public int moveToCenter = 0;
    String urlStr;
    boolean hideSubtree = false;
    boolean orgHideSubtree = false;
    String jspStr = null;
    double handleSize = 0.0;
    double handleX;
    double handleY;
    boolean handle = false;
    private double tempSize;
    private int minNumLines = 0;
    private int maxNumLines = -1;
    private boolean drawIcon = true;
    private boolean inFocus = false;
    boolean setup = false;
    private double handleYOffset = Double.NaN;
    private Image expandIcon = null;
    private Image collapseIcon = null;
    private double sFacX = 1.0;
    private double sFacY = 1.0;

    public NLDNode() {
        this.size = -1.0;
        this.height = -1.0;
        this.type = NLDViewer.DEFAULT_SHAPE_TYPE;
    }

    public NLDNode(double x, double y) {
        this();
        this.xpos = this.orgXpos = x;
        this.ypos = this.orgYpos = y;
    }

    public NLDNode(NLDNode n) {
        super(n);
        this.id = n.id;
        this.size = n.size;
        this.tempSize = n.tempSize;
        this.height = n.height;
        this.type = n.type;
        this.xpos = n.xpos;
        this.ypos = n.ypos;
        this.orgXpos = n.orgXpos;
        this.orgYpos = n.orgYpos;
        this.moveToCenter = n.moveToCenter;
        this.urlStr = n.urlStr;
        this.hideSubtree = n.hideSubtree;
        this.handleX = n.handleX;
        this.handleY = n.handleY;
        this.handle = n.handle;
        this.localTextColor = n.localTextColor;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    void reset() {
        this.xpos = this.orgXpos;
        this.ypos = this.orgYpos;
    }

    void resetHideSubtree() {
        this.hideSubtree = this.orgHideSubtree;
    }

    @Override
    public void analyseLabel() {
        if (this.mlabel == null) {
            int index = this.label.indexOf("\\n");
            while (index == 0 && this.label.length() >= 2) {
                this.label = this.label.substring(2);
                index = this.label.indexOf("\\n");
            }
            int idx2 = this.label.lastIndexOf("\\n");
            while (this.label.length() > 2 && this.label.length() - 2 == idx2) {
                this.label = this.label.substring(0, this.label.length() - 2);
                idx2 = this.label.lastIndexOf("\\n");
            }
            if (index != -1) {
                StringBuffer sb = new StringBuffer();
                int len = this.label.length();
                int prevIndex = 0;
                while (index != -1) {
                    if (this.label.charAt(index - 1) == '\\') {
                        sb.append(this.label.substring(prevIndex, index - 1));
                    } else {
                        sb.append(this.label.substring(prevIndex, index));
                    }
                    prevIndex = index + 2;
                    if (prevIndex < len) {
                        sb.append(newLine);
                        index = this.label.indexOf("\\n", prevIndex);
                        continue;
                    }
                    index = -1;
                }
                if (prevIndex < len) {
                    sb.append(this.label.substring(prevIndex, len));
                }
                this.label = new String(sb);
            }
        } else {
            this.numLines = this.mlabel.size();
            StringBuffer sb = new StringBuffer();
            sb.append((String)this.mlabel.elementAt(0));
            for (int i = 1; i < this.numLines; ++i) {
                sb.append(newLine + (String)this.mlabel.elementAt(i));
            }
            this.label = new String(sb);
        }
    }

    @Override
    public void analyseInfo() {
        if (this.minfo == null) {
            int index = this.info.indexOf("\\n");
            while (index == 0 && this.info.length() >= 2) {
                this.info = this.info.substring(2);
                index = this.info.indexOf("\\n");
            }
            int idx2 = this.info.lastIndexOf("\\n");
            while (this.info.length() > 2 && this.info.length() - 2 == idx2) {
                this.info = this.info.substring(0, this.info.length() - 2);
                idx2 = this.info.lastIndexOf("\\n");
            }
            if (index != -1) {
                this.minfo = new Vector();
                int len = this.info.length();
                int prevIndex = 0;
                while (index != -1) {
                    if (this.info.charAt(index - 1) == '\\') {
                        this.minfo.addElement(this.info.substring(prevIndex, index - 1));
                    } else {
                        this.minfo.addElement(this.info.substring(prevIndex, index));
                    }
                    prevIndex = index + 2;
                    if (prevIndex < len) {
                        index = this.info.indexOf("\\n", prevIndex);
                        continue;
                    }
                    index = -1;
                }
                if (prevIndex < len) {
                    this.minfo.addElement(this.info.substring(prevIndex, len));
                }
            }
        } else {
            int num = this.minfo.size();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < num; ++i) {
                sb.append((String)this.minfo.elementAt(i) + newLine);
            }
            this.info = new String(sb);
        }
    }

    public void setPosition(double x, double y) {
        this.xpos = this.orgXpos = x;
        this.ypos = this.orgYpos = y;
    }

    public void setCurPosition(double x, double y) {
        this.xpos = x;
        this.ypos = y;
    }

    public void setXPosition(double x) {
        this.xpos = this.orgXpos = x;
    }

    public double getXPosition() {
        return this.orgXpos;
    }

    public void setOrgXPosition(double x) {
        this.orgXpos = x;
    }

    public void setOrgYPosition(double y) {
        this.orgYpos = y;
    }

    public void setYPosition(double y) {
        this.ypos = this.orgYpos = y;
    }

    public double getYPosition() {
        return this.orgYpos;
    }

    public void setCurXPosition(double x) {
        this.xpos = x;
    }

    public double getCurXPosition() {
        return this.xpos;
    }

    public void setCurYPosition(double y) {
        this.ypos = y;
    }

    public double getCurYPosition() {
        return this.ypos;
    }

    public void resetSize() {
        this.setup = false;
        this.size = -1.0;
        this.height = 0.0;
        this.handleSize = 0.0;
        this.handleY = 0.0;
        this.handleX = 0.0;
    }

    public synchronized void build(ChannelLite channel, int handleType, int iconType, int texthalign, int textvalign, double w, double h, double zoomVal) {
        double y;
        double x;
        int border;
        if (this.hide) {
            return;
        }
        double minDim = Math.min(w, h);
        this.setScaleFactor(minDim * zoomVal / w, minDim * zoomVal / h);
        channel.glTextAlign(texthalign, textvalign);
        channel.glRectAlign(this.halign, this.valign);
        this.tempSize = this.size * sizefac;
        if (!this.setup) {
            this.doSetup(channel, handleType, iconType);
        }
        if (this.moveToCenter != 0) {
            this.doCenterMove();
        }
        if (handleType == 2 && this.handle) {
            channel.glLoadName((Object)("H" + this.index));
            this.buildHandle(channel, iconType);
        }
        channel.glLoadName((Object)("N" + this.index));
        if (iconType == 2) {
            if (this.icon != null) {
                border = channel.getBorderType();
                channel.setBorderType(0);
                x = this.xpos - this.tempSize * this.sFacX / 2.0 - this.iconWidth / 2.0 - 4.0;
                y = this.ypos;
                channel.glImage(this.icon, x, y);
                channel.setBorderType(border);
            } else if (this.iconList != null) {
                border = channel.getBorderType();
                channel.setBorderType(0);
                x = this.xpos - this.tempSize * this.sFacX / 2.0 - this.iconWidth;
                y = this.ypos;
                channel.glImage(this.iconList, this.iconID, x, y);
                channel.setBorderType(border);
            }
        }
        if (this.color == null) {
            this.color = Color.white;
        }
        switch (this.type) {
            case 0: {
                this.buildSquare(channel);
                break;
            }
            case 5: {
                this.buildImage(channel);
                break;
            }
            case 1: {
                this.buildCircle(channel);
                break;
            }
            case 2: {
                this.buildTriangle(channel);
                break;
            }
            case 3: {
                this.buildDiamond(channel);
                break;
            }
        }
        if (iconType == 1 && this.type != 8) {
            if (this.icon != null) {
                border = channel.getBorderType();
                channel.setBorderType(0);
                x = this.xpos - this.size / 2.0 + this.iconWidth / 2.0 + 4.0;
                y = this.ypos;
                channel.glImage(this.icon, x, y);
                channel.setBorderType(border);
            } else if (this.iconList != null) {
                border = channel.getBorderType();
                channel.setBorderType(0);
                x = this.xpos - this.size / 2.0 + this.iconWidth / 2.0 + 4.0;
                y = this.ypos;
                channel.glImage(this.iconList, this.iconID, x, y);
                channel.setBorderType(border);
            }
        }
    }

    private void doSetup(ChannelLite channel, int handleType, int iconType) {
        if (channel == null) {
            return;
        }
        if (this.icon != null && this.iconWidth == 0.0) {
            this.iconWidth = channel.glGetImageWidth(this.icon);
            this.iconHeight = channel.glGetImageHeight(this.icon);
            while (this.iconWidth < 0.0) {
                try {
                    Thread.sleep(100L);
                    this.iconWidth = channel.glGetImageWidth(this.icon);
                    this.iconHeight = channel.glGetImageHeight(this.icon);
                }
                catch (InterruptedException e) {
                    this.iconHeight = this.iconWidth = channel.glGetTextHeight() + 4.0;
                }
            }
        } else if (iconType != 0 && this.iconstr != null) {
            this.iconHeight = this.iconWidth = channel.glGetTextHeight() + 4.0;
        }
        if (this.expandIcon != null) {
            this.waitForImageLoad(channel, this.expandIcon);
        }
        if (this.collapseIcon != null) {
            this.waitForImageLoad(channel, this.collapseIcon);
        }
        Font saveFont = null;
        if (this.size <= 0.0) {
            if (this.font != null) {
                saveFont = channel.glGetFont();
                channel.glSelect2DFont(this.font);
            }
            this.tempSize = handleType == 1 ? (this.size = channel.glGetTextWidth(" +" + this.label) + (double)(2 * selectBorderWidth)) : (this.size = channel.glGetTextWidth("  " + this.label) + (double)(2 * selectBorderWidth));
            if (iconType == 1) {
                this.size = this.tempSize = this.size + (this.drawIcon ? Math.min(this.iconWidth, 24.0) + 4.0 : 0.0);
            }
            if (this.height <= 0.0) {
                double fsize = this.handleSize;
                if (fsize == 0.0) {
                    fsize = channel.glGetTextHeight();
                }
                if (this.userHeight > 0.0) {
                    this.height = fsize * this.userHeight;
                } else {
                    if (this.label != null && this.numLines == 1) {
                        StringTokenizer st = new StringTokenizer(this.label, "\n");
                        this.numLines = st.countTokens();
                    }
                    this.numLines = Math.max(this.numLines, this.minNumLines);
                    if (this.maxNumLines > 0) {
                        this.numLines = Math.min(this.numLines, this.maxNumLines);
                    }
                    this.height = (1.0 * (double)this.numLines + 0.5) * fsize;
                    this.height = Math.max(this.height, Math.min(this.iconHeight, 24.0));
                }
            }
        } else if (this.height <= 0.0) {
            this.height = this.tempSize;
        }
        if (iconType == 1 && this.iconHeight <= 24.0) {
            this.height = Math.max(this.height, this.iconHeight);
        }
        if (handleType == 2 && this.handleSize == 0.0) {
            if (this.font != null && saveFont == null) {
                saveFont = channel.glGetFont();
                channel.glSelect2DFont(this.font);
            }
            this.handleSize = 0.8 * channel.glGetTextHeight();
        }
        if (saveFont != null) {
            channel.glSelect2DFont(saveFont);
        }
        this.setup = true;
    }

    private void doCenterMove() {
        double iw = this.iconWidth;
        if (this.type == 8) {
            iw = this.icon == null ? 24.0 : Math.min(this.iconWidth, 24.0);
        }
        switch (this.moveToCenter) {
            default: {
                break;
            }
            case 1: {
                this.orgXpos = this.xpos = this.orgXpos + iw + this.size / 2.0;
                break;
            }
            case 3: {
                this.orgXpos = this.xpos = this.orgXpos - this.size / 2.0;
                break;
            }
            case 2: {
                this.orgYpos = this.ypos = this.orgYpos + this.height / 2.0;
                break;
            }
            case 4: {
                this.orgYpos = this.ypos = this.orgYpos - this.height / 2.0;
            }
        }
        this.moveToCenter = 0;
    }

    private void waitForImageLoad(ChannelLite channel, Image icon) {
        if (icon != null) {
            double iw = channel.glGetImageWidth(icon);
            double ih = channel.glGetImageHeight(icon);
            while (iw < 0.0) {
                try {
                    Thread.sleep(100L);
                    iw = channel.glGetImageWidth(icon);
                    ih = channel.glGetImageHeight(icon);
                }
                catch (InterruptedException e) {
                    iw = channel.glGetTextHeight() + 4.0;
                    ih = this.iconWidth;
                }
            }
        }
    }

    double[] arrowTip(ChannelLite channel, double x1, double y1, double xfac, double yfac) {
        double tx = this.xpos;
        double ty = this.ypos;
        this.setScaleFactor(xfac, yfac);
        this.tempSize = sizefac * this.size;
        double xShift = this.tempSize * this.sFacX / 2.0;
        double yShift = this.tempSize * this.sFacY / 2.0;
        switch (this.type) {
            case 0: 
            case 5: {
                ty = y1 <= this.ypos ? this.ypos - yShift : this.ypos + yShift;
                if (x1 <= this.xpos) {
                    tx = this.xpos - xShift;
                    break;
                }
                tx = this.xpos + xShift;
                break;
            }
            case 1: {
                double dx = this.xpos - x1;
                double dy = this.ypos - y1;
                double ang = Math.atan2(dy, dx);
                double rad = Math.sqrt(dx * dx + dy * dy);
                double radX = rad - this.tempSize * this.sFacX / 2.0;
                double radY = rad - this.tempSize * this.sFacY / 2.0;
                if (rad < 0.0) {
                    rad = 0.0;
                }
                dx = radX * Math.cos(ang);
                dy = radY * Math.sin(ang);
                tx = x1 + dx;
                ty = y1 + dy;
                break;
            }
            case 2: {
                if (x1 <= this.xpos) {
                    if (y1 <= this.ypos) {
                        tx = this.xpos - xShift;
                        ty = this.ypos - yShift;
                        break;
                    }
                    tx = this.xpos - xShift / 2.0;
                    ty = this.ypos;
                    break;
                }
                if (y1 <= this.ypos) {
                    tx = this.xpos + xShift;
                    ty = this.ypos - yShift;
                    break;
                }
                tx = this.xpos + xShift / 2.0;
                ty = this.ypos;
                break;
            }
            case 3: {
                if (x1 <= this.xpos) {
                    if (y1 <= this.ypos) {
                        tx = this.xpos - xShift / 2.0;
                        ty = this.ypos - yShift / 2.0;
                        break;
                    }
                    tx = this.xpos - xShift / 2.0;
                    ty = this.ypos + yShift / 2.0;
                    break;
                }
                if (y1 <= this.ypos) {
                    tx = this.xpos + xShift / 2.0;
                    ty = this.ypos - yShift / 2.0;
                    break;
                }
                tx = this.xpos + xShift / 2.0;
                ty = this.ypos + yShift / 2.0;
                break;
            }
            case 4: {
                double halfTextWidth;
                double halfTextHeight;
                yShift = halfTextHeight = channel.glGetTextHeight(this.label) / 2.0;
                ty = y1 <= this.ypos ? this.ypos - yShift : this.ypos + yShift;
                xShift = halfTextWidth = channel.glGetTextWidth(this.label) / 2.0;
                if (x1 <= this.xpos) {
                    tx = this.xpos - xShift;
                    break;
                }
                tx = this.xpos + xShift;
                break;
            }
        }
        double[] tip = new double[]{tx, ty};
        return tip;
    }

    private void buildSquare(ChannelLite channel) {
        channel.glColor(this.color);
        if (this.selected) {
            channel.glLineWidth(3.0f);
            channel.lineCapStyle(1);
        } else {
            channel.glLineWidth(1.0f);
        }
        channel.glBegin(2);
        double xShift = this.tempSize * this.sFacX / 2.0;
        double yShift = this.tempSize * this.sFacY / 2.0;
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(this.xpos - xShift, this.ypos - yShift);
        channel.glVertex(this.xpos - xShift, this.ypos + yShift);
        channel.glVertex(this.xpos + xShift, this.ypos + yShift);
        channel.glVertex(this.xpos + xShift, this.ypos - yShift);
        if (this.selected) {
            channel.glVertex(this.xpos - xShift, this.ypos - yShift);
        }
        channel.glEnd();
    }

    private void buildImage(ChannelLite channel) {
        int border = 0;
        Color edge = null;
        if (this.selected) {
            border = channel.getBorderType();
            edge = channel.getEdgeColor();
            channel.setBorderType(1);
            channel.glLineWidth((float)selectBorderWidth);
            channel.glEdgeColor(this.color);
        }
        channel.glColor(this.color);
        if (this.image != null) {
            channel.glImage(this.image, this.xpos, this.ypos, !this.selected);
        } else if (this.imList != null) {
            channel.glImage(this.imList, this.imID, this.xpos, this.ypos, !this.selected);
        } else {
            channel.glRectangle(this.xpos, this.ypos, this.size, this.height, !this.selected);
        }
        if (this.selected) {
            channel.setBorderType(border);
            channel.glEdgeColor(edge);
            channel.glLineWidth(1.0f);
        }
    }

    private void buildHandle(ChannelLite channel, int iconType) {
        double y;
        double y1;
        double y2;
        double x;
        double x1;
        double x2;
        if (Double.isNaN(this.handleYOffset)) {
            this.handleYOffset = this.height / 2.0;
        }
        if (this.handleX == 0.0) {
            x1 = x2 = this.xpos;
            x = x2;
        } else if (this.handleX > 0.0) {
            x = this.xpos + this.size / 2.0 + this.handleX;
            x1 = x - this.handleSize;
            x2 = x - this.handleSize / 2.0;
        } else {
            x = iconType == 2 ? this.xpos + this.handleX - this.size / 2.0 - this.iconWidth - 4.0 : this.xpos + this.handleX - this.size / 2.0;
            x1 = x + this.handleSize;
            x2 = x + this.handleSize / 2.0;
        }
        if (this.handleY == 0.0) {
            y1 = y2 = this.ypos;
            y = y2;
        } else if (this.handleY > 0.0) {
            y = this.ypos + this.handleY + this.handleYOffset;
            y1 = y - this.handleSize;
            y2 = y - this.handleSize / 2.0;
            y2 = y;
            y1 = y;
        } else {
            y = this.ypos + this.handleY - this.handleYOffset;
            y1 = y + this.handleSize;
            y2 = y + this.handleSize / 2.0;
            y2 = this.ypos;
        }
        int borderType = channel.getBorderType();
        channel.setBorderType(0);
        if (this.localTextColor != null) {
            channel.glColor(this.localTextColor);
        } else if (this.textColor == Color.black && this.type != 8) {
            float[] hsb = new float[3];
            hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), hsb);
            if ((double)hsb[2] < 0.4) {
                channel.setTextColor(this.textColor);
            } else {
                channel.setTextColor(Color.white);
            }
        } else {
            channel.glColor(this.textColor);
        }
        x1 = x - this.handleSize / 2.0;
        x2 = x + this.handleSize / 2.0;
        y1 = y - this.handleSize / 2.0;
        y2 = y + this.handleSize / 2.0;
        int mode = channel.getPolygonMode();
        channel.glPolygonMode(4);
        Color edge = channel.getEdgeColor();
        channel.glEdgeColor(Color.gray);
        channel.glColor(Color.white);
        channel.glEdgeColor(edge);
        int textType = channel.getTextBorderType();
        Font saveFont = channel.glGetFont();
        channel.setTextBorderType(0);
        channel.glColor(Color.black);
        if (this.hideSubtree) {
            if (this.expandIcon != null) {
                channel.glImage(this.expandIcon, x, y);
            } else {
                channel.setTextColor(this.textColor);
                channel.glSelect2DFont(new Font("Dialog", 0, (int)(1.25 * this.handleSize)));
                channel.glTextAlign(1, 1);
                channel.gl2DText("+", x, y, true);
            }
        } else if (this.collapseIcon != null) {
            channel.glImage(this.collapseIcon, x, y);
        } else {
            channel.setTextColor(this.textColor);
            channel.glSelect2DFont(new Font("Dialog", 0, (int)(1.4 * this.handleSize)));
            channel.glTextAlign(1, 1);
            channel.gl2DText("-", x, y + 0.15 * this.handleSize, true);
        }
        channel.setBorderType(borderType);
        channel.setTextBorderType(textType);
        if (saveFont != null) {
            channel.glSelect2DFont(saveFont);
        }
    }

    private void buildDiamond(ChannelLite channel) {
        channel.glColor(this.color);
        if (this.selected) {
            channel.glLineWidth(3.0f);
            channel.lineCapStyle(1);
        } else {
            channel.glLineWidth(1.0f);
        }
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        double xShift = this.tempSize * this.sFacX / 2.0;
        double yShift = this.tempSize * this.sFacY / 2.0;
        channel.glVertex(this.xpos, this.ypos - yShift);
        channel.glVertex(this.xpos + xShift, this.ypos);
        channel.glVertex(this.xpos, this.ypos + yShift);
        channel.glVertex(this.xpos - xShift, this.ypos);
        if (this.selected) {
            channel.glVertex(this.xpos, this.ypos - yShift);
        }
        channel.glEnd();
    }

    private void buildTriangle(ChannelLite channel) {
        channel.glColor(this.color);
        if (this.selected) {
            channel.glLineWidth(3.0f);
            channel.lineCapStyle(1);
        } else {
            channel.glLineWidth(1.0f);
        }
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        double xShift = this.tempSize * this.sFacX / 2.0;
        double yShift = this.tempSize * this.sFacY / 2.0;
        channel.glVertex(this.xpos - xShift, this.ypos - yShift);
        channel.glVertex(this.xpos, this.ypos + yShift);
        channel.glVertex(this.xpos + xShift, this.ypos - yShift);
        if (this.selected) {
            channel.glVertex(this.xpos - xShift, this.ypos - yShift);
        }
        channel.glEnd();
    }

    private void buildCircle(ChannelLite channel) {
        channel.glColor(this.color);
        if (this.selected) {
            channel.glLineWidth(3.0f);
            channel.lineCapStyle(1);
        } else {
            channel.glLineWidth(1.0f);
        }
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        double radX = this.tempSize * this.sFacX / 2.0;
        double radY = this.tempSize * this.sFacY / 2.0;
        int numangs = 60;
        double angle = 0.0;
        double ainc = Math.PI * 2 / (double)numangs;
        for (int i = 0; i < numangs; ++i) {
            channel.glVertex(this.xpos + radX * Math.cos(angle += ainc), this.ypos + radY * Math.sin(angle), 0.0);
        }
        if (this.selected) {
            ainc = Math.PI * 2 / (double)numangs;
            channel.glVertex(this.xpos + radX * Math.cos(ainc), this.ypos + radY * Math.sin(ainc), 0.0);
        }
        channel.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildLabel(ChannelLite channel, int handleType, int iconType, int texthalign, int textvalign, double cW, double cH, double zoomVal) {
        double xx;
        double yy;
        if (this.label == null) {
            this.label = this.getID();
        }
        if (this.label == null) {
            return;
        }
        double minDim = Math.min(cW, cH);
        this.setScaleFactor(minDim * zoomVal / cW, minDim * zoomVal / cH);
        switch (textvalign) {
            case 0: {
                yy = this.ypos - this.tempSize * this.sFacY / 2.0;
                break;
            }
            default: {
                yy = this.ypos;
                break;
            }
            case 3: {
                yy = this.ypos + this.tempSize * this.sFacY / 2.0;
            }
        }
        switch (texthalign) {
            case 0: {
                xx = this.xpos + this.tempSize * this.sFacY / 2.0;
                break;
            }
            default: {
                xx = this.xpos;
                break;
            }
            case 2: {
                xx = this.xpos - this.tempSize * this.sFacY / 2.0;
            }
        }
        ChannelLite channelLite = channel;
        synchronized (channelLite) {
            CompoundedText rt;
            Font saveFont = null;
            if (this.font != null) {
                saveFont = channel.glGetFont();
                channel.glSelect2DFont(this.font);
            }
            if (iconType == 1) {
                xx += this.iconWidth / 2.0 + 4.0;
            }
            channel.glLoadName((Object)("N" + this.index));
            channel.glColor(this.color);
            int w = this.selected ? selectBorderWidth : 1;
            boolean shapeIcon = false;
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    shapeIcon = true;
                    break;
                }
                default: {
                    shapeIcon = false;
                }
            }
            if (this.localTextColor != null) {
                channel.setTextColor(this.localTextColor);
            } else if (!shapeIcon && this.type != 8 && this.textColor.getRGB() == -16777216) {
                float[] hsb = new float[3];
                hsb = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), hsb);
                if ((double)hsb[2] > 0.6666) {
                    channel.setTextColor(this.textColor);
                } else {
                    channel.setTextColor(Color.white);
                }
            } else {
                channel.setTextColor(this.textColor);
            }
            channel.setTextBorderColor(this.borderColor);
            channel.glTextAlign(texthalign, textvalign);
            if (this.type == 6 || this.type == 7) {
                rt = channel.glRectangleText(this.label, xx, yy, this.size, this.height, true);
                if (this.hideSubtree && handleType == 1) {
                    rt.setHandleVisible(true);
                }
                if (this.selected) {
                    rt.setBorderColor(this.selectColor);
                    rt.setBorderWidth(w);
                }
            } else if (this.type == 8) {
                CompositeTextRectangle cr = channel.glCompositeText(this.label, this.xpos, this.ypos, this.size, this.height, this.icon, true);
                cr.setInFocus(this.inFocus);
                cr.setDrawIcon(this.drawIcon);
                cr.setMaxNumLines(this.maxNumLines);
                cr.setBorderColor(this.borderColor);
                cr.setSelected(this.selected);
                cr.setColor(this.color);
                if (this.selected) {
                    cr.setSelectColor(this.selectColor);
                    cr.setBorderWidth(w);
                }
            } else {
                rt = channel.gl2DText(this.label, xx, yy, true);
                double ht = this.userHeight > 0.0 ? this.userHeight : 1.0;
                rt.setBorderHeight(ht);
                rt.setBorderWidth(w);
                if (this.hideSubtree && handleType == 1) {
                    rt.setHandleVisible(true);
                }
                if (this.selected) {
                    rt.setBorderColor(this.borderColor);
                }
            }
            if (this.font != null) {
                channel.glSelect2DFont(saveFont);
            }
        }
    }

    void displayPos(ChannelLite channel) {
        System.out.println("In World -- x: " + this.xpos + ", y: " + this.ypos);
        double[] world = new double[]{this.xpos, this.ypos};
        double[] screen = new double[2];
        channel.gluProject(world, screen);
        System.out.println("In Screen -- x: " + screen[0] + ", y: " + screen[1]);
    }

    public double[] getHandlePosition(ChannelLite channel, int iconType) {
        double deltaY;
        double[] pos = new double[2];
        if (!this.setup) {
            this.doSetup(channel, 2, iconType);
        }
        if (Double.isNaN(this.handleYOffset)) {
            this.handleYOffset = this.height / 2.0;
        }
        if (this.moveToCenter != 0) {
            this.doCenterMove();
        }
        double deltaX = this.handle ? this.handleX : 0.0;
        double d = deltaY = this.handle ? this.handleY : 0.0;
        pos[0] = this.handleX == 0.0 && this.type != 8 ? this.xpos : (this.handleX > 0.0 ? this.xpos + this.size / 2.0 + deltaX : (iconType == 2 ? this.xpos + deltaX - this.size / 2.0 - this.iconWidth - 4.0 : this.xpos + deltaX - this.size / 2.0));
        pos[1] = this.handleY == 0.0 ? this.ypos : (this.handleY > 0.0 ? this.ypos + deltaY + this.handleYOffset : this.ypos + deltaY - this.handleYOffset);
        return pos;
    }

    public double[] getSize(ChannelLite channel, int handleType) {
        return this.getSize(channel, handleType, 0);
    }

    public double[] getSize(ChannelLite channel, int handleType, int iconType) {
        if (!this.setup) {
            this.doSetup(channel, handleType, iconType);
        }
        double[] dim = new double[]{this.size, this.height};
        return dim;
    }

    void setSize(double w, double h) {
        this.height = h;
        this.size = w;
    }

    double[] getIconSize(ChannelLite channel) {
        if (this.icon != null && this.iconWidth == 0.0) {
            this.iconWidth = channel.glGetImageWidth(this.icon);
            this.iconHeight = channel.glGetImageHeight(this.icon);
        }
        double[] dim = new double[]{this.iconWidth, this.iconHeight};
        return dim;
    }

    public double[] getLocation(ChannelLite channel, int handleType, int iconType) {
        double[] pos = new double[2];
        if (!this.setup) {
            this.doSetup(channel, handleType, iconType);
        }
        if (this.moveToCenter != 0) {
            this.doCenterMove();
        }
        pos[0] = this.xpos;
        pos[1] = this.ypos;
        return pos;
    }

    public void setAction(String actionStr) {
        this.action = actionStr;
    }

    public String getAction() {
        return this.action;
    }

    public void setID(String idStr) {
        this.id = idStr;
    }

    public String getID() {
        return this.id;
    }

    public void setParent(String idStr) {
        this.parent = idStr;
    }

    public String getParent() {
        return this.parent;
    }

    public void setUrl(String url) {
        this.urlStr = url;
    }

    public String getUrl() {
        return this.urlStr;
    }

    public void setImage(String str) {
        this.imgstr = str;
        this.image = null;
        this.imID = -1;
    }

    public void setImage(Image img) {
        this.image = img;
    }

    public Image getImage() {
        return this.image;
    }

    public void setIcon(String str) {
        this.iconstr = str;
        this.icon = null;
        this.iconID = -1;
    }

    public void setIcon(Image img) {
        this.icon = img;
    }

    public Image getIcon() {
        return this.icon;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color newColor) {
        this.borderColor = newColor;
    }

    public void setCollapsed(boolean collapse) {
        this.hideSubtree = collapse;
    }

    public boolean isCollapsed() {
        return this.hideSubtree;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public int getType() {
        return this.type;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double ht) {
        this.height = ht;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double sz) {
        this.size = sz;
    }

    public boolean isHandleVisible() {
        return this.handle;
    }

    public void setHandleVisible(boolean visible) {
        this.handle = visible;
    }

    public boolean isDeleted() {
        return this.id == null;
    }

    public void setHandle(boolean flag) {
        this.handle = flag;
    }

    public boolean getHandle() {
        return this.handle;
    }

    public void setSplitVars(Vector newList) {
        this.splitVars = newList;
    }

    public Vector getSplitVars() {
        return this.splitVars;
    }

    public void setVarXMLs(Vector newList) {
        this.varXMLs = newList;
    }

    public Vector getVarXMLs() {
        return this.varXMLs;
    }

    public int compareTo(Object obj) {
        if (obj instanceof NLDNode) {
            NLDNode n = (NLDNode)obj;
            return this.index - n.getIndex();
        }
        return this.hashCode() - obj.hashCode();
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public void setExpandIcon(Image icon) {
        this.expandIcon = icon;
    }

    public void setCollapseIcon(Image icon) {
        this.collapseIcon = icon;
    }

    public void setMinNumLines(int minNumLines) {
        this.minNumLines = minNumLines;
    }

    public void setMaxNumLines(int maxNumLines) {
        this.maxNumLines = maxNumLines;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public void setDrawIcon(boolean drawIcon) {
        this.drawIcon = drawIcon;
    }

    public boolean isInFocus() {
        return this.inFocus;
    }

    public void setInFocus(boolean inFocus) {
        this.inFocus = inFocus;
    }

    public void setScaleFactor(double xfac, double yfac) {
        this.sFacX = xfac;
        this.sFacY = yfac;
    }

    public double getHandleYOffset() {
        return this.handleYOffset;
    }

    public void setHandleYOffset(double handleYOffset) {
        this.handleYOffset = handleYOffset;
    }
}

