/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NLDMouseFrame
extends Frame
implements WindowListener {
    protected boolean useRBSizing = true;
    protected int width = 250;
    protected int height = 250;
    protected String title;
    protected String[] text;
    protected ResourceBundle rb = null;

    public NLDMouseFrame(ResourceBundle rbIn, String title, String[] text, boolean useRBSizingIn) {
        super(title);
        Rectangle r = null;
        this.useRBSizing = useRBSizingIn;
        this.rb = rbIn;
        this.title = title == null ? "SAS Institute, Inc." : new String(title);
        this.text = text;
        this.addWindowListener(this);
        r = this.getRBBounds(this.rb, "MouseDialog.size", 1, 1, this.width, this.height);
        if (r != null) {
            this.width = r.width;
            this.height = r.height;
        }
        this.setSize(this.width, this.height);
    }

    public NLDMouseFrame(String title, String[] text) {
        this(null, title, text, true);
    }

    protected Rectangle getRBBounds(ResourceBundle rb, String name, int x, int y, int width, int height) {
        String s = this.GRS(rb, name, null);
        Rectangle rect = new Rectangle(x, y, width, height);
        if (s == null || rect == null || !this.useRBSizing) {
            return rect;
        }
        try {
            int i;
            if (name.endsWith(".bounds")) {
                i = s.indexOf(",");
                rect.x = Integer.valueOf(s.substring(0, i));
                if (rect.x == -1) {
                    rect.x = x;
                }
                s = s.substring(i + 1);
                i = s.indexOf(",");
                rect.y = Integer.valueOf(s.substring(0, i));
                if (rect.y == -1) {
                    rect.y = y;
                }
                s = s.substring(i + 1);
            }
            i = s.indexOf(",");
            rect.width = Integer.valueOf(s.substring(0, i));
            if (rect.width == -1) {
                rect.width = width;
            }
            s = s.substring(i + 1);
            rect.height = Integer.valueOf(s);
            if (rect.height == -1) {
                rect.height = height;
            }
        }
        catch (NumberFormatException e) {
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
        }
        return rect;
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            System.err.println("Resource '" + name + "' not found. Using default value.");
            System.err.flush();
            s = null;
        }
        if (s == null) {
            System.err.println("Resource '" + name + "' not found. Using default value.");
            System.err.flush();
            s = defStrg;
        }
        return s;
    }

    @Override
    public void paint(Graphics g) {
        int x = 0;
        int curWidth = this.width;
        int curHeight = this.height;
        FontMetrics fm = g.getFontMetrics();
        Color c = null;
        Color bColor = null;
        Color fColor = null;
        int maxDescent = fm.getMaxDescent();
        int maxAscent = fm.getMaxAscent();
        Dimension d = this.getSize();
        Insets is = this.getInsets();
        curWidth = d.width - is.left - is.right;
        curHeight = d.height - is.top - is.bottom;
        bColor = this.getBackground();
        fColor = g.getColor();
        if (bColor != null && bColor.equals(fColor)) {
            c = bColor.equals(Color.black) ? Color.white : (bColor.equals(Color.white) ? Color.black : fColor.brighter().brighter());
            g.setColor(c);
        }
        g.clearRect(0, 0, curWidth, curHeight);
        int y = is.top + maxDescent + maxAscent;
        int strgWidth = fm.stringWidth(this.title);
        x = (curWidth - strgWidth) / 2;
        g.drawString(this.title, x, y);
        x = is.left + fm.stringWidth(" ");
        y += 2 * maxDescent + 2 * maxAscent;
        if (this.text != null) {
            for (int i = 0; i < this.text.length; ++i) {
                g.drawString(this.text[i], x, y);
                y += maxDescent + maxAscent;
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }
}

