/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDHierarchyLayout;
import com.sas.graphics.util.nld.NLDLayoutStrategy;
import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Cursor;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Stack;

public abstract class NLDModel {
    protected int arcMask = 7;
    protected boolean hideLinks = false;
    public VectorNodeModel nodes = null;
    public VectorNodeModel handles = null;
    public VectorLinkModel links = null;
    public Stack deletedNodes = new Stack();
    protected NLDViewer viewer;
    protected String action = null;
    protected int chartType = 0;
    protected int shape = NLDViewer.DEFAULT_SHAPE_TYPE;
    protected boolean userAction = false;
    protected ResourceBundle appRB = null;
    protected boolean dupCheck = false;
    protected boolean directed = false;
    protected int numLinks = 0;
    protected int numNodes = 0;
    protected int nodeLabelMode = 1;
    private boolean arrangeFirstTime = true;
    protected boolean doUpdateModel = false;
    Thread animationThread = null;
    private boolean alive = false;
    protected String xmlFile = null;
    protected String xmlParam = null;
    private double error = -1.0;
    private int time = -1;
    protected Hashtable linkTable = null;

    public NLDModel() {
        this.nodes = new VectorNodeModel();
        this.links = new VectorLinkModel();
    }

    public NLDModel(int type) {
        this();
        this.chartType = type;
        this.arrangeFirstTime = true;
        this.doUpdateModel = false;
    }

    public void dispose() {
        if (this.nodes != null) {
            this.nodes.dispose();
        }
        if (this.links != null) {
            this.links.dispose();
        }
        this.viewer = null;
        this.nodes = null;
        this.handles = null;
        this.links = null;
        if (this.deletedNodes != null) {
            this.deletedNodes.clear();
        }
    }

    public void doUpdateModel(boolean flag) {
        this.doUpdateModel = flag;
    }

    public void setViewer(NLDViewer v) {
        this.viewer = v;
    }

    public NLDViewer getViewer() {
        return this.viewer;
    }

    public void setChartType(int type) {
        this.chartType = type;
    }

    public void setDuplicateCheck(boolean flag) {
        this.dupCheck = flag;
    }

    public void setDirected(boolean flag) {
        this.directed = flag;
    }

    public boolean getDirected() {
        return this.directed;
    }

    public void setHideLinks(boolean flag) {
        this.hideLinks = flag;
    }

    public boolean isHideLinks() {
        return this.hideLinks;
    }

    public String getNodeShape() {
        String shapestr = null;
        switch (this.shape) {
            case 4: {
                shapestr = "None";
                break;
            }
            case 0: {
                shapestr = "Square";
                break;
            }
            case 1: {
                shapestr = "Circle";
                break;
            }
            default: {
                shapestr = NLDViewer.DEFAULT_SHAPE_STRING;
                break;
            }
            case 2: {
                shapestr = "Triangle";
                break;
            }
            case 3: {
                shapestr = "Diamond";
                break;
            }
            case 5: {
                shapestr = "Image";
            }
        }
        return shapestr;
    }

    public int getNodeType() {
        return this.shape;
    }

    public void setNodeShape(String shapeStr) {
        this.shape = (shapeStr = shapeStr.trim()).equalsIgnoreCase("circle") ? 1 : (shapeStr.equalsIgnoreCase("triangle") ? 2 : (shapeStr.equalsIgnoreCase("diamond") ? 3 : (shapeStr.equalsIgnoreCase("image") ? 5 : (shapeStr.equalsIgnoreCase("none") ? 4 : (shapeStr.equalsIgnoreCase("square") ? 0 : NLDViewer.DEFAULT_SHAPE_TYPE)))));
    }

    public int getLinksMask() {
        return this.arcMask;
    }

    public void setLinksMask(int mask) {
        this.arcMask = mask;
    }

    public void selectAll() {
        if (this.nodes == null) {
            return;
        }
        this.nodes.setSelectAll(true);
        if (this.handles != null) {
            this.handles.setSelectAll(true);
        }
        if (this.hideLinks) {
            this.updateLinks();
        } else {
            if (this.links == null) {
                return;
            }
            this.links.setShowAll();
        }
    }

    public void reset() {
        if (this.nodes == null) {
            return;
        }
        this.nodes.resetAll();
        this.nodes.setSelectAll(true);
        if (this.handles != null) {
            this.handles.resetAll();
            this.handles.setSelectAll(true);
        }
    }

    public void unselectAll() {
        if (this.nodes == null) {
            return;
        }
        this.nodes.unselectAll(true);
        if (this.handles != null) {
            this.handles.unselectAll(true);
        }
        if (this.links == null) {
            return;
        }
        if (this.hideLinks) {
            boolean hide;
            boolean bl = hide = this.chartType == 1;
            if (!hide) {
                this.links.setShowAll();
            }
        }
    }

    public void deselectAll() {
        if (this.nodes == null) {
            return;
        }
        this.nodes.setSelectAll(false);
        if (this.handles != null) {
            this.handles.setSelectAll(false);
        }
        if (this.links == null) {
            return;
        }
        if (this.hideLinks) {
            boolean hide;
            boolean bl = hide = this.chartType == 1;
            if (!hide) {
                this.links.setShowAll();
            }
        }
    }

    public int getNumNodes() {
        return this.numNodes;
    }

    public int getNumLinks() {
        return this.numLinks;
    }

    public void updateLinks() {
        if (this.links == null) {
            return;
        }
        if (this.hideLinks) {
            if (this.links instanceof VectorLinkModel) {
                for (int i = 0; i < this.links.size(); ++i) {
                    NLDLink a = (NLDLink)this.links.elementAt(i);
                    if (a.from < 0 || a.to < 0) continue;
                    NLDNode f = (NLDNode)this.nodes.elementAt(a.from);
                    NLDNode t = (NLDNode)this.nodes.elementAt(a.to);
                    if (f.hide || t.hide) continue;
                    a.hide = true;
                    if ((this.arcMask & 1) != 0 && !f.selected && t.selected) {
                        a.hide = false;
                    }
                    if ((this.arcMask & 2) != 0 && f.selected && !t.selected) {
                        a.hide = false;
                    }
                    if ((this.arcMask & 4) == 0 || !f.selected || !t.selected) continue;
                    a.hide = false;
                }
            }
        } else {
            this.links.setShowAll();
        }
    }

    public abstract boolean loadModel(NLDViewer var1);

    public abstract boolean loadModel();

    public abstract boolean loadNodePositions();

    public abstract boolean loadLayer(NLDNode var1, int var2);

    public void setAction(String a) {
        this.action = a;
        this.userAction = a != null && !a.equals("");
    }

    public String getAction() {
        return this.action;
    }

    public synchronized void setArrangeFirstTime(boolean flag) {
        this.arrangeFirstTime = flag;
    }

    public synchronized void setLayoutThreadAlive(boolean flag) {
        this.alive = flag;
    }

    public synchronized boolean isLayoutThreadAlive() {
        return this.alive;
    }

    public boolean arrange() {
        if (this.viewer == null) {
            return false;
        }
        if (this.viewer.isEmptyPlot()) {
            return false;
        }
        this.viewer.setPauseLayout(true);
        while (this.isLayoutThreadAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        int type = this.viewer.getLayoutStrategy();
        boolean isHybrid = false;
        switch (type) {
            case 2: {
                isHybrid = true;
            }
            case 1: {
                if (this.viewer.getAnimationFlag() && this.viewer.isAnimating()) {
                    this.viewer.setAnimating(false);
                }
                if (!isHybrid) {
                    NLDHierarchyLayout treeLayout = new NLDHierarchyLayout(this);
                    treeLayout.init();
                    treeLayout.setComponentSpacing(10);
                    treeLayout.apply();
                    break;
                }
                if (this.arrangeFirstTime) {
                    NLDHierarchyLayout treeLayout = new NLDHierarchyLayout(this);
                    treeLayout.init();
                    treeLayout.setComponentSpacing(10);
                    treeLayout.apply();
                    treeLayout.shrinkModelToUnitSpace();
                    this.arrangeFirstTime = false;
                }
                final NLDLayoutStrategy strategy = new NLDLayoutStrategy(this);
                strategy.init(this.arrangeFirstTime);
                final boolean doAnimation = this.viewer.getAnimationFlag();
                if (!doAnimation) {
                    this.viewer.setCursor(Cursor.getPredefinedCursor(3));
                    this.viewer.setPauseLayout(false);
                    this.viewer.setAnimating(false);
                    this.setLayoutThreadAlive(true);
                    strategy.DynamicLayout(this.viewer);
                    this.setLayoutThreadAlive(false);
                    this.viewer.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                this.animationThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NLDModel.this.viewer.setCursor(Cursor.getPredefinedCursor(3));
                        NLDModel.this.viewer.setPauseLayout(false);
                        NLDModel.this.viewer.setAnimating(doAnimation);
                        NLDModel.this.setLayoutThreadAlive(true);
                        strategy.DynamicLayout(NLDModel.this.viewer);
                        if (doAnimation) {
                            NLDModel.this.viewer.setAnimating(false);
                        }
                        NLDModel.this.viewer.setCursor(Cursor.getDefaultCursor());
                        NLDModel.this.setLayoutThreadAlive(false);
                    }
                });
                this.animationThread.start();
                break;
            }
            case 0: {
                if (this.viewer.getAnimationFlag() && this.viewer.isAnimating()) {
                    this.viewer.setAnimating(false);
                }
                final NLDLayoutStrategy strategy = new NLDLayoutStrategy(this);
                strategy.init(this.arrangeFirstTime);
                final boolean doAnimation = this.viewer.getAnimationFlag();
                if (!doAnimation) {
                    this.viewer.setCursor(Cursor.getPredefinedCursor(3));
                    this.viewer.setPauseLayout(false);
                    this.viewer.setAnimating(false);
                    this.setLayoutThreadAlive(true);
                    strategy.DynamicLayout(this.viewer);
                    this.setLayoutThreadAlive(false);
                    this.viewer.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                this.animationThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NLDModel.this.viewer.setCursor(Cursor.getPredefinedCursor(3));
                        NLDModel.this.viewer.setPauseLayout(false);
                        NLDModel.this.viewer.setAnimating(doAnimation);
                        NLDModel.this.setLayoutThreadAlive(true);
                        strategy.DynamicLayout(NLDModel.this.viewer);
                        if (doAnimation) {
                            NLDModel.this.viewer.setAnimating(false);
                        }
                        NLDModel.this.viewer.setCursor(Cursor.getDefaultCursor());
                        NLDModel.this.setLayoutThreadAlive(false);
                    }
                });
                this.animationThread.start();
                break;
            }
            default: {
                System.out.println("Auto Layout not implemented yet!!");
            }
        }
        this.doUpdateModel = true;
        return false;
    }

    public void setXMLFile(String param) {
        this.xmlFile = param;
    }

    public void setXMLData(String param) {
        this.xmlParam = param;
    }

    protected String GRS(ResourceBundle rb, String name, String defStrg) {
        String s = null;
        if (name == null) {
            return defStrg;
        }
        try {
            if (rb != null) {
                s = rb.getString(name);
            }
        }
        catch (MissingResourceException e) {
            s = null;
        }
        if (s == null) {
            s = defStrg;
        }
        return s;
    }

    protected void dispError(String err) {
        System.out.println(err);
    }

    public void resetSizes() {
        this.numLinks = this.links.size();
        this.numNodes = this.nodes.size();
    }

    public boolean setLayoutTolerance(double err) {
        if (err <= 0.0 || err >= 1.0) {
            return false;
        }
        this.error = err;
        return true;
    }

    public double getLayoutTolerance() {
        return this.error;
    }

    public boolean setLayoutTime(int t) {
        this.time = t;
        return true;
    }

    public int getLayoutTime() {
        return this.time;
    }

    public boolean getDefaultDirected() {
        return this.directed;
    }

    public boolean setLabelMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.nodeLabelMode = mode;
                return true;
            }
        }
        return false;
    }

    public boolean loadChildren(int index) {
        return false;
    }

    public boolean updateDragAndDrop(NLDNode draggedNode, NLDNode dropAt) {
        return false;
    }

    public int getDefaultNodeShape() {
        return this.shape;
    }

    public int getLink(int i, int j) {
        long hashKey = i * this.numLinks + j;
        if (this.linkTable == null) {
            return -1;
        }
        NLDNode nI = (NLDNode)this.nodes.elementAt(i);
        NLDNode nJ = (NLDNode)this.nodes.elementAt(j);
        if (!nI.isVisible() || !nJ.isVisible()) {
            return -1;
        }
        Integer linkIndex = (Integer)this.linkTable.get(new Long(hashKey));
        if (null != linkIndex) {
            int retVal = linkIndex;
            if (this.links.isCulled(retVal) || !this.links.isVisible(retVal)) {
                return -1;
            }
            String nodeFromIdStr = nI.getID();
            String nodeToIdStr = nJ.getID();
            NLDLink oneLink = (NLDLink)this.links.elementAt(retVal);
            String linkFromStr = oneLink.getFromNode().toString();
            String linkToStr = oneLink.getToNode().toString();
            if (!nodeFromIdStr.equalsIgnoreCase(linkFromStr) || !nodeToIdStr.equalsIgnoreCase(linkToStr)) {
                return -1;
            }
            return retVal;
        }
        return -1;
    }

    public boolean isFreeNode(NLDNode n) {
        int idx = n.getIndex();
        int nNodes = this.nodes.size();
        for (int i = 0; i < nNodes; ++i) {
            int toIdx = ((NLDNode)this.nodes.elementAt(i)).getIndex();
            int linkIdT = this.getLink(idx, toIdx);
            int linkIdF = this.getLink(toIdx, idx);
            if (linkIdT < 0 && linkIdF < 0) continue;
            return false;
        }
        return true;
    }

    public boolean isNextLevelSelected(NLDNode n) {
        if (!n.isSelected()) {
            return false;
        }
        int idx = n.getIndex();
        int nNodes = this.nodes.size();
        for (int i = 0; i < nNodes; ++i) {
            NLDNode to = (NLDNode)this.nodes.elementAt(i);
            int toIdx = to.getIndex();
            int linkIdT = this.getLink(idx, toIdx);
            int linkIdF = this.getLink(toIdx, idx);
            if (linkIdT < 0 && linkIdF < 0 || to.isSelected()) continue;
            return false;
        }
        return true;
    }
}

