/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.j2d.ChannelLite;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDObject;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.awt.Color;
import java.util.Vector;

public class NLDLink
extends NLDObject {
    double width;
    protected int from;
    protected int to;
    boolean directed;
    int stipple = 0;
    int factor = 1;
    protected double x1;
    protected double x2;
    protected double y1;
    protected double y2;
    static Color textColor = Color.white;
    Vector points;
    private double sFacX = 1.0;
    private double sFacY = 1.0;

    public NLDLink(int f, int t) {
        this.width = -1.0;
        this.from = f;
        this.to = t;
        this.showLabel = false;
        this.directed = false;
    }

    public NLDLink(NLDLink a) {
        this.width = a.width;
        this.from = a.from;
        this.to = a.to;
        this.directed = a.directed;
        this.stipple = a.stipple;
        this.factor = a.factor;
        this.points = a.points;
    }

    public synchronized void build(ChannelLite channel, Object n, double w, double h, double zoomVal, double arrowsize) {
        if (this.hide || this.cull) {
            return;
        }
        if (!(n instanceof VectorNodeModel)) {
            return;
        }
        VectorNodeModel nodes = (VectorNodeModel)n;
        if (this.from < 0 || this.to < 0 || this.from == this.to || this.from >= nodes.size() || this.to >= nodes.size()) {
            return;
        }
        channel.glLoadName((Object)("A" + this.index));
        NLDNode f = (NLDNode)nodes.elementAt(this.from);
        NLDNode t = (NLDNode)nodes.elementAt(this.to);
        if (f == t) {
            return;
        }
        if (f.hide && t.hide) {
            return;
        }
        int border = channel.getBorderType();
        channel.setBorderType(0);
        channel.glLineWidth((float)((int)this.width));
        if (this.color == null) {
            this.color = Color.black;
        }
        if (!this.selected) {
            channel.glColor(this.color);
        } else {
            channel.glColor(this.selectColor);
        }
        if (this.stipple != 0) {
            channel.glEnable(7);
            channel.glLineStipple(this.factor, this.stipple);
        }
        double minDim = Math.min(w, h);
        this.setScaleFactor(minDim * zoomVal / w, minDim * zoomVal / h);
        if (this.points != null) {
            channel.glBegin(1);
            for (int i = 0; i < this.points.size(); ++i) {
                double[] p = (double[])this.points.elementAt(i);
                channel.glVertex(p[0], p[1], 0.0);
            }
            channel.glEnd();
        } else {
            this.x1 = f.xpos;
            this.y1 = f.ypos;
            this.x2 = t.xpos;
            this.y2 = t.ypos;
            if (this.directed) {
                double[] p2 = t.arrowTip(channel, this.x1, this.y1, minDim * zoomVal / w, minDim * zoomVal / h);
                this.buildNLDLink(channel, this.x1, this.y1, p2[0], p2[1], arrowsize);
            } else {
                channel.glBegin(1);
                channel.glVertex(this.x1, this.y1, 0.0);
                channel.glVertex(this.x2, this.y2, 0.0);
                channel.glEnd();
            }
        }
        channel.glDisable(7);
        channel.glLineWidth(1.0f);
        channel.setBorderType(border);
    }

    protected void buildNLDLink(ChannelLite channel, double x1, double y1, double x2, double y2, double arrowsize) {
        int steps = 10;
        double xp = 0.0;
        double yp = 0.0;
        double xd = x2 - x1;
        double yd = y2 - y1;
        double len = Math.sqrt(xd * xd + yd * yd);
        double ang = 0.39269908169872414;
        double a1 = len == 0.0 ? 0.0 : Math.atan2(yd, xd);
        double v1x = 0.5 * len * Math.cos(a1 + ang);
        double v1y = 0.5 * len * Math.sin(a1 + ang);
        double v2x = 0.5 * len * Math.cos(a1 - ang);
        double v2y = 0.5 * len * Math.sin(a1 - ang);
        if (this.stipple != 0) {
            channel.glEnable(7);
            channel.glLineStipple(this.factor, this.stipple);
        }
        int border = channel.getBorderType();
        channel.setBorderType(0);
        channel.glBegin(1);
        for (int s = 0; s <= steps; ++s) {
            double t;
            double u = t = 1.0 * (double)s / (double)steps;
            double u2 = u * u;
            double u3 = u2 * u;
            double f1 = 2.0 * u3 - 3.0 * u2 + 1.0;
            double f2 = -2.0 * u3 + 3.0 * u2;
            double f3 = u3 - 2.0 * u2 + u;
            double f4 = u3 - u2;
            double x = f1 * x1 + f2 * x2 + f3 * v1x + f4 * v2x;
            double y = f1 * y1 + f2 * y2 + f3 * v1y + f4 * v2y;
            channel.glVertex(x, y, 0.0);
            if (s != steps - 2) continue;
            xp = x;
            yp = y;
        }
        channel.glEnd();
        double arrow = 0.39269908169872414;
        xd = xp - x2;
        yd = yp - y2;
        len = xd * xd + yd * yd;
        a1 = len == 0.0 ? 0.0 : Math.atan2(yd, xd);
        v1x = arrowsize * this.sFacX * Math.cos(a1 - arrow);
        v1y = arrowsize * this.sFacY * Math.sin(a1 - arrow);
        v2x = arrowsize * this.sFacX * Math.cos(a1 + arrow);
        v2y = arrowsize * this.sFacY * Math.sin(a1 + arrow);
        int mode = channel.getPolygonMode();
        channel.glPolygonMode(0);
        channel.glBegin(2);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(x2, y2);
        channel.glVertex(x2 + v1x, y2 + v1y);
        channel.glVertex(x2 + v2x, y2 + v2y);
        channel.glEnd();
        channel.glPolygonMode(mode);
        channel.glBegin(1);
        channel.glNormal(0.0, 0.0, 1.0);
        channel.glVertex(x2 + v1x, y2 + v1y);
        channel.glVertex(x2, y2);
        channel.glVertex(x2 + v2x, y2 + v2y);
        channel.glEnd();
        if (this.stipple != 0) {
            channel.glDisable(7);
        }
        channel.setBorderType(border);
    }

    synchronized void buildLabel(ChannelLite channel) {
        channel.glLoadName((Object)("A" + this.index));
        channel.glColor(textColor);
        channel.gl2DText(this.label, (this.x1 + this.x2) / 2.0, (this.y1 + this.y2) / 2.0, 1.0);
    }

    public Object getFromNode() {
        return new Integer(this.from);
    }

    public Object getToNode() {
        return new Integer(this.to);
    }

    @Override
    public void analyseLabel() {
        if (this.mlabel == null) {
            int index = this.label.indexOf("\\n");
            while (index == 0 && this.label.length() >= 2) {
                this.label = this.label.substring(2);
                index = this.label.indexOf("\\n");
            }
            int idx2 = this.label.lastIndexOf("\\n");
            while (this.label.length() > 2 && this.label.length() - 2 == idx2) {
                this.label = this.label.substring(0, this.label.length() - 2);
                idx2 = this.label.lastIndexOf("\\n");
            }
            if (index != -1) {
                StringBuffer sb = new StringBuffer();
                int len = this.label.length();
                int prevIndex = 0;
                while (index != -1) {
                    if (this.label.charAt(index - 1) == '\\') {
                        sb.append(this.label.substring(prevIndex, index - 1));
                    } else {
                        sb.append(this.label.substring(prevIndex, index));
                    }
                    prevIndex = index + 2;
                    if (prevIndex < len) {
                        sb.append(newLine);
                        index = this.label.indexOf("\\n", prevIndex);
                        continue;
                    }
                    index = -1;
                }
                if (prevIndex < len) {
                    sb.append(this.label.substring(prevIndex, len));
                }
                this.label = new String(sb);
            }
        } else {
            int numLines = this.mlabel.size();
            StringBuffer sb = new StringBuffer();
            sb.append((String)this.mlabel.elementAt(0));
            for (int i = 1; i < numLines; ++i) {
                sb.append(newLine + (String)this.mlabel.elementAt(i));
            }
            this.label = new String(sb);
        }
    }

    @Override
    public void analyseInfo() {
        if (this.minfo == null) {
            int index = this.info.indexOf("\\n");
            while (index == 0 && this.info.length() >= 2) {
                this.info = this.info.substring(2);
                index = this.info.indexOf("\\n");
            }
            int idx2 = this.info.lastIndexOf("\\n");
            while (this.info.length() > 2 && this.info.length() - 2 == idx2) {
                this.info = this.info.substring(0, this.info.length() - 2);
                idx2 = this.info.lastIndexOf("\\n");
            }
            if (index != -1) {
                this.minfo = new Vector();
                int len = this.info.length();
                int prevIndex = 0;
                while (index != -1) {
                    if (this.info.charAt(index - 1) == '\\') {
                        this.minfo.addElement(this.info.substring(prevIndex, index - 1));
                    } else {
                        this.minfo.addElement(this.info.substring(prevIndex, index));
                    }
                    prevIndex = index + 2;
                    if (prevIndex < len) {
                        index = this.info.indexOf("\\n", prevIndex);
                        continue;
                    }
                    index = -1;
                }
                if (prevIndex < len) {
                    this.minfo.addElement(this.info.substring(prevIndex, len));
                }
            }
        } else {
            int num = this.minfo.size();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < num; ++i) {
                sb.append((String)this.minfo.elementAt(i) + newLine);
            }
            this.info = new String(sb);
        }
    }

    public void setLineWidth(double newWidth) {
        this.width = newWidth;
    }

    public double getLineWidth() {
        return this.width;
    }

    public int getFromIndex() {
        return this.from;
    }

    public void setFromIndex(int fromIndex) {
        this.from = fromIndex;
    }

    public int getToIndex() {
        return this.to;
    }

    public void setToIndex(int toIndex) {
        this.to = toIndex;
    }

    public int getStipple() {
        return this.stipple;
    }

    public void setStipple(int newStipple) {
        this.stipple = newStipple;
    }

    public int getStippleFactor() {
        return this.factor;
    }

    public void setStippleFactor(int newFactor) {
        this.factor = newFactor;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double newWidth) {
        this.width = newWidth;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directedFlag) {
        this.directed = directedFlag;
    }

    public void setPoints(Vector p) {
        this.points = p;
    }

    public void setScaleFactor(double xfac, double yfac) {
        this.sFacX = xfac;
        this.sFacY = yfac;
    }
}

