/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.nld;

import com.sas.graphics.util.nld.NLDLink;
import com.sas.graphics.util.nld.NLDModel;
import com.sas.graphics.util.nld.NLDNode;
import com.sas.graphics.util.nld.NLDViewer;
import com.sas.graphics.util.nld.VectorLinkModel;
import com.sas.graphics.util.nld.VectorNodeModel;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class NLDLayoutStrategy {
    public static final int DONE = 0;
    public static final int UNSTABLE = 1;
    public static final int TOO_LONG = 2;
    public static final int USER_BREAK = 3;
    public static final double MAX_TIME_SCALE = 500.0;
    public static final double DOUBLE_ZERO = 1.0E-8;
    private VectorNodeModel nodes;
    private VectorLinkModel links = null;
    private double[] forceX;
    private double[] forceY;
    private Hashtable linkTable = null;
    private double[] minMaxLinkValues = null;
    private long linkCount = -1L;
    private long nodeCount = -1L;
    private long hashConst = -1L;
    private double springConstant = 0.1;
    private double repulsiveCoeff = 0.01;
    private double maxDataRange = 0.0;
    private double threshold = 0.06;
    private boolean useValue = true;
    private boolean someNegValues = false;
    private Vector nodesAdded = new Vector();
    private Vector nodesRemoved = new Vector();
    private int visNodeCount = 0;
    private int visLinkCount = 0;
    private boolean linksChanged = false;
    double orgXmin = Double.POSITIVE_INFINITY;
    double orgYmin = Double.POSITIVE_INFINITY;
    double orgXmax = Double.NEGATIVE_INFINITY;
    double orgYmax = Double.NEGATIVE_INFINITY;
    public static final double TIME_STEP = 1.0;
    public static final double MIN_DISP = 1.0E-4;
    private double error = 1.0;
    private int maxTime = 240;

    public NLDLayoutStrategy(NLDModel model) {
        double tol;
        int i;
        for (i = 0; i < model.links.size(); ++i) {
            NLDLink l = (NLDLink)model.links.elementAt(i);
            if (l.to < 0 || l.from < 0 || l.to >= model.nodes.size() || l.from >= model.nodes.size() || l.to == l.from) continue;
            NLDNode nodeF = (NLDNode)model.nodes.elementAt(l.from);
            NLDNode nodeT = (NLDNode)model.nodes.elementAt(l.to);
            if (nodeF == null || nodeT == null || !nodeF.isVisible() || !nodeT.isVisible() || !l.isVisible()) continue;
            ++this.visLinkCount;
        }
        for (i = 0; i < model.nodes.size(); ++i) {
            NLDNode n = (NLDNode)model.nodes.elementAt(i);
            if (!n.isVisible()) continue;
            ++this.visNodeCount;
        }
        this.nodes = model.nodes;
        this.links = model.links;
        this.nodesAdded = model.nodes.getNewNodes();
        this.nodesRemoved = model.nodes.getRemovedNodes();
        if (model.links.getNewLinks().size() > 0 || model.links.getRemovedLinks().size() > 0) {
            this.linksChanged = true;
            model.links.getNewLinks().removeAllElements();
            model.links.getRemovedLinks().removeAllElements();
        }
        this.minMaxLinkValues = null;
        this.linkTable = null;
        this.linkCount = this.links.size();
        this.nodeCount = this.nodes.size();
        this.hashConst = this.linkCount > this.nodeCount ? this.linkCount : this.nodeCount;
        this.springConstant = 0.1;
        this.repulsiveCoeff = 0.01;
        this.forceX = null;
        this.forceY = null;
        this.maxDataRange = 0.0;
        this.useValue = true;
        this.someNegValues = false;
        if (model.getLayoutTime() > 0) {
            this.maxTime = model.getLayoutTime();
        }
        if ((tol = model.getLayoutTolerance()) > 0.0 && tol < 1.0) {
            this.error = tol;
        }
    }

    private void ComputeLinkMap() {
        if (this.linkCount <= 0L) {
            return;
        }
        this.linkTable = new Hashtable((int)this.linkCount);
        this.minMaxLinkValues = new double[2];
        this.minMaxLinkValues[0] = Double.POSITIVE_INFINITY;
        this.minMaxLinkValues[1] = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.linkCount) {
            NLDLink l = (NLDLink)this.links.elementAt(i);
            if (l.isVisible()) {
                if (l.from == -1) {
                    l.from = l.getFromIndex();
                }
                if (l.to == -1) {
                    l.to = l.getToIndex();
                }
                if (l.to >= 0 && l.from >= 0 && l.to < this.nodes.size() && l.from < this.nodes.size() && l.to != l.from) {
                    long hashValue = (long)l.from * this.hashConst + (long)l.to;
                    this.linkTable.put(new Long(hashValue), new Integer(i));
                    this.minMaxLinkValues[0] = Math.min(this.minMaxLinkValues[0], l.value);
                    this.minMaxLinkValues[1] = Math.max(this.minMaxLinkValues[1], l.value);
                }
            }
            ++i;
        }
        if (this.minMaxLinkValues[1] == this.minMaxLinkValues[0] && this.minMaxLinkValues[1] == 0.0) {
            this.useValue = false;
        }
        if (this.minMaxLinkValues[0] < 0.0) {
            this.someNegValues = true;
        }
    }

    private void setConstants() {
        this.springConstant = 0.1;
        this.repulsiveCoeff = this.springConstant / 10.0;
        if (this.visNodeCount == 0) {
            return;
        }
        double lnR = (double)this.visLinkCount / (double)this.visNodeCount;
        if (lnR <= 0.25) {
            this.springConstant = 0.02;
            this.repulsiveCoeff = this.springConstant / 10.0;
            return;
        }
        if (lnR <= 0.75) {
            this.springConstant = 0.05;
            this.repulsiveCoeff = this.springConstant / 10.0;
            return;
        }
        if (lnR < 0.9) {
            this.springConstant = 0.07;
            this.repulsiveCoeff = this.springConstant / 10.0;
            return;
        }
        if (lnR <= 1.0 && lnR > 0.9) {
            this.springConstant = 0.01;
            this.repulsiveCoeff = this.springConstant / 10.0;
            return;
        }
        if (lnR > 1.0 && lnR <= 1.5) {
            this.springConstant = 0.02;
            this.repulsiveCoeff = this.springConstant / 10.0;
            return;
        }
        this.springConstant = 0.02;
        this.repulsiveCoeff = this.springConstant / 10.0;
    }

    private void placeNewNodesOnCircle() {
        int newNnodes = this.nodesAdded.size();
        double r = 1.0;
        double delta = Math.PI * 2 / (double)newNnodes;
        for (int i = 0; i < newNnodes; ++i) {
            double theta = (double)i * delta;
            NLDNode currNode = (NLDNode)this.nodesAdded.elementAt(i);
            currNode.xpos = r * Math.cos(theta);
            currNode.ypos = r * Math.sin(theta);
            currNode.orgXpos = r * Math.cos(theta);
            currNode.orgYpos = r * Math.sin(theta);
        }
    }

    private void placeNewNodesOnDataBoxEdge(double dataMinX, double dataMinY, double dataMaxX, double dataMaxY) {
        double maxDim = Math.max(dataMaxX - dataMinX, dataMaxY - dataMinY);
        dataMaxX = dataMinX + maxDim;
        dataMaxY = dataMinY + maxDim;
        int newNnodes = this.nodesAdded.size();
        int nodesPerEdge = newNnodes / 4 + newNnodes % 4 + 1;
        int midEdgeNodeIdx = nodesPerEdge / 2;
        double gapBetweenNodes = maxDim / (double)nodesPerEdge;
        int nodesPlacedOnLeftEdge = 0;
        int LELeftCount = 0;
        int LERightCount = 0;
        double LEMidY = 0.0;
        int nodesPlacedOnBottomEdge = 0;
        int BELeftCount = 0;
        int BERightCount = 0;
        double BEMidX = 0.0;
        int nodesPlacedOnRightEdge = 0;
        int RELeftCount = 0;
        int RERightCount = 0;
        double REMidY = 0.0;
        int nodesPlacedOnTopEdge = 0;
        int TELeftCount = 0;
        int TERightCount = 0;
        double TEMidX = 0.0;
        for (int i = 0; i < newNnodes; ++i) {
            NLDNode currNode = (NLDNode)this.nodesAdded.elementAt(i);
            int c = i % 4;
            switch (c) {
                case 0: {
                    if (nodesPlacedOnLeftEdge == 0) {
                        LEMidY = currNode.orgYpos = dataMinY + (double)midEdgeNodeIdx * gapBetweenNodes;
                    } else {
                        currNode.orgYpos = nodesPlacedOnLeftEdge % 2 == 0 ? LEMidY - gapBetweenNodes * (double)(++LELeftCount) : LEMidY + gapBetweenNodes * (double)(++LERightCount);
                    }
                    currNode.orgXpos = dataMinX;
                    ++nodesPlacedOnLeftEdge;
                    break;
                }
                case 1: {
                    if (nodesPlacedOnBottomEdge == 0) {
                        BEMidX = currNode.orgXpos = dataMinX + (double)midEdgeNodeIdx * gapBetweenNodes;
                    } else {
                        currNode.orgXpos = nodesPlacedOnBottomEdge % 2 == 0 ? BEMidX - gapBetweenNodes * (double)(++BELeftCount) : BEMidX + gapBetweenNodes * (double)(++BERightCount);
                    }
                    currNode.orgYpos = dataMaxY;
                    ++nodesPlacedOnBottomEdge;
                    break;
                }
                case 2: {
                    if (nodesPlacedOnRightEdge == 0) {
                        REMidY = currNode.orgYpos = dataMinY + (double)midEdgeNodeIdx * gapBetweenNodes;
                    } else {
                        currNode.orgYpos = nodesPlacedOnRightEdge % 2 == 0 ? REMidY + gapBetweenNodes * (double)(++RERightCount) : REMidY - gapBetweenNodes * (double)(++RELeftCount);
                    }
                    currNode.orgXpos = dataMaxX;
                    ++nodesPlacedOnRightEdge;
                    break;
                }
                case 3: {
                    if (nodesPlacedOnTopEdge == 0) {
                        TEMidX = currNode.orgXpos = dataMinX + (double)midEdgeNodeIdx * gapBetweenNodes;
                    } else {
                        currNode.orgXpos = nodesPlacedOnRightEdge % 2 == 0 ? TEMidX + gapBetweenNodes * (double)(++TERightCount) : TEMidX - gapBetweenNodes * (double)(++TELeftCount);
                    }
                    currNode.orgYpos = dataMinY;
                    ++nodesPlacedOnTopEdge;
                }
            }
            currNode.xpos = currNode.orgXpos;
            currNode.ypos = currNode.orgYpos;
        }
    }

    private void placeAddedNodes() {
        double dataMinX = Double.POSITIVE_INFINITY;
        double dataMinY = Double.POSITIVE_INFINITY;
        double dataMaxX = Double.NEGATIVE_INFINITY;
        double dataMaxY = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode currNode = (NLDNode)this.nodes.elementAt(i);
            if (!this.nodesAdded.contains(currNode)) {
                dataMinX = Math.min(dataMinX, currNode.orgXpos);
                dataMinY = Math.min(dataMinY, currNode.orgYpos);
                dataMaxX = Math.max(dataMaxX, currNode.orgXpos);
                dataMaxY = Math.max(dataMaxY, currNode.orgYpos);
            }
            ++i;
        }
        if (dataMinX != dataMaxX && dataMinY != dataMaxY) {
            if (dataMinX == Double.POSITIVE_INFINITY || dataMinY == Double.POSITIVE_INFINITY || dataMaxX == Double.NEGATIVE_INFINITY || dataMaxY == Double.NEGATIVE_INFINITY) {
                this.placeNewNodesOnCircle();
            } else {
                this.placeNewNodesOnDataBoxEdge(dataMinX, dataMinY, dataMaxX, dataMaxY);
            }
        } else {
            this.placeNewNodesOnCircle();
        }
    }

    private void initNodePositions(boolean fTime) {
        if (fTime) {
            double r = 1.0;
            double delta = Math.PI * 2 / (double)this.nodeCount;
            int i = 0;
            while ((long)i < this.nodeCount) {
                double theta = (double)i * delta;
                NLDNode currNode = (NLDNode)this.nodes.elementAt(i);
                currNode.orgXpos = r * Math.cos(theta);
                currNode.orgYpos = r * Math.sin(theta);
                ++i;
            }
        }
        if (this.nodesAdded.size() > 0) {
            this.placeAddedNodes();
        }
        this.computeDataRange();
        if (!fTime) {
            this.unproject();
            if (this.nodesAdded.size() > 0) {
                this.nodesAdded.removeAllElements();
            }
            if (this.nodesRemoved.size() > 0) {
                this.nodesRemoved.removeAllElements();
            }
        }
    }

    private void computeDataRange() {
        this.orgXmin = Double.POSITIVE_INFINITY;
        this.orgYmin = Double.POSITIVE_INFINITY;
        this.orgXmax = Double.NEGATIVE_INFINITY;
        this.orgYmax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode currNode = (NLDNode)this.nodes.elementAt(i);
            if (currNode.isVisible()) {
                this.orgXmin = Math.min(this.orgXmin, currNode.orgXpos);
                this.orgYmin = Math.min(this.orgYmin, currNode.orgYpos);
                this.orgXmax = Math.max(this.orgXmax, currNode.orgXpos);
                this.orgYmax = Math.max(this.orgYmax, currNode.orgYpos);
            }
            ++i;
        }
        this.maxDataRange = Math.max(this.orgXmax - this.orgXmin, this.orgYmax - this.orgYmin);
    }

    private void initForces() {
        this.forceX = new double[(int)this.nodeCount];
        this.forceY = new double[(int)this.nodeCount];
    }

    public void init(boolean firstTime) {
        if (this.linkTable == null || this.linksChanged) {
            this.ComputeLinkMap();
        }
        this.initNodePositions(firstTime);
        this.setConstants();
        this.initForces();
    }

    private int getLink(int i, int j) {
        long hashKey = (long)i * this.hashConst + (long)j;
        if (this.linkTable == null) {
            return -1;
        }
        if (i < 0 || i >= this.nodes.size() || j < 0 || j >= this.nodes.size()) {
            return -1;
        }
        NLDNode nodeI = (NLDNode)this.nodes.elementAt(i);
        NLDNode nodeJ = (NLDNode)this.nodes.elementAt(j);
        if (!nodeI.isVisible() || !nodeJ.isVisible()) {
            return -1;
        }
        Integer linkIndex = (Integer)this.linkTable.get(new Long(hashKey));
        if (null != linkIndex) {
            int retVal = linkIndex;
            if (retVal < 0 || retVal >= this.links.size()) {
                return -1;
            }
            if (this.links.isCulled(retVal)) {
                return -1;
            }
            return retVal;
        }
        return -1;
    }

    private double computeForces() {
        double magMax = 0.0;
        int i = 0;
        while ((long)i < this.nodeCount) {
            this.forceX[i] = 0.0;
            this.forceY[i++] = 0.0;
        }
        double attractionThresh = this.maxDataRange / 7.0;
        int i2 = 0;
        while ((long)i2 < this.nodeCount) {
            NLDNode nodeI = (NLDNode)this.nodes.elementAt(i2);
            if (nodeI.isVisible()) {
                int j = i2 + 1;
                while ((long)j < this.nodeCount) {
                    NLDNode nodeJ = (NLDNode)this.nodes.elementAt(j);
                    if (nodeJ.isVisible()) {
                        int linkIdF;
                        double cy;
                        double cx;
                        double dx = nodeJ.orgXpos - nodeI.orgXpos;
                        double dy = nodeJ.orgYpos - nodeI.orgYpos;
                        double dist = Math.sqrt(dx * dx + dy * dy);
                        if (dist == 0.0) {
                            cx = Math.random();
                            cy = Math.random();
                            double d = Math.sqrt(cx * cx + cy * cy);
                            cx /= d;
                            cy /= d;
                        } else {
                            cx = dx / dist;
                            cy = dy / dist;
                        }
                        double af = 0.0;
                        double rf = 0.0;
                        double value = 0.0;
                        int linkIdT = this.getLink(i2, j);
                        if (linkIdT >= 0) {
                            if (this.useValue) {
                                NLDLink l = (NLDLink)this.links.elementAt(linkIdT);
                                double lValue = l.value;
                                if (this.someNegValues) {
                                    lValue += Math.abs(this.minMaxLinkValues[0]);
                                }
                                if (lValue <= 0.0) {
                                    lValue = 1.0E-8;
                                }
                                value += lValue;
                            } else {
                                value += 1.0;
                            }
                        }
                        if ((linkIdF = this.getLink(j, i2)) >= 0) {
                            if (this.useValue) {
                                NLDLink l = (NLDLink)this.links.elementAt(linkIdF);
                                double lValue = l.value;
                                if (this.someNegValues) {
                                    lValue += Math.abs(this.minMaxLinkValues[0]);
                                }
                                if (lValue <= 0.0) {
                                    lValue = 1.0E-8;
                                }
                                value += lValue;
                            } else {
                                value += 1.0;
                            }
                        }
                        if (linkIdT >= 0 || linkIdF >= 0) {
                            value = this.useValue ? (value /= this.minMaxLinkValues[1]) : (value /= 2.0);
                            af = dist * this.springConstant;
                            if (dist < attractionThresh) {
                                af -= (attractionThresh - dist) * this.springConstant;
                            }
                            af *= Math.sqrt(Math.sqrt(value));
                        } else {
                            value = 1.0;
                        }
                        rf = dist < this.threshold ? this.repulsiveCoeff / (this.threshold * this.threshold) : this.repulsiveCoeff / this.threshold * Math.pow(0.8, dist);
                        double resf = af - rf;
                        double resfx = resf * cx;
                        double resfy = resf * cy;
                        int n = i2;
                        this.forceX[n] = this.forceX[n] + resfx;
                        int n2 = i2;
                        this.forceY[n2] = this.forceY[n2] + resfy;
                        int n3 = j;
                        this.forceX[n3] = this.forceX[n3] - resfx;
                        int n4 = j;
                        this.forceY[n4] = this.forceY[n4] - resfy;
                    }
                    ++j;
                }
                double mag = Math.sqrt(this.forceX[i2] * this.forceX[i2] + this.forceY[i2] * this.forceY[i2]);
                if (mag > magMax) {
                    magMax = mag;
                }
            }
            ++i2;
        }
        return magMax;
    }

    private double getCurrTol() {
        double maxRatio = 0.0;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode n = (NLDNode)this.nodes.elementAt(i);
            if (n.isVisible()) {
                double displacement = Math.sqrt(this.forceX[i] * this.forceX[i] + this.forceY[i] * this.forceY[i]);
                double ratio = displacement / this.maxDataRange;
                maxRatio = Math.max(maxRatio, ratio);
            }
            ++i;
        }
        return maxRatio;
    }

    private void moveNodes() {
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode n = (NLDNode)this.nodes.elementAt(i);
            if (n.isVisible()) {
                n.orgXpos += this.forceX[i];
                n.orgYpos += this.forceY[i];
            }
            ++i;
        }
        this.computeDataRange();
    }

    public synchronized int DynamicLayout(NLDViewer viewer) {
        if (this.visNodeCount <= 0) {
            return 0;
        }
        if (this.visNodeCount == 1 || this.visLinkCount == 0) {
            this.project();
            viewer.setAnimating(false);
            viewer.build();
            viewer.buildSelected();
            viewer.repaint();
            try {
                Thread.sleep(97L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0;
        }
        double tolerance = Math.min(1.0E-4, this.error);
        double MAX_TIME = 500.0 * (double)(this.visNodeCount + 1);
        long timeStamp = new Date().getTime();
        int i = 0;
        for (double time = 0.0; time < MAX_TIME; time += 1.0) {
            long temp1;
            long temp2;
            ++i;
            double mag = this.computeForces();
            double ratio = this.getCurrTol();
            if (ratio < tolerance || viewer.isLayoutInterrupted()) {
                this.project();
                viewer.setAnimating(false);
                viewer.build();
                viewer.buildSelected();
                viewer.repaint();
                return 0;
            }
            this.moveNodes();
            if (viewer.getAnimationFlag() && i % 5 == 0) {
                this.project();
                viewer.build();
                viewer.buildSelected();
                viewer.repaint();
                try {
                    Thread.sleep(97L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((temp2 = ((temp1 = new Date().getTime()) - timeStamp) / 1000L) <= (long)this.maxTime) continue;
            this.project();
            viewer.setAnimating(false);
            viewer.build();
            viewer.buildSelected();
            viewer.repaint();
            return 2;
        }
        this.project();
        viewer.setAnimating(false);
        viewer.build();
        viewer.buildSelected();
        viewer.repaint();
        return 2;
    }

    private void unproject() {
        double yexp;
        double xexp;
        double xposMin = Double.POSITIVE_INFINITY;
        double yposMin = Double.POSITIVE_INFINITY;
        double xposMax = Double.NEGATIVE_INFINITY;
        double yposMax = Double.NEGATIVE_INFINITY;
        double orgXposMin = Double.POSITIVE_INFINITY;
        double orgYposMin = Double.POSITIVE_INFINITY;
        double orgXposMax = Double.NEGATIVE_INFINITY;
        double orgYposMax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            NLDNode currNode = (NLDNode)this.nodes.elementAt(i);
            if (currNode.isVisible()) {
                xposMin = Math.min(xposMin, currNode.xpos);
                yposMin = Math.min(yposMin, currNode.ypos);
                xposMax = Math.max(xposMax, currNode.xpos);
                yposMax = Math.max(yposMax, currNode.ypos);
                orgXposMin = Math.min(orgXposMin, currNode.orgXpos);
                orgYposMin = Math.min(orgYposMin, currNode.orgYpos);
                orgXposMax = Math.max(orgXposMax, currNode.orgXpos);
                orgYposMax = Math.max(orgYposMax, currNode.orgYpos);
            }
            ++i;
        }
        double oldxm = (xposMin + xposMax) / 2.0;
        double oldym = (yposMin + yposMax) / 2.0;
        double oldxd = xposMax - xposMin;
        double oldyd = yposMax - yposMin;
        double newCx = (orgXposMax + orgXposMin) / 2.0;
        double newCy = (orgYposMax + orgYposMin) / 2.0;
        double newxmin = orgXposMin - newCx;
        double newxmax = orgXposMax - newCx;
        double newymin = orgYposMin - newCy;
        double newymax = orgYposMax - newCy;
        double newxm = (newxmin + newxmax) / 2.0;
        double newym = (newymin + newymax) / 2.0;
        double newxd = newxmax - newxmin;
        double newyd = newymax - newymin;
        double xshift = newxm - oldxm;
        double yshift = newym - oldym;
        if (this.visNodeCount == 1) {
            xexp = newxd / (oldxd + 1.0);
            yexp = newyd / (oldyd + 1.0);
        } else {
            xexp = newxd / (oldxd == 0.0 ? 1.0E-8 : oldxd);
            yexp = newyd / (oldyd == 0.0 ? 1.0E-8 : oldyd);
        }
        double expand = Math.min(xexp, yexp);
        int i2 = 0;
        while ((long)i2 < this.nodeCount) {
            NLDNode n = (NLDNode)this.nodes.elementAt(i2);
            if (n.isVisible()) {
                double x = n.xpos + xshift;
                double y = n.ypos + yshift;
                x = newxm + (x - newxm) * expand;
                y = newym + (y - newym) * expand;
                n.orgXpos = x;
                n.orgYpos = y;
                orgXposMin = Math.min(orgXposMin, n.orgXpos);
                orgYposMin = Math.min(orgYposMin, n.orgYpos);
                orgXposMax = Math.max(orgXposMax, n.orgXpos);
                orgYposMax = Math.max(orgYposMax, n.orgYpos);
            }
            ++i2;
        }
        this.maxDataRange = Math.max(orgXposMax - orgXposMin, orgYposMax - orgYposMin);
    }

    private void project() {
        double yexp;
        double xexp;
        double y;
        double x;
        NLDNode n;
        double oldxmin = Double.POSITIVE_INFINITY;
        double oldxmax = Double.NEGATIVE_INFINITY;
        double oldymin = Double.POSITIVE_INFINITY;
        double oldymax = Double.NEGATIVE_INFINITY;
        int i = 0;
        while ((long)i < this.nodeCount) {
            n = (NLDNode)this.nodes.elementAt(i);
            if (n.isVisible()) {
                x = n.orgXpos;
                y = n.orgYpos;
                if (i == 0) {
                    oldxmin = oldxmax = x;
                    oldymin = oldymax = y;
                } else {
                    oldxmin = Math.min(x, oldxmin);
                    oldxmax = Math.max(x, oldxmax);
                    oldymin = Math.min(y, oldymin);
                    oldymax = Math.max(y, oldymax);
                }
            }
            ++i;
        }
        double oldxm = (oldxmin + oldxmax) / 2.0;
        double oldym = (oldymin + oldymax) / 2.0;
        double oldxd = oldxmax - oldxmin;
        double oldyd = oldymax - oldymin;
        double fac = 0.0;
        fac = this.visNodeCount == 1 ? 0.01 : 0.6 + 0.1 * Math.min(2.0, Math.sqrt(this.visNodeCount));
        double newxmin = -fac;
        double newxmax = fac;
        double newymin = -fac;
        double newymax = fac;
        double newxm = (newxmin + newxmax) / 2.0;
        double newym = (newymin + newymax) / 2.0;
        double newxd = newxmax - newxmin;
        double newyd = newymax - newymin;
        double xshift = newxm - oldxm;
        double yshift = newym - oldym;
        if (this.visNodeCount == 1) {
            xexp = newxd / (oldxd + 1.0);
            yexp = newyd / (oldyd + 1.0);
        } else {
            xexp = newxd / (oldxd == 0.0 ? 1.0E-8 : oldxd);
            yexp = newyd / (oldyd == 0.0 ? 1.0E-8 : oldyd);
        }
        double expand = Math.min(xexp, yexp);
        int i2 = 0;
        while ((long)i2 < this.nodeCount) {
            n = (NLDNode)this.nodes.elementAt(i2);
            if (n.isVisible()) {
                x = n.orgXpos + xshift;
                y = n.orgYpos + yshift;
                x = newxm + (x - newxm) * expand;
                y = newym + (y - newym) * expand;
                n.xpos = x;
                n.ypos = y;
            }
            ++i2;
        }
    }

    public void setLayoutTime(int t) {
        this.maxTime = t;
    }

    public void setLayoutTolerance(double err) {
        this.error = err;
    }
}

