/*
 * Decompiled with CFR 0.152.
 */
package MITI.EtlBridgeLib.parameterProcessor;

import MITI.EtlBridgeLib.parameterProcessor.BasicParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IDomain;
import MITI.EtlBridgeLib.parameterProcessor.IParameter;
import MITI.EtlBridgeLib.parameterProcessor.IParameterFile;
import MITI.EtlBridgeLib.parameterProcessor.IParameterModel;
import MITI.messages.MIRModelBridge.BLIB;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;

public class INIParameterFile
extends BasicParameterFile
implements IParameterFile {
    private static final String SCOPE_NAME_SFX = "[";
    private static final String SCOPE_NAME_PFX = "]";
    private static String[] keyValueDelimiters = new String[]{"=", ";", ":", ","};

    public static void setDelimiter(String string) {
        keyValueDelimiters = new String[]{string};
    }

    @Override
    public void read(InputStream inputStream, IParameterModel iParameterModel) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
            String string = null;
            String string2 = "";
            IDomain iDomain = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().isEmpty()) continue;
                String string3 = this.getCommentLine(string);
                if (string3 != null) {
                    if (string3.trim().isEmpty()) continue;
                    string2 = string3;
                    continue;
                }
                IDomain iDomain2 = this.getDomain(string, iParameterModel);
                if (iDomain2 != null) {
                    iDomain2.setDescription(string2);
                    string2 = "";
                    iDomain = iDomain2;
                    continue;
                }
                IParameter iParameter = this.getParameter(string, iParameterModel);
                if (iParameter == null) continue;
                iParameter.setDescription(string2);
                string2 = "";
                if (iDomain != null) {
                    iParameter.setDomain(iDomain);
                    continue;
                }
                iParameterModel.addParameter(iParameter);
            }
        }
        catch (IOException iOException) {
            BLIB.DBG_DEBUG.log(iOException, new Object[0]);
        }
    }

    protected String getCommentLine(String string) {
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String string2 = string.substring(0, 1);
        if (string2.equals("#") || string2.equals(";")) {
            String string3 = string.substring(1).trim();
            return string3;
        }
        return null;
    }

    protected IDomain getDomain(String string, IParameterModel iParameterModel) {
        IDomain iDomain = null;
        if (string != null && !string.trim().isEmpty()) {
            String string2 = null;
            if ((string = string.trim()).startsWith(SCOPE_NAME_SFX) && string.endsWith(SCOPE_NAME_PFX)) {
                string2 = string.substring(1, string.length() - 1);
            }
            if (string2 != null && (iDomain = iParameterModel.getDomain(string2)) == null) {
                iDomain = iParameterModel.createDomain(string2);
                iParameterModel.addDomain(iDomain);
            }
        }
        return iDomain;
    }

    protected IParameter getParameter(String string, IParameterModel iParameterModel) {
        IParameter iParameter = null;
        int n = INIParameterFile.getDelimieterIndex(string = string.trim());
        if (n != -1 && n != string.length()) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1);
            iParameter = iParameterModel.createParameter(string2, INIParameterFile.preProcessParameterValue(string3));
        }
        return iParameter;
    }

    private static int getDelimieterIndex(String string) {
        return Arrays.stream(keyValueDelimiters).map(string2 -> string.indexOf((String)string2)).filter(n -> n > 0).min(Integer::compareTo).orElse(-1);
    }

    private static String preProcessParameterValue(String string) {
        String string2 = string.trim();
        if (string2.startsWith("\"") && string2.endsWith("\"")) {
            return string2;
        }
        return "\"" + string2 + "\"";
    }

    @Override
    protected void printDomainName(PrintWriter printWriter, String string) {
        if (!INIParameterFile.isNullOrEmpty(string)) {
            printWriter.println(SCOPE_NAME_SFX + string + SCOPE_NAME_PFX);
        }
    }

    @Override
    protected void printParameterName(PrintWriter printWriter, String string) {
        if (!INIParameterFile.isNullOrEmpty(string)) {
            printWriter.print(string + "=");
        }
    }

    @Override
    protected String printValue(String string, int n) {
        String string2 = "";
        string2 = string.contains(System.lineSeparator()) ? string.replaceAll(System.lineSeparator(), " ") : string.toString();
        return string2;
    }
}

