/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.net.URLCodec;

@SASScope(value="ALL")
public class URLEncoder
extends URLCodec {
    private static final String US_ASCII = "US-ASCII";
    public static final BitSet WWW_FORM_URL_COPY = new BitSet(256);

    public static String encodeURL(String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        byte[] transcodedValue = pString.getBytes(charset);
        if (URLEncoder.isURLSafe(transcodedValue)) {
            return pString;
        }
        return new String(URLEncoder.encodeUrl((BitSet)WWW_FORM_URL, (byte[])transcodedValue), US_ASCII);
    }

    @SASScope
    public static boolean isURLSafe(byte[] bytes) {
        if (bytes == null) {
            return true;
        }
        for (int n : bytes) {
            if (n < 0) {
                n = 256 + n;
            }
            if (WWW_FORM_URL.get(n)) {
                if (n != 32) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean isURLSafe(String s) {
        if (s == null) {
            return true;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (WWW_FORM_URL.get(c)) {
                if (c != ' ') continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isURLSafeBasedOnSet(BitSet safeSet, byte[] bytes) {
        if (bytes == null || safeSet == null) {
            return true;
        }
        for (int n : bytes) {
            if (n < 0) {
                n = 256 + n;
            }
            if (safeSet.get(n)) {
                if (n != 32) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @SASScope
    public static String encodeURLBasedOnSet(BitSet safeSet, String pString, String charset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        byte[] transcodedValue = pString.getBytes(charset);
        if (URLEncoder.isURLSafeBasedOnSet(safeSet, transcodedValue)) {
            return pString;
        }
        return new String(URLEncoder.encodeUrl((BitSet)safeSet, (byte[])transcodedValue), charset);
    }

    public static String encodeURLBasedOnSet(BitSet safeSet, String pString, String charset, String outputCharset) throws UnsupportedEncodingException {
        if (pString == null) {
            return null;
        }
        byte[] transcodedValue = pString.getBytes(charset);
        if (URLEncoder.isURLSafeBasedOnSet(safeSet, transcodedValue)) {
            return pString;
        }
        return new String(URLEncoder.encodeUrl((BitSet)safeSet, (byte[])transcodedValue), outputCharset != null ? outputCharset : US_ASCII);
    }

    static {
        WWW_FORM_URL_COPY.or(WWW_FORM_URL);
    }
}

