/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.util.BaseUtil;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@SASScope(value="ALL")
public class MethodInvocationServlet
extends HttpServlet {
    public static final String CLASS_PARAMETER = "CLASS_PARAMETER";
    public static final String METHOD_PARAMETER = "METHOD";
    public static final String OBJECT_PARAMETER = "OBJECT_PARAMETER";
    private static final String METHOD_NAME = "servletInvocationMethod";
    public static final Class[] PARAMS = new Class[]{HttpServletRequest.class, HttpServletResponse.class};

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletContext context = null;
        try {
            context = this.getServletContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MethodInvocationServlet.invoke(request, response, context);
    }

    @SASScope
    public static void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MethodInvocationServlet.invoke(request, response, null);
    }

    @SASScope
    public static void invoke(HttpServletRequest request, HttpServletResponse response, ServletContext context) throws ServletException, IOException {
        String charset = BaseUtil.getOutputCharacterEncoding(request);
        response.setContentType("text/html; charset=" + charset);
        try {
            String method = request.getParameter(METHOD_PARAMETER);
            if (method == null) {
                method = METHOD_NAME;
            }
            String classParam = request.getParameter(CLASS_PARAMETER);
            Object obj = null;
            Class<?> c = null;
            if (classParam != null) {
                c = Class.forName(classParam);
            } else {
                String objParam = request.getParameter(OBJECT_PARAMETER);
                obj = request.getAttribute(objParam);
                if (obj == null && request.getSession(false) != null) {
                    obj = request.getSession(false).getAttribute(objParam);
                }
                if (obj == null && context != null) {
                    obj = context.getAttribute(objParam);
                }
                if (obj != null) {
                    c = obj.getClass();
                }
            }
            if (c != null) {
                Method m = c.getMethod(method, PARAMS);
                m.invoke(obj, request, response);
            }
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e != null && e.getCause() != null) {
                throw new ServletException(e.getCause());
            }
            throw new ServletException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

