/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import java.io.PrintWriter;
import java.io.StringWriter;

@SASScope
public class DocType {
    public static final String QUIRKS = "quirks";
    public static final String HTML_STRICT = "html.strict";
    public static final String HTML_TRANSITIONAL = "html.transitional";
    public static final String XHTML_STRICT = "xhtml.strict";
    public static final String XHTML_TRANSITIONAL = "xhtml.transitional";
    public static final String XHTML_FRAMESET = "xhtml.frameset";
    public static String DEFAULT_DOCTYPE = "xhtml.transitional";

    private DocType() {
    }

    public static void write(PrintWriter out) {
        DocType.write(out, DEFAULT_DOCTYPE);
    }

    public static void write(StringWriter out, String mode) {
        PrintWriter writer = new PrintWriter(out);
        DocType.write(writer, mode);
    }

    public static void write(PrintWriter out, String mode) {
        if (mode.equalsIgnoreCase(XHTML_STRICT)) {
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        } else if (mode.equalsIgnoreCase(XHTML_TRANSITIONAL)) {
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        } else if (mode.equalsIgnoreCase(XHTML_FRAMESET)) {
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">");
        } else if (mode.equalsIgnoreCase(HTML_TRANSITIONAL)) {
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        } else if (mode.equalsIgnoreCase(HTML_STRICT)) {
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">");
        } else {
            out.println("<!-- QUIRKS MODE -->");
        }
    }

    public static String getDescription(String mode) {
        if (mode.equalsIgnoreCase(XHTML_STRICT)) {
            return "XHTML 1.0 STRICT";
        }
        if (mode.equalsIgnoreCase(XHTML_TRANSITIONAL)) {
            return "XHTML 1.0 TRANSITIONAL";
        }
        if (mode.equalsIgnoreCase(XHTML_FRAMESET)) {
            return "XHTML 1.0 FRAMESET";
        }
        if (mode.equalsIgnoreCase(HTML_TRANSITIONAL)) {
            return "HTML 4.01 TRANSITIONAL";
        }
        if (mode.equalsIgnoreCase(HTML_STRICT)) {
            return "HTML 4.01 STRICT";
        }
        return "QUIRKS";
    }
}

