/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import com.sas.framework.themes.client.BaseThemeElement;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.Template;
import com.sas.framework.themes.client.Theme;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.preferences.SASProfileInterface;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.olaptableview.html.ColorGradientUtil;
import com.sas.servlet.util.ClientInfo;
import com.sas.servlet.util.DocType;
import com.sas.servlet.util.RB;
import com.sas.themeresources.cdd.images.ComponentImages;
import com.sas.themeresources.cdd.templates.ComponentTemplates;
import com.sas.util.ValidateArg;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

@SASScope(value="ALL")
public class ComponentPropertyManager {
    static final String RB_KEY = "ComponentPropertyManager.";
    public static final String DEFAULT_STYLE_SHEET = "sasComponents_IE_6.css";
    @SASScope
    protected static final String DEFAULT_IMAGE_LOCATION = "images/";
    @SASScope
    protected static final String DEFAULT_STYLE_LOCATION = "styles/";
    @SASScope
    protected static final String DEFAULT_JAVASCRIPT_LOCATION = "scripts/";
    @SASScope
    protected static final String DEFAULT_TEMPLATE_LOCATION = "/templates/";
    @SASScope
    protected static final String DEFAULT_DYNAMIC_BUTTON_ROOT_NAME = "button";
    protected static final String DEFAULT_INPUT_CHARACTER_ENCODING = "UTF-8";
    protected static final String DEFAULT_OUTPUT_CHARACTER_ENCODING = "UTF-8";
    protected static final String DEFAULT_CONTEXT_MENU_LAUNCH_EVENT = "oncontextmenu";
    protected static final String DEFAULT_DOCTYPE = DocType.DEFAULT_DOCTYPE;
    protected static final String META_REFRESH_INT = "sas.framework.meta_refresh_int";
    protected String contextPath = "";
    protected String absolutePath = "";
    protected GraphStyle graphStyle;
    protected GraphStyle defaultGraphStyle;
    private static final String prefix = "<link href=\"";
    private static final String suffix = "\" rel=\"STYLESHEET\" type=\"text/css\"/>";
    private String imageLocation;
    private String styleLocation;
    private String javaScriptLocation;
    private String templateLocation;
    private String dynamicButtonRootName;
    private String inputCharacterEncoding;
    private String outputCharacterEncoding;
    private String templateURLLocation;
    private List styleSheetList;
    private String contextMenuLaunchEvent = null;
    private String docType;
    private Theme theme;
    private boolean updateAttributes = true;
    private String defaultImageLocation;
    private String defaultStyleLocation;
    private String defaultJavaScriptLocation;
    private boolean templateURLLocationFromTheme;
    private String configFileImageLocation;
    private String configFileStyleLocation;
    private String configFileJavaScriptLocation;
    private String configFileTemplateLocation;
    private String configFileTemplateURLLocation;
    private String configFileDynamicButtonRootName;
    private String configFileOutputCharacterEncoding;
    private String configFileInputCharacterEncoding;
    private GraphStyle configFileGraphStyle;
    private String configFileContextMenuLaunchEvent = null;
    private String configDocType;
    private String refreshURL;
    private int refreshInterval;
    private boolean autoComplete;
    private Map<TransformationInterface, String> viewerToPopUpLaunchEvent = Collections.synchronizedMap(new HashMap());
    private static ComponentPropertyManager defaultCPM = new ComponentPropertyManager();

    protected ComponentPropertyManager() {
    }

    public String getStyleSheetLinks(List l) {
        if (l == null) {
            l = this.getStyleSheetList();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < l.size(); ++i) {
            sb.append(prefix);
            sb.append(this.getStyleLocation() + l.get(i));
            sb.append(suffix);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    @SASScope
    public void writeStyleSheetLinks(PrintWriter out) {
        out.println(this.getStyleSheetLinks(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentPropertyManager getInstance(HttpServletRequest request) {
        ComponentPropertyManager cpm;
        block44: {
            cpm = null;
            if (request != null) {
                HttpSession session = request.getSession();
                ServletContext servletContext = session.getServletContext();
                HashMap<ServletContext, ComponentPropertyManager> mapOfCPMs = null;
                try {
                    mapOfCPMs = (HashMap<ServletContext, ComponentPropertyManager>)session.getAttribute("sas_ComponentPropertyManager");
                    if (mapOfCPMs != null) {
                        cpm = (ComponentPropertyManager)mapOfCPMs.get(servletContext);
                        cpm.setTheme(ComponentPropertyManager.getTheme(request));
                    } else {
                        mapOfCPMs = new HashMap<ServletContext, ComponentPropertyManager>();
                        session.setAttribute("sas_ComponentPropertyManager", mapOfCPMs);
                    }
                    if (cpm != null) break block44;
                    cpm = new ComponentPropertyManager();
                    int interval = request.getSession().getMaxInactiveInterval();
                    Integer ri = (Integer)request.getAttribute(META_REFRESH_INT);
                    if (null != ri) {
                        interval = ri;
                    }
                    cpm.setRefreshInterval(interval);
                    cpm.setAutoComplete(true);
                    cpm.setTheme(ComponentPropertyManager.getTheme(request));
                    String contextPath = request.getContextPath();
                    if (contextPath != null) {
                        cpm.setContextPath(contextPath + "/");
                        if (request.getScheme() != null && request.getServerName() != null) {
                            String absolutePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + cpm.getContextPath();
                            cpm.setAbsolutePath(absolutePath);
                        }
                    }
                    cpm.calcStyleSheetList(request);
                    mapOfCPMs.put(servletContext, cpm);
                    InputStream is = servletContext.getResourceAsStream("WEB-INF/sas_ComponentProperties.config");
                    Properties properties = new Properties();
                    try {
                        if (is != null) {
                            int style;
                            properties.load(is);
                            String property = properties.getProperty("ImageLocation");
                            if (property != null && property.length() > 0) {
                                cpm.setConfigFileImageLocation(property);
                            }
                            if ((property = properties.getProperty("StyleLocation")) != null && property.length() > 0) {
                                cpm.setConfigFileStyleLocation(property);
                            }
                            if ((property = properties.getProperty("JavaScriptLocation")) != null && property.length() > 0) {
                                cpm.setConfigFileJavaScriptLocation(property);
                            }
                            if ((property = properties.getProperty("TemplateLocation")) != null && property.length() > 0) {
                                cpm.setConfigFileTemplateLocation(property);
                            }
                            if ((property = properties.getProperty("TemplateURLLocation")) != null && property.length() > 0) {
                                cpm.setConfigFileTemplateURLLocation(property);
                            }
                            if ((property = properties.getProperty("DynamicButtonRootName")) != null && property.length() > 0) {
                                cpm.setConfigFileDynamicButtonRootName(property);
                            }
                            if ((property = properties.getProperty("OutputCharacterEncoding")) != null && property.length() > 0) {
                                cpm.setConfigFileOutputCharacterEncoding(property);
                            }
                            if ((property = properties.getProperty("InputCharacterEncoding")) != null && property.length() > 0) {
                                cpm.setConfigFileInputCharacterEncoding(property);
                            }
                            if ((property = properties.getProperty("ContextMenuLaunchEvent")) != null && property.length() > 0) {
                                cpm.configFileContextMenuLaunchEvent = property;
                            }
                            if ((property = properties.getProperty("DocType")) != null && property.length() > 0) {
                                cpm.configDocType = property;
                            }
                            if ((property = properties.getProperty("RefreshInterval")) != null && property.length() > 0) {
                                cpm.refreshInterval = Integer.parseInt(property);
                            }
                            if ((property = properties.getProperty("RefreshURL")) != null && property.length() > 0) {
                                cpm.refreshURL = property;
                            }
                            if ((property = properties.getProperty("autoComplete")) != null && property.length() > 0 && property.equalsIgnoreCase("off")) {
                                cpm.setAutoComplete(false);
                            }
                            if ((property = properties.getProperty("GraphStyle")) != null && (style = property.equals("STYLE_ANALYSIS") ? 100000 : (property.equals("STYLE_ASTRONOMY") ? 100001 : (property.equals("STYLE_BANKER") ? 100002 : (property.equals("STYLE_BLOCKPRINT") ? 100003 : (property.equals("STYLE_CONVENTION") ? 100004 : (property.equals("STYLE_CURVE") ? 100005 : (property.equals("STYLE_EDUCATION") ? 100006 : (property.equals("STYLE_ELECTRONICS") ? 100007 : (property.equals("STYLE_GEARS") ? 100008 : (property.equals("STYLE_MAGNIFY") ? 100009 : (property.equals("STYLE_MONEY") ? 100010 : (property.equals("STYLE_MONOCHROME") ? 100011 : (property.equals("STYLE_RSVP") ? 100012 : (property.equals("STYLE_SCIENCE") ? 100013 : (property.equals("STYLE_SKETCH") ? 100014 : (property.equals("STYLE_STATISTICAL") ? 100015 : (property.equals("STYLE_TORN") ? 100016 : (property.equals("STYLE_WATERCOLOR") ? 100017 : (property.equals("STYLE_OLAP") ? 100018 : -1))))))))))))))))))) != -1) {
                                cpm.setConfigFileGraphStyle(new GraphStyle(style));
                            }
                        }
                    }
                    catch (IOException e) {
                        System.out.println(RB.getStringResource(RB_KEY, "propertyFileError.txt"));
                    }
                    catch (NullPointerException ioe) {
                    }
                    finally {
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException ioe) {
                            LoggerRepository2.getLogger((String)ComponentPropertyManager.class.getName(), null).error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
                catch (IllegalStateException e) {
                    cpm = defaultCPM;
                }
                catch (ClassCastException e) {
                    cpm = defaultCPM;
                }
                catch (NullPointerException e) {
                    cpm = defaultCPM;
                }
                catch (UnsupportedOperationException e) {
                    cpm = defaultCPM;
                }
                catch (IllegalArgumentException e) {
                    cpm = defaultCPM;
                }
            } else {
                cpm = defaultCPM;
            }
        }
        return cpm;
    }

    private void calcStyleSheetList(HttpServletRequest request) {
        String browser = "IE";
        String version = "6";
        if (request != null) {
            ClientInfo ci = new ClientInfo(request);
            if (ci.isInternetExplorer()) {
                browser = "IE";
                version = ci.getBrowserVersion().startsWith("6") ? "6" : "7";
            } else {
                browser = "FF";
                double ffVersion = 0.0;
                try {
                    ffVersion = Double.parseDouble(ci.getBrowserVersion2());
                    version = ffVersion >= 4.0 ? "5" : "1.5";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ffVersion == 0.0) {
                    version = "1.5";
                }
            }
            if (this.styleSheetList == null) {
                this.styleSheetList = new Vector(1);
                this.styleSheetList.add("sasComponents_" + browser + "_" + version + ".css");
            }
        }
    }

    private String getConfigFileImageLocation() {
        return this.configFileImageLocation;
    }

    private void setConfigFileImageLocation(String configFileImageLocation) {
        this.configFileImageLocation = configFileImageLocation;
    }

    private String getConfigFileDynamicButtonRootName() {
        return this.configFileDynamicButtonRootName;
    }

    private void setConfigFileDynamicButtonRootName(String configFileDynamicButtonRootName) {
        this.configFileDynamicButtonRootName = configFileDynamicButtonRootName;
    }

    private String getConfigFileInputCharacterEncoding() {
        return this.configFileInputCharacterEncoding;
    }

    private void setConfigFileInputCharacterEncoding(String configFileInputCharacterEncoding) {
        this.configFileInputCharacterEncoding = configFileInputCharacterEncoding;
    }

    private String getConfigFileJavaScriptLocation() {
        return this.configFileJavaScriptLocation;
    }

    private void setConfigFileJavaScriptLocation(String configFileJavaScriptLocation) {
        this.configFileJavaScriptLocation = configFileJavaScriptLocation;
    }

    private String getConfigFileOutputCharacterEncoding() {
        return this.configFileOutputCharacterEncoding;
    }

    private void setConfigFileOutputCharacterEncoding(String configFileOutputCharacterEncoding) {
        this.configFileOutputCharacterEncoding = configFileOutputCharacterEncoding;
    }

    private String getConfigFileStyleLocation() {
        return this.configFileStyleLocation;
    }

    private void setConfigFileStyleLocation(String configFileStyleLocation) {
        this.configFileStyleLocation = configFileStyleLocation;
    }

    private String getConfigFileTemplateLocation() {
        return this.configFileTemplateLocation;
    }

    private void setConfigFileTemplateLocation(String configFileTemplateLocation) {
        this.configFileTemplateLocation = configFileTemplateLocation;
    }

    private String getConfigFileTemplateURLLocation() {
        return this.configFileTemplateURLLocation;
    }

    private void setConfigFileTemplateURLLocation(String configFileTemplateURLLocation) {
        this.configFileTemplateURLLocation = configFileTemplateURLLocation;
    }

    public void setGraphStyle(GraphStyle graphStyle) {
        this.graphStyle = graphStyle;
    }

    public GraphStyle getGraphStyle() {
        if (this.graphStyle == null) {
            if (this.configFileGraphStyle != null) {
                this.defaultGraphStyle = this.configFileGraphStyle;
            }
            if (this.defaultGraphStyle == null) {
                this.defaultGraphStyle = new GraphStyle(100018);
            }
            MarkerStyle[] markerStyles = this.defaultGraphStyle.getDataElementStyles().getMarkerStyles();
            this.defaultGraphStyle.setSelectionColor(Color.black);
            this.defaultGraphStyle.setSelectionAccentColor(Color.black);
            markerStyles[0].setConnectionOrder(40101);
            markerStyles[0].setInterpolation(40002);
            Color rowColor = ColorGradientUtil.findBackgroundColorFromTheme(this, ".OLAPTableRowHeader");
            Color colColor = ColorGradientUtil.findBackgroundColorFromTheme(this, ".OLAPTableColumnHeader");
            if (rowColor == null) {
                rowColor = new Color(241, 234, 203);
            }
            if (colColor == null) {
                colColor = new Color(241, 234, 203);
            }
            Color fillColor = colColor;
            this.defaultGraphStyle.setColumnAxisValueCellBackgroundColor(colColor);
            this.defaultGraphStyle.setRowAxisValueCellBackgroundColor(rowColor);
            this.defaultGraphStyle.getLegendBackgroundFillStyle().setSolidFillColor(fillColor);
            return this.defaultGraphStyle;
        }
        return this.graphStyle;
    }

    public String getImageLocation() {
        if (this.imageLocation == null) {
            String location2;
            if (this.theme != null && (location2 = this.theme.getFullPath("IMAGE")) != null) {
                return location2;
            }
            if (this.configFileImageLocation != null) {
                return this.configFileImageLocation;
            }
            if (this.updateAttributes) {
                this.updateDefaultAttributes();
            }
            return this.defaultImageLocation;
        }
        return this.imageLocation;
    }

    private void updateDefaultAttributes() {
        String path = this.getContextPath();
        this.defaultImageLocation = path + DEFAULT_IMAGE_LOCATION;
        this.defaultStyleLocation = path + DEFAULT_STYLE_LOCATION;
        this.defaultJavaScriptLocation = path + DEFAULT_JAVASCRIPT_LOCATION;
        this.updateAttributes = false;
    }

    public void setImageLocation(String location2) {
        this.imageLocation = location2;
    }

    public String getStyleLocation() {
        if (this.styleLocation == null) {
            String location2;
            if (this.theme != null && (location2 = this.theme.getFullPath("STYLE")) != null) {
                return location2;
            }
            if (this.configFileStyleLocation != null) {
                return this.configFileStyleLocation;
            }
            if (this.updateAttributes) {
                this.updateDefaultAttributes();
            }
            return this.defaultStyleLocation;
        }
        return this.styleLocation;
    }

    public void setStyleLocation(String location2) {
        this.styleLocation = location2;
    }

    public String getJavaScriptLocation() {
        if (this.javaScriptLocation == null) {
            if (this.configFileJavaScriptLocation != null) {
                return this.configFileJavaScriptLocation;
            }
            if (this.updateAttributes) {
                this.updateDefaultAttributes();
            }
            return this.defaultJavaScriptLocation;
        }
        return this.javaScriptLocation;
    }

    public void setJavaScriptLocation(String location2) {
        this.javaScriptLocation = location2;
    }

    public String getTemplateLocation() {
        if (this.templateLocation == null) {
            if (this.configFileTemplateLocation != null) {
                return this.configFileTemplateLocation;
            }
            return DEFAULT_TEMPLATE_LOCATION;
        }
        return this.templateLocation;
    }

    public void setTemplateLocation(String location2) {
        this.templateLocation = location2;
    }

    public String getDynamicButtonRootName() {
        if (this.dynamicButtonRootName == null) {
            if (this.configFileDynamicButtonRootName != null) {
                return this.configFileDynamicButtonRootName;
            }
            return DEFAULT_DYNAMIC_BUTTON_ROOT_NAME;
        }
        return this.dynamicButtonRootName;
    }

    public void setDynamicButtonRootName(String root) {
        this.dynamicButtonRootName = root;
    }

    public String getInputCharacterEncoding() {
        if (this.inputCharacterEncoding == null) {
            if (this.configFileInputCharacterEncoding != null) {
                return this.configFileInputCharacterEncoding;
            }
            return "UTF-8";
        }
        return this.inputCharacterEncoding;
    }

    public void setInputCharacterEncoding(String characterEncoding) {
        this.inputCharacterEncoding = characterEncoding;
    }

    public String getOutputCharacterEncoding() {
        if (this.outputCharacterEncoding == null) {
            if (this.configFileOutputCharacterEncoding != null) {
                return this.configFileOutputCharacterEncoding;
            }
            return "UTF-8";
        }
        return this.outputCharacterEncoding;
    }

    public void setOutputCharacterEncoding(String characterEncoding) {
        this.outputCharacterEncoding = characterEncoding;
    }

    public void setStyleSheetList(List list) {
        this.styleSheetList = list;
    }

    public List getStyleSheetList() {
        if (this.styleSheetList == null) {
            this.styleSheetList = new Vector(1);
            this.styleSheetList.add(DEFAULT_STYLE_SHEET);
        }
        return this.styleSheetList;
    }

    public String getTemplateURLLocation() {
        this.templateURLLocationFromTheme = false;
        if (this.templateURLLocation == null) {
            String location2;
            if (this.theme != null && (location2 = this.theme.getInternalFullPath("TEMPLATE")) != null) {
                this.templateURLLocationFromTheme = true;
                return location2;
            }
            if (this.configFileTemplateURLLocation != null) {
                return this.configFileTemplateURLLocation;
            }
        }
        return this.templateURLLocation;
    }

    public void setTemplateURLLocation(String url) {
        this.templateURLLocation = url;
    }

    protected void setContextPath(String requestingURI) {
        this.updateAttributes = true;
        this.contextPath = requestingURI;
    }

    protected String getContextPath() {
        return this.contextPath;
    }

    protected SASProfileInterface getSASProfile() {
        return null;
    }

    public void setSASProfile(SASProfileInterface sasProfile) {
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    private GraphStyle getConfigFileGraphStyle() {
        return this.configFileGraphStyle;
    }

    private void setConfigFileGraphStyle(GraphStyle configFileGraphStyle) {
        this.configFileGraphStyle = configFileGraphStyle;
    }

    @SASScope
    public String getContextMenuLaunchEvent() {
        if (this.contextMenuLaunchEvent == null) {
            if (this.configFileContextMenuLaunchEvent != null) {
                return this.configFileContextMenuLaunchEvent;
            }
            return DEFAULT_CONTEXT_MENU_LAUNCH_EVENT;
        }
        return this.contextMenuLaunchEvent;
    }

    @SASScope
    public void setContextMenuLaunchEvent(String contextMenuLaunchEvent) {
        this.contextMenuLaunchEvent = contextMenuLaunchEvent;
    }

    @SASScope
    public boolean isTemplateURLLocationFromTheme() {
        return this.templateURLLocationFromTheme;
    }

    @SASScope
    public String getDocType() {
        if (this.docType == null) {
            if (this.configDocType != null) {
                return this.configDocType;
            }
            return DEFAULT_DOCTYPE;
        }
        return this.docType;
    }

    @SASScope
    public void setDocType(String docType) {
        this.docType = docType;
    }

    @SASScope
    public String getImageURI(String componentImageKey) {
        return this.getImageURI(componentImageKey, null);
    }

    @SASScope
    public String getImageURI(String componentImageKey, String overrideLocation) {
        Image themeImage;
        String location2;
        Image defaultComponentImage = (Image)ComponentImages.getInstance().get(componentImageKey);
        String string = location2 = overrideLocation != null && !"".equals(overrideLocation.trim()) ? overrideLocation : this.imageLocation;
        if (location2 != null && location2.trim() != "" && defaultComponentImage != null) {
            return this.buildURI(location2, (BaseThemeElement)defaultComponentImage, false);
        }
        if (this.theme != null && (themeImage = this.theme.getImage(componentImageKey)) != null) {
            return themeImage.getFile();
        }
        if (defaultComponentImage == null) {
            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "unknownImageKey.txt"), componentImageKey));
        }
        if (this.configFileImageLocation != null) {
            return this.buildURI(this.configFileImageLocation, (BaseThemeElement)defaultComponentImage, false);
        }
        if (this.updateAttributes) {
            this.updateDefaultAttributes();
        }
        return this.buildURI(this.defaultImageLocation, (BaseThemeElement)defaultComponentImage, false);
    }

    @SASScope
    public String getTemplateURI(String componentTemplateKey) {
        String configLocation;
        String location2;
        Template defaultComponentTemplate = (Template)ComponentTemplates.getInstance().get(componentTemplateKey);
        String string = location2 = this.templateURLLocation == null ? this.templateLocation : this.templateURLLocation;
        if (location2 != null && location2.trim() != "" && defaultComponentTemplate != null) {
            this.templateURLLocationFromTheme = false;
            return this.buildURI(location2, (BaseThemeElement)defaultComponentTemplate, true);
        }
        if (this.theme != null) {
            this.templateURLLocationFromTheme = true;
            return this.theme.getTemplate(componentTemplateKey, false).getInternalFile();
        }
        this.templateURLLocationFromTheme = false;
        if (defaultComponentTemplate == null) {
            throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource(RB_KEY, "unknownTemplateKey.txt"), componentTemplateKey));
        }
        String string2 = configLocation = this.configFileTemplateURLLocation == null ? this.configFileTemplateLocation : this.configFileTemplateURLLocation;
        if (configLocation != null && configLocation.trim() != "") {
            return this.buildURI(configLocation, (BaseThemeElement)defaultComponentTemplate, true);
        }
        if (this.updateAttributes) {
            this.updateDefaultAttributes();
        }
        return this.buildURI(DEFAULT_TEMPLATE_LOCATION, (BaseThemeElement)defaultComponentTemplate, true);
    }

    @SASScope
    public String getImageName(String componentImageKey) {
        return this.getImageName(componentImageKey, null);
    }

    @SASScope
    public String getImageName(String componentImageKey, String overrideLocation) {
        String uri = this.getImageURI(componentImageKey, overrideLocation);
        String imageName = null;
        if (uri == null) {
            return imageName;
        }
        int index = uri.lastIndexOf("/");
        if (index == -1) {
            index = uri.lastIndexOf("\\");
        }
        return uri.substring(index == -1 ? 0 : (index == uri.length() - 1 ? 0 : index + 1));
    }

    private String buildURI(String location2, BaseThemeElement themeElement, boolean makeAbsolute) {
        if (makeAbsolute && location2.startsWith("/")) {
            String absolutePath = this.getAbsolutePath();
            if (absolutePath == null || absolutePath.equals("")) {
                return null;
            }
            if (absolutePath.endsWith("/")) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            return absolutePath + location2 + themeElement.getFile();
        }
        return location2 + themeElement.getFile();
    }

    @SASScope
    public static final Theme getTheme(HttpServletRequest request) {
        ValidateArg.notNull((Object)request, (String)"request");
        return (Theme)request.getAttribute("sas.framework.themeobject");
    }

    private void setTheme(Theme theme) {
        if (theme == null && this.theme != null) {
            LoggerRepository2.getLogger((String)ComponentPropertyManager.class.getName(), null).warn(RB.getStringResource(RB_KEY, "noThemeOnRequest.txt"));
        }
        this.theme = theme;
    }

    @SASScope
    public String getRefreshURL() {
        return this.refreshURL;
    }

    @SASScope
    public void setRefreshURL(String refreshURL) {
        this.refreshURL = refreshURL;
    }

    @SASScope
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    @SASScope
    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setAutoComplete(boolean value) {
        this.autoComplete = value;
    }

    public boolean isAutoComplete() {
        return this.autoComplete;
    }

    public void setContextMenuLaunchEvent(TransformationInterface tBean, String contextMenuLaunchEvent) {
        this.viewerToPopUpLaunchEvent.put(tBean, contextMenuLaunchEvent);
    }

    public String getContextMenuLaunchEvent(TransformationInterface tBean) {
        return this.viewerToPopUpLaunchEvent.get(tBean);
    }
}

