/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.codepolicy.SASScope;
import jakarta.servlet.http.HttpServletRequest;
import java.text.Collator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope(value="ALL")
public class ClientInfo {
    public static final int WML_UP_BROWSER = 1;
    public static final int WML_OTHER_BROWSER = 2;
    public static final int HDML_BROWSER = 3;
    public static final int HTML_BROWSER = 4;
    public static final String WML_CONTENT_TYPE = "text/vnd.wap.wml";
    public static final String HDML_CONTENT_TYPE = "text/x-hdml";
    public static final String HTML_CONTENT_TYPE = "text/html";
    private String userAgent;
    private String accept;
    private String browserType;
    private String browserVersion;
    private HttpServletRequest request;
    private Properties applicationSettings;
    private String mobileRegularExpression = "android|blackberry|up.browser|up.link|windows ce|ipod|iphone|palm|iemobile|mini|mmp|symbian|midp|wap|phone|pocket|mobile|pda|psp";

    public ClientInfo(HttpServletRequest request) {
        if (request != null) {
            this.userAgent = request.getHeader("USER_AGENT");
            this.accept = request.getHeader("ACCEPT");
            if (this.userAgent == null) {
                this.userAgent = request.getHeader("USER-AGENT");
            }
            this.request = request;
        }
        this.initialize();
    }

    public void initialize() {
        if (this.accept == null) {
            this.accept = "?";
        }
        if (this.userAgent == null) {
            this.browserType = "?";
            this.browserVersion = "?";
            return;
        }
        String agent = new String(this.userAgent);
        int upLinkOffset = agent.indexOf("UP.Link");
        if (upLinkOffset > -1) {
            agent = agent.substring(0, upLinkOffset);
        }
        if (agent.indexOf("AOL") > -1) {
            this.browserType = "AOL";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("AOL")));
        } else if (agent.indexOf("Blackberry") > -1) {
            this.browserType = "Blackberry";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Blackberry")));
        } else if (agent.indexOf("WebTV") > -1) {
            this.browserType = "WebTV";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("WebTV")));
        } else if (agent.indexOf("Firefox") > -1) {
            this.browserType = "Firefox";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Firefox")));
        } else if (agent.indexOf("MSIE") > -1 || agent.indexOf("Trident") > -1) {
            this.browserType = "MSIE";
            this.browserVersion = agent.indexOf("MSIE") > -1 ? this.getVersion(agent.substring(agent.indexOf("MSIE"))) : this.getVersion(agent.substring(agent.indexOf("rv:")));
        } else if (agent.indexOf("Netscape6") > -1) {
            this.browserType = "Netscape";
            String s = "Netscape6";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf(s) + s.length()));
        } else if (agent.indexOf("Netscape") > -1) {
            this.browserType = "Netscape";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Netscape")));
        } else if (agent.indexOf("Lynx") > -1) {
            this.browserType = "Lynx";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Lynx")));
        } else if (agent.indexOf("Opera") > -1) {
            this.browserType = "Opera";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Opera")));
        } else if (agent.indexOf("HotJava") > -1) {
            this.browserType = "HotJava";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("HotJava")));
        } else if (agent.indexOf("Webster Pro") > -1) {
            this.browserType = "Webster Pro";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Webster Pro")));
        } else if (agent.indexOf("Nokia-WAP-Toolkit") > -1) {
            this.browserType = "Nokia";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Nokia-WAP-Toolkit")));
        } else if (agent.indexOf("Nokia") > -1) {
            this.browserType = "Nokia";
            int versionIndex = (agent = agent.substring(agent.indexOf("Nokia"))).indexOf("(");
            if (versionIndex > -1) {
                this.browserVersion = this.getVersion(agent.substring(versionIndex));
            } else {
                versionIndex = agent.indexOf("/");
                if (versionIndex > -1) {
                    this.browserVersion = this.getVersion(agent.substring(versionIndex));
                }
            }
        } else if (agent.indexOf("Ericsson") > -1) {
            agent = agent.substring(agent.indexOf("Ericsson"));
            this.browserType = "Ericsson";
            int versionIndex = agent.indexOf("/");
            if (versionIndex > -1) {
                this.browserVersion = this.getVersion(agent.substring(versionIndex));
            }
        } else if (agent.indexOf("WAP-IDE") > -1) {
            this.browserType = "Ericsson";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("WAP-IDE")));
        } else if (agent.indexOf("WapIDE") > -1) {
            this.browserType = "Ericsson";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("WapIDE")));
        } else if (agent.indexOf("R380") > -1) {
            this.browserType = "Ericsson";
            String s = "R380";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf(s) + s.length()));
        } else if (agent.indexOf("WAPman") > -1) {
            this.browserType = "WAPman";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("WAPman")));
        } else if (agent.indexOf("AvantGo") > -1) {
            this.browserType = "AvantGo";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("AvantGo")));
        } else if (agent.indexOf("Elaine") > -1) {
            this.browserType = "PalmVII";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Elaine")));
        } else if (agent.indexOf("Oracle") > -1) {
            this.browserType = "Oracle";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Oracle")));
        } else if (agent.indexOf("Mosaic") > -1) {
            this.browserType = "Mosaic";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Mosaic")));
        } else if (agent.indexOf("PRODIGY") > -1) {
            this.browserType = "Prodigy";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("PRODIGY")));
        } else if (agent.indexOf("WebView") > -1) {
            this.browserType = "WebView";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("WebView")));
        } else if (agent.indexOf("MSPIE") > -1) {
            this.browserType = "MSPIE";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("MSPIE")));
        } else if (agent.indexOf("UP.Browser") > -1) {
            this.browserType = "UP";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("UP.Browser")));
        } else if (agent.indexOf("UP") > -1) {
            this.browserType = "UP";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("UP")));
        } else if (agent.indexOf("DoCoMo") > -1) {
            this.browserType = "imode";
            int versionIndex = agent.indexOf("/");
            if (versionIndex > -1 && versionIndex + 1 < agent.length() && (versionIndex = agent.indexOf("/", versionIndex + 1)) > -1) {
                agent = agent.substring(versionIndex);
                this.browserVersion = this.getVersion(agent);
            }
        } else if (agent.indexOf("Chrome") > -1) {
            this.browserType = "Chrome";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Chrome")));
        } else if (agent.indexOf("Safari") > -1) {
            this.browserType = "Safari";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Safari")));
        } else if (agent.indexOf("Mozilla") > -1) {
            this.browserType = "Netscape";
            this.browserVersion = this.getVersion(agent.substring(agent.indexOf("Mozilla")));
        } else {
            this.browserType = "?";
        }
        if (this.isUP()) {
            if (this.getAccept().indexOf("version=3.1") > -1 && Collator.getInstance().compare(this.browserVersion, "3.1") < 0) {
                this.browserVersion = "3.1";
            } else if (this.getAccept().indexOf("version=3.0") > -1 && Collator.getInstance().compare(this.browserVersion, "3.0") < 0) {
                this.browserVersion = "3.0";
            }
        }
    }

    private String getVersion(String agent) {
        if (agent != null && agent.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            boolean firstNumberSeen = false;
            for (int i = 0; i < agent.length(); ++i) {
                char c = agent.charAt(i);
                if (Character.isDigit(c)) {
                    firstNumberSeen = true;
                    buffer.append(c);
                    continue;
                }
                if (firstNumberSeen && c == '.') {
                    buffer.append(c);
                    continue;
                }
                if (firstNumberSeen) break;
            }
            if (buffer.length() == 0) {
                return "?";
            }
            return buffer.toString();
        }
        return "?";
    }

    public void setBrowserType(String browser) {
        this.browserType = browser;
    }

    public void setBrowserVersion(String version) {
        this.browserVersion = version;
    }

    public void setUserAgent(String agent) {
        this.userAgent = agent;
    }

    public void setAccept(String acceptHeader) {
        this.accept = acceptHeader;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    @SASScope
    public String getBrowserVersion2() {
        String ver = "";
        String fullVersion = this.getBrowserVersion();
        if (fullVersion != null) {
            int secondDotIndex;
            ver = fullVersion;
            int dotIndex = fullVersion.indexOf(".");
            if (dotIndex != -1 && (secondDotIndex = fullVersion.indexOf(".", dotIndex + 1)) != -1) {
                ver = fullVersion.substring(0, secondDotIndex);
            }
        }
        return ver;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getAccept() {
        return this.accept;
    }

    public boolean isInternetExplorer() {
        return this.browserType.equals("MSIE");
    }

    public boolean isIE11Plus() {
        return this.browserType.equals("MSIE") && this.userAgent.contains("Trident");
    }

    @SASScope
    public boolean isFirefox() {
        return this.browserType.equals("Firefox");
    }

    public boolean isNetscape() {
        return this.browserType.equals("Netscape");
    }

    public boolean isChrome() {
        return this.browserType.equals("Chrome");
    }

    public boolean isSafari() {
        return this.browserType.equals("Safari");
    }

    public boolean isUP() {
        return this.browserType.equals("UP");
    }

    public boolean isPalmVII() {
        return this.browserType.equals("PalmVII");
    }

    public boolean isWML() {
        if (this.accept.indexOf("wap") > -1) {
            return !this.isUP() || Collator.getInstance().compare(this.browserVersion, "3.1") >= 0;
        }
        return false;
    }

    public boolean isHDML() {
        return this.accept.indexOf("x-hdml") > -1;
    }

    public void setApplicationSettings(Properties settings) {
        this.applicationSettings = settings;
        if (this.applicationSettings != null && this.applicationSettings.containsKey("mobileRegularExpression")) {
            this.mobileRegularExpression = this.applicationSettings.getProperty("mobileRegularExpression");
        }
    }

    public boolean isMobile() {
        Pattern pattern = Pattern.compile(this.mobileRegularExpression);
        Matcher matcher = pattern.matcher(this.userAgent);
        if (matcher.find()) {
            return true;
        }
        if (this.request.getHeader("x-wap-profile") != null || this.request.getHeader("X-OperaMini-Phone") != null) {
            return true;
        }
        return this.isWML() || this.isHDML();
    }
}

