/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.util;

import com.sas.actionprovider.ActionProviderReference;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DoubleType;
import com.sas.datatypes.IntegerType;
import com.sas.datatypes.StringType;
import com.sas.entities.AttributeSetException;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Image;
import com.sas.framework.themes.client.MediaType;
import com.sas.framework.themes.client.Theme;
import com.sas.iom.SAS.IFileService;
import com.sas.iom.SAS.IWorkspace;
import com.sas.services.user.UserContextInterface;
import com.sas.servlet.tbeans.BaseButton;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.datasource.IFileDialog;
import com.sas.servlet.tbeans.datasource.directoryfile.DirectoryFileDialog;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.Hidden;
import com.sas.servlet.tbeans.remotefileselector2.html.IFileServiceSelector;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.Components;
import com.sas.servlet.util.DocType;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.servlet.util.RB;
import com.sas.svcs.config.client.ConfigurationServiceInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileNavigationModelInterface;
import com.sas.swing.models.remotefileselector2.ifileservice.IFileServiceAdapterSupport;
import com.sas.swing.visuals.DataSourceUtil;
import com.sas.text.Message;
import com.sas.util.ChainedException;
import com.sas.util.SimpleTemplateToPrintWriter;
import com.sas.util.Strings;
import com.sas.util.UncheckedException;
import com.sas.util.ValidateArg;
import com.sas.util.transforms.TransformException;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@SASScope(value="ALL")
public class BaseUtil {
    static final String RB_KEY = "BaseUtil.";
    public static final String BASE_AJAX_URL = "BASE_AJAX_URL";
    public static final String AJAX_URL_SUFFIX = "AJAX_URL_SUFFIX";
    public static final String AJAX_BASEUTIL_URL_TEMPLATE = "%BASE_AJAX_URL(%BASE_AJAX_URL)%AJAX_URL_SUFFIX(%AJAX_URL_SUFFIX)CLASS_PARAMETER=" + BaseUtil.class.getName() + "&id=%id";
    public static int MNEMONIC_ONLY = 1;
    public static int LABEL_ONLY = 2;
    public static int MNEMONIC_AND_LABEL = 3;
    private static char[] wmlSpecialCharacters = new char[]{'&', '$', '<', '>', '\'', '\"'};
    private static String[] wmlSpecialCharacterReplacements = new String[]{"&amp;", "$$", "&lt;", "&gt;", "&apos;", "&quot;"};
    private static char[] hdmlSpecialCharacters = new char[]{'&', '$', '<', '>', '\"'};
    private static String[] hdmlSpecialCharacterReplacements = new String[]{"&amp;", "&dol;", "&lt;", "&gt;", "&quot;"};
    private static char[] htmlSpecialCharacters = new char[]{'<', '>'};
    private static String[] htmlSpecialCharacterReplacements = new String[]{"&lt;", "&gt;"};
    private static char[] xmlSpecialCharacters = new char[]{'<', '>', '&'};
    private static String[] xmlSpecialCharacterReplacements = new String[]{"&#60;", "&#62;", "&#38;"};
    private static char[] specialCharacters = new char[]{'\"', '\\', '\''};
    private static String[] specialCharacterReplacements = new String[]{"\\\"", "\\\\", "\\'"};
    public static String COMPONENTS_INIT = "COMPONENTS_INIT";
    public static String CONTEXTPATH = "CONTEXTPATH";
    public static String IMAGE_LOCATION = "IMAGE_LOCATION";
    public static String STYLE_LOCATION = "STYLE_LOCATION";
    public static String JAVASCRIPT_LOCATION = "JAVASCRIPT_LOCATION";
    public static String TEMPLATE_LOCATION = "TEMPLATE_LOCATION";
    public static String SELECTOR = "SELECTOR";
    public static String DOC_TYPE = "DOC_TYPE";
    public static String DIRECTION = "DIRECTION";
    public static String TEXT_PLAIN_MIME_TYPE = "text/plain";
    public static final String POLICY_DISPLAY_SESSION_TIMEOUT_WARNING = "Policy.DisplaySessionTimeoutWarning";
    public static final String APP_SESSION_TIMEOUT_WARNING_INTERVAL = "App.SessionTimeoutWarningInterval";
    public static final int TIMEOUT_WARNING_INTERVAL_DEFAULT = 300;
    static final char[] b2c = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    static final char pad = '=';
    static byte[] c2b = null;
    private static final String REVERSED_ESCAPED_AMPERSAND = new StringBuffer("&amp;").reverse().toString();
    private static final String linkText = "<link rel=stylesheet href=\"";
    private static final String typeText = "\" type=\"text/css\" />";

    @SASScope
    public static Object getSessionObject(HttpServletRequest req, String name) throws ServletException {
        HttpSession session = req.getSession(true);
        if (session == null) {
            throw new ServletException(RB.getStringResource(RB_KEY, "noSession.txt"));
        }
        Object o = session.getAttribute(name);
        return o;
    }

    @SASScope
    public static void putSessionObject(HttpServletRequest req, String name, Object value) throws ServletException {
        HttpSession session = req.getSession(true);
        if (session == null) {
            throw new ServletException(RB.getStringResource(RB_KEY, "noSession.txt"));
        }
        if (value == null) {
            session.removeAttribute(name);
        } else {
            session.setAttribute(name, value);
        }
    }

    @SASScope
    public static final UserContextInterface getUserContext(HttpServletRequest request) throws ServletException {
        ValidateArg.notNull((Object)request, (String)"request");
        return (UserContextInterface)BaseUtil.getSessionObject(request, "sasUserContext_s");
    }

    @SASScope
    public static final String getUserName(HttpServletRequest request) throws ServletException {
        String retVal = "";
        UserContextInterface ucf = BaseUtil.getUserContext(request);
        if (null != ucf) {
            try {
                retVal = ucf.getName();
            }
            catch (RemoteException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return retVal;
    }

    public static String decodeBase64(String s) {
        if (c2b == null) {
            c2b = new byte[256];
            for (int b = 0; b < 64; b = (int)((byte)(b + 1))) {
                BaseUtil.c2b[(byte)BaseUtil.b2c[b]] = b;
            }
        }
        byte[] nibble = new byte[4];
        char[] decode = new char[s.length()];
        int d = 0;
        int n = 0;
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            nibble[n] = c2b[c];
            if (c == '=') break;
            switch (n) {
                case 0: {
                    ++n;
                    continue block6;
                }
                case 1: {
                    byte b = (byte)(nibble[0] * 4 + nibble[1] / 16);
                    decode[d++] = (char)b;
                    ++n;
                    continue block6;
                }
                case 2: {
                    byte b = (byte)((nibble[1] & 0xF) * 16 + nibble[2] / 4);
                    decode[d++] = (char)b;
                    ++n;
                    continue block6;
                }
                default: {
                    byte b = (byte)((nibble[2] & 3) * 64 + nibble[3]);
                    decode[d++] = (char)b;
                    n = 0;
                }
            }
        }
        String decoded = new String(decode, 0, d);
        return decoded;
    }

    @SASScope
    public static void resetBeanStringProperties(Object bean, ServletRequest request, String properties, boolean alwaysReset, String defaultValue) throws ServletException {
        boolean DEBUG = false;
        try {
            Class<?> c = bean.getClass();
            BeanInfo bi = Introspector.getBeanInfo(c);
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            String[] propertyNames = null;
            int numProps = 0;
            if (properties != null && !properties.equals("*")) {
                propertyNames = Strings.split((String)properties, null, (String)",", null);
                numProps = propertyNames.length;
            }
            String[] setterParms = new String[]{defaultValue};
            int numProperties = pd.length;
            for (int i = 0; i < numProperties; ++i) {
                Method writeMethod;
                String propertyName = pd[i].getName();
                Class<?> propertyType = pd[i].getPropertyType();
                if (propertyType != String.class || (writeMethod = pd[i].getWriteMethod()) == null || propertyNames != null && -1 == Strings.indexOf((String)propertyName, (String[])propertyNames)) continue;
                if (!alwaysReset) {
                    String[] values;
                    String parmValue = null;
                    if (request != null && (null != (values = request.getParameterValues(propertyName)) && values.length != 1 || (parmValue = values[0]) != null && Strings.trimmedLength((String)parmValue) != 0)) continue;
                }
                Object readMethod = null;
                try {
                    writeMethod.invoke(bean, (Object[])setterParms);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }
        catch (IntrospectionException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @SASScope
    public static String replaceXMLSpecialCharacters(String inputString) {
        return Strings.replace((String)inputString, (char[])xmlSpecialCharacters, (String[])xmlSpecialCharacterReplacements);
    }

    public static String replaceSpecialCharacters(String inputString, int browserType) {
        if (browserType == 1 || browserType == 2) {
            return Strings.replace((String)inputString, (char[])wmlSpecialCharacters, (String[])wmlSpecialCharacterReplacements);
        }
        if (browserType == 3) {
            return Strings.replace((String)inputString, (char[])hdmlSpecialCharacters, (String[])hdmlSpecialCharacterReplacements);
        }
        if (browserType == 4) {
            return Strings.replace((String)inputString, (char[])htmlSpecialCharacters, (String[])htmlSpecialCharacterReplacements);
        }
        return inputString;
    }

    @SASScope
    public static String escapeUrlAmpersands(String inputString) {
        if (inputString == null || inputString.indexOf(38) == -1) {
            return inputString;
        }
        int length = inputString.length();
        int equalIndex = inputString.lastIndexOf(61);
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int j = length - 1; j > equalIndex; --j) {
            buffer.append(inputString.charAt(j));
        }
        for (int i = equalIndex; i >= 0; --i) {
            char c1 = inputString.charAt(i);
            if (c1 != '&') {
                buffer.append(c1);
                continue;
            }
            boolean escapedAlready = false;
            if (!(i + 4 >= length || inputString.charAt(i + 1) != 'a' && inputString.charAt(i + 1) != 'A' || inputString.charAt(i + 2) != 'm' && inputString.charAt(i + 2) != 'M' || inputString.charAt(i + 3) != 'p' && inputString.charAt(i + 3) != 'P' || inputString.charAt(i + 4) != ';')) {
                escapedAlready = true;
            }
            buffer.append(escapedAlready ? "&" : REVERSED_ESCAPED_AMPERSAND);
            int prevIndex = i;
            i = inputString.lastIndexOf(61, i);
            for (int j = prevIndex - 1; j >= i && j >= 0; --j) {
                buffer.append(inputString.charAt(j));
            }
        }
        return buffer.reverse().toString();
    }

    @SASScope
    public static Form getDefaultFormObject(Object viewer, HttpServletRequest request, HttpServletResponse response) {
        Form form = null;
        String action = "";
        if (viewer != null && viewer instanceof BaseTransformation) {
            String controllerURL;
            HttpActionProvider actionProvider;
            form = new Form(((BaseTransformation)viewer).getId() + "_Form");
            if (viewer instanceof HttpActionProviderViewInterface && (actionProvider = ((HttpActionProviderViewInterface)viewer).getActionProvider()) != null && (controllerURL = actionProvider.getControllerURL()) != null) {
                action = controllerURL;
            }
        } else {
            form = new Form("_Form");
        }
        if (!action.equals("") && response != null) {
            action = response.encodeURL(action);
        }
        form.setAction(action);
        return form;
    }

    @SASScope
    public static String getDefaultFormAction(BaseTransformation viewer) {
        String action = null;
        if (viewer != null) {
            HttpServletResponse response;
            HttpServletRequest request;
            String controllerURL;
            HttpActionProvider actionProvider;
            if (viewer instanceof HttpActionProviderViewInterface && (actionProvider = ((HttpActionProviderViewInterface)((Object)viewer)).getActionProvider()) != null && (controllerURL = actionProvider.getControllerURL()) != null) {
                action = controllerURL;
            }
            if (action == null && (request = viewer.getRequest()) != null) {
                action = request.getRequestURI();
            }
            if (action != null && (response = viewer.getResponse()) != null) {
                action = response.encodeURL(action);
            }
        } else {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "nullViewer.txt"));
        }
        return action;
    }

    public static String escapeSpecialCharacters(String text) {
        return Strings.escapeForJavaScript((String)text);
    }

    @SASScope
    public static String escapeQuotesAndBackslash(String text) {
        String val = null;
        if (text != null) {
            val = Strings.replace((String)text, (char[])specialCharacters, (String[])specialCharacterReplacements);
        }
        return val;
    }

    public static void writeAdditionalParameters(HashMap additionalParameters, PrintWriter out) {
        if (additionalParameters != null) {
            Set keys = additionalParameters.keySet();
            for (String name : keys) {
                String value = (String)additionalParameters.get(name);
                Hidden.writeElement(out, null, name, value, true);
            }
        }
    }

    @SASScope
    public static String getCharacterEncoding(HttpServletRequest request, HttpServletResponse response) {
        if (response != null && response.getCharacterEncoding() != null) {
            return response.getCharacterEncoding();
        }
        if (request != null && request.getCharacterEncoding() != null) {
            return request.getCharacterEncoding();
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("file.encoding");
            }
        });
    }

    public static String getInputCharacterEncoding(HttpServletRequest request) {
        if (request != null && request.getCharacterEncoding() != null) {
            return request.getCharacterEncoding();
        }
        return ComponentPropertyManager.getInstance(request).getInputCharacterEncoding();
    }

    public static String getOutputCharacterEncoding(HttpServletRequest request) {
        String charset = null;
        if (request != null && (charset = request.getParameter("sas_charEncoding")) == null) {
            HttpSession session = request.getSession();
            charset = (String)session.getAttribute("sas_charEncoding");
        }
        if (charset == null || charset.length() == 0) {
            charset = ComponentPropertyManager.getInstance(request).getOutputCharacterEncoding();
        }
        return charset;
    }

    @SASScope
    public static OutputStreamWriter createOutputStreamWriter(ServletResponse response) {
        try {
            if (response != null) {
                ServletOutputStream out = response.getOutputStream();
                String charset = response.getCharacterEncoding();
                OutputStreamWriter writer = null;
                writer = charset != null ? new OutputStreamWriter((OutputStream)out, charset) : new OutputStreamWriter((OutputStream)out);
                return writer;
            }
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e, null);
        }
        return null;
    }

    public static String getRemoteSessionParameters(HttpServletRequest request, boolean firstParam) {
        String first = "";
        if (!firstParam) {
            first = "&";
        }
        String sessionid = request.getParameter("saspfs_http_root_session_id");
        String host = request.getParameter("saspfs_http_root_session_host");
        if (sessionid != null && host != null && sessionid.length() > 0 && host.length() > 0) {
            return first + "saspfs_http_root_session_id" + "=" + sessionid + "&" + "saspfs_http_root_session_host" + "=" + host;
        }
        return "";
    }

    public static void applySingleCommandAttributes(HttpServletRequest request, Object target, String parameterPrefix) {
        if (target == null || request == null) {
            return;
        }
        PropertyDescriptor[] pd = BaseUtil.getPropertyDescriptors(target);
        if (pd == null) {
            return;
        }
        String prefix = parameterPrefix == null ? "" : parameterPrefix;
        int length = Array.getLength(pd);
        for (int i = 0; i < length; ++i) {
            String attributeName = pd[i].getName();
            if (attributeName == null) continue;
            BaseUtil.setAttribute(target, pd[i], attributeName, BaseUtil.getObjectAttributeValue(request.getParameterValues(prefix + attributeName), pd[i].getPropertyType()));
        }
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Object source) {
        if (source == null) {
            return null;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(source.getClass());
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        PropertyDescriptor[] pd = null;
        if (beanInfo != null) {
            pd = beanInfo.getPropertyDescriptors();
        }
        return pd;
    }

    public static void setAttribute(Object target, PropertyDescriptor pd, String attributeName, Object objectAttributeValue) {
        if (target == null || pd == null || objectAttributeValue == null) {
            return;
        }
        Object attributeValue = null;
        attributeValue = objectAttributeValue instanceof ActionProviderReference ? ((ActionProviderReference)objectAttributeValue).get() : objectAttributeValue;
        Class<?> attributeTypeClass = pd.getPropertyType();
        if (attributeTypeClass != null && attributeTypeClass.isPrimitive()) {
            Method setter = pd.getWriteMethod();
            if (setter == null) {
                return;
            }
            Object[] args = new Object[]{attributeValue};
            try {
                setter.invoke(target, args);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        } else if (target instanceof DynamicAttributeCommandInterface) {
            if (attributeName != null) {
                try {
                    ((DynamicAttributeCommandInterface)target).setAttribute(attributeName, attributeValue);
                }
                catch (AttributeSetException setter) {}
            }
        } else {
            Method setter = pd.getWriteMethod();
            if (setter == null) {
                return;
            }
            Object[] args = new Object[]{attributeValue};
            try {
                setter.invoke(target, args);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static Object getObjectAttributeValue(String[] stringParameterValues, Class attributeTypeClass) {
        if (stringParameterValues == null || attributeTypeClass == null) {
            return null;
        }
        int numberOfParameters = stringParameterValues.length;
        if (numberOfParameters == 0) {
            return null;
        }
        try {
            Object objectAttributeValue = null;
            if (numberOfParameters == 1) {
                objectAttributeValue = stringParameterValues[0];
                if (objectAttributeValue != null) {
                    objectAttributeValue = com.sas.actionprovider.BaseUtil.getStringToTransforms().transform(objectAttributeValue, attributeTypeClass);
                }
            } else {
                objectAttributeValue = com.sas.actionprovider.BaseUtil.getStringArrayToTransforms().transform((Object)stringParameterValues, attributeTypeClass);
            }
            return objectAttributeValue;
        }
        catch (TransformException transformException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyCommandAttributesFromMap(DynamicAttributeCommandInterface command, Map attributesMap) {
        Set keySet;
        if (command == null || attributesMap == null || attributesMap.isEmpty()) {
            return;
        }
        Set set = keySet = attributesMap.keySet();
        synchronized (set) {
            for (String attributeName : keySet) {
                if (attributeName == null) continue;
                Object attributeValue = attributesMap.get(attributeName);
                if (attributeValue != null && attributeValue instanceof ActionProviderReference) {
                    attributeValue = ((ActionProviderReference)attributeValue).get();
                }
                if (attributeValue == null) continue;
                try {
                    command.setAttribute(attributeName, attributeValue);
                }
                catch (AttributeSetException attributeSetException) {}
            }
        }
    }

    public static void applyTbeanStringParameterValues(HttpServletRequest request, TransformationInterface tbean, Map parameterMap) {
        if (request != null) {
            Iterator parameterKeys = parameterMap.keySet().iterator();
            Class[] parmTypes = new Class[]{new String().getClass()};
            while (parameterKeys.hasNext()) {
                String parmKey = (String)parameterKeys.next();
                String parmName = (String)parameterMap.get(parmKey);
                String parmValue = request.getParameter(parmName);
                try {
                    Method setter = tbean.getClass().getMethod(parmKey, parmTypes);
                    String[] setterMethodArgs = new String[]{parmValue};
                    setter.invoke((Object)tbean, (Object[])setterMethodArgs);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
    }

    public static String getMnemonicLabel(String label, int showMnemonic) {
        StringBuffer parsedLabel = new StringBuffer();
        if (label != null) {
            boolean foundAmpersand = false;
            int len = label.length();
            for (int i = 0; i < len; ++i) {
                if ('&' == label.charAt(i)) {
                    if (foundAmpersand || i + 3 < len && "&gt;".equals(label.substring(i, i + 4)) || i + 3 < len && "&lt;".equals(label.substring(i, i + 4)) || i + 4 < len && "&amp;".equals(label.substring(i, i + 5)) || i + 5 < len && "&copy;".equals(label.substring(i, i + 6)) || i + 2 < len && "&#".equals(label.substring(i, i + 2))) {
                        if (showMnemonic != MNEMONIC_ONLY) {
                            parsedLabel.append(label.substring(i, i + 1));
                        }
                        foundAmpersand = false;
                        continue;
                    }
                    foundAmpersand = true;
                    continue;
                }
                if (foundAmpersand) {
                    if (showMnemonic == MNEMONIC_AND_LABEL) {
                        parsedLabel.append("<span class=\"mnemonic\">");
                    }
                    parsedLabel.append(label.substring(i, i + 1));
                    if (showMnemonic == MNEMONIC_AND_LABEL) {
                        parsedLabel.append("</span>");
                    }
                    if (showMnemonic == MNEMONIC_ONLY) {
                        break;
                    }
                } else if (showMnemonic != MNEMONIC_ONLY) {
                    parsedLabel.append(label.substring(i, i + 1));
                }
                foundAmpersand = false;
            }
        }
        return parsedLabel.toString();
    }

    public static void setLabelAndAccessKeyOnButton(BaseButton button, String text) {
        String label = BaseUtil.getMnemonicLabel(text, MNEMONIC_AND_LABEL);
        String accessKey = BaseUtil.getMnemonicLabel(text, MNEMONIC_ONLY);
        button.setAccessKey(accessKey);
        button.setLabel(label);
    }

    public static StringBuffer getFormattedMessage(Exception ex, Locale locale) {
        StringBuffer details = new StringBuffer("<p>");
        Throwable curException = ex;
        int whichCause = 1;
        while (curException != null) {
            String message = curException.getLocalizedMessage();
            if (message == null && (message = curException.getMessage()) == null) {
                message = RB.getStringResource(RB_KEY, "noDetails.txt", locale);
            }
            details.append("<b>").append(whichCause).append(". ").append(RB.getStringResource(RB_KEY, "cause.txt", locale)).append("</b><pre>").append(Strings.quoteForXML((String)message)).append("</pre>");
            StackTraceElement[] elements = curException.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                String styleStart = "";
                String styleEnd = "";
                if (elements[i].getClassName().startsWith("com.sas")) {
                    styleStart = "<span style=\"color:red;\">";
                    styleEnd = "</span>";
                } else if (elements[i].getClassName().startsWith("org.apache.jsp")) {
                    styleStart = "<span style=\"color:red\">";
                    styleEnd = "</span>";
                }
                details.append("<br/>&#160;&#160;&#160;&#160;at ").append(styleStart).append(elements[i].getClassName()).append(styleEnd).append(".").append(elements[i].getMethodName()).append("(").append(elements[i].getFileName()).append(":").append(elements[i].getLineNumber()).append(")");
            }
            if (curException instanceof JspException) {
                Throwable nextException = ((JspException)curException).getRootCause();
                if (nextException == null) {
                    curException = curException.getCause();
                }
                curException = nextException;
            } else if (curException instanceof ServletException) {
                Throwable nextException = ((ServletException)curException).getRootCause();
                if (nextException == null) {
                    curException = curException.getCause();
                }
                curException = nextException;
            } else {
                curException = ChainedException.getTargetException((Throwable)curException);
            }
            if (curException != null) {
                details.append("<br/><br/><b><i>" + RB.getStringResource(RB_KEY, "causedBy.txt", locale) + "&#160;" + " </i></b>");
            }
            ++whichCause;
        }
        details.append("</p>");
        return details;
    }

    @SASScope
    public static void writeDialog(PrintWriter out, HttpServletRequest request, TransformationInterface tbean, String templateFileName) throws IOException {
        BaseUtil.writeDialog(out, request, tbean, new HashMap(), templateFileName);
    }

    @SASScope
    public static void writeDialog(PrintWriter out, HttpServletRequest request, TransformationInterface tbean, HashMap dictionary, String template) throws IOException {
        if (dictionary == null) {
            dictionary = new HashMap<String, String>();
        }
        ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance(request);
        StringWriter docTypeWriter = new StringWriter();
        DocType.write(docTypeWriter, propertyManager.getDocType());
        docTypeWriter.flush();
        StringWriter componentsInitWriter = new StringWriter();
        PrintWriter componentsInitPrintWriter = new PrintWriter(componentsInitWriter);
        Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
        if (theme != null) {
            BrowserType browserType = (BrowserType)request.getAttribute("sas.framework.browsertype");
            String stylesString = BaseUtil.getStyleSheetLinks(theme, browserType, null);
            componentsInitPrintWriter.println(stylesString);
        }
        Components.init(componentsInitPrintWriter, request);
        BaseUtil.writeSessionTimeout(request, componentsInitPrintWriter, null, true);
        componentsInitWriter.flush();
        dictionary.put(COMPONENTS_INIT, componentsInitWriter.toString());
        dictionary.put(CONTEXTPATH, request.getContextPath());
        dictionary.put(IMAGE_LOCATION, propertyManager.getImageLocation());
        dictionary.put(STYLE_LOCATION, propertyManager.getStyleLocation());
        dictionary.put(JAVASCRIPT_LOCATION, propertyManager.getJavaScriptLocation());
        dictionary.put(TEMPLATE_LOCATION, propertyManager.getTemplateLocation());
        if (tbean != null) {
            dictionary.put(SELECTOR, tbean.toString());
        }
        dictionary.put(DOC_TYPE, docTypeWriter.toString());
        String direction = BaseUtil.isRTL(request) ? "rtl" : "ltr";
        dictionary.put(DIRECTION, direction);
        PrintWriter bufferedWriter = new PrintWriter(new BufferedWriter(out));
        SimpleTemplateToPrintWriter.write((String)template, dictionary, (PrintWriter)bufferedWriter);
        bufferedWriter.flush();
        out.println();
    }

    @SASScope
    public static boolean isRTL(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        Boolean rtlSupported = (Boolean)request.getAttribute("sas.framework.rtl");
        return rtlSupported != null && rtlSupported != false;
    }

    @SASScope
    public static String getSkipLinkAnchor(String name, String title) {
        return "<a href=\"#" + name + "\" title=\"" + title + "\"></a>";
    }

    @SASScope
    public static String getSkipLinkAnchorTarget(String name) {
        return "<a name=\"" + name + "\"></a>";
    }

    @SASScope
    public static void combinePathAndFilename(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IFileDialog dialog;
        IFileServiceSelector ifss;
        response.setContentType(TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        String filename = request.getParameter("filename");
        String id = request.getParameter("compId");
        String existCheckString = request.getParameter("existCheck");
        boolean existCheck = Boolean.valueOf(existCheckString);
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof IFileDialog && (ifss = (IFileServiceSelector)(dialog = (IFileDialog)ti).getComponent("FILE_REMOTE_FILE_SELECTOR")) != null) {
            RemoteFileNavigationModelInterface model = ifss.getModel();
            if (model != null) {
                String value = IFileServiceAdapterSupport.combinePathAndFileName((IFileService)ifss.getWorkspace().FileService(), (String)model.getLocation(), (String)filename);
                out.print("var return_Obj = {");
                if (existCheck && !DataSourceUtil.isExistingFile((IWorkspace)ifss.getWorkspace(), (String)value)) {
                    String error = new Message(com.sas.swing.visuals.remotefileselector2.RB.getStringResource((String)"RemoteFileSelector.", (String)"unavailablePathMessage.txt", (Locale)ti.getLocale()), (Object)filename).toString();
                    out.print("error : \"" + Strings.escapeForJavaScript((String)error, (boolean)true) + "\"");
                } else {
                    out.print("pathAndFilename : \"" + Strings.escapeForJavaScript((String)value, (boolean)true) + "\"");
                    dialog.closeResources();
                }
                out.print("}");
            } else {
                dialog.closeResources();
            }
        }
    }

    @SASScope
    public static void cleanupResources(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        String id = request.getParameter("compId");
        TransformationInterface ti = (TransformationInterface)ComponentSessionManager.getSessionManager(request).get(id);
        if (ti instanceof IFileDialog) {
            ((IFileDialog)ti).closeResources();
        } else if (ti instanceof DirectoryFileDialog) {
            ((DirectoryFileDialog)ti).closeResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SASScope
    public static void validateByType(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType(TEXT_PLAIN_MIME_TYPE);
        PrintWriter out = response.getWriter();
        DataTypeInterface dataType = BaseUtil.getDataTypeFromString(request.getParameter("type"));
        out.print("var return_Obj = {");
        try {
            Object result = dataType.coerceValue((Object)request.getParameter("value"), request.getLocale());
            out.print("value: \"" + String.valueOf(result) + "\"");
        }
        catch (IllegalArgumentException ex) {
            out.print("error: \"" + Strings.escapeForJavaScript((String)ex.getLocalizedMessage(), (boolean)true) + "\"");
        }
        finally {
            out.println("}");
        }
    }

    protected static DataTypeInterface getDataTypeFromString(String typeStr) {
        IntegerType dataType = null;
        if ("INTEGER".equalsIgnoreCase(typeStr)) {
            dataType = IntegerType.DEFAULT_INSTANCE;
        } else if ("DOUBLE".equalsIgnoreCase(typeStr)) {
            dataType = DoubleType.DEFAULT_INSTANCE;
        } else if ("STRING".equalsIgnoreCase(typeStr)) {
            dataType = StringType.DEFAULT_INSTANCE;
        }
        return dataType;
    }

    @SASScope
    public static final String getStyleSheetLinks(Theme theme, BrowserType browserType, String styleNames) {
        ValidateArg.notNull((Object)theme, (String)"theme");
        ValidateArg.notNull((Object)browserType, (String)"browserType");
        StringBuilder buf = new StringBuilder(512);
        Collection styles = theme.getStyleSheetsForNamedStyles(MediaType.SCREEN, browserType, styleNames);
        if (!styles.isEmpty()) {
            Iterator styleItor = styles.iterator();
            while (styleItor.hasNext()) {
                String style = (String)styleItor.next();
                buf.append(linkText);
                buf.append(style).append(typeText);
                if (!styleItor.hasNext()) continue;
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    @SASScope
    public static final String getImageFromTheme(Theme theme, String imageName, String imageDivID, String onClick, String resourceBundle, Locale locale) {
        ValidateArg.notNull((Object)theme, (String)"theme");
        ValidateArg.notNull((Object)imageName, (String)"imageName");
        Image image = theme.getImage(imageName);
        StringBuilder img = new StringBuilder(512);
        img.append("<img src=\"").append(image.getFile()).append("\" border=\"0\"");
        String str = image.getAltTextKey();
        if (null != str) {
            if (null != resourceBundle && null != locale) {
                ResourceBundle bundle = ResourceBundle.getBundle(resourceBundle, locale);
                str = bundle.getString(str);
            }
            img.append(" alt=\"").append(str).append("\"");
        }
        if (null != (str = image.getDescription())) {
            img.append(" title=\"").append(str).append("\"");
        }
        if (null != (str = image.getHeight())) {
            img.append(" height=\"").append(str).append("\"");
        }
        if (null != (str = image.getWidth())) {
            img.append(" width=\"").append(str).append("\"");
        }
        if (null != imageDivID) {
            img.append(" id=\"").append(imageDivID).append("\"");
        }
        if (null != onClick) {
            img.append(" onClick=\"").append(onClick).append("\"");
        }
        img.append(">");
        return img.toString();
    }

    public static Properties getApplicationSettings(HttpServletRequest request) {
        Properties appSettings = null;
        HttpSession session = request.getSession();
        try {
            WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)session.getServletContext());
            if (ac != null) {
                String appName;
                Map beans = ac.getBeansOfType(ConfigurationServiceInterface.class);
                if (null == beans || beans.isEmpty()) {
                    throw new IllegalStateException("Cannot obtain a ConfigurationServiceInterface from Spring's ApplicationContext.");
                }
                ConfigurationServiceInterface configurationService = (ConfigurationServiceInterface)beans.values().iterator().next();
                if (configurationService != null && (appName = session.getServletContext().getInitParameter("application-name")) != null) {
                    appSettings = configurationService.getSettings(appName);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return appSettings;
    }

    public static boolean isTimeoutWarningEnabled(HttpServletRequest request) {
        String value;
        Properties settings = BaseUtil.getApplicationSettings(request);
        return settings != null && (value = settings.getProperty(POLICY_DISPLAY_SESSION_TIMEOUT_WARNING)) != null && value.equalsIgnoreCase("true");
    }

    public static int getTimeoutWarningDuration(HttpServletRequest request) {
        String value;
        int duration = 300;
        Properties settings = BaseUtil.getApplicationSettings(request);
        if (settings != null && (value = settings.getProperty(APP_SESSION_TIMEOUT_WARNING_INTERVAL)) != null) {
            try {
                duration = Integer.valueOf(value) * 60;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return duration;
    }

    @SASScope
    public static StringBuffer getTimeoutScript(HttpServletRequest request, String url, int refreshInterval, String function, boolean dialog) {
        return BaseUtil.getTimeoutScript(request, url, refreshInterval, function, dialog, false, false, true);
    }

    public static StringBuffer getTimeoutScript(HttpServletRequest request, String url, int refreshInterval, String function, boolean dialog, boolean disableWarning, boolean frames, boolean centerWarning) {
        String path;
        if (url == null) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
            url = cpm.getRefreshURL();
        }
        boolean isWarningEnabled = false;
        isWarningEnabled = disableWarning ? false : BaseUtil.isTimeoutWarningEnabled(request);
        int warningDuration = 0;
        if (isWarningEnabled && (warningDuration = BaseUtil.getTimeoutWarningDuration(request)) > refreshInterval) {
            isWarningEnabled = false;
            throw new IllegalStateException("App.SessionTimeoutWarningInterval in metadata can no be longer than the HttpSession maxInactiveInterval (session-timeout). Timeout warning has been disabled.");
        }
        StringBuffer sb = new StringBuffer();
        if (isWarningEnabled) {
            path = JavaScriptIncludeHandler.getPath(request);
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_Bootstrap.js\"></script>\n");
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_Common.js\"></script>\n");
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_FastClickProtection_CustomFunctions.js\"></script>\n");
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_FastClickProtection.js\"></script>\n");
        } else if (frames) {
            path = JavaScriptIncludeHandler.getPath(request);
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_Bootstrap.js\"></script>\n");
            sb.append("<script type=\"text/javascript\" src=\"" + path + "sas_Common.js\"></script>\n");
        }
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("var sas_framework_timeout;\n");
        if (isWarningEnabled) {
            sb.append("var sas_framework_timeout_warning;\n");
            sb.append("var sas_framework_timeout_warning_counter;\n");
        }
        if (null == function || function.trim().length() == 0) {
            function = "sas_framework_onTimeout()";
            sb.append("function sas_framework_onTimeout() {\n");
            if (dialog) {
                sb.append("  if (window.opener) { \n");
                sb.append("      if (typeof window.opener.sas_framework_onTimeout != 'undefined') {\n");
                sb.append("      \twindow.opener.sas_framework_onTimeout();\n");
                sb.append("      }\n");
                sb.append("      window.close();\n");
                sb.append("  }\n");
                if (url != null) {
                    sb.append("   else {\n");
                    sb.append("   \t\tvar url = '" + url + "';\n");
                    sb.append("   \t\tif(window.top){\n");
                    sb.append("\t\t      \twindow.top.location.href = url;\n");
                    sb.append("   \t\t}\n");
                    sb.append("   \t\telse {\n");
                    sb.append("\t\t      \twindow.location.href = url;\n");
                    sb.append("   \t\t}\n");
                    sb.append("   }\n");
                }
            } else if (url != null) {
                sb.append("   var url = '" + url + "';\n");
                sb.append("   if(window.top){\n");
                sb.append("\t\twindow.top.location.href = url;\n");
                sb.append("   }\n");
                sb.append("   else {\n");
                sb.append("\t\twindow.location.href = url;\n");
                sb.append("   }\n");
            }
            sb.append("}\n");
        }
        if (frames) {
            sb.append("function sas_framework_updateTimeout() {\n");
            sb.append("   sas_framework_extendOtherSessions(window.top);\n");
            sb.append("   sas_framework_updateFrameTimeout();\n");
            sb.append("}\n");
            sb.append("function sas_framework_extendOtherSessions(parentWindow) {\n");
            sb.append("  if (parentWindow.frames.length > 0) {\n");
            sb.append("\t\tfor (var i=0; i < parentWindow.frames.length; i++) {\n");
            sb.append("\t\t  try {\n");
            sb.append("var f = parentWindow.frames[i];\n");
            sb.append("if (f != self) {\n");
            sb.append("\t\t\t    if (f.frames.length > 0) {\n");
            sb.append("\t\t          sas_framework_extendOtherSessions(f);\n");
            sb.append("\t\t        }\n");
            sb.append("\t\t        if (typeof f.sas_framework_extendSession != 'undefined') {\n");
            sb.append("\t\t          f.sas_framework_extendSession();\n");
            sb.append("\t\t        }\n");
            sb.append("\t\t      }\n");
            sb.append("\t\t  }\n");
            sb.append("\t\t  catch (err) {}\n");
            sb.append("\t\t}\n");
            sb.append("  }\n");
            sb.append("}\n");
            sb.append("function sas_framework_updateFrameTimeout() {\n");
            sb.append("  self.clearTimeout(sas_framework_timeout);\n");
            if (isWarningEnabled) {
                sb.append("  sas_framework_timeout = self.setTimeout('sas_framework_showTimeoutWarning()', " + (refreshInterval - warningDuration) * 1000 + ");\n");
            } else {
                sb.append("  sas_framework_timeout = self.setTimeout('" + function + "', " + refreshInterval * 1000 + ");\n");
            }
            sb.append("}\n");
        } else {
            sb.append("function sas_framework_updateTimeout() {\n");
            sb.append("  self.clearTimeout(sas_framework_timeout);\n");
            if (isWarningEnabled) {
                sb.append("  sas_framework_timeout = self.setTimeout('sas_framework_showTimeoutWarning()', " + (refreshInterval - warningDuration) * 1000 + ");\n");
            } else {
                sb.append("  sas_framework_timeout = self.setTimeout('" + function + "', " + refreshInterval * 1000 + ");\n");
            }
            if (dialog) {
                sb.append("  if (window.opener) { \n");
                sb.append("  if (typeof window.opener.sas_framework_updateTimeout != 'undefined') {\n");
                if (isWarningEnabled) {
                    sb.append("  \t\t\tself.setTimeout(function(){window.opener.sas_framework_updateTimeout();},0);\n");
                } else {
                    sb.append("  \t\t\twindow.opener.sas_framework_updateTimeout();\n");
                }
                sb.append("      }\n");
                sb.append("   }\n");
            }
            sb.append("}\n");
        }
        if (isWarningEnabled) {
            ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
            StringBuffer innerHTML = new StringBuffer();
            String timeoutWarningTitle = RB.getStringResource(RB_KEY, "timeoutWarningTitle.txt", request.getLocale());
            Object[] args = new Object[]{Integer.toString(warningDuration)};
            String timeoutWarning = MessageFormat.format(RB.getStringResource(RB_KEY, "timeoutWarning.txt", request.getLocale()), args);
            String timeoutWarningContinue = RB.getStringResource(RB_KEY, "timeoutWarningContinue.txt", request.getLocale());
            String timeoutWarningButton = RB.getStringResource(RB_KEY, "timeoutWarningButton.txt", request.getLocale());
            String imageSrc = "";
            try {
                imageSrc = cpm.getImageURI("MessageWarning_24");
            }
            catch (Exception e) {
                imageSrc = cpm.getImageLocation() + "MessageWarning24.gif";
            }
            innerHTML.append("<div class='timeoutInnerShadow'><div class='timeoutDiv'>");
            innerHTML.append(" <div class='timeoutTitle' id='timeoutTitle'>");
            innerHTML.append(timeoutWarningTitle);
            innerHTML.append(" </div>");
            innerHTML.append(" <table id='timeoutMessage' class='timeoutMessage'>");
            innerHTML.append("  <tr>");
            innerHTML.append("   <td style='vertical-align:top;padding-right:5px'><img border='0' alt='' src='").append(imageSrc).append("'/></td>");
            innerHTML.append("   <td style='padding:0px 0px 0px 0px'>");
            innerHTML.append("     <div>" + timeoutWarning + "</div>");
            innerHTML.append("     <div>" + timeoutWarningContinue + "</div>");
            innerHTML.append("   </td>");
            innerHTML.append("  </tr>");
            innerHTML.append(" </table>");
            innerHTML.append(" <div class='timeoutButton'>");
            innerHTML.append("  <button id='sas_framework_timeout_warning_button' class='button' style='padding-top:0px;padding-bottom:0px' onClick='sas_framework_continueButtonHandler()'>");
            innerHTML.append(timeoutWarningButton);
            innerHTML.append("  </button>");
            innerHTML.append(" </div>");
            innerHTML.append("</div></div>");
            sb.append("function sas_framework_showTimeoutWarning() {\n");
            if (frames) {
                sb.append("  if (window.top.warningShown != null) {\n");
                sb.append("    return;");
                sb.append("  }else{\n");
                sb.append("    window.top.warningShown = true;");
                sb.append("  }");
            }
            if (dialog) {
                sb.append("  if (window.opener) {\n");
                sb.append("  \tif (typeof window.opener.sas_framework_timeout != 'undefined') {\n");
                sb.append("    \t\twindow.opener.clearTimeout(window.opener.sas_framework_timeout);\n");
                sb.append("      }\n");
                sb.append("  }\n");
                sb.append("  sas_registerEventHandler(window,'beforeunload',sas_framework_dialogUnloadHandler,false);\n");
            }
            sb.append("  var div = document.createElement('div');\n");
            sb.append("  div.setAttribute('id', 'sas_framework_timeout_div');\n");
            sb.append("  div.setAttribute('role', 'alertdialog');\n");
            sb.append("  div.setAttribute('aria-live', 'assertive');\n");
            sb.append("  div.setAttribute('aria-labelledby', 'timeoutTitle');\n");
            sb.append("  div.setAttribute('aria-describedby', 'timeoutMessage');\n");
            sb.append("  div.className='timeoutOuterShadow';\n");
            sb.append("  div.innerHTML = \"" + innerHTML.toString() + "\";\n");
            sb.append("  sas_framework_timeout_warning_counter = " + warningDuration + ";\n");
            sb.append("  self.clearTimeout(sas_framework_timeout_warning);\n");
            sb.append("  document.body.appendChild(div);\n");
            sb.append("  sas_centerObject(div);\n");
            if (!centerWarning) {
                sb.append("  div.style.top = '0px';\n");
            }
            sb.append("  sas_framework_timeout_warning = self.setInterval(sas_framework_timeoutWarningHandler,1000);\n");
            sb.append("  if (typeof sas_FastClick_createFastClickManager != 'undefined' && sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' )\n");
            sb.append("  {\n");
            sb.append("      if (window.fastClickManager == null){\n");
            sb.append("          sas_FastClick_createFastClickManager();\n");
            sb.append("          if (window.fastClickManager.setClickHandlerEnabled != null && typeof fastClickManager.setClickHandlerEnabled == 'function') {\n");
            sb.append("\t             window.fastClickManager.setClickHandlerEnabled(false);\n");
            sb.append("          }\n");
            sb.append("      }\n");
            sb.append("  }\n");
            sb.append("  if (window.fastClickManager && window.fastClickManager.protectPage != null && typeof fastClickManager.protectPage == 'function') {\n");
            sb.append("      window.fastClickManager.setProtectionType('EXCLUSIVE');\n");
            sb.append("      window.fastClickManager.setProtectionAffectedObjects([div]);\n");
            sb.append("  \t loaded=true;\n");
            sb.append("      window.fastClickManager.protectPage();\n");
            sb.append("  }\n");
            sb.append("  var button = document.getElementById('sas_framework_timeout_warning_button');\n");
            sb.append("  if (button != null){button.focus();}\n");
            sb.append("}\n");
            sb.append("function sas_framework_timeoutWarningHandler() {\n");
            sb.append("  sas_framework_timeout_warning_counter--;\n");
            sb.append("  var span = document.getElementById('timeoutSeconds');\n");
            sb.append("  if (span != null){\n");
            sb.append("  \tspan.innerHTML = sas_framework_timeout_warning_counter;\n");
            sb.append("  }\n");
            sb.append("  if (sas_framework_timeout_warning_counter == 0){\n");
            if (dialog) {
                sb.append("  sas_unRegisterEventHandler(window,'beforeunload',sas_framework_dialogUnloadHandler,false);\n");
            }
            sb.append("  \tself.clearTimeout(sas_framework_timeout_warning);\n");
            sb.append("  \t" + function + "\n");
            sb.append("  }\n");
            sb.append("}\n");
            if (dialog) {
                sb.append("function sas_framework_dialogUnloadHandler() {\n");
                sb.append("      if (window.opener && (typeof window.opener.sas_framework_extendSession != 'undefined')) {\n");
                sb.append("  \t\t\twindow.opener.sas_framework_extendSession();\n");
                sb.append("      }\n");
                sb.append("}\n");
            }
            sb.append("function sas_framework_continueButtonHandler() {\n");
            if (dialog) {
                sb.append("  sas_unRegisterEventHandler(window,'beforeunload',sas_framework_dialogUnloadHandler,false);\n");
            }
            sb.append("  sas_framework_extendSession();\n");
            if (frames) {
                sb.append("  sas_framework_extendOtherSessions(window.top);\n");
            }
            sb.append("}\n");
        }
        if (frames || isWarningEnabled) {
            sb.append("function sas_framework_extendSession() {\n");
            if (isWarningEnabled) {
                sb.append("  self.clearTimeout(sas_framework_timeout_warning);\n");
                sb.append("  var div = document.getElementById('sas_framework_timeout_div');\n");
                sb.append("  if (window.fastClickManager && window.fastClickManager.unprotectPage != null && typeof fastClickManager.unprotectPage == 'function') {\n");
                sb.append("      window.fastClickManager.unprotectPage();\n");
                sb.append("  }\n");
                sb.append("  if (div) {\n");
                sb.append("  \tdocument.body.removeChild(div);\n");
                sb.append("  }\n");
            }
            sb.append("  var timestamp = new Date();\n");
            sb.append("\t var url = '").append(request.getContextPath()).append("/Director?_sessionTouch=true&tstamp=' + timestamp.getTime();\n");
            sb.append("   var xmlhttp = sas_createXMLHttpRequest();\n");
            sb.append("   xmlhttp.open('POST', url, true);\n");
            sb.append("   xmlhttp.send('');\n");
            if (frames) {
                sb.append("  window.top.warningShown = null;\n");
                sb.append("  sas_framework_updateFrameTimeout();\n");
            } else {
                sb.append("  sas_framework_updateTimeout();\n");
            }
            sb.append("}\n");
        }
        sb.append("sas_framework_updateTimeout();\n");
        sb.append("</script>\n");
        return sb;
    }

    @SASScope
    public static void writeSessionTimeout(HttpServletRequest request, Writer out, String function, boolean dialog) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        ComponentPropertyManager cpm = ComponentPropertyManager.getInstance(request);
        int refreshInterval = cpm.getRefreshInterval();
        StringBuffer sb = BaseUtil.getTimeoutScript(request, cpm.getRefreshURL(), refreshInterval, function, dialog);
        writer.println(sb);
    }
}

