/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.webmddbview;

import com.sas.codepolicy.SASScope;
import com.sas.idesupport.ExperimentalInterface;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.webmddbview.RB;
import com.sas.util.Strings;
import com.sas.util.Util;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Vector;

@SASScope(value="ALL")
public class WebMDDBView
extends BaseTransformation
implements ExperimentalInterface {
    private RandomAccessFile raf;
    private int iStart;
    private int iEnd;
    private int start;
    private int end;
    private int recLen;
    private String fileName;
    private String reportType;
    private Vector expands;
    private String reportTitle;
    private String detailTitle;
    private String expandTableHeader;
    private String detailTableHeader;
    ByteArrayOutputStream byteArrayOS = null;
    public static final int NULL_COMMAND = 0;
    public static final int EXPAND_COMMAND = 1;
    public static final int COLLAPSE_COMMAND = 2;
    public static final int SHOW_DETAIL_DATA_COMMAND = 4;
    public static final String RB_KEY = "WebMDDBView.";

    public WebMDDBView() {
        this(Util.getName((String)"mddbView"));
    }

    public WebMDDBView(String name) {
        this.setDescription("WebMDDBView object");
        this.expands = new Vector();
        this.setId(name);
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        boolean isStart = false;
        if (this.raf == null) {
            throw new IOException(RB.getStringResource(RB_KEY, "error.fileNotSet.txt", this.getLocale()));
        }
        if (this.start == 0 && this.end == 0 || this.iStart == 0 && this.iEnd == 0) {
            isStart = true;
            byte[] temp = new byte[10];
            this.raf.seek(0L);
            this.raf.read(temp);
            String s = new String(temp);
            try {
                this.iStart = Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new IOException(ne.getMessage());
            }
            this.start = this.iStart;
            this.raf.read(temp);
            s = new String(temp);
            try {
                this.iEnd = Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new IOException(ne.getMessage());
            }
            this.end = this.iEnd;
            this.raf.seek(24L);
            this.raf.read(temp);
            s = new String(temp);
            try {
                this.recLen = Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new IOException(ne.getMessage());
            }
            if (this.iStart == 5) {
                this.raf.seek(this.recLen + 24);
                temp = new byte[this.recLen - 24];
                this.raf.read(temp);
                this.expandTableHeader = new String(temp);
                this.raf.seek(this.recLen * 2 + 24);
                this.raf.read(temp);
                this.detailTableHeader = new String(temp);
                this.raf.seek(this.recLen * 3 + 24);
                this.raf.read(temp);
                this.reportTitle = new String(temp);
                this.raf.seek(this.recLen * 4 + 24);
                this.raf.read(temp);
                this.detailTitle = new String(temp);
            } else if (this.iStart == 3) {
                this.raf.seek(this.recLen + 24);
                temp = new byte[this.recLen - 24];
                this.raf.read(temp);
                this.expandTableHeader = new String(temp);
                this.raf.seek(this.recLen * 2 + 24);
                this.raf.read(temp);
                this.reportTitle = new String(temp);
            }
            this.reportType = "E";
        } else {
            this.reportType = this.getRecordType(this.start);
        }
        if (this.end - this.start + 1 < 0) {
            throw new IOException(RB.getStringResource(RB_KEY, "error.invalidStartEnd.txt", this.getLocale()));
        }
        StringBuffer sb = new StringBuffer();
        if (this.reportType.trim().equals("E")) {
            out.println(this.reportTitle);
        } else if (this.reportType.trim().equals("D")) {
            out.println(this.detailTitle);
        }
        String style = this.getStyle();
        String styleClass = this.getStyleClass();
        String custAttr = this.getCustomAttributes();
        String epilog = this.getTagEpilog();
        String prolog = this.getTagProlog();
        if (prolog != null) {
            sb.append(prolog);
        }
        sb.append("<table border=1 ");
        if (style != null) {
            sb.append(" style=\"" + style + "\" ");
        }
        if (styleClass != null) {
            sb.append(" class=\"" + styleClass + "\" ");
        }
        if (custAttr != null) {
            sb.append(custAttr);
        }
        sb.append(">");
        out.println(sb.toString());
        if (this.reportType.trim().equals("E")) {
            out.println(this.expandTableHeader);
            this.readBlock(this.raf, out, this.iStart, this.iEnd);
        } else if (this.reportType.trim().equals("D")) {
            out.println(this.detailTableHeader);
            this.readBlock(this.raf, out, this.start, this.end);
        }
        out.println("</table>");
        if (epilog != null) {
            out.println(epilog);
        }
    }

    private String getRecordType(int recNum) throws IOException {
        long offset = recNum * this.recLen + 20;
        this.raf.seek(offset);
        byte[] flag = new byte[4];
        this.raf.read(flag);
        return new String(flag);
    }

    private void readBlock(RandomAccessFile raf, PrintWriter out, int start, int end) throws IOException {
        int expandCount = this.expands.size();
        for (int c = start; c <= end; ++c) {
            long soffset = c * this.recLen + 24;
            long eoffset = (c + 1) * this.recLen - 1;
            raf.seek(soffset);
            byte[] b = new byte[(int)(eoffset - soffset) + 1];
            raf.read(b);
            String str = new String(b);
            out.println(this.encodeURL(str, c));
            if (!this.reportType.trim().equals("E")) continue;
            for (int i = 0; i < expandCount; ++i) {
                location sl = (location)this.expands.get(i);
                String compare = "?start=" + sl.start + "&end=" + sl.end;
                if (str.indexOf(compare.trim()) <= -1) continue;
                int sIndex = str.indexOf("start=");
                int eIndex = str.indexOf("&end=", sIndex);
                int eEnd = str.indexOf("\">", eIndex);
                String s = str.substring(sIndex + 6, eIndex);
                String e = str.substring(eIndex + 5, eEnd);
                try {
                    int newStart = Integer.parseInt(str.substring(sIndex + 6, eIndex));
                    int newEnd = Integer.parseInt(str.substring(eIndex + 5, eEnd));
                    this.readBlock(raf, out, newStart, newEnd);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(nfe.getMessage());
                }
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fname) throws IOException {
        this.fileName = fname;
        if (this.raf != null) {
            this.raf.close();
        }
        try {
            this.raf = new RandomAccessFile(fname, "r");
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException(fnfe.getMessage());
        }
        catch (SecurityException se) {
            throw new IOException(se.getMessage());
        }
    }

    public void setFileName(String fname, PageContext pc) throws IOException {
        ServletContext sc = pc.getServletContext();
        if (sc != null) {
            String realPath = sc.getRealPath(fname);
            this.setFileName(realPath);
        }
    }

    public void setFileName(String fname, ServletContext sc) throws IOException {
        String realPath = sc.getRealPath(fname);
        this.setFileName(realPath);
    }

    public int processCommand(PageContext pageContext) throws IOException {
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        HttpServletResponse resp = (HttpServletResponse)pageContext.getResponse();
        JspWriter out = pageContext.getOut();
        out.clearBuffer();
        return this.processCommand(req, resp);
    }

    public int processCommand(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block7: {
            this.setRequest(req);
            this.setResponse(resp);
            String startStr = req.getParameter("start");
            String endStr = req.getParameter("end");
            String recNumStr = req.getParameter("recnum");
            try {
                this.start = Integer.parseInt(startStr);
                this.end = Integer.parseInt(endStr);
                int recNum = Integer.parseInt(recNumStr);
                this.reportType = this.getRecordType(this.start);
                if (this.reportType.trim().equals("E")) {
                    int cnt = this.expands.size();
                    boolean found = false;
                    for (int i = 0; i < cnt; ++i) {
                        location l = (location)this.expands.get(i);
                        if (!l.equals(this.start, this.end)) continue;
                        found = true;
                        for (int j = 0; j < this.expands.size(); ++j) {
                            location location2 = (location)this.expands.get(j);
                        }
                        Object o = this.expands.remove(i);
                        this.removeChildren((location)o);
                        return 2;
                    }
                    if (!found) {
                        this.expands.add(new location(this.start, this.end, recNum));
                        return 1;
                    }
                    break block7;
                }
                return 4;
            }
            catch (NumberFormatException nfe) {
                this.start = 0;
                this.end = 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    private String encodeURL(String htmlString, int recNum) {
        String returnString = htmlString;
        int pos = htmlString.toUpperCase().indexOf("HREF=\"");
        while (pos > -1) {
            int endpos = htmlString.indexOf("\"", pos + 6);
            if (endpos > -1) {
                String hrefString = htmlString.substring(pos + 6, endpos);
                HttpServletResponse resp = this.getResponse();
                String replaceString = resp.encodeURL(hrefString + "&recnum=" + recNum);
                returnString = Strings.replace((String)returnString, (int)0, (int)-1, (String)hrefString, (String)replaceString);
            }
            pos = htmlString.toUpperCase().indexOf("HREF=\"", endpos + 1);
        }
        return returnString;
    }

    private void removeChildren(location l) {
        int i;
        int cStart = l.start;
        int cEnd = l.end;
        Vector<location> children = new Vector<location>();
        for (i = 0; i < this.expands.size(); ++i) {
            location loc = (location)this.expands.get(i);
            if (loc.recordNumber < this.start || loc.recordNumber > cEnd) continue;
            children.add(loc);
        }
        for (i = 0; i < children.size(); ++i) {
            boolean removed = this.expands.remove(children.get(i));
            this.removeChildren((location)children.get(i));
        }
    }

    @SASScope
    class location {
        public int start;
        public int end;
        public int recordNumber;

        public location(int s, int e, int recNum) {
            this.start = s;
            this.end = e;
            this.recordNumber = recNum;
        }

        public boolean equals(int s, int e) {
            return s == this.start && e == this.end;
        }

        public String toString() {
            return "Location Object: Start=" + this.start + " End=" + this.end + " Record Number=" + this.recordNumber;
        }
    }
}

