/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.valuepicker;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.actionprovider.ActionList;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.StringType;
import com.sas.datatypes.TimeStampType;
import com.sas.datatypes.TimeType;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.tableview.AbstractBaseTableView;
import com.sas.servlet.tbeans.tableview.TableCellContentsRenderer;
import com.sas.servlet.tbeans.tableview.TableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.swing.models.ValueProviderModelAdapter;
import com.sas.util.DatePeriod;
import com.sas.util.ValueItem;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;

public class ValuePickerTableCellRenderer
extends DefaultTableCellRenderer
implements TableCellRenderer {
    private DataTypeInterface dataType;

    public ValuePickerTableCellRenderer() {
        this((DataTypeInterface)null);
    }

    public ValuePickerTableCellRenderer(DataTypeInterface dataType) {
        this.dataType = dataType;
    }

    @Override
    public void write(PrintWriter out, AbstractBaseTableView tableview, Object value, String name, ActionList actions) throws IOException {
        if (this.isValueItemSeparator(value)) {
            this.writeSeparatorHtml(out, tableview);
            return;
        }
        Locale locale = this.getLocale();
        Object returnValue = null;
        if (value instanceof ValueItem) {
            ValueItem item = (ValueItem)value;
            Object input = item.getLabelObject();
            if (input instanceof Date) {
                returnValue = input instanceof Time ? TimeType.DEFAULT_INSTANCE.getDisplayString(input, locale) : (input instanceof Timestamp ? TimeStampType.DEFAULT_INSTANCE.getDisplayString(input, locale) : DateType.DEFAULT_INSTANCE.getDisplayString(input, locale));
            } else if (item.getLabel() != null) {
                if (item.getValue() instanceof DataSourceColumnInterface) {
                    StringBuffer label = new StringBuffer();
                    label.append(((DataSourceColumnInterface)item.getValue()).getColumnLabel()).append(" [").append(((DataSourceColumnInterface)item.getValue()).getColumnName()).append("]");
                    returnValue = label.toString();
                } else if (!(this.dataType instanceof BaseDateType)) {
                    returnValue = item.getLabel();
                }
            }
        } else if (value instanceof SpecialValues) {
            returnValue = SpecialValues.toDisplayString((SpecialValues)((SpecialValues)value), (Locale)locale);
        }
        if (this.dataType != null && returnValue == null) {
            MissingValues missingValue2;
            if (value instanceof MissingValues) {
                returnValue = MissingValues.toDisplayString((MissingValues)((MissingValues)value), (Locale)locale);
            } else if (value instanceof String && !(this.dataType instanceof StringType) && (missingValue2 = MissingValues.getNumericMissingValues((String)((String)value))) != null) {
                returnValue = MissingValues.toDisplayString((MissingValues)missingValue2, (Locale)locale);
            }
            if (returnValue == null && value instanceof Date) {
                returnValue = value instanceof Time ? TimeType.DEFAULT_INSTANCE.getDisplayString(value, locale) : (value instanceof Timestamp ? TimeStampType.DEFAULT_INSTANCE.getDisplayString(value, locale) : this.dataType.getDisplayString(this.dataType.coerceValue(value, locale), locale));
            }
            if (returnValue == null) {
                try {
                    returnValue = this.dataType instanceof CollectionType && value instanceof String ? value : this.dataType.getDisplayString(this.dataType.coerceValue(value, locale), locale);
                }
                catch (Exception missingValue2) {
                    // empty catch block
                }
            }
        }
        if (returnValue instanceof DatePeriod) {
            returnValue = ((DatePeriod)returnValue).toDisplayString(null, locale);
        } else if (returnValue instanceof SpecialValues) {
            returnValue = SpecialValues.toDisplayString((SpecialValues)((SpecialValues)returnValue), (Locale)locale);
        } else if (returnValue instanceof MissingValues) {
            returnValue = MissingValues.toDisplayString((MissingValues)((MissingValues)returnValue), (Locale)locale);
        }
        if (returnValue == null) {
            returnValue = value;
        }
        String customAttributes = this.getCustomAttributes();
        StyleInfo currentStyleInfo = this.getStyleInfo();
        ResizingUtil.writeBeginCell(out, tableview, this);
        TableCellContentsRenderer tableCellContentsRenderer = this.getTableCellContentsRenderer();
        tableCellContentsRenderer.setRequest(tableview.getRequest());
        tableCellContentsRenderer.setResponse(tableview.getResponse());
        tableCellContentsRenderer.setLocale(this.getLocale());
        TransformationInterface tbean = tableCellContentsRenderer.getCellContentsRendererComponent(tableview, value, actions);
        if (tbean instanceof Label) {
            ((Label)tbean).setEncodeWhiteSpace(true);
            if (value instanceof ValueItem && returnValue == null) {
                ((Label)tbean).setText(((ValueItem)value).getLabel());
            } else {
                ((Label)tbean).setText(returnValue == null ? null : returnValue.toString());
            }
        }
        tbean.write(out);
        this.setCustomAttributes(customAttributes);
        this.setStyleInfo(currentStyleInfo);
        this.writeEndCell(out);
    }

    private boolean isValueItemSeparator(Object input) {
        return input != null && input.equals(ValueProviderModelAdapter.SEPARATOR);
    }

    private void writeSeparatorHtml(PrintWriter out, AbstractBaseTableView table) {
        StyleInfo separatorStyleInfo = (StyleInfo)table.getParentComposite().getParentComposite().getStyleMap().get(ValuePicker.VALUEPICKER_SEPARATOR_STYLE);
        String styleInfoString = separatorStyleInfo == null ? "class='valuePickerSeparator'" : separatorStyleInfo.write(new StringBuffer(), null).toString();
        out.print("<td><div" + styleInfoString + "></div></td>");
    }
}

