/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.valuepicker;

import com.sas.datatypes.DataTypeInterface;
import com.sas.models.itemlistmanager.InsertRowInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.html.Button;
import com.sas.servlet.tbeans.html.ValueListEditor;
import com.sas.servlet.tbeans.itemlistmanager.AbstractItemListManager;
import com.sas.servlet.tbeans.tableview.html.DefaultTableCellRenderer;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.valuepicker.ValuePicker;
import com.sas.servlet.tbeans.valuepicker.ValuePickerTableCellRenderer;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.swing.models.ValueItemsToTableModelAdapter;
import com.sas.swing.visuals.dualselector.RB;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class TargetValueListEditor
extends ValueListEditor {
    private static final long serialVersionUID = 1L;
    private boolean valueDisplayed;
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "ValuePickerValueListEditor.html";
    private static final String ITEMLISTMANAGER_TABLE_CONTAINER_CELL = "ITEMLISTMANAGER_TABLE_CONTAINER_CELL";
    public static final String RB_KEY = "ValueProviderTableSelector.";
    private int selectionMode;

    public TargetValueListEditor(ValuePicker valuePicker, DataTypeInterface dataType) {
        super(null, null);
        this.setTemplateKey("Value_Picker_Value_List_Editor");
        this.setRowPageSize(100);
        StyleInfo targetTableContainer = (StyleInfo)this.getStyleMap().get("ITEMLISTMANAGER_TABLE_CONTAINER");
        String height = valuePicker.getEditorComponent() == null ? "250px" : "280px";
        HashMap<String, String> dictionary = this.getTemplateDictionary();
        dictionary = new HashMap<String, String>();
        dictionary.put("VALUELISTEDITOR_HEIGHT", height);
        this.setTemplateDictionary(dictionary);
        this.getStyleMap().put("ITEMLISTMANAGER_TABLE_CONTAINER", new StyleInfo(targetTableContainer.getClassid() + " valuePickerTargetContainer"));
        this.getStyleMap().put(ITEMLISTMANAGER_TABLE_CONTAINER_CELL, new StyleInfo("valuePickerTargetCell"));
        this.valueDisplayed = valuePicker.getValueProvider() != null ? valuePicker.getValueProvider().isValueDisplayed() : false;
        TableView targetTableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        targetTableView.setDefaultRenderer(new ValuePickerTableCellRenderer(dataType));
        targetTableView.setCellPadding(0);
        this.selectionMode = valuePicker.getSelectionMode();
    }

    @Override
    protected void prepareTableForWrite() {
        super.prepareTableForWrite();
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            this.controller.enableEditor = false;
        }
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        TableView targetTableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)targetTableView.getDefaultRenderer();
        if (this.selectionMode == 301 || this.selectionMode == 302) {
            renderer.setCustomAttributes("onDblClick='" + this.getButtonOnClick(BUTTON_DELETE) + "'");
        }
        super.write(out);
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        Button btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_DELETE);
        if (btn != null) {
            btn.setButtonType(4);
            btn.setWidthPercentage(-1);
            btn.setTabIndex(0);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("buttonCenter"));
        }
        if ((btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_MOVE_DOWN)) != null) {
            btn.setButtonType(4);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("buttonCenter"));
            btn.setTabIndex(0);
            btn.setWidthPercentage(-1);
        }
        if ((btn = (Button)this.getPredefinedButton(ValueListEditor.BUTTON_MOVE_UP)) != null) {
            btn.setButtonType(4);
            btn.getStyleMap().put("BUTTON_STYLE", new StyleInfo("buttonCenter"));
            btn.setTabIndex(0);
            btn.setWidthPercentage(-1);
        }
    }

    @Override
    public void setModel(TableModel model) {
        if (model == null) {
            ValueItemsToTableModelAdapter tableModel = new ValueItemsToTableModelAdapter(new ArrayList());
            List columns = ListFactory.newList();
            if (this.valueDisplayed) {
                columns.add("VALUE");
                columns.add("LABEL");
                tableModel.setColumns(columns);
                tableModel.setColumnName(RB.getStringResource((String)RB_KEY, (String)"value.txt", (Locale)this.getLocale()), 0);
                tableModel.setColumnName(RB.getStringResource((String)RB_KEY, (String)"label.txt", (Locale)this.getLocale()), 1);
            }
            model = tableModel;
        }
        super.setModel(model);
    }

    @Override
    public Object getModel() {
        Object model = super.getModel();
        if (model == null || model instanceof DefaultTableModel) {
            ValueItemsToTableModelAdapter tableModel = new ValueItemsToTableModelAdapter(new ArrayList());
            List columns = ListFactory.newList();
            if (this.valueDisplayed) {
                columns.add("VALUE");
                columns.add("LABEL");
                tableModel.setColumns(columns);
                tableModel.setColumnName(RB.getStringResource((String)RB_KEY, (String)"value.txt", (Locale)this.getLocale()), 0);
                tableModel.setColumnName(RB.getStringResource((String)RB_KEY, (String)"label.txt", (Locale)this.getLocale()), 1);
                model = tableModel;
                TableView targetTableView = (TableView)this.getComponent("ITEMLISTMANAGER_TABLE");
                targetTableView.setColumnHeaderVisible(true);
                targetTableView.setModel((TableModel)tableModel);
                this.setModel((TableModel)tableModel);
            }
        }
        return model;
    }

    public static void ajax_AddRow(HttpServletRequest request, HttpServletResponse response) {
        if (request == null || response == null) {
            return;
        }
        TargetValueListEditor ilm = (TargetValueListEditor)TargetValueListEditor.getItemListManager(request);
        CommonLoggerInterface logger = LoggerRepository2.getLogger((String)AbstractItemListManager.class.getPackage().getName(), null);
        if (ilm != null && ilm.getModel() != null) {
            try {
                TargetValueListEditor.commitUncommittedValues(ilm, request);
                String value = request.getParameter("ilmRowValue");
                TableView tableView = (TableView)ilm.getComponent("ITEMLISTMANAGER_TABLE");
                TableModel model = TargetValueListEditor.getILMTableModel(ilm);
                int newSelectedRowIndex = -1;
                if (model instanceof InsertRowInterface) {
                    InsertRowInterface insertModel = (InsertRowInterface)model;
                    int row = ilm.getRowCount();
                    if (insertModel.canInsertRow(row)) {
                        logger.debug("ajax_AddRow: attempt insert row at: " + row);
                        if (value == null) {
                            newSelectedRowIndex = insertModel.insertRow(row);
                        } else {
                            String text = request.getParameter("ilmRowText");
                            ValueItem vi = new ValueItem();
                            vi.setValue((Object)value);
                            if (text != null) {
                                vi.setLabel(text);
                            }
                            Object[] obj = new Object[]{vi};
                            newSelectedRowIndex = insertModel.insertRow(obj, row);
                        }
                        logger.debug("ajax_AddRow: row inserted at : " + newSelectedRowIndex);
                    } else {
                        logger.debug("ajax_AddRow: model doesn't support insert row at: " + row);
                    }
                }
                ilm.clearSelectedRows();
                if (newSelectedRowIndex != -1) {
                    ilm.addRowSelectionInterval(newSelectedRowIndex, newSelectedRowIndex);
                }
                int endRow = tableView.getEndRow();
                if (newSelectedRowIndex != -1 && endRow != -1 && newSelectedRowIndex > endRow && tableView.isGotoRowSupported()) {
                    tableView.gotoRow(newSelectedRowIndex + 1);
                }
                response.setContentType("text/xml");
                String tableHTML = TargetValueListEditor.getTableHTML(request, response, tableView);
                StringBuffer sb = new StringBuffer();
                sb.append(JavaScriptIncludeHandler.getStartScript());
                sb.append(ilm.getTableControllerJavaScript());
                int rowCount = tableView == null ? -1 : tableView.getRowCount();
                sb.append(ilm.getId() + ".rowCount=" + rowCount + ";");
                sb.append(ilm.getId() + ".updateComponent();");
                sb.append(JavaScriptIncludeHandler.getEndScript(null));
                String script = sb.toString();
                String xml = TargetValueListEditor.writeAJAXResponseXML(new String[]{TargetValueListEditor.getTableXML(tableHTML), TargetValueListEditor.getButtonState(ilm), script, TargetValueListEditor.getActionTypeXML("ADD_ROW"), ilm.getNavBarXML("rowNavBar", request, response)});
                PrintWriter out = response.getWriter();
                out.println(xml);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

