/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class MaximumValueValidator
extends JavaScriptValidator {
    public static final String INTEGER = "INTEGER";
    public static final String FLOAT = "FLOAT";
    @SASScope
    public static final String RB_KEY = "MaximumValueValidator.";
    @SASScope
    protected int max;
    protected String type;

    public MaximumValueValidator() {
        this(100);
    }

    public MaximumValueValidator(int max) {
        this.setValidationFunctionName("sas_Validator_isMaxValueValid");
        this.max = max;
        this.type = INTEGER;
    }

    public void setMaxValue(int max) {
        this.max = max;
    }

    public int getMaxValue() {
        return this.max;
    }

    @SASScope
    public void setType(String type) {
        this.type = type;
    }

    @SASScope
    public String getType() {
        return this.type;
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"MaximumValueValidator\";");
        out.println(this.getId() + "_Obj.type = \"" + this.getType() + "\";");
        out.println(this.getId() + "_Obj.maxValue = " + this.getMaxValue() + ";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)Message.format((String)RB.getStringResource(RB_KEY, "greaterThanMaxValue.txt", bean.getLocale()), (Object)this.getDescription(bean), (Object)Integer.toString(this.max))) + "\";");
        }
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "greaterThanMaxValue.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        return "max: " + this.max + ", type:'" + this.type + "'";
    }
}

