/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class MaximumLengthValidator
extends JavaScriptValidator {
    @SASScope
    public static final String RB_KEY = "MaximumLengthValidator.";
    @SASScope
    protected int max;

    public MaximumLengthValidator() {
        this(50);
    }

    public MaximumLengthValidator(int max) {
        this.setValidationFunctionName("sas_Validator_isMaxLengthValid");
        this.max = max;
    }

    public void setMaxLength(int max) {
        this.max = max;
    }

    public int getMaxLength() {
        return this.max;
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "greaterThanMaxLength.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        return "max: " + this.max;
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"MaximumLengthValidator\";");
        out.println(this.getId() + "_Obj.maxLength = " + this.getMaxLength() + ";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)Message.format((String)RB.getStringResource(RB_KEY, "greaterThanMaxLength.txt", bean.getLocale()), (Object)this.getDescription(bean), (Object)Integer.toString(this.max))) + "\";");
        }
    }
}

