/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationObjectCreationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidationOnChangeInterface;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.Strings;
import com.sas.util.Util;
import com.sas.util.validators.Validator;
import java.io.PrintWriter;

@SASScope(value="ALL")
public class JavaScriptValidator
extends Validator
implements JavaScriptValidationOnChangeInterface,
JavaScriptValidationObjectCreationInterface {
    @SASScope
    public static final String RB_KEY = "JavaScriptValidator.";
    private String validationFunctionName;
    private String errorHandlerFunctionName;
    private String clearErrorsFunctionName;
    private boolean validationOnChange;
    private boolean validateContinuous;
    private String id;

    public JavaScriptValidator() {
        this.setId(Util.getName((String)"Validator"));
        this.message = null;
        this.validationFunctionName = null;
        this.errorHandlerFunctionName = null;
        this.clearErrorsFunctionName = null;
        this.validationOnChange = false;
        this.validateContinuous = true;
    }

    @Override
    @SASScope
    public void setId(String value) {
        this.id = value;
    }

    @Override
    @SASScope
    public String getId() {
        return this.id;
    }

    @Override
    public void setValidationFunctionName(String name) {
        this.validationFunctionName = name;
    }

    @Override
    public String getValidationFunctionName() {
        return this.validationFunctionName;
    }

    @Override
    public void setErrorHandlerFunctionName(String name) {
        this.errorHandlerFunctionName = name;
    }

    @Override
    public String getErrorHandlerFunctionName() {
        return this.errorHandlerFunctionName;
    }

    @Override
    public void setClearErrorsFunctionName(String name) {
        this.clearErrorsFunctionName = name;
    }

    @Override
    public String getClearErrorsFunctionName() {
        return this.clearErrorsFunctionName;
    }

    @SASScope
    public void setValidateContinuous(boolean value) {
        this.validateContinuous = value;
    }

    @SASScope
    public boolean isValidateContinuous() {
        return this.validateContinuous;
    }

    @Override
    public String createValidationFunctionCall(TransformationInterface bean) {
        StringBuffer sb = new StringBuffer();
        String elementName = bean.getName();
        String elementId = bean.getId();
        String funcName = this.getValidationFunctionName();
        String errorFuncName = this.getErrorHandlerFunctionName();
        String clearErrorsFuncName = this.getClearErrorsFunctionName();
        String parameters = this.getValidationParameters(bean);
        sb.append(funcName);
        sb.append("(window.event, {elementName:'").append(elementName).append("'");
        sb.append(", elementId:'").append(elementId).append("'");
        if (errorFuncName != null) {
            sb.append(", errorFunctionName:'").append(errorFuncName).append("'");
        }
        if (clearErrorsFuncName != null) {
            sb.append(", clearErrorFunctionName: '").append(clearErrorsFuncName).append("'");
        }
        if (parameters != null) {
            sb.append(",").append(parameters);
        }
        sb.append(", validationOnChange: " + this.isValidationOnChange());
        sb.append(", validateContinuous: " + this.isValidateContinuous());
        sb.append(", message: '");
        if (this.getValidationMessage() != null) {
            sb.append(Strings.escapeForJavaScript((String)this.getValidationMessage().toString())).append("'");
        } else {
            sb.append(Strings.escapeForJavaScript((String)this.getDefaultValidationMessage(bean))).append("'");
        }
        sb.append("})");
        return sb.toString();
    }

    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return RB.getStringResource(RB_KEY, "notValid.txt", bean.getLocale());
    }

    protected String getValidationParameters(TransformationInterface bean) {
        return null;
    }

    @Override
    @SASScope
    public void setValidationOnChange(boolean value) {
        this.validationOnChange = value;
    }

    @Override
    @SASScope
    public boolean isValidationOnChange() {
        return this.validationOnChange;
    }

    protected String getDescription(TransformationInterface bean) {
        if (bean.getDescription() != null) {
            return bean.getDescription();
        }
        return bean.getName();
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        out.println(this.getId() + "_Obj = new sas_Validator();");
        out.println(this.getId() + "_Obj.id = \"" + this.getId() + "\";");
        out.println(this.getId() + "_Obj.elementName = \"" + bean.getName() + "\";");
        out.println(this.getId() + "_Obj.validationFunctionName = \"" + this.getValidationFunctionName() + "\";");
        out.println(this.getId() + "_Obj.errorFunctionName = \"" + this.getErrorHandlerFunctionName() + "\";");
        out.println(this.getId() + "_Obj.clearErrorFunctionName = \"" + this.getClearErrorsFunctionName() + "\";");
        out.println(this.getId() + "_Obj.validationOnChange = " + this.isValidationOnChange() + ";");
    }

    static {
        JavaScriptIncludeHandler.addAlias(JavaScriptValidator.class, "VALIDATOR");
    }
}

