/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.util.Locale;

@SASScope(value="ALL")
public class IntegerInputValidator
extends JavaScriptValidator {
    public static final String RB_KEY = "IntegerInputValidator.";
    public static final int GENERIC_BASE = 0;
    public static final int DECIMAL_BASE = 10;
    protected static int MIN_VALID_BASE = 2;
    protected static int MAX_VALID_BASE = 36;
    protected int base;

    public IntegerInputValidator() {
        this.setValidationFunctionName("sas_Validator_isInteger");
        this.setBase(0);
    }

    public void setBase(int base) {
        if (base != 0 && (base < MIN_VALID_BASE || base > MAX_VALID_BASE)) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "invalidInteger.txt", Locale.getDefault()));
        }
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "invalidInteger.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        return "base: " + this.base;
    }

    @Override
    @SASScope
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"IntegerInputValidator\";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getDefaultValidationMessage(bean)) + "\";");
        }
    }
}

