/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util.validators;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.util.validators.JavaScriptValidator;
import com.sas.servlet.tbeans.util.validators.RB;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.PrintWriter;
import java.util.Locale;

@SASScope
public class DateIntervalStringValidator
extends JavaScriptValidator {
    public static final String WEEK = "WEEK";
    public static final String WEEKDAY = "WEEKDAY";
    public static final String QUARTER = "QUARTER";
    public static final String MONTH = "MONTH";
    public static final String YEAR = "YEAR";
    public static final String RB_KEY = "DateIntervalValidator.";
    private String containerId;
    protected String type;

    public DateIntervalStringValidator() {
        this.setValidationFunctionName("sas_Validator_isDateIntervalStringValid");
        this.type = WEEK;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getMonthValueString(Locale locale) {
        return RB.getStringResource(RB_KEY, "monthValueArr.txt", locale);
    }

    public String getShortMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "shortMonthPat.txt", locale);
    }

    public String getFullMonthString(Locale locale) {
        return RB.getStringResource(RB_KEY, "fullMonthPat.txt", locale);
    }

    @Override
    protected String getDefaultValidationMessage(TransformationInterface bean) {
        return Message.format((String)RB.getStringResource(RB_KEY, "invalidDateInterval.txt", bean.getLocale()), (Object)this.getDescription(bean));
    }

    @Override
    protected String getValidationParameters(TransformationInterface bean) {
        StringBuffer sb = new StringBuffer();
        sb.append("type:'" + this.type + "'");
        sb.append(", monthValueString: '" + Strings.escapeForJavaScript((String)this.getMonthValueString(bean.getLocale()))).append("'");
        sb.append(", fullMonthString:'" + Strings.escapeForJavaScript((String)this.getFullMonthString(bean.getLocale()))).append("'");
        sb.append(", shortMonthString:'" + Strings.escapeForJavaScript((String)this.getShortMonthString(bean.getLocale()))).append("'");
        sb.append(", containerId:'" + this.getContainerId()).append("'");
        return sb.toString();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public void writeJavaScriptValidatorObject(PrintWriter out, TransformationInterface bean) {
        super.writeJavaScriptValidatorObject(out, bean);
        out.println(this.getId() + "_Obj.validatorType = \"DateIntervalStringValidator\";");
        out.println(this.getId() + "_Obj.type = \"" + this.getType() + "\";");
        if (this.getValidationMessage() != null) {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getValidationMessage().toString()) + "\";");
        } else {
            out.println(this.getId() + "_Obj.message = \"" + Strings.escapeForJavaScript((String)this.getDefaultValidationMessage(bean)) + "\";");
        }
    }
}

