/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util;

import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.TransformationInterface2;
import com.sas.servlet.tbeans.tableview.ajax.AJAXPacket;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PartialRefreshHandler {
    private static CommonLoggerInterface _log;
    public static final String CONTAINER_ID_PARM = "containerId";
    public static final String REFRESH_VIEWER_ID_PARAMETER = "refreshViewerId";

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) {
        String viewerId = request.getParameter(REFRESH_VIEWER_ID_PARAMETER);
        Object viewer = request.getSession().getAttribute(viewerId);
        if (viewer == null) {
            viewer = ComponentSessionManager.getSessionManager(request).get(viewerId);
        }
        if (viewer == null) {
            PartialRefreshHandler.getLog().error("Could not find the viewer component that needs refresh on the session.");
        }
        String containerId = request.getParameter(CONTAINER_ID_PARM);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            TransformationInterface tbean;
            if (viewer instanceof TransformationInterface2) {
                tbean = (TransformationInterface2)viewer;
                if (containerId == null) {
                    containerId = tbean.getContainerId();
                }
                ((TransformationInterface2)viewer).writePartialRefresh(request, response, pw);
            } else if (viewer instanceof TransformationInterface) {
                tbean = (TransformationInterface)viewer;
                tbean.setRequest(request);
                tbean.setResponse(response);
                tbean.write(pw);
            }
        }
        catch (IOException ioe) {
            PartialRefreshHandler.getLog().error(ioe.getMessage(), (Throwable)ioe);
        }
        try {
            new AJAXPacket().add(sw.toString(), CONTAINER_ID_PARM, containerId).send(response);
        }
        catch (IOException ioe) {
            PartialRefreshHandler.getLog().error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)PartialRefreshHandler.class.getName(), null);
        }
        return _log;
    }
}

