/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.util;

import com.sas.actionprovider.SelectorAction;
import com.sas.actionprovider.SelectorActionInterface;
import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.menubar.BaseMenu;
import com.sas.servlet.tbeans.menubar.BaseMenuBar;
import com.sas.servlet.tbeans.menubar.BaseMenuItem;
import com.sas.servlet.tbeans.menubar.html.BaseHTMLMenuBar;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.MenuItem;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuItem;
import com.sas.servlet.util.BaseUtil;
import com.sas.swing.util.Action;
import com.sas.swing.util.ActionList;
import com.sas.util.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SASScope
public abstract class ActionUIFactory {
    private HashMap _menuBars;
    private HashMap _menus;
    private HashMap _menuItems;
    private boolean cachingEnabled;

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public BaseMenuBar getMenuBar(ActionList actionList, BaseMenuBar menuBar) {
        return this.getMenuBar(actionList, menuBar, true);
    }

    public BaseMenuBar getMenuBar(ActionList actionList, BaseMenuBar menuBar, boolean encodeText) {
        return this.getMenuBar(actionList, menuBar, encodeText, false);
    }

    @SASScope
    public BaseMenuBar getMenuBar(ActionList actionList, BaseMenuBar menuBar, boolean encodeText, boolean escapedAmpersand) {
        if (actionList == null) {
            return null;
        }
        if (this._menuBars != null && this._menuBars.containsKey(actionList)) {
            return (BaseMenuBar)this._menuBars.get(actionList);
        }
        if (menuBar == null) {
            menuBar = this.newMenuBar();
        } else {
            menuBar.getMenus().clear();
        }
        menuBar.setMenuType(5);
        this.populateMenuBar(menuBar, actionList, encodeText, escapedAmpersand);
        if (this.isCachingEnabled()) {
            if (this._menuBars == null) {
                this._menuBars = new HashMap();
            }
            this._menuBars.put(actionList, menuBar);
        }
        menuBar.setCellSpacing(3);
        return menuBar;
    }

    public BaseMenuBar getMenuBar(ActionList actionList, boolean encodeText) {
        return this.getMenuBar(actionList, null, encodeText);
    }

    public BaseMenuBar getMenuBar(ActionList actionList) {
        return this.getMenuBar(actionList, null, true);
    }

    public void populateMenuBar(BaseMenuBar menuBar, ActionList actionList) {
        this.populateMenuBar(menuBar, actionList, true);
    }

    public void populateMenuBar(BaseMenuBar menuBar, ActionList actionList, boolean encodeText) {
        this.populateMenuBar(menuBar, actionList, encodeText, false);
    }

    @SASScope
    public void populateMenuBar(BaseMenuBar menuBar, ActionList actionList, boolean encodeText, boolean escapeAmpersand) {
        Map styleMap;
        int endIndex;
        if (actionList == null) {
            return;
        }
        List actions = actionList.getActions();
        for (endIndex = actions.size() - 1; endIndex >= 0 && actions.get(endIndex) == ActionList.SEPARATOR; --endIndex) {
        }
        for (int beginIndex = 0; beginIndex <= endIndex && actions.get(beginIndex) == ActionList.SEPARATOR; ++beginIndex) {
        }
        Object previousAction = null;
        for (int i = beginIndex; i <= endIndex; ++i) {
            Object action = actions.get(i);
            if (action instanceof ActionList) {
                menuBar.add(this.getMenu((ActionList)action, encodeText, escapeAmpersand));
            } else if (action instanceof Action) {
                menuBar.add(this.getMenu((Action)action, encodeText, escapeAmpersand));
            } else if (action == ActionList.SEPARATOR && previousAction != ActionList.SEPARATOR && menuBar instanceof BaseHTMLMenuBar) {
                ((BaseHTMLMenuBar)menuBar).addSeparator("|");
            }
            previousAction = action;
        }
        if (menuBar instanceof BaseHTMLMenuBar && (styleMap = (Map)actionList.getValue("StyleMap")) != null) {
            ((BaseHTMLMenuBar)menuBar).setStyleMap(styleMap);
        }
    }

    public BaseMenu getMenu(ActionList actionList) {
        return this.getMenu(actionList, true);
    }

    public BaseMenu getMenu(ActionList actionList, boolean encodeText) {
        return this.getMenu(actionList, encodeText, false);
    }

    @SASScope
    public BaseMenu getMenu(ActionList actionList, boolean encodeText, boolean escapeAmpersand) {
        int endIndex;
        if (actionList == null) {
            return null;
        }
        if (this._menus != null && this._menus.containsKey(actionList)) {
            return (BaseMenu)this._menus.get(actionList);
        }
        Menu menu = (Menu)this.newMenu();
        this.moveAttributes((Action)actionList, menu, encodeText, escapeAmpersand);
        Map styleMap = (Map)actionList.getValue("StyleMap");
        if (styleMap != null) {
            menu.setStyleMap(styleMap);
        }
        List actions = actionList.getActions();
        for (endIndex = actions.size() - 1; endIndex >= 0 && actions.get(endIndex) == ActionList.SEPARATOR; --endIndex) {
        }
        for (int beginIndex = 0; beginIndex <= endIndex && actions.get(beginIndex) == ActionList.SEPARATOR; ++beginIndex) {
        }
        Object previousAction = null;
        for (int i = beginIndex; i <= endIndex; ++i) {
            Object action = actions.get(i);
            if (action instanceof ActionList) {
                menu.add((Menu)this.getMenu((ActionList)action, encodeText));
            } else if (action instanceof Action) {
                Action a = (Action)action;
                BaseMenuItem item = this.getMenuItem(a, encodeText, escapeAmpersand);
                menu.add(item);
            } else if (action == ActionList.SEPARATOR) {
                if (previousAction != ActionList.SEPARATOR) {
                    menu.addSeparator();
                }
            } else {
                throw new IllegalStateException();
            }
            previousAction = action;
        }
        if (this.isCachingEnabled()) {
            if (this._menus == null) {
                this._menus = new HashMap();
            }
            this._menus.put(actionList, menu);
        }
        return menu;
    }

    public BaseMenu getMenu(Action action) {
        return this.getMenu(action, true);
    }

    public BaseMenu getMenu(Action action, boolean encodeText) {
        return this.getMenu(action, encodeText, false);
    }

    @SASScope
    public BaseMenu getMenu(Action action, boolean encodeText, boolean escapeAmpersand) {
        if (this._menus != null && this._menus.containsKey(action)) {
            return (BaseMenu)this._menus.get(action);
        }
        Menu menu = (Menu)this.newMenu();
        if (action instanceof Action) {
            if (action instanceof SelectorActionInterface) {
                BaseMenuItem item = this.newMenuItem(action);
                menu.setSelectorMenuItem((SelectorMenuItem)item);
                menu.setMenuType(((SelectorAction)action).getSelectorType());
                if (action instanceof SelectorAction) {
                    menu.setDefaultURLSuppressed(((SelectorAction)action).isDefaultURLSuppressed());
                }
            }
            this.moveAttributes(action, menu, encodeText, escapeAmpersand);
            Map styleMap = (Map)action.getValue("StyleMap");
            if (styleMap != null) {
                menu.setStyleMap(styleMap);
            }
        } else {
            throw new IllegalStateException();
        }
        if (this.isCachingEnabled()) {
            if (this._menus == null) {
                this._menus = new HashMap();
            }
            this._menus.put(action, menu);
        }
        return menu;
    }

    private void moveAttributes(Action action, BaseMenuItem baseMenuItem, boolean encodeText, boolean escapeAmpersand) {
        String rolloverImage;
        String label = (String)action.getValue("Label");
        if (label == null) {
            label = (String)action.getValue("Name");
        }
        if (encodeText && label != null && !label.equals("&#160;")) {
            label = Strings.quoteForXML((String)label);
        }
        baseMenuItem.setLabel(label);
        String image = (String)action.getValue("SmallIconName");
        if (image != null) {
            baseMenuItem.setImage(image);
        }
        if ((rolloverImage = (String)action.getValue("RolloverIconName")) != null && image != null) {
            baseMenuItem.setRolloverImage(rolloverImage);
        }
        if (action.isEnabled()) {
            String shortDescription = (String)action.getValue("ShortDescription");
            baseMenuItem.setTitle(shortDescription != null ? shortDescription : "");
            baseMenuItem.setEnabled(true);
        } else {
            String shortDisabledDescription = (String)action.getValue("ShortDisabledDescription");
            baseMenuItem.setTitle(shortDisabledDescription != null ? shortDisabledDescription : "");
            baseMenuItem.setEnabled(false);
        }
        baseMenuItem.setDisabledImage((String)action.getValue("SmallDisabledIconName"));
        String alternateText = (String)action.getValue("AlternateText");
        if (alternateText == null) {
            String string = alternateText = action.isEnabled() ? (String)action.getValue("ShortDescription") : (String)action.getValue("ShortDisabledDescription");
            if (alternateText == null) {
                alternateText = "";
            }
        }
        baseMenuItem.setAlternateText(alternateText);
        String alignment = (String)action.getValue("TextAlignment");
        if (alignment != null && (alignment.equals("SwingConstants.LEFT") || alignment.equals("SwingConstants.LEADING"))) {
            baseMenuItem.setImagePosition(4096);
        } else {
            baseMenuItem.setImagePosition(512);
        }
        baseMenuItem.setTarget((String)action.getValue("Target"));
        if (escapeAmpersand) {
            baseMenuItem.setURL(BaseUtil.escapeUrlAmpersands((String)action.getValue("URL")));
        } else {
            baseMenuItem.setURL((String)action.getValue("URL"));
        }
    }

    public BaseMenuItem getMenuItem(Action action) {
        return this.getMenuItem(action, true);
    }

    public BaseMenuItem getMenuItem(Action action, boolean encodeText) {
        return this.getMenuItem(action, encodeText, false);
    }

    @SASScope
    public BaseMenuItem getMenuItem(Action action, boolean encodeText, boolean escapeAmpersand) {
        Map styleMap;
        if (this._menuItems != null && this._menuItems.containsKey(action)) {
            return (BaseMenuItem)this._menuItems.get(action);
        }
        BaseMenuItem menuItem = this.newMenuItem(action);
        this.moveAttributes(action, menuItem, encodeText, escapeAmpersand);
        if (menuItem instanceof MenuItem && (styleMap = (Map)action.getValue("StyleMap")) != null) {
            ((MenuItem)menuItem).setStyleMap(styleMap);
        }
        if (this.isCachingEnabled()) {
            if (this._menuItems == null) {
                this._menuItems = new HashMap();
            }
            this._menuItems.put(action, menuItem);
        }
        return menuItem;
    }

    public ActionList getActionList(BaseMenuBar menuBar) {
        return (ActionList)this.getKeyFromValue(this._menuBars, menuBar);
    }

    public ActionList getActionList(BaseMenu menu) {
        return (ActionList)this.getKeyFromValue(this._menus, menu);
    }

    public Action getAction(BaseMenuItem menuItem) {
        return (Action)this.getKeyFromValue(this._menuItems, menuItem);
    }

    protected abstract BaseMenuBar newMenuBar();

    protected abstract BaseMenu newMenu();

    protected BaseMenuItem newMenuItem(Action action) {
        BaseMenuItem menuItem;
        String actionType = (String)action.getValue("Type");
        if ("boolean".equals(actionType)) {
            menuItem = action.getValue("GroupName") != null ? this.newRadioButtonMenuItem() : this.newCheckBoxMenuItem();
        } else if (action instanceof SelectorActionInterface) {
            menuItem = this.newSelectorMenuItem();
            ((SelectorMenuItem)menuItem).setSelector(((SelectorActionInterface)action).getSelector());
            if (action instanceof SelectorAction) {
                ((SelectorMenuItem)menuItem).setDefaultURLSuppressed(((SelectorAction)action).isDefaultURLSuppressed());
                ((SelectorMenuItem)menuItem).setSelectorWidth(((SelectorAction)action).getSelectorWidth());
                ((SelectorMenuItem)menuItem).setSelectorHeight(((SelectorAction)action).getSelectorHeight());
                ((SelectorMenuItem)menuItem).setModal(((SelectorAction)action).isModal());
            }
        } else {
            menuItem = this.newMenuItem();
        }
        return menuItem;
    }

    protected abstract BaseMenuItem newMenuItem();

    protected abstract BaseMenuItem newSelectorMenuItem();

    protected BaseMenuItem newCheckBoxMenuItem() {
        return this.newMenuItem();
    }

    protected BaseMenuItem newRadioButtonMenuItem() {
        return this.newMenuItem();
    }

    private Object getKeyFromValue(HashMap map, Object value) {
        if (map == null) {
            return null;
        }
        for (Object key : map.keySet()) {
            if (map.get(key) != value) continue;
            return key;
        }
        return null;
    }
}

