/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.tableview.html;

import com.sas.codepolicy.SASScope;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.BaseCompositeTransformation2;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.dataselectors.html.RelationalMenuBar;
import com.sas.servlet.tbeans.html.AppliedFilters;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.navigationbar.BaseNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableColumnNavigationBar;
import com.sas.servlet.tbeans.navigationbar.html.TableRowNavigationBar;
import com.sas.servlet.tbeans.tableview.BaseTableView;
import com.sas.servlet.tbeans.tableview.TableColumnModel;
import com.sas.servlet.tbeans.tableview.TableRowModel;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.tbeans.tableview.html.TableViewCompositeKeysInterface;
import com.sas.servlet.tbeans.tableview.html.TableViewCompositeStyleKeysInterface;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.util.MapWithDefaults;
import com.sas.util.Util;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class TableViewComposite
extends BaseCompositeTransformation2
implements TableViewCompositeKeysInterface,
TableViewCompositeStyleKeysInterface {
    static final String RB_KEY = "TableViewComposite.";
    @SASScope
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "TableView.html";
    private TableModel dataModel;
    private static final HashMap defaultStyleMap = new HashMap();

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put("TABLEVIEW_CONTAINER_STYLE", new ImmutableStyleInfo("tableContainer"));
            defaultStyleMap.put("TABLEVIEW_CONTENT_STYLE", new ImmutableStyleInfo("tableContent"));
            defaultStyleMap.put("TABLEVIEW_TITLE_STYLE", new ImmutableStyleInfo("tableTitle"));
            defaultStyleMap.put("TABLEVIEW_FOOTER_STYLE", new ImmutableStyleInfo("tableFooter"));
            defaultStyleMap.put("TABLEVIEW_TOOLBAR_STYLE", new ImmutableStyleInfo("tableToolBar"));
        }
    }

    public TableViewComposite() {
        this(null, null, null);
    }

    public TableViewComposite(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public TableViewComposite(TableModel tableModel, TableColumnModel columnModel) {
        this(tableModel, columnModel, null);
    }

    public TableViewComposite(TableModel tm, TableColumnModel cm, TableRowModel rm) {
        this.setId(Util.getName((String)"tvc"));
        TableView table = new TableView(tm, cm, rm);
        table.setId(this.getId() + "_tv");
        table.setRowPageSize(20);
        table.setColumnPageSize(10);
        TableViewComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap((Map)defaultStyleMap);
        this.setComponent("TABLEVIEW_TABLEDATA", table);
        this.setComponent("TABLEVIEW_COLUMN_NAVIGATIONBAR", this.getDefaultColumnNavigationBar());
        this.setComponent("TABLEVIEW_ROW_NAVIGATIONBAR", this.getDefaultRowNavigationBar());
        this.setComponent("TABLEVIEW_MENUBAR", this.getDefaultMenuBar());
        this.setComponent("TABLEVIEW_TITLE", this.getDefaultTitle());
        this.setComponent("TABLEVIEW_FOOTER", this.getDefaultFooter());
        this.setComponent("TABLEVIEW_APPLIEDFILTERS", this.getDefaultAppliedFilters());
        this.setDefaultRefreshProxyRelationships();
        this.setTemplateKey("Table_View");
    }

    public TableViewComposite(int numRows, int numColumns) {
        this(new DefaultTableModel(numRows, numColumns));
    }

    public TableViewComposite(final Object[][] rowData, final Object[] columnNames) {
        this(new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return columnNames[column].toString();
            }

            @Override
            public int getRowCount() {
                return rowData.length;
            }

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return rowData[row][col];
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                rowData[row][col] = value;
                this.fireTableCellUpdated(row, col);
            }
        });
    }

    public TableViewComposite(final Vector rowData, final Vector columnNames) {
        this(new AbstractTableModel(){

            @Override
            public String getColumnName(int column) {
                return columnNames.elementAt(column).toString();
            }

            @Override
            public int getRowCount() {
                return rowData.size();
            }

            @Override
            public int getColumnCount() {
                return columnNames.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return ((Vector)rowData.elementAt(row)).elementAt(column);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                ((Vector)rowData.elementAt(row)).setElementAt(value, column);
                this.fireTableCellUpdated(row, column);
            }
        });
    }

    @SASScope
    protected BaseNavigationBar getDefaultColumnNavigationBar() {
        TransformationInterface table = this.getComponent("TABLEVIEW_TABLEDATA");
        if (table instanceof BaseTableView) {
            TableColumnNavigationBar cnb = new TableColumnNavigationBar((BaseTableView)table);
            cnb.setId(this.getId() + "_cnb");
            return cnb;
        }
        return null;
    }

    @SASScope
    protected BaseNavigationBar getDefaultRowNavigationBar() {
        TransformationInterface table = this.getComponent("TABLEVIEW_TABLEDATA");
        if (table instanceof BaseTableView) {
            TableRowNavigationBar rnb = new TableRowNavigationBar((BaseTableView)table);
            rnb.setId(this.getId() + "_rnb");
            return rnb;
        }
        return null;
    }

    @SASScope
    protected Label getDefaultTitle() {
        Label title = new Label("TABLEVIEW TITLE");
        title.setVisible(false);
        title.setId(this.getId() + "_title");
        return title;
    }

    @SASScope
    protected Label getDefaultFooter() {
        Label footer = new Label("TABLEVIEW FOOTER");
        footer.setVisible(false);
        footer.setId(this.getId() + "_footer");
        return footer;
    }

    @SASScope
    protected ActionProviderMenuBar getDefaultMenuBar() {
        RelationalMenuBar mb = new RelationalMenuBar();
        mb.setModel(this.getModel());
        mb.setVisible(false);
        TransformationInterface table = this.getComponent("TABLEVIEW_TABLEDATA");
        if (table instanceof BaseActionTransformation) {
            mb.setViewer((BaseActionTransformation)table);
        }
        mb.setId(this.getId() + "_mb");
        return mb;
    }

    protected AppliedFilters getDefaultAppliedFilters() {
        AppliedFilters appliedFilters = new AppliedFilters();
        appliedFilters.setId(this.getId() + "_af");
        appliedFilters.setTitleDisplayed(4);
        appliedFilters.setNoFilterTextDisplayed(false);
        appliedFilters.setVisible(false);
        return appliedFilters;
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setModel(TableModel tableModel) {
        if (this.dataModel != tableModel) {
            this.dataModel = tableModel;
            TransformationInterface o = this.getComponent("TABLEVIEW_TABLEDATA");
            if (o != null && o instanceof TableView) {
                ((TableView)o).setModel(this.dataModel);
            }
            if ((o = this.getComponent("TABLEVIEW_MENUBAR")) != null && o instanceof RelationalMenuBar) {
                ((RelationalMenuBar)o).setModel(this.dataModel);
            }
            if ((o = this.getComponent("TABLEVIEW_APPLIEDFILTERS")) != null && o instanceof AppliedFilters) {
                ((AppliedFilters)o).setModel(this.dataModel);
            }
        }
    }

    @Override
    protected void writeContent(PrintWriter out) throws IOException {
        HashMap<String, String> dictionary;
        this.flushActionProvider();
        if (this.isPartialRefreshActionsEnabled()) {
            HttpServletRequest request;
            JavaScriptIncludeHandler.writeIncludes(out, "AJAX", this.getRequest());
            if (this.getPartialRefreshProxy() == null && (request = this.getRequest()) != null) {
                ComponentSessionManager.getSessionManager(request).put(this.getId(), this);
            }
        }
        if ((dictionary = this.getTemplateDictionary()) == null) {
            dictionary = new HashMap<String, String>(1);
            this.setTemplateDictionary(dictionary);
        }
        dictionary.put("TABLEVIEW_ID", this.getId());
        this.writeTemplate(this, null, out);
    }

    private void setDefaultRefreshProxyRelationships() {
        this.setPartialRefreshProxy("TABLEVIEW_TABLEDATA", this);
        this.setPartialRefreshProxy("TABLEVIEW_COLUMN_NAVIGATIONBAR", this);
        this.setPartialRefreshProxy("TABLEVIEW_ROW_NAVIGATIONBAR", this);
        this.setPartialRefreshProxy("TABLEVIEW_MENUBAR", this);
        this.setPartialRefreshProxy("TABLEVIEW_TITLE", this);
        this.setPartialRefreshProxy("TABLEVIEW_FOOTER", this);
        this.setPartialRefreshProxy("TABLEVIEW_APPLIEDFILTERS", this);
    }
}

